/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.mapping;

import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import nl.b3p.gis.mapping.FeatureType;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.Validator;
import org.xml.sax.ContentHandler;

public class Mapping
implements Serializable {
    private String _name;
    private String _description;
    private ArrayList _featureTypeList = new ArrayList();

    public void addFeatureType(FeatureType vFeatureType) throws IndexOutOfBoundsException {
        this._featureTypeList.add(vFeatureType);
    }

    public void addFeatureType(int index, FeatureType vFeatureType) throws IndexOutOfBoundsException {
        this._featureTypeList.add(index, vFeatureType);
    }

    public void clearFeatureType() {
        this._featureTypeList.clear();
    }

    public Enumeration enumerateFeatureType() {
        return Collections.enumeration(this._featureTypeList);
    }

    public String getDescription() {
        return this._description;
    }

    public FeatureType getFeatureType(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._featureTypeList.size()) {
            throw new IndexOutOfBoundsException();
        }
        return (FeatureType)this._featureTypeList.get(index);
    }

    public FeatureType[] getFeatureType() {
        int size = this._featureTypeList.size();
        FeatureType[] mArray = new FeatureType[size];
        for (int index = 0; index < size; ++index) {
            mArray[index] = (FeatureType)this._featureTypeList.get(index);
        }
        return mArray;
    }

    public int getFeatureTypeCount() {
        return this._featureTypeList.size();
    }

    public String getName() {
        return this._name;
    }

    public boolean isValid() {
        try {
            this.validate();
        }
        catch (ValidationException vex) {
            return false;
        }
        return true;
    }

    public void marshal(Writer out) throws MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (Writer)out);
    }

    public void marshal(ContentHandler handler) throws IOException, MarshalException, ValidationException {
        Marshaller.marshal((Object)this, (ContentHandler)handler);
    }

    public boolean removeFeatureType(FeatureType vFeatureType) {
        boolean removed = this._featureTypeList.remove(vFeatureType);
        return removed;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setFeatureType(int index, FeatureType vFeatureType) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this._featureTypeList.size()) {
            throw new IndexOutOfBoundsException();
        }
        this._featureTypeList.set(index, vFeatureType);
    }

    public void setFeatureType(FeatureType[] featureTypeArray) {
        this._featureTypeList.clear();
        for (int i = 0; i < featureTypeArray.length; ++i) {
            this._featureTypeList.add(featureTypeArray[i]);
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public static Mapping unmarshal(Reader reader) throws MarshalException, ValidationException {
        return (Mapping)Unmarshaller.unmarshal(Mapping.class, (Reader)reader);
    }

    public void validate() throws ValidationException {
        Validator validator = new Validator();
        validator.validate((Object)this);
    }
}

