/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.sld;

import java.io.StringWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nl.b3p.commons.xml.DocumentHelper;
import nl.b3p.ogc.sld.SldNamedLayer;
import nl.b3p.ogc.sld.SldWriter;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class SldNode {
    private static final Log log = LogFactory.getLog(SldNamedLayer.class);
    private static XPathFactory factory = null;
    protected static XPath xpath = null;
    protected Node node;
    protected String version = "1.1.0";
    protected List<String> supportedVersions = Arrays.asList("1.0.0", "1.1.0");

    public abstract String getName() throws Exception;

    public SldNode() throws XPathExpressionException {
        if (factory == null) {
            factory = XPathFactory.newInstance();
            xpath = factory.newXPath();
            xpath.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    if (prefix == null) {
                        throw new NullPointerException("Null prefix");
                    }
                    if ("sld".equals(prefix)) {
                        return "http://www.opengis.net/sld";
                    }
                    if ("se".equals(prefix)) {
                        return "http://www.opengis.net/se";
                    }
                    if ("ogc".equals(prefix)) {
                        return "http://www.opengis.net/ogc";
                    }
                    if ("xml".equals(prefix)) {
                        return "http://www.w3.org/XML/1998/namespace";
                    }
                    return "";
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    throw new UnsupportedOperationException("");
                }

                public Iterator getPrefixes(String namespaceURI) {
                    throw new UnsupportedOperationException("");
                }
            });
        }
    }

    public SldNode(String version) throws XPathExpressionException {
        this();
        if (!this.supportedVersions.contains(version)) {
            throw new NotImplementedException();
        }
        this.version = version;
    }

    protected String serializeXpathNode(Node node) {
        StringWriter writer = new StringWriter();
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            if (this.isTextNode(node)) {
                writer.write(node.getNodeValue());
            } else if (node.getNodeType() == 2) {
                writer.write(((Attr)node).getValue());
            } else if (node.getNodeType() == 1) {
                transformer.transform(new DOMSource(node), new StreamResult(writer));
            }
        }
        catch (Exception e) {
            log.error((Object)("Fout tijdens serializen XPath Node: " + e));
        }
        return writer.toString();
    }

    public String getSldPart() {
        return this.serializeXpathNode(this.node);
    }

    protected boolean isTextNode(Node node) {
        if (node == null) {
            return false;
        }
        short nodeType = node.getNodeType();
        return nodeType == 4 || nodeType == 3;
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public String getVersion() {
        return this.version;
    }

    public static String getSldNodeString(String ver) {
        if (ver.equalsIgnoreCase("1.0.0")) {
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:se=\"http://www.opengis.net/se\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/sld http://schemas.opengis.net/sld/1.0.0/StyledLayerDescriptor.xsd\" version=\"1.0.0\"/>";
        }
        if (ver.equalsIgnoreCase("1.1.0")) {
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><StyledLayerDescriptor xmlns=\"http://www.opengis.net/sld\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:se=\"http://www.opengis.net/se\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://www.opengis.net/sld http://schemas.opengis.net/sld/1.1.0/StyledLayerDescriptor.xsd\" version=\"1.1.0\"/>";
        }
        throw new NotImplementedException();
    }

    public static String getSld100Example() {
        return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><StyledLayerDescriptor version=\"1.0.0\"   xsi:schemaLocation=\"http://www.opengis.net/sld StyledLayerDescriptor.xsd\"   xmlns=\"http://www.opengis.net/sld\"   xmlns:ogc=\"http://www.opengis.net/ogc\"   xmlns:xlink=\"http://www.w3.org/1999/xlink\"   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <NamedLayer>      <Name>OCEANSEA_1M:Foundation</Name>      <UserStyle>         <Name>GEOSYM</Name>         <IsDefault>1</IsDefault>         <FeatureTypeStyle>            <Rule>               <Name>main</Name>               <PolygonSymbolizer>                  <Geometry>                     <ogc:PropertyName>GEOMETRY</ogc:PropertyName>                  </Geometry>                  <Fill>                     <CssParameter name=\"fill\">#96C3F5</CssParameter>                  </Fill>               </PolygonSymbolizer>            </Rule>         </FeatureTypeStyle>      </UserStyle>   </NamedLayer></StyledLayerDescriptor>";
    }

    public static String getSld110Example() {
        return "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><StyledLayerDescriptor version=\"1.1.0\" xsi:schemaLocation=\"http://www.opengis.net/sld StyledLayerDescriptor.xsd\" xmlns=\"http://www.opengis.net/sld\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:se=\"http://www.opengis.net/se\" xmlns:xlink=\"http://www.w3.org/1999/xlink\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\t<NamedLayer>\t\t<se:Name xmlns:se=\"http://www.opengis.net/se\">OCEANSEA_1M:Foundation</se:Name>\t\t<UserStyle>\t\t\t<se:Name>GEOSYM</se:Name>\t\t\t<IsDefault>1</IsDefault>\t\t\t<se:FeatureTypeStyle>\t\t\t\t<se:FeatureTypeName>Foundation</se:FeatureTypeName>\t\t\t\t<se:Rule>\t\t\t\t\t<se:Name>main</se:Name>\t\t\t\t\t<se:PolygonSymbolizer uom=\"http://www.opengis.net/sld/units/pixel\">\t\t\t\t\t\t<se:Name>MySymbol</se:Name>\t\t\t\t\t\t<se:Description>\t\t\t\t\t\t\t<se:Title>Example Symbol</se:Title>\t\t\t\t\t\t\t<se:Abstract>This is just a simple example.</se:Abstract>\t\t\t\t\t\t</se:Description>\t\t\t\t\t\t<se:Geometry>\t\t\t\t\t\t\t<ogc:PropertyName>GEOMETRY</ogc:PropertyName>\t\t\t\t\t\t</se:Geometry>\t\t\t\t\t\t<se:Fill>\t\t\t\t\t\t\t<se:SvgParameter name=\"fill\">#96C3F5</se:SvgParameter>\t\t\t\t\t\t</se:Fill>\t\t\t\t\t</se:PolygonSymbolizer>\t\t\t\t</se:Rule>\t\t\t</se:FeatureTypeStyle>\t\t</UserStyle>\t</NamedLayer></StyledLayerDescriptor>";
    }

    public static void main(String[] args) throws Exception {
        Node importedNode;
        Node snlNode;
        Document nl110Doc = SldWriter.getDocument(SldNode.getSld110Example(), "UTF-8");
        Document nl100Doc = SldWriter.getDocument(SldNode.getSld100Example(), "UTF-8");
        SldWriter sr = new SldWriter();
        sr.parseDocument(nl110Doc);
        System.out.println("110 doc, version: " + sr.getVersion());
        List<SldNamedLayer> nl110List = sr.getNamedlayers();
        SldWriter sr2 = new SldWriter();
        sr2.parseDocument(nl100Doc);
        System.out.println("100 doc, version: " + sr2.getVersion());
        List<SldNamedLayer> nl100List = sr2.getNamedlayers();
        Document sldDoc = SldWriter.getDocument(SldNode.getSldNodeString("1.1.0"), "UTF-8");
        for (SldNamedLayer snl : nl110List) {
            snlNode = snl.getNode();
            importedNode = sldDoc.importNode(snlNode, true);
            sldDoc.getFirstChild().appendChild(importedNode);
        }
        for (SldNamedLayer snl : nl100List) {
            snlNode = snl.getNode();
            importedNode = sldDoc.importNode(snlNode, true);
            sldDoc.getFirstChild().appendChild(importedNode);
        }
        sldDoc.normalizeDocument();
        String sldString = DocumentHelper.document2String((Document)sldDoc);
        System.out.println(sldString);
        String newSldString = sldString.replaceFirst("xmlns:se=\"http://www.opengis.net/se\"", "HACKHACK").replaceAll(" xmlns:se=\"http://www.opengis.net/se\"", "").replaceFirst("HACKHACK", "xmlns:se=\"http://www.opengis.net/se\"");
        System.out.println(newSldString);
        Document newSldDoc = SldWriter.getDocument(newSldString, "UTF-8");
        System.out.println(DocumentHelper.document2String((Document)newSldDoc));
    }
}

