/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import nl.b3p.ogc.utils.LayerSummary;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.ogc.wfs.v110.WfsLayer;
import nl.b3p.ogc.wfs.v110.WfsServiceProvider;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.ServiceProvider;
import nl.b3p.wms.capabilities.Style;

public class SpLayerSummary {
    private Integer serviceproviderId = null;
    private String username = null;
    private String password = null;
    private String spUrl = null;
    private String spAbbr = null;
    private String spInUrl = null;
    private List<LayerSummary> layers = null;

    public SpLayerSummary(Integer serviceproviderId, Integer layerId, String layerName, String spUrl, String spAbbr, String queryable, Set<Style> styles) {
        this(serviceproviderId, layerId, layerName, spUrl, spAbbr, queryable, styles, null, null);
    }

    public SpLayerSummary(Integer serviceproviderId, Integer layerId, String layerName, String spUrl, String spAbbr, String queryable, Set<Style> styles, String username, String password) {
        this.serviceproviderId = serviceproviderId;
        this.username = username;
        this.password = password;
        this.spUrl = spUrl;
        this.spAbbr = spAbbr;
        try {
            LayerSummary ls = OGCCommunication.splitLayerWithoutNsFix(layerName, false, spAbbr, null);
            ls.setLayerId(layerId);
            ls.setQueryable(queryable);
            ls.setStyles(styles);
            ArrayList<LayerSummary> lsl = new ArrayList<LayerSummary>();
            lsl.add(ls);
            this.setLayers(lsl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SpLayerSummary(Layer l, String queryable) {
        this(l.getServiceProvider().getId(), l.getId(), l.getName(), l.getServiceProvider().getUrl(), l.getServiceProvider().getAbbr(), queryable, l.getStyles(), l.getServiceProvider().getUserName(), l.getServiceProvider().getPassword());
    }

    public SpLayerSummary(WfsLayer l, String queryable) {
        this(l.getWfsServiceProvider().getId(), l.getId(), l.getName(), l.getWfsServiceProvider().getUrl(), l.getWfsServiceProvider().getAbbr(), queryable, null, l.getWfsServiceProvider().getUsername(), l.getWfsServiceProvider().getPassword());
    }

    public SpLayerSummary(WfsLayer l, String queryable, ServiceProvider sp) {
        this(l, queryable);
        this.setServiceProvider(sp);
    }

    public SpLayerSummary(WfsLayer l, String queryable, WfsServiceProvider sp) {
        this(l, queryable);
        this.setServiceProvider(sp);
    }

    public SpLayerSummary(Layer l, String queryable, ServiceProvider sp) {
        this(l, queryable);
        this.setServiceProvider(sp);
    }

    public SpLayerSummary(Layer l, String queryable, WfsServiceProvider sp) {
        this(l, queryable);
        this.setServiceProvider(sp);
    }

    public SpLayerSummary() {
    }

    public Integer getServiceproviderId() {
        return this.serviceproviderId;
    }

    public void setServiceproviderId(Integer serviceproviderId) {
        this.serviceproviderId = serviceproviderId;
    }

    public String getLayerName() {
        if (this.getLayers() != null && !this.getLayers().isEmpty()) {
            LayerSummary l = this.getLayers().get(0);
            return OGCCommunication.buildLayerNameWithoutSp(l);
        }
        return null;
    }

    public String getSpUrl() {
        return this.spUrl;
    }

    public void setSpUrl(String spUrl) {
        this.spUrl = spUrl;
    }

    public String getSpAbbr() {
        return this.spAbbr;
    }

    public final void setServiceProvider(WfsServiceProvider sp) {
        this.username = sp.getUsername();
        this.password = sp.getPassword();
    }

    public final void setServiceProvider(ServiceProvider sp) {
        if (sp == null) {
            return;
        }
        this.username = sp.getUserName();
        this.password = sp.getPassword();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setSpAbbr(String spAbbr) {
        this.spAbbr = spAbbr;
    }

    public List<LayerSummary> getLayers() {
        return this.layers;
    }

    public final void setLayers(List<LayerSummary> layers) {
        this.layers = layers;
    }

    public void addLayer(LayerSummary layerName) {
        if (this.layers == null) {
            this.layers = new ArrayList<LayerSummary>();
        }
        this.layers.add(layerName);
    }

    public void addLayers(List<LayerSummary> lss) {
        if (this.layers == null) {
            this.layers = new ArrayList<LayerSummary>();
        }
        this.layers.addAll(lss);
    }

    public String getLayersAsString() {
        if (this.layers == null) {
            return null;
        }
        StringBuffer ll = new StringBuffer();
        for (LayerSummary l : this.layers) {
            if (ll.length() != 0) {
                ll.append(",");
            }
            ll.append(OGCCommunication.buildLayerNameWithoutSp(l));
        }
        return ll.toString();
    }

    public String getQueryable() {
        if (this.getLayers() != null && !this.getLayers().isEmpty()) {
            return this.getLayers().get(0).getQueryable();
        }
        return null;
    }

    public Style getStyle(String layerName, String styleName) {
        if (layerName == null || styleName == null) {
            return null;
        }
        for (LayerSummary ls : this.getLayers()) {
            if (!layerName.equals(OGCCommunication.buildLayerNameWithoutSp(ls))) continue;
            Set<Style> layerStyles = ls.getStyles();
            for (Style s : layerStyles) {
                if (!styleName.equals(s.getName())) continue;
                return s;
            }
        }
        return null;
    }

    public String getSpInUrl() {
        return this.spInUrl;
    }

    public void setSpInUrl(String spInUrl) {
        this.spInUrl = spInUrl;
    }
}

