/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.utils;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.utils.OGCConstants;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.utils.OGCResponse;
import nl.b3p.ogc.utils.OgcWfsClient;
import nl.b3p.ogc.utils.SpLayerSummary;
import nl.b3p.xml.ogc.v100.capabilities.Arithmetic_OperatorsTypeItem;
import nl.b3p.xml.ogc.v100.capabilities.Comparison_OperatorsTypeItem;
import nl.b3p.xml.ogc.v100.capabilities.Scalar_CapabilitiesTypeItem;
import nl.b3p.xml.ogc.v100.capabilities.Spatial_OperatorsTypeItem;
import nl.b3p.xml.ogc.v110.ArithmeticOperatorsTypeItem;
import nl.b3p.xml.ogc.v110.ComparisonOperatorsTypeItem;
import nl.b3p.xml.ogc.v110.Id_CapabilitiesTypeItem;
import nl.b3p.xml.ogc.v110.LogicalOperators;
import nl.b3p.xml.ogc.v110.SimpleArithmetic;
import nl.b3p.xml.ogc.v110.SpatialOperator;
import nl.b3p.xml.ogc.v110.types.GeometryOperandType;
import nl.b3p.xml.ows.v100.DCP;
import nl.b3p.xml.ows.v100.HTTP;
import nl.b3p.xml.ows.v100.Operation;
import nl.b3p.xml.ows.v100.OperationsMetadata;
import nl.b3p.xml.ows.v100.Parameter_Operation;
import nl.b3p.xml.ows.v100.ServiceContact;
import nl.b3p.xml.ows.v100.ServiceIdentification;
import nl.b3p.xml.ows.v100.ServiceProvider;
import nl.b3p.xml.wfs.FeatureTypeList;
import nl.b3p.xml.wfs.Filter_Capabilities;
import nl.b3p.xml.wfs.v100.capabilities.DCPTypeType;
import nl.b3p.xml.wfs.v100.capabilities.HTTPTypeItem;
import nl.b3p.xml.wfs.v100.capabilities.RequestTypeItem;
import nl.b3p.xml.wfs.v100.capabilities.Service;
import nl.b3p.xml.wfs.v110.FeatureType;
import nl.b3p.xml.wfs.v110.FeatureTypeListType;
import nl.b3p.xml.wfs.v110.FeatureTypeType;
import nl.b3p.xml.wfs.v110.WFS_Capabilities;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.xml.Unmarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WFSGetCapabilitiesResponse
extends OGCResponse
implements OGCConstants {
    private nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities newWfsCapabilitiesV100;
    private WFS_Capabilities newWfsCapabilitiesV110;
    private final List getCapabilitiesV100 = new ArrayList();
    private final List getCapabilitiesV110 = new ArrayList();
    private final List versions = new ArrayList();
    private List supportedOperations = new ArrayList();

    private String createVendorBlock(OGCRequest ogcrequest) {
        StringBuffer xml = new StringBuffer("<?xml version=\"1.0\"?>");
        xml.append("<kaartenbalie>");
        xml.append("<personalcode>");
        xml.append(ogcrequest.getPersonalCode());
        xml.append("</personalcode>");
        xml.append("<username>");
        xml.append(ogcrequest.getUsername());
        xml.append("</username>");
        xml.append("</kaartenbalie>");
        return xml.toString();
    }

    private void buildHeader(OGCRequest ogcrequest) {
        String vendorBlock = this.createVendorBlock(ogcrequest);
        if (this.version.equalsIgnoreCase("1.0.0")) {
            Service s = this.newWfsCapabilitiesV100.getService();
            s.setAbstract(KBConfiguration.SERVICE_ABSTRACT);
            s.setAccessConstraints("<![CDATA[" + vendorBlock + "]]>");
            s.setFees(KBConfiguration.SERVICE_FEES);
            s.setKeywords("");
            s.setName(KBConfiguration.SERVICE_NAME);
            s.setTitle(KBConfiguration.SERVICE_TITLE);
        } else {
            ServiceIdentification si = this.newWfsCapabilitiesV110.getServiceIdentification();
            si.setTitle(KBConfiguration.SERVICE_TITLE);
            si.setAbstract(KBConfiguration.SERVICE_ABSTRACT);
            String[] ac = new String[]{KBConfiguration.SERVICE_CONSTRAINTS};
            si.setAccessConstraints(ac);
            si.setFees(KBConfiguration.SERVICE_FEES);
            ServiceProvider sp = this.newWfsCapabilitiesV110.getServiceProvider();
            sp.setProviderName(KBConfiguration.SERVICE_NAME);
            ServiceContact sc = sp.getServiceContact();
            sc.setIndividualName(KBConfiguration.CONTACT_PERSON);
            sc.setPositionName(KBConfiguration.CONTACT_POSITION);
            sp.setServiceContact(sc);
            OperationsMetadata om = this.newWfsCapabilitiesV110.getOperationsMetadata();
            AnyNode extra = null;
            try {
                extra = OgcWfsClient.xmlStringToAnyNode(vendorBlock);
                om.setExtendedCapabilities(extra);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void rebuildResponse(Document doc, OGCRequest request, String prefix) throws Exception {
        Element element = doc.getDocumentElement();
        this.httpHost = request.getUrlWithNonOGCparams();
        this.findNameSpace(doc);
        this.version = element.getAttribute("VERSION".toLowerCase());
        this.isSupportedVersion(this.version);
        if (this.version.equalsIgnoreCase("1.0.0")) {
            Unmarshaller um = new Unmarshaller(nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities.class);
            Object o = um.unmarshal((Node)element);
            nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities wfsCapabilities = (nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities)o;
            this.getCapabilitiesV100.add(this.replaceCapabilitiesV100Url(wfsCapabilities, prefix));
        } else {
            Unmarshaller um = new Unmarshaller(WFS_Capabilities.class);
            Object o = um.unmarshal((Node)element);
            WFS_Capabilities wfsCapabilities = (WFS_Capabilities)o;
            this.getCapabilitiesV110.add(this.replaceCapabilitiesV110Url(wfsCapabilities, prefix));
        }
        this.checkSupportedOperations(OGCConstants.SUPPORTED_WFS_REQUESTS);
    }

    private void replaceUrl(HTTPTypeItem httpItem) {
        if (httpItem.getGet() != null) {
            httpItem.getGet().setOnlineResource(this.httpHost);
        } else if (httpItem.getPost() != null) {
            httpItem.getPost().setOnlineResource(this.httpHost);
        }
    }

    public nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities replaceCapabilitiesV100Url(nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities wfsCapabilities, String prefix) {
        wfsCapabilities.getService().setOnlineResource(this.httpHost);
        nl.b3p.xml.wfs.v100.capabilities.FeatureType[] featureTypeList = ((nl.b3p.xml.wfs.v100.capabilities.FeatureTypeListType)((Object)wfsCapabilities.getFeatureTypeList())).getFeatureType();
        for (int b = 0; b < featureTypeList.length; ++b) {
            String layer = featureTypeList[b].getName();
            String featureTypeName = this.determineFeatureTypeName(prefix, layer);
            featureTypeList[b].setName(featureTypeName);
        }
        ArrayList<String> newSupportedOperations = new ArrayList<String>();
        int requestCount = wfsCapabilities.getCapability().getRequest().getRequestTypeItemCount();
        for (int i = 0; i < requestCount; ++i) {
            int y;
            int httpItemCount;
            DCPTypeType dcp;
            int x;
            int dcpCount;
            RequestTypeItem requestItem = wfsCapabilities.getCapability().getRequest().getRequestTypeItem(i);
            if (requestItem.getDescribeFeatureType() != null) {
                newSupportedOperations.add("DescribeFeatureType");
                dcpCount = requestItem.getDescribeFeatureType().getDCPType_DescribeFeatureTypeTypeCount();
                for (x = 0; x < dcpCount; ++x) {
                    dcp = requestItem.getDescribeFeatureType().getDCPType_DescribeFeatureTypeType(x);
                    httpItemCount = dcp.getHTTP().getHTTPTypeItemCount();
                    for (y = 0; y < httpItemCount; ++y) {
                        this.replaceUrl(dcp.getHTTP().getHTTPTypeItem(y));
                    }
                }
                continue;
            }
            if (requestItem.getGetCapabilities() != null) {
                newSupportedOperations.add("GetCapabilities");
                dcpCount = requestItem.getGetCapabilities().getDCPType_GetCapabilitiesTypeCount();
                for (x = 0; x < dcpCount; ++x) {
                    dcp = requestItem.getGetCapabilities().getDCPType_GetCapabilitiesType(x);
                    httpItemCount = dcp.getHTTP().getHTTPTypeItemCount();
                    for (y = 0; y < httpItemCount; ++y) {
                        this.replaceUrl(dcp.getHTTP().getHTTPTypeItem(y));
                    }
                }
                continue;
            }
            if (requestItem.getGetFeature() != null) {
                newSupportedOperations.add("GetFeature");
                dcpCount = requestItem.getGetFeature().getDCPType_FeatureTypeTypeCount();
                for (x = 0; x < dcpCount; ++x) {
                    dcp = requestItem.getGetFeature().getDCPType_FeatureTypeType(x);
                    httpItemCount = dcp.getHTTP().getHTTPTypeItemCount();
                    for (y = 0; y < httpItemCount; ++y) {
                        this.replaceUrl(dcp.getHTTP().getHTTPTypeItem(y));
                    }
                }
                continue;
            }
            if (requestItem.getGetFeatureWithLock() != null) {
                newSupportedOperations.add("GetFeatureWithLock");
                dcpCount = requestItem.getGetFeatureWithLock().getDCPType_FeatureTypeTypeCount();
                for (x = 0; x < dcpCount; ++x) {
                    dcp = requestItem.getGetFeatureWithLock().getDCPType_FeatureTypeType(x);
                    httpItemCount = dcp.getHTTP().getHTTPTypeItemCount();
                    for (y = 0; y < httpItemCount; ++y) {
                        this.replaceUrl(dcp.getHTTP().getHTTPTypeItem(y));
                    }
                }
                continue;
            }
            if (requestItem.getLockFeature() != null) {
                newSupportedOperations.add("LockFeature");
                dcpCount = requestItem.getLockFeature().getDCPTypeCount();
                for (x = 0; x < dcpCount; ++x) {
                    dcp = requestItem.getLockFeature().getDCPType(x);
                    httpItemCount = dcp.getHTTP().getHTTPTypeItemCount();
                    for (y = 0; y < httpItemCount; ++y) {
                        this.replaceUrl(dcp.getHTTP().getHTTPTypeItem(y));
                    }
                }
                continue;
            }
            if (requestItem.getTransaction() == null) continue;
            newSupportedOperations.add("Transaction");
            dcpCount = requestItem.getTransaction().getDCPType_TransactionTypeCount();
            for (x = 0; x < dcpCount; ++x) {
                dcp = requestItem.getTransaction().getDCPType_TransactionType(x);
                httpItemCount = dcp.getHTTP().getHTTPTypeItemCount();
                for (y = 0; y < httpItemCount; ++y) {
                    this.replaceUrl(dcp.getHTTP().getHTTPTypeItem(y));
                }
            }
        }
        this.checkSupportedOperations(newSupportedOperations);
        return wfsCapabilities;
    }

    public WFS_Capabilities replaceCapabilitiesV110Url(WFS_Capabilities wfsCapabilities, String prefix) {
        FeatureType[] featureTypeList = ((FeatureTypeListType)((Object)wfsCapabilities.getFeatureTypeList())).getFeatureType();
        for (int b = 0; b < featureTypeList.length; ++b) {
            String layer = featureTypeList[b].getName();
            String featureTypeName = this.determineFeatureTypeName(prefix, layer);
            featureTypeList[b].setName(featureTypeName);
        }
        ArrayList<String> newSupportedOperations = new ArrayList<String>();
        int operationCount = wfsCapabilities.getOperationsMetadata().getOperationCount();
        for (int i = 0; i < operationCount; ++i) {
            Operation operation = wfsCapabilities.getOperationsMetadata().getOperation(i);
            if (!newSupportedOperations.contains(operation.getName())) {
                newSupportedOperations.add(operation.getName());
            }
            int dcpCount = operation.getDCPCount();
            for (int n = 0; n < dcpCount; ++n) {
                DCP dcp = operation.getDCP(n);
                HTTP http = dcp.getHTTP();
                int httpCount = http.getHTTPItemCount();
                for (int x = 0; x < httpCount; ++x) {
                    if (http.getHTTPItem(x).getGet() != null) {
                        http.getHTTPItem(x).getGet().setHref(this.httpHost);
                        continue;
                    }
                    if (http.getHTTPItem(x).getPost() == null) continue;
                    http.getHTTPItem(x).getPost().setHref(this.httpHost);
                }
            }
        }
        this.checkSupportedOperations(newSupportedOperations);
        if (wfsCapabilities.getServiceProvider() != null && wfsCapabilities.getServiceProvider().getServiceContact().getContactInfo() != null && wfsCapabilities.getServiceProvider().getServiceContact().getContactInfo().getOnlineResource() != null) {
            wfsCapabilities.getServiceProvider().getServiceContact().getContactInfo().getOnlineResource().setHref(this.httpHost);
        }
        return wfsCapabilities;
    }

    @Override
    public String getResponseBody(List<SpLayerSummary> layers, OGCRequest ogcrequest, String encoding) {
        String spInUrl = ogcrequest.getServiceProviderName();
        Object castorObject = this.mergeCapabilities(layers, spInUrl);
        if (!this.isUsableResponse()) {
            if (this.hasWfsV100ErrorResponse()) {
                return this.getWfsV100ErrorResponseBody(encoding);
            }
            if (this.hasOwsV100ErrorResponse()) {
                return this.getOwsV100ErrorResponseBody(encoding);
            }
            throw new UnsupportedOperationException("Failed to get suitable reponse! ");
        }
        if (this.hasWfsV100ErrorResponse()) {
            this.logErrorResponse(encoding);
        }
        this.buildHeader(ogcrequest);
        return this.marshalObject(castorObject, encoding);
    }

    private void clearGetCapabilitiesV110() {
        this.getCapabilitiesV110.clear();
    }

    private void clearGetCapabilitiesV100() {
        this.getCapabilitiesV100.clear();
    }

    private Object mergeCapabilities(List<SpLayerSummary> spLayerSummaries, String spInUrl) {
        Object caps = new Object();
        if (this.versions.size() > 1) {
            throw new UnsupportedOperationException("Capabilities with more versions are not yet supported!");
        }
        if (this.version.equalsIgnoreCase("1.0.0")) {
            caps = this.getFeatureTypesV100(spLayerSummaries, spInUrl);
        } else if (this.version.equalsIgnoreCase("1.1.0")) {
            caps = this.getFeatureTypesV110(spLayerSummaries, spInUrl);
        }
        return caps;
    }

    private WFS_Capabilities getFeatureTypesV110(List<SpLayerSummary> spLayerSummaries, String spInUrl) {
        ArrayList<nl.b3p.xml.wfs.FeatureType> foundFeatureTypes = new ArrayList<nl.b3p.xml.wfs.FeatureType>();
        for (WFS_Capabilities nextWfsCapabilitiesV110 : this.getCapabilitiesV110) {
            FeatureTypeList nextTypeList = nextWfsCapabilitiesV110.getFeatureTypeList();
            for (int x = 0; x < ((FeatureTypeListType)((Object)nextTypeList)).getFeatureTypeCount(); ++x) {
                nl.b3p.xml.wfs.FeatureType feature = ((nl.b3p.xml.wfs.v110.FeatureTypeList)nextTypeList).getFeatureType(x);
                String name = ((FeatureTypeType)((Object)feature)).getName();
                try {
                    if (this.getRequestName(name, spLayerSummaries, spInUrl) == null) continue;
                    foundFeatureTypes.add(feature);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.newWfsCapabilitiesV110 == null) {
                this.newWfsCapabilitiesV110 = nextWfsCapabilitiesV110;
                continue;
            }
            this.checkFilterCapabilities(this.newWfsCapabilitiesV110.getFilter_Capabilities(), nextWfsCapabilitiesV110.getFilter_Capabilities());
        }
        if (this.newWfsCapabilitiesV110 == null) {
            return null;
        }
        Iterator it2 = foundFeatureTypes.iterator();
        nl.b3p.xml.wfs.v110.FeatureTypeList foundTypeList = new nl.b3p.xml.wfs.v110.FeatureTypeList();
        while (it2.hasNext()) {
            foundTypeList.addFeatureType((FeatureType)it2.next());
        }
        this.newWfsCapabilitiesV110.setFeatureTypeList(foundTypeList);
        Operation[] operations = this.newWfsCapabilitiesV110.getOperationsMetadata().getOperation();
        String[] names = new String[operations.length];
        for (int x = 0; x < operations.length; ++x) {
            names[x] = operations[x].getName();
        }
        for (int y = 0; y < names.length; ++y) {
            if (!this.supportedOperations.contains(names[y])) {
                Operation remove = operations[y];
                this.newWfsCapabilitiesV110.getOperationsMetadata().removeOperation(remove);
                continue;
            }
            Operation o = operations[y];
            Parameter_Operation[] poa = o.getParameter_Operation();
            for (int x = 0; x < poa.length; ++x) {
                if (poa[x] == null || poa[x].getName() == null || !poa[x].getName().equalsIgnoreCase("outputFormat")) continue;
                poa[x].setValue(0, "text/xml; subtype=gml/3.1.1");
            }
        }
        this.clearGetCapabilitiesV110();
        this.clearVersions();
        this.setUsableResponse(true);
        return this.newWfsCapabilitiesV110;
    }

    private nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities getFeatureTypesV100(List<SpLayerSummary> spLayerSummaries, String spInUrl) {
        ArrayList<nl.b3p.xml.wfs.v100.capabilities.FeatureType> foundFeatureTypes = new ArrayList<nl.b3p.xml.wfs.v100.capabilities.FeatureType>();
        for (nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities nextWfsCapabilitiesV100 : this.getCapabilitiesV100) {
            nl.b3p.xml.wfs.v100.capabilities.FeatureType[] featureTypes = ((nl.b3p.xml.wfs.v100.capabilities.FeatureTypeListType)((Object)nextWfsCapabilitiesV100.getFeatureTypeList())).getFeatureType();
            for (int x = 0; x < featureTypes.length; ++x) {
                nl.b3p.xml.wfs.v100.capabilities.FeatureType feature = featureTypes[x];
                String name = feature.getName();
                try {
                    if (this.getRequestName(name, spLayerSummaries, spInUrl) == null) continue;
                    foundFeatureTypes.add(feature);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.newWfsCapabilitiesV100 == null) {
                this.newWfsCapabilitiesV100 = nextWfsCapabilitiesV100;
                continue;
            }
            this.checkFilterCapabilities(this.newWfsCapabilitiesV100.getFilter_Capabilities(), nextWfsCapabilitiesV100.getFilter_Capabilities());
        }
        if (this.newWfsCapabilitiesV100 == null) {
            return null;
        }
        Iterator it2 = foundFeatureTypes.iterator();
        nl.b3p.xml.wfs.v100.capabilities.FeatureTypeList foundTypeList = new nl.b3p.xml.wfs.v100.capabilities.FeatureTypeList();
        while (it2.hasNext()) {
            foundTypeList.addFeatureType((nl.b3p.xml.wfs.v100.capabilities.FeatureType)it2.next());
        }
        this.newWfsCapabilitiesV100.setFeatureTypeList(foundTypeList);
        RequestTypeItem[] operations = this.newWfsCapabilitiesV100.getCapability().getRequest().getRequestTypeItem();
        ArrayList<RequestTypeItem> unsupportedRequestItems = new ArrayList<RequestTypeItem>();
        for (int x = 0; x < operations.length; ++x) {
            boolean supported = true;
            if (operations[x].getDescribeFeatureType() != null && !this.supportedOperations.contains("DescribeFeatureType")) {
                supported = false;
            } else if (operations[x].getGetCapabilities() != null && !this.supportedOperations.contains("GetCapabilities")) {
                supported = false;
            } else if (operations[x].getGetFeature() != null && !this.supportedOperations.contains("GetFeature")) {
                supported = false;
            } else if (operations[x].getGetFeatureWithLock() != null && !this.supportedOperations.contains("GetFeatureWithLock")) {
                supported = false;
            } else if (operations[x].getLockFeature() != null && !this.supportedOperations.contains("LockFeature")) {
                supported = false;
            } else if (operations[x].getTransaction() != null && !this.supportedOperations.contains("Transaction")) {
                supported = false;
            }
            if (supported) continue;
            unsupportedRequestItems.add(this.newWfsCapabilitiesV100.getCapability().getRequest().getRequestTypeItem(x));
        }
        for (RequestTypeItem requestItem : unsupportedRequestItems) {
            this.newWfsCapabilitiesV100.getCapability().getRequest().removeRequestTypeItem(requestItem);
        }
        this.clearGetCapabilitiesV100();
        this.clearVersions();
        this.setUsableResponse(true);
        return this.newWfsCapabilitiesV100;
    }

    private void checkFilterCapabilities(Filter_Capabilities filterCapabilities, Filter_Capabilities newFilterCapabilities) {
        block34: {
            block33: {
                if (!(filterCapabilities instanceof nl.b3p.xml.ogc.v110.Filter_Capabilities)) break block33;
                nl.b3p.xml.ogc.v110.Filter_Capabilities filter = (nl.b3p.xml.ogc.v110.Filter_Capabilities)filterCapabilities;
                nl.b3p.xml.ogc.v110.Filter_Capabilities newFilter = (nl.b3p.xml.ogc.v110.Filter_Capabilities)newFilterCapabilities;
                GeometryOperandType[] geometryOperand = filter.getSpatial_Capabilities().getGeometryOperands_Spatial_CapabilitiesType().getGeometryOperand();
                GeometryOperandType[] newGeometryOperand = newFilter.getSpatial_Capabilities().getGeometryOperands_Spatial_CapabilitiesType().getGeometryOperand();
                for (int i = 0; i < geometryOperand.length; ++i) {
                    boolean isValid = false;
                    String value = geometryOperand[i].toString();
                    for (int j = 0; j < newGeometryOperand.length; ++j) {
                        String newValue = newGeometryOperand[j].toString();
                        if (!value.equals(newValue)) continue;
                        isValid = true;
                    }
                    if (isValid) continue;
                }
                SpatialOperator[] spatialOperator = filter.getSpatial_Capabilities().getSpatialOperators().getSpatialOperator();
                SpatialOperator[] newSpatialOperator = newFilter.getSpatial_Capabilities().getSpatialOperators().getSpatialOperator();
                for (int x = 0; x < spatialOperator.length; ++x) {
                    boolean isValid = false;
                    String value = spatialOperator[x].getName().toString();
                    for (int y = 0; y < newSpatialOperator.length; ++y) {
                        String newValue = newSpatialOperator[y].getName().toString();
                        if (!value.equals(newValue)) continue;
                        isValid = true;
                    }
                    if (isValid) continue;
                }
                LogicalOperators logicalOperators = filter.getScalar_Capabilities().getLogicalOperators();
                LogicalOperators newLogicalOperators = newFilter.getScalar_Capabilities().getLogicalOperators();
                if (!logicalOperators.toString().equals(newLogicalOperators.toString()) && logicalOperators != null && newLogicalOperators == null) {
                    filter.getScalar_Capabilities().setLogicalOperators(null);
                }
                ComparisonOperatorsTypeItem[] comparisonOperators = null;
                if (filter.getScalar_Capabilities().getComparisonOperators() != null) {
                    comparisonOperators = filter.getScalar_Capabilities().getComparisonOperators().getComparisonOperatorsTypeItem();
                }
                ComparisonOperatorsTypeItem[] newComparisonOperators = null;
                if (newFilter.getScalar_Capabilities().getComparisonOperators() != null) {
                    newComparisonOperators = newFilter.getScalar_Capabilities().getComparisonOperators().getComparisonOperatorsTypeItem();
                }
                if (comparisonOperators != null) {
                    for (int o = 0; o < comparisonOperators.length; ++o) {
                        boolean isValid = false;
                        Class<?> valueClass = comparisonOperators[o].getComparisonOperator().getClass();
                        if (newComparisonOperators != null) {
                            for (int p = 0; p < newComparisonOperators.length; ++p) {
                                Class<?> newValueClass = newComparisonOperators[p].getComparisonOperator().getClass();
                                if (!valueClass.equals(newValueClass)) continue;
                                isValid = true;
                            }
                        }
                        if (isValid) continue;
                        filter.getScalar_Capabilities().getComparisonOperators().removeComparisonOperatorsTypeItem(comparisonOperators[o]);
                    }
                }
                ArithmeticOperatorsTypeItem[] arithmeticOperators = null;
                if (filter.getScalar_Capabilities().getArithmeticOperators() != null) {
                    arithmeticOperators = filter.getScalar_Capabilities().getArithmeticOperators().getArithmeticOperatorsTypeItem();
                }
                Object newArithmeticOperators = null;
                if (newFilter.getScalar_Capabilities().getArithmeticOperators() != null) {
                    newFilter.getScalar_Capabilities().getArithmeticOperators().getArithmeticOperatorsTypeItem();
                }
                if (arithmeticOperators != null) {
                    for (int f = 0; f < arithmeticOperators.length; ++f) {
                        boolean isValid = false;
                        SimpleArithmetic simpleArithmetic = arithmeticOperators[f].getSimpleArithmetic();
                        if (simpleArithmetic != null) {
                            Class<?> valueClass = simpleArithmetic.getClass();
                            if (newArithmeticOperators != null) {
                                for (int h = 0; h < (newArithmeticOperators).length; ++h) {
                                    Class<?> newValueClass = newArithmeticOperators[h].getSimpleArithmetic().getClass();
                                    if (!valueClass.equals(newValueClass)) continue;
                                    isValid = true;
                                }
                            }
                        }
                        if (isValid) continue;
                        filter.getScalar_Capabilities().getArithmeticOperators().removeArithmeticOperatorsTypeItem(arithmeticOperators[f]);
                    }
                }
                Id_CapabilitiesTypeItem[] idCapabilities = filter.getId_Capabilities().getId_CapabilitiesTypeItem();
                Id_CapabilitiesTypeItem[] newIdCapabilities = newFilter.getId_Capabilities().getId_CapabilitiesTypeItem();
                for (int a = 0; a < idCapabilities.length; ++a) {
                    boolean isValid = false;
                    Class<?> valueClass = idCapabilities[a].getChoiceValue().getClass();
                    for (int b = 0; b < newIdCapabilities.length; ++b) {
                        Class<?> newValueClass = newIdCapabilities[b].getChoiceValue().getClass();
                        if (!valueClass.equals(newValueClass)) continue;
                        isValid = true;
                    }
                    if (isValid) continue;
                    filter.getId_Capabilities().removeId_CapabilitiesTypeItem(idCapabilities[a]);
                }
                break block34;
            }
            if (!(filterCapabilities instanceof nl.b3p.xml.ogc.v100.capabilities.Filter_Capabilities)) break block34;
            nl.b3p.xml.ogc.v100.capabilities.Filter_Capabilities filter = (nl.b3p.xml.ogc.v100.capabilities.Filter_Capabilities)filterCapabilities;
            nl.b3p.xml.ogc.v100.capabilities.Filter_Capabilities newFilter = (nl.b3p.xml.ogc.v100.capabilities.Filter_Capabilities)newFilterCapabilities;
            Spatial_OperatorsTypeItem[] spatialOperators = filter.getSpatial_Capabilities().getSpatial_Operators().getSpatial_OperatorsTypeItem();
            Spatial_OperatorsTypeItem[] newSpatialOperators = newFilter.getSpatial_Capabilities().getSpatial_Operators().getSpatial_OperatorsTypeItem();
            for (int i = 0; i < spatialOperators.length; ++i) {
                boolean isValid = false;
                Class<?> valueClass = spatialOperators[i].getChoiceValue().getClass();
                for (int j = 0; j < newSpatialOperators.length; ++j) {
                    Class<?> newValueClass = newSpatialOperators[j].getChoiceValue().getClass();
                    if (!newValueClass.equals(valueClass)) continue;
                    isValid = true;
                }
                if (isValid) continue;
                filter.getSpatial_Capabilities().getSpatial_Operators().removeSpatial_OperatorsTypeItem(spatialOperators[i]);
            }
            Scalar_CapabilitiesTypeItem[] scalarCapabilities = filter.getScalar_Capabilities().getScalar_CapabilitiesTypeItem();
            Scalar_CapabilitiesTypeItem[] newScalarCapabilities = newFilter.getScalar_Capabilities().getScalar_CapabilitiesTypeItem();
            for (int x = 0; x < scalarCapabilities.length; ++x) {
                Class<?> newValueClass;
                int l;
                Class<?> valueClass;
                boolean isValid;
                if (scalarCapabilities[x].getArithmetic_Operators() != null) {
                    Arithmetic_OperatorsTypeItem[] arithmeticOperators = scalarCapabilities[x].getArithmetic_Operators().getArithmetic_OperatorsTypeItem();
                    for (int y = 0; y < newScalarCapabilities.length; ++y) {
                        if (newScalarCapabilities[y].getArithmetic_Operators() == null) continue;
                        Arithmetic_OperatorsTypeItem[] newArithmeticOperators = newScalarCapabilities[y].getArithmetic_Operators().getArithmetic_OperatorsTypeItem();
                        for (int k = 0; k < arithmeticOperators.length; ++k) {
                            isValid = false;
                            valueClass = arithmeticOperators[k].getChoiceValue().getClass();
                            for (l = 0; l < newArithmeticOperators.length; ++l) {
                                newValueClass = newArithmeticOperators[l].getChoiceValue().getClass();
                                if (!valueClass.equals(newValueClass)) continue;
                                isValid = true;
                            }
                            if (isValid) continue;
                            filter.getScalar_Capabilities().getScalar_CapabilitiesTypeItem(x).getArithmetic_Operators().removeArithmetic_OperatorsTypeItem(arithmeticOperators[k]);
                        }
                    }
                    continue;
                }
                if (scalarCapabilities[x].getComparison_Operators() != null) {
                    Comparison_OperatorsTypeItem[] comparisonOperators = scalarCapabilities[x].getComparison_Operators().getComparison_OperatorsTypeItem();
                    for (int y = 0; y < newScalarCapabilities.length; ++y) {
                        if (newScalarCapabilities[y].getComparison_Operators() == null) continue;
                        Comparison_OperatorsTypeItem[] newComparisonOperators = newScalarCapabilities[y].getComparison_Operators().getComparison_OperatorsTypeItem();
                        for (int k = 0; k < comparisonOperators.length; ++k) {
                            isValid = false;
                            valueClass = comparisonOperators[k].getChoiceValue().getClass();
                            for (l = 0; l < newComparisonOperators.length; ++l) {
                                newValueClass = newComparisonOperators[l].getChoiceValue().getClass();
                                if (!valueClass.equals(newValueClass)) continue;
                                isValid = true;
                            }
                            if (isValid || x >= filter.getScalar_Capabilities().getScalar_CapabilitiesTypeItemCount()) continue;
                            filter.getScalar_Capabilities().getScalar_CapabilitiesTypeItem(x).getComparison_Operators().removeComparison_OperatorsTypeItem(comparisonOperators[k]);
                        }
                    }
                    continue;
                }
                if (scalarCapabilities[x].getLogical_Operators() == null) continue;
                boolean isValid2 = false;
                Class<?> valueClass2 = scalarCapabilities[x].getLogical_Operators().getClass();
                for (int y = 0; y < newScalarCapabilities.length; ++y) {
                    Class<?> newValueClass2 = null;
                    if (newScalarCapabilities != null && newScalarCapabilities[y].getLogical_Operators() != null) {
                        newValueClass2 = newScalarCapabilities[y].getLogical_Operators().getClass();
                    }
                    if (!valueClass2.equals(newValueClass2)) continue;
                    isValid2 = true;
                }
                if (isValid2) continue;
                filter.getScalar_Capabilities().removeScalar_CapabilitiesTypeItem(scalarCapabilities[x]);
            }
        }
    }

    private void checkSupportedOperations(List newSupportedOperations) {
        if (this.supportedOperations.size() < 1) {
            this.supportedOperations = newSupportedOperations;
        } else {
            boolean equals = true;
            if (this.supportedOperations.size() == newSupportedOperations.size()) {
                Iterator it = newSupportedOperations.iterator();
                while (it.hasNext()) {
                    if (this.supportedOperations.contains(it.next())) continue;
                    equals = false;
                }
            } else {
                equals = false;
            }
            if (!equals) {
                ArrayList remove = new ArrayList();
                for (Object o : this.supportedOperations) {
                    if (newSupportedOperations.contains(o)) continue;
                    remove.add(o);
                }
                Iterator itremove = remove.iterator();
                while (itremove.hasNext()) {
                    this.supportedOperations.remove(itremove.next());
                }
            }
        }
    }

    private void clearVersions() {
        this.versions.clear();
    }

    private boolean isSupportedVersion(String version) {
        if (OGCConstants.SUPPORTED_WFS_VERSIONS.contains(version)) {
            if (!this.versions.contains(version) && version != null) {
                this.versions.add(version);
            }
            return true;
        }
        throw new UnsupportedOperationException("WFS Version the serviceProvider returned is not supported by Kaartenbalie!");
    }
}

