/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.utils;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.jump.feature.AttributeType;

public class SqlMetaDataUtils {
    public static final String PRODUCT_POSTGRES = "PostgreSQL";

    public static List getTableAndViewNames(Connection conn) throws SQLException {
        DatabaseMetaData dbmd = conn.getMetaData();
        String[] types = new String[]{"TABLE", "VIEW"};
        ResultSet rs = dbmd.getTables(null, null, null, types);
        ArrayList<String> tables = null;
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            if (tables == null) {
                tables = new ArrayList<String>();
            }
            tables.add(tableName);
        }
        return tables;
    }

    public static List getColumnNames(String tablename, String column, Connection conn) throws SQLException {
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getColumns(null, null, tablename, column);
        ArrayList<String> columns = null;
        while (rs.next()) {
            String columnName = rs.getString("COLUMN_NAME");
            if (columns == null) {
                columns = new ArrayList<String>();
            }
            columns.add(columnName);
        }
        return columns;
    }

    public static AttributeType getAttributeTypeFromSqlType(int sqlType) {
        AttributeType at = null;
        if (sqlType == -5 || sqlType == 4 || sqlType == 5 || sqlType == -6 || sqlType == 2) {
            at = AttributeType.INTEGER;
        } else if (sqlType == 91 || sqlType == 92 || sqlType == 93) {
            at = AttributeType.DATE;
        } else if (sqlType == 3 || sqlType == 8 || sqlType == 6 || sqlType == 7) {
            at = AttributeType.DOUBLE;
        } else if (sqlType == 1 || sqlType == 2004 || sqlType == 2005 || sqlType == -1 || sqlType == 12) {
            at = AttributeType.STRING;
        } else if (sqlType == 1111) {
            at = AttributeType.OBJECT;
        }
        return at;
    }
}

