/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.wfs.v110;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.commons.services.HttpClientConfigured;
import nl.b3p.ogc.utils.OGCCommunication;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.wfs.v110.WfsLayer;
import nl.b3p.ogc.wfs.v110.WfsServiceProvider;
import nl.b3p.xml.wfs.v100.capabilities.FeatureTypeListType;
import nl.b3p.xml.wfs.v110.FeatureType;
import nl.b3p.xml.wfs.v110.GetCapabilities;
import nl.b3p.xml.wfs.v110.WFS_Capabilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WfsCapabilitiesReader {
    private static final Log log = LogFactory.getLog(WfsCapabilitiesReader.class);

    public WfsServiceProvider getProvider(String url) throws IOException, Exception {
        return this.getProvider(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WfsServiceProvider getProvider(String url, B3PCredentials credentials) throws IOException, Exception {
        WfsServiceProvider provider;
        block13: {
            provider = new WfsServiceProvider();
            HttpClientConfigured hcc = new HttpClientConfigured(credentials);
            OGCRequest or = new OGCRequest(url);
            or.addOrReplaceParameter("REQUEST", "GetCapabilities");
            or.addOrReplaceParameter("SERVICE", "WFS");
            String eUrl = or.getUrl();
            HttpGet httpget = new HttpGet(eUrl);
            HttpResponse response = hcc.execute((HttpUriRequest)httpget);
            try {
                HttpEntity entity = response.getEntity();
                if (entity == null) {
                    String body = this.getGetCapabilitieBody();
                    HttpPost httppost = new HttpPost(body);
                    httppost.setEntity((HttpEntity)new StringEntity(body));
                    response = hcc.execute((HttpUriRequest)httppost);
                    entity = response.getEntity();
                }
                if (entity != null) {
                    InputStream is = entity.getContent();
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    DocumentBuilder builder = dbf.newDocumentBuilder();
                    Document doc = builder.parse(is);
                    Element rootElement = doc.getDocumentElement();
                    OGCCommunication ogcc = new OGCCommunication();
                    ogcc.findNameSpace(doc);
                    String version = rootElement.getAttribute("VERSION".toLowerCase());
                    if (version.equalsIgnoreCase("1.0.0")) {
                        Unmarshaller um = new Unmarshaller(nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities.class);
                        Object o = um.unmarshal((Node)rootElement);
                        nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities wfsCapabilities = (nl.b3p.xml.wfs.v100.capabilities.WFS_Capabilities)o;
                        provider.setWfsVersion(wfsCapabilities.getVersion());
                        Date date = new Date(System.currentTimeMillis());
                        provider.setUpdatedDate(date);
                        String title = wfsCapabilities.getService().getTitle();
                        provider.setName("OGC:WFS");
                        provider.setTitle(title);
                        nl.b3p.xml.wfs.v100.capabilities.FeatureType[] featureTypeArray = ((FeatureTypeListType)((Object)wfsCapabilities.getFeatureTypeList())).getFeatureType();
                        for (int i = 0; i < featureTypeArray.length; ++i) {
                            nl.b3p.xml.wfs.v100.capabilities.FeatureType featureType = featureTypeArray[i];
                            WfsLayer layer = new WfsLayer();
                            String lname = ogcc.fixNsPrefix(featureType.getName());
                            layer.setName(lname);
                            String layerTitle = featureType.getTitle();
                            if (layerTitle != null && layerTitle.length() != 0) {
                                layer.setTitle(layerTitle);
                            } else {
                                layer.setTitle(layer.getName());
                            }
                            layer.setWfsServiceProvider(provider);
                            provider.addWfsLayer(layer);
                        }
                    } else {
                        Unmarshaller um = new Unmarshaller(WFS_Capabilities.class);
                        Object o = um.unmarshal((Node)rootElement);
                        WFS_Capabilities wfsCapabilities = (WFS_Capabilities)o;
                        provider.setWfsVersion(wfsCapabilities.getVersion());
                        Date date = new Date(System.currentTimeMillis());
                        provider.setUpdatedDate(date);
                        String title = wfsCapabilities.getServiceProvider().getProviderName();
                        provider.setName("OGC:WFS");
                        provider.setTitle(title);
                        FeatureType[] featureTypeArray = ((nl.b3p.xml.wfs.v110.FeatureTypeListType)((Object)wfsCapabilities.getFeatureTypeList())).getFeatureType();
                        for (int i = 0; i < featureTypeArray.length; ++i) {
                            FeatureType featureType = featureTypeArray[i];
                            WfsLayer layer = new WfsLayer();
                            String lname = ogcc.fixNsPrefix(featureType.getName());
                            layer.setName(lname);
                            String layerTitle = featureType.getTitle();
                            if (layerTitle != null && layerTitle.length() != 0) {
                                layer.setTitle(layerTitle);
                            } else {
                                layer.setTitle(layer.getName());
                            }
                            layer.setWfsServiceProvider(provider);
                            provider.addWfsLayer(layer);
                        }
                    }
                    break block13;
                }
                log.error((Object)("Error doing Post getCapabilities: " + response.getStatusLine().getStatusCode() + ": " + this.getGetCapabilitieBody()));
                throw new Exception("Error doing HTTPPost and HTTPGet method. Code returned: " + response.getStatusLine().getStatusCode() + " request: " + or.getUrl());
            }
            finally {
                hcc.close(response);
                hcc.close();
            }
        }
        provider.setUrl(url);
        return provider;
    }

    public String getGetCapabilitieBody() {
        String body = null;
        GetCapabilities getCapabilities = new GetCapabilities();
        getCapabilities.setService("WFS");
        try {
            StringWriter sw = new StringWriter();
            Marshaller m = new Marshaller((Writer)sw);
            m.setNamespaceMapping("wfs", "http://www.opengis.net/wfs");
            m.setNamespaceMapping("gml", "http://www.opengis.net/gml");
            m.setNamespaceMapping("ogc", "http://www.opengis.net/ogc");
            m.setNamespaceMapping("app", "http://www.deegree.org/app");
            m.setNamespaceMapping("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            m.setSchemaLocation("http://www.opengis.net/wfs ../wfs/1.1.0/WFS.xsd");
            m.marshal((Object)getCapabilities);
            body = sw.toString();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Failed to make body for getCapabilities request!");
        }
        return body;
    }
}

