/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.wms.capabilities;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import nl.b3p.commons.services.B3PCredentials;
import nl.b3p.commons.services.HttpClientConfigured;
import nl.b3p.commons.xml.IgnoreEntityResolver;
import nl.b3p.wms.capabilities.Attribution;
import nl.b3p.wms.capabilities.ContactInformation;
import nl.b3p.wms.capabilities.Dimensions;
import nl.b3p.wms.capabilities.ElementHandler;
import nl.b3p.wms.capabilities.Identifier;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.LayerDomainResource;
import nl.b3p.wms.capabilities.Roles;
import nl.b3p.wms.capabilities.ServiceDomainResource;
import nl.b3p.wms.capabilities.ServiceProvider;
import nl.b3p.wms.capabilities.SrsBoundingBox;
import nl.b3p.wms.capabilities.Style;
import nl.b3p.wms.capabilities.StyleDomainResource;
import nl.b3p.wms.capabilities.Switcher;
import nl.b3p.wms.capabilities.TileSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class WMSCapabilitiesReader {
    private static final Log log = LogFactory.getLog(WMSCapabilitiesReader.class);
    private static final String VALIDATION_FEATURE = "http://xml.org/sax/features/validation";
    private static final String SCHEMA_FEATURE = "http://apache.org/xml/features/validation/schema";
    private static final String SCHEMA_FACTORY = "http://www.w3.org/2001/XMLSchema";
    private static final String SCHEMA_FILE = "wms.xsd";
    private Stack stack = new Stack();
    private Switcher s = null;
    private ServiceProvider serviceProvider = null;

    public WMSCapabilitiesReader() {
        this.setElementHandlers();
    }

    private void checkObject(Object obj) throws SAXException {
        if (obj != null) {
            return;
        }
        StringBuffer message = new StringBuffer();
        message.append("No service provider created, possible cause: invalid GetCapabilities xml. ");
        if (obj instanceof ServiceProvider) {
            message.append("Service provider is null. ");
        } else if (obj instanceof Layer) {
            message.append("Layer is null. ");
        }
        throw new SAXException(message.toString());
    }

    public ByteArrayOutputStream getCapabilities(String location) throws Exception {
        return this.getCapabilities(location, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream getCapabilities(String location, B3PCredentials credentials, String remoteAddr) throws Exception {
        HttpClientConfigured hcc = new HttpClientConfigured(credentials);
        HttpGet httpget = new HttpGet(location);
        if (remoteAddr != null) {
            httpget.addHeader("X-Forwarded-For", remoteAddr);
        }
        HttpResponse response = hcc.execute((HttpUriRequest)httpget);
        ByteArrayOutputStream out = null;
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                Header mimeType = entity.getContentType();
                if (mimeType == null || mimeType.getValue().indexOf("xml") == -1) {
                    throw new Exception("Host: " + location + " error: Cannot get a GetCapabilities document from server");
                }
                if (mimeType.getValue().equals("application/vnd.ogc.se_xml")) {
                    throw new Exception("Host: " + location + " error: Cannot get a GetCapabilities document. reason: " + entity.getContent());
                }
                InputStream is = entity.getContent();
                int len = 0;
                out = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while ((len = is.read(buf)) > -1) {
                    out.write(buf, 0, len);
                }
            }
        }
        finally {
            hcc.close(response);
            hcc.close();
        }
        if (out == null) {
            throw new Exception("Host: " + location + " error: No service provider object could be created, unkown reason!");
        }
        return out;
    }

    public ServiceProvider getProvider(String location) throws IOException, SAXException, Exception {
        return this.getProvider(location, null, null);
    }

    public ServiceProvider getProvider(String location, B3PCredentials credentials) throws IOException, SAXException, Exception {
        return this.getProvider(location, credentials, null);
    }

    public ServiceProvider getProvider(String location, String username, String password, String ip) throws IOException, SAXException, Exception {
        B3PCredentials cred = new B3PCredentials();
        cred.setUserName(username);
        cred.setPassword(password);
        return this.getProvider(location, cred, ip);
    }

    public ServiceProvider getProvider(String location, B3PCredentials credentials, String remoteAddr) throws IOException, SAXException, Exception {
        ByteArrayOutputStream getCap = this.getCapabilities(location, credentials, remoteAddr);
        ByteArrayInputStream in = new ByteArrayInputStream(getCap.toByteArray());
        this.serviceProvider = new ServiceProvider();
        XMLReader reader = XMLReaderFactory.createXMLReader();
        IgnoreEntityResolver r = new IgnoreEntityResolver();
        reader.setEntityResolver((EntityResolver)r);
        reader.setContentHandler(this.s);
        InputSource is = new InputSource(in);
        is.setEncoding("UTF-8");
        reader.parse(is);
        if (this.serviceProvider == null) {
            log.error((Object)("Host: " + location + " error: No service provider object could be created, unkown reason!"));
            throw new Exception("Host: " + location + " error: No service provider object could be created, unkown reason!");
        }
        return this.serviceProvider;
    }

    public ServiceProvider getProvider(ByteArrayInputStream in) {
        this.serviceProvider = new ServiceProvider();
        XMLReader reader = null;
        try {
            reader = XMLReaderFactory.createXMLReader();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        IgnoreEntityResolver r = new IgnoreEntityResolver();
        reader.setEntityResolver((EntityResolver)r);
        reader.setContentHandler(this.s);
        InputSource is = new InputSource(in);
        is.setEncoding("UTF-8");
        try {
            reader.parse(is);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.serviceProvider;
    }

    private void validate(String location) throws IOException, SAXException {
        SchemaFactory factory = SchemaFactory.newInstance(SCHEMA_FACTORY);
        File schemaLocation = new File(SCHEMA_FILE);
        Schema schema = factory.newSchema(schemaLocation);
        Validator validator = schema.newValidator();
        StreamSource source = new StreamSource(new File(location));
        validator.validate(source);
    }

    private void setElementHandlers() {
        this.s = new Switcher();
        this.s.setElementHandler("WMT_MS_Capabilities", new WMTHandler());
        this.s.setElementHandler("Service", new ServiceHandler());
        this.s.setElementHandler("Name", new NameHandler());
        this.s.setElementHandler("Title", new TitleHandler());
        this.s.setElementHandler("Abstract", new AbstractHandler());
        this.s.setElementHandler("Fees", new FeesHandler());
        this.s.setElementHandler("AccessConstraints", new ConstraintsHandler());
        this.s.setElementHandler("OnlineResource", new OnlineResourceHandler());
        this.s.setElementHandler("KeywordList", new KeywordListHandler());
        this.s.setElementHandler("Keyword", new KeywordHandler());
        this.s.setElementHandler("City", new CityHandler());
        this.s.setElementHandler("Address", new AddressHandler());
        this.s.setElementHandler("AddressType", new AddressTypeHandler());
        this.s.setElementHandler("StateOrProvince", new StateOrProvinceHandler());
        this.s.setElementHandler("PostCode", new PostCodeHandler());
        this.s.setElementHandler("Country", new CountryHandler());
        this.s.setElementHandler("ContactOrganization", new ContactOrganizationHandler());
        this.s.setElementHandler("ContactPerson", new ContactPersonHandler());
        this.s.setElementHandler("ContactPersonPrimary", new ContactPersonPrimaryHandler());
        this.s.setElementHandler("ContactPosition", new ContactPositionHandler());
        this.s.setElementHandler("ContactAddress", new ContactAddressHandler());
        this.s.setElementHandler("ContactVoiceTelephone", new ContactVoiceTelephoneHandler());
        this.s.setElementHandler("ContactFacsimileTelephone", new ContactFacsimileTelephoneHandler());
        this.s.setElementHandler("ContactElectronicMailAddress", new ContactElectronicMailAddressHandler());
        this.s.setElementHandler("ContactInformation", new ContactInformationHandler());
        this.s.setElementHandler("Format", new FormatHandler());
        this.s.setElementHandler("SRS", new SRSHandler());
        this.s.setElementHandler("Capability", new CapabilityHandler());
        this.s.setElementHandler("Request", new RequestHandler());
        this.s.setElementHandler("Exception", new ExceptionHandler());
        this.s.setElementHandler("GetCapabilities", new GetCapabilitiesHandler());
        this.s.setElementHandler("GetMap", new GetMapHandler());
        this.s.setElementHandler("GetFeatureInfo", new GetFeatureInfoHandler());
        this.s.setElementHandler("DescribeLayer", new DescribeLayerHandler());
        this.s.setElementHandler("GetLegendGraphic", new GetLegendGraphicHandler());
        this.s.setElementHandler("GetStyles", new GetStylesHandler());
        this.s.setElementHandler("Style", new StyleHandler());
        this.s.setElementHandler("LegendURL", new LegendURLHandler());
        this.s.setElementHandler("Layer", new LayerHandler());
        this.s.setElementHandler("Attribution", new AttributionHandler());
        this.s.setElementHandler("DCPType", new DCPTypeHandler());
        this.s.setElementHandler("Get", new GetHandler());
        this.s.setElementHandler("Post", new PostHandler());
        this.s.setElementHandler("HTTP", new HTTPHandler());
        this.s.setElementHandler("PutStyles", new PutStylesHandler());
        this.s.setElementHandler("BoundingBox", new BoundingBoxHandler());
        this.s.setElementHandler("LatLonBoundingBox", new LatLonBoundingBoxHandler());
        this.s.setElementHandler("Dimension", new DimensionHandler());
        this.s.setElementHandler("Extent", new ExtentHandler());
        this.s.setElementHandler("AuthorityURL", new AuthorityURLHandler());
        this.s.setElementHandler("Identifier", new IdentifierHandler());
        this.s.setElementHandler("MetadataURL", new MetadataURLHandler());
        this.s.setElementHandler("DataURL", new DataURLHandler());
        this.s.setElementHandler("FeatureListURL", new FeatureListURLHandler());
        this.s.setElementHandler("ScaleHint", new ScaleHintHandler());
        this.s.setElementHandler("LogoURL", new LogoURLHandler());
        this.s.setElementHandler("StyleURL", new StyleURLHandler());
        this.s.setElementHandler("StyleSheetURL", new StyleSheetURLHandler());
        this.s.setElementHandler("LegendURL", new LegendURLHandler());
        this.s.setElementHandler("VendorSpecificCapabilities", new VendorSpecificCapabilitiesHandler());
        this.s.setElementHandler("Role", new RoleHandler());
        this.s.setElementHandler("OrganizationCode", new OrganizationCodeHandler());
        this.s.setElementHandler("ExpireDate", new ExpireDateHandler());
        this.s.setElementHandler("UserName", new UserNameHandler());
        this.s.setElementHandler("GivenName", new GivenNameHandler());
        this.s.setElementHandler("PersonalCode", new PersonalCodeHandler());
        this.s.setElementHandler("TileSet", new TileSetHandler());
        this.s.setElementHandler("Resolutions", new ResolutionsHandler());
        this.s.setElementHandler("Width", new WidthHandler());
        this.s.setElementHandler("Height", new HeightHandler());
        this.s.setElementHandler("Format", new FormatHandler());
        this.s.setElementHandler("Layers", new LayersHandler());
        this.s.setElementHandler("Styles", new StylesHandler());
    }

    private class UserDefinedSymbolizationHandler
    extends ElementHandler {
        private UserDefinedSymbolizationHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class WidthHandler
    extends ElementHandler {
        StringBuffer sb;

        private WidthHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof TileSet) {
                TileSet tileset = (TileSet)object;
                WMSCapabilitiesReader.this.checkObject(tileset);
                tileset.setWidth(new Integer(this.sb.toString()));
            }
        }
    }

    private class StylesHandler
    extends ElementHandler {
        StringBuffer sb;

        private StylesHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof TileSet) {
                TileSet tileset = (TileSet)object;
                WMSCapabilitiesReader.this.checkObject(tileset);
                tileset.setStyles(this.sb.toString());
            }
        }
    }

    private class LayersHandler
    extends ElementHandler {
        StringBuffer sb;

        private LayersHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof TileSet) {
                TileSet tileset = (TileSet)object;
                WMSCapabilitiesReader.this.checkObject(tileset);
                tileset.setLayerString(this.sb.toString());
            }
        }
    }

    private class HeightHandler
    extends ElementHandler {
        StringBuffer sb;

        private HeightHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof TileSet) {
                TileSet tileset = (TileSet)object;
                WMSCapabilitiesReader.this.checkObject(tileset);
                tileset.setHeight(new Integer(this.sb.toString()));
            }
        }
    }

    private class ResolutionsHandler
    extends ElementHandler {
        StringBuffer sb;

        private ResolutionsHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof TileSet) {
                TileSet tileset = (TileSet)object;
                WMSCapabilitiesReader.this.checkObject(tileset);
                tileset.setResolutions(this.sb.toString());
            }
        }
    }

    private class TileSetHandler
    extends ElementHandler {
        private TileSetHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            TileSet tileset = new TileSet();
            WMSCapabilitiesReader.this.stack.push(tileset);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            TileSet ts = (TileSet)WMSCapabilitiesReader.this.stack.pop();
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ServiceProvider) {
                ServiceProvider sp = (ServiceProvider)object;
                WMSCapabilitiesReader.this.checkObject(sp);
                sp.addTileSet(ts);
                ts.setServiceProvider(WMSCapabilitiesReader.this.serviceProvider);
            }
        }
    }

    private class PersonalCodeHandler
    extends ElementHandler {
        StringBuffer sb;

        private PersonalCodeHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ServiceProvider serviceProvider = (ServiceProvider)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(serviceProvider);
            serviceProvider.setPersonalCode(this.sb.toString());
        }
    }

    private class GivenNameHandler
    extends ElementHandler {
        StringBuffer sb;

        private GivenNameHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ServiceProvider serviceProvider = (ServiceProvider)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(serviceProvider);
            serviceProvider.setGivenName(this.sb.toString());
        }
    }

    private class UserNameHandler
    extends ElementHandler {
        StringBuffer sb;

        private UserNameHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ServiceProvider serviceProvider = (ServiceProvider)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(serviceProvider);
            serviceProvider.setUserName(this.sb.toString());
        }
    }

    private class ExpireDateHandler
    extends ElementHandler {
        StringBuffer sb;

        private ExpireDateHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ServiceProvider serviceProvider = (ServiceProvider)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(serviceProvider);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            Date today = null;
            try {
                today = df.parse(this.sb.toString());
            }
            catch (ParseException e) {
                log.debug((Object)("Error pasring string to Date." + e));
            }
            serviceProvider.setExpireDate(today);
        }
    }

    private class OrganizationCodeHandler
    extends ElementHandler {
        StringBuffer sb;

        private OrganizationCodeHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ServiceProvider serviceProvider = (ServiceProvider)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(serviceProvider);
            serviceProvider.setOrganizationCode(this.sb.toString());
        }
    }

    private class RoleHandler
    extends ElementHandler {
        private RoleHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            Roles roles = new Roles();
            roles.setRole(atts.getValue("id"));
            WMSCapabilitiesReader.this.stack.push(roles);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Roles roles = (Roles)WMSCapabilitiesReader.this.stack.pop();
            ServiceProvider serviceProvider = (ServiceProvider)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(serviceProvider);
            serviceProvider.addRole(roles);
        }
    }

    private class VendorSpecificCapabilitiesHandler
    extends ElementHandler {
        private VendorSpecificCapabilitiesHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class ContactElectronicMailAddressHandler
    extends ElementHandler {
        StringBuffer sb;

        private ContactElectronicMailAddressHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ContactInformation) {
                ContactInformation contactInformation = (ContactInformation)object;
                WMSCapabilitiesReader.this.checkObject(contactInformation);
                contactInformation.setEmailAddress(this.sb.toString());
            }
        }
    }

    private class ContactFacsimileTelephoneHandler
    extends ElementHandler {
        StringBuffer sb;

        private ContactFacsimileTelephoneHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ContactInformation) {
                ContactInformation contactInformation = (ContactInformation)object;
                WMSCapabilitiesReader.this.checkObject(contactInformation);
                contactInformation.setFascimileTelephone(this.sb.toString());
            }
        }
    }

    private class ContactVoiceTelephoneHandler
    extends ElementHandler {
        StringBuffer sb;

        private ContactVoiceTelephoneHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ContactInformation) {
                ContactInformation contactInformation = (ContactInformation)object;
                WMSCapabilitiesReader.this.checkObject(contactInformation);
                contactInformation.setVoiceTelephone(this.sb.toString());
            }
        }
    }

    private class CountryHandler
    extends ElementHandler {
        StringBuffer sb;

        private CountryHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ContactInformation) {
                ContactInformation contactInformation = (ContactInformation)object;
                WMSCapabilitiesReader.this.checkObject(contactInformation);
                contactInformation.setCountry(this.sb.toString());
            }
        }
    }

    private class PostCodeHandler
    extends ElementHandler {
        StringBuffer sb;

        private PostCodeHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ContactInformation) {
                ContactInformation contactInformation = (ContactInformation)object;
                WMSCapabilitiesReader.this.checkObject(contactInformation);
                contactInformation.setPostcode(this.sb.toString());
            }
        }
    }

    private class StateOrProvinceHandler
    extends ElementHandler {
        StringBuffer sb;

        private StateOrProvinceHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ContactInformation) {
                ContactInformation contactInformation = (ContactInformation)object;
                WMSCapabilitiesReader.this.checkObject(contactInformation);
                contactInformation.setStateOrProvince(this.sb.toString());
            }
        }
    }

    private class CityHandler
    extends ElementHandler {
        StringBuffer sb;

        private CityHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ContactInformation) {
                ContactInformation contactInformation = (ContactInformation)object;
                WMSCapabilitiesReader.this.checkObject(contactInformation);
                contactInformation.setCity(this.sb.toString());
            }
        }
    }

    private class AddressHandler
    extends ElementHandler {
        StringBuffer sb;

        private AddressHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ContactInformation) {
                ContactInformation contactInformation = (ContactInformation)object;
                WMSCapabilitiesReader.this.checkObject(contactInformation);
                contactInformation.setAddress(this.sb.toString());
            }
        }
    }

    private class AddressTypeHandler
    extends ElementHandler {
        StringBuffer sb;

        private AddressTypeHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ContactInformation) {
                ContactInformation contactInformation = (ContactInformation)object;
                WMSCapabilitiesReader.this.checkObject(contactInformation);
                contactInformation.setAddressType(this.sb.toString());
            }
        }
    }

    private class ContactAddressHandler
    extends ElementHandler {
        private ContactAddressHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class ContactPositionHandler
    extends ElementHandler {
        StringBuffer sb;

        private ContactPositionHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ContactInformation) {
                ContactInformation contactInformation = (ContactInformation)object;
                WMSCapabilitiesReader.this.checkObject(contactInformation);
                contactInformation.setContactPosition(this.sb.toString());
            }
        }
    }

    private class ContactOrganizationHandler
    extends ElementHandler {
        StringBuffer sb;

        private ContactOrganizationHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ContactInformation) {
                ContactInformation contactInformation = (ContactInformation)object;
                WMSCapabilitiesReader.this.checkObject(contactInformation);
                contactInformation.setContactOrganization(this.sb.toString());
            }
        }
    }

    private class ContactPersonHandler
    extends ElementHandler {
        StringBuffer sb;

        private ContactPersonHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ContactInformation) {
                ContactInformation contactInformation = (ContactInformation)object;
                WMSCapabilitiesReader.this.checkObject(contactInformation);
                contactInformation.setContactPerson(this.sb.toString());
            }
        }
    }

    private class ContactPersonPrimaryHandler
    extends ElementHandler {
        private ContactPersonPrimaryHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class ContactInformationHandler
    extends ElementHandler {
        private ContactInformationHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            ContactInformation contactInformation = new ContactInformation();
            WMSCapabilitiesReader.this.stack.push(contactInformation);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ContactInformation contactInformation = (ContactInformation)WMSCapabilitiesReader.this.stack.pop();
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ServiceProvider) {
                ServiceProvider serviceProvider = (ServiceProvider)object;
                WMSCapabilitiesReader.this.checkObject(serviceProvider);
                serviceProvider.setContactInformation(contactInformation);
            }
        }
    }

    private class OnlineResourceHandler
    extends ElementHandler {
        private OnlineResourceHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String xlink = attributes.getValue("xmlns:xlink");
            String type = attributes.getValue("xlink:type");
            String href = attributes.getValue("xlink:href");
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof String) {
                String method = (String)object;
                WMSCapabilitiesReader.this.checkObject(method);
                if (method.equals("GET") || method.equals("POST")) {
                    WMSCapabilitiesReader.this.stack.pop();
                    Object object2 = WMSCapabilitiesReader.this.stack.peek();
                    if (object2 instanceof ServiceDomainResource) {
                        ServiceDomainResource domainResource = (ServiceDomainResource)WMSCapabilitiesReader.this.stack.pop();
                        String domain = (String)WMSCapabilitiesReader.this.stack.peek();
                        domainResource.setDomain(domain);
                        if (method.equals("GET")) {
                            domainResource.setGetUrl(href);
                        } else if (method.equals("POST")) {
                            domainResource.setPostUrl(href);
                        }
                        WMSCapabilitiesReader.this.stack.push(domainResource);
                    }
                }
            } else if (object instanceof LayerDomainResource) {
                LayerDomainResource domainResource = (LayerDomainResource)WMSCapabilitiesReader.this.stack.pop();
                WMSCapabilitiesReader.this.checkObject(domainResource);
                String domain = (String)WMSCapabilitiesReader.this.stack.peek();
                domainResource.setUrl(href);
                domainResource.setDomain(domain);
                WMSCapabilitiesReader.this.stack.push(domainResource);
            } else if (object instanceof StyleDomainResource) {
                StyleDomainResource domainResource = (StyleDomainResource)WMSCapabilitiesReader.this.stack.pop();
                WMSCapabilitiesReader.this.checkObject(domainResource);
                String domain = (String)WMSCapabilitiesReader.this.stack.peek();
                String urlString = href;
                if (domain.equals("LegendURL") && !urlString.toLowerCase().contains("service=wms")) {
                    urlString = urlString + "&SERVICE=WMS";
                }
                domainResource.setUrl(urlString);
                domainResource.setDomain(domain);
                WMSCapabilitiesReader.this.stack.push(domainResource);
            } else if (object instanceof ServiceProvider) {
                ServiceProvider serviceProvider = (ServiceProvider)object;
                WMSCapabilitiesReader.this.checkObject(serviceProvider);
                serviceProvider.setUrl(href);
            } else if (object instanceof Attribution) {
                Attribution attribution = (Attribution)object;
                WMSCapabilitiesReader.this.checkObject(attribution);
                attribution.setAttributionURL(href);
            } else if (object instanceof Identifier) {
                Identifier identifier = (Identifier)object;
                WMSCapabilitiesReader.this.checkObject(identifier);
                identifier.setAuthorityURL(href);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class KeywordHandler
    extends ElementHandler {
        StringBuffer sb;

        private KeywordHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ServiceProvider) {
                ServiceProvider serviceProvider = (ServiceProvider)object;
                WMSCapabilitiesReader.this.checkObject(serviceProvider);
                serviceProvider.addKeyword(this.sb.toString());
            } else if (object instanceof Layer) {
                Layer layer = (Layer)object;
                WMSCapabilitiesReader.this.checkObject(layer);
                layer.addKeyword(this.sb.toString());
            }
        }
    }

    private class KeywordListHandler
    extends ElementHandler {
        private KeywordListHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class ConstraintsHandler
    extends ElementHandler {
        StringBuffer sb;

        private ConstraintsHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ServiceProvider) {
                ServiceProvider serviceProvider = (ServiceProvider)object;
                WMSCapabilitiesReader.this.checkObject(serviceProvider);
                serviceProvider.setAccessConstraints(this.sb.toString());
            }
        }
    }

    private class FeesHandler
    extends ElementHandler {
        StringBuffer sb;

        private FeesHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ServiceProvider) {
                ServiceProvider serviceProvider = (ServiceProvider)object;
                WMSCapabilitiesReader.this.checkObject(serviceProvider);
                serviceProvider.setFees(this.sb.toString());
            }
        }
    }

    private class AbstractHandler
    extends ElementHandler {
        StringBuffer sb;

        private AbstractHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ServiceProvider) {
                ServiceProvider serviceProvider = (ServiceProvider)object;
                WMSCapabilitiesReader.this.checkObject(serviceProvider);
                serviceProvider.setAbstracts(this.sb.toString());
            } else if (object instanceof Layer) {
                Layer layer = (Layer)object;
                WMSCapabilitiesReader.this.checkObject(layer);
                layer.setAbstracts(this.sb.toString());
            } else if (object instanceof Style) {
                Style style = (Style)object;
                WMSCapabilitiesReader.this.checkObject(style);
                style.setAbstracts(this.sb.toString());
            }
        }
    }

    private class TitleHandler
    extends ElementHandler {
        StringBuffer sb;

        private TitleHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ServiceProvider) {
                ServiceProvider serviceProvider = (ServiceProvider)object;
                WMSCapabilitiesReader.this.checkObject(serviceProvider);
                serviceProvider.setTitle(this.sb.toString());
            } else if (object instanceof Layer) {
                Layer layer = (Layer)object;
                WMSCapabilitiesReader.this.checkObject(layer);
                layer.setTitle(this.sb.toString());
            } else if (object instanceof Attribution) {
                Attribution attribution = (Attribution)object;
                WMSCapabilitiesReader.this.checkObject(attribution);
                attribution.setTitle(this.sb.toString());
            } else if (object instanceof Style) {
                Style style = (Style)object;
                WMSCapabilitiesReader.this.checkObject(style);
                style.setTitle(this.sb.toString());
            }
        }
    }

    private class NameHandler
    extends ElementHandler {
        StringBuffer sb;

        private NameHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof ServiceProvider) {
                ServiceProvider serviceProvider = (ServiceProvider)object;
                WMSCapabilitiesReader.this.checkObject(serviceProvider);
                serviceProvider.setName(this.sb.toString());
            } else if (object instanceof Layer) {
                Layer layer = (Layer)object;
                WMSCapabilitiesReader.this.checkObject(layer);
                layer.setName(this.sb.toString());
            } else if (object instanceof Style) {
                Style style = (Style)object;
                WMSCapabilitiesReader.this.checkObject(style);
                style.setName(this.sb.toString());
            }
        }
    }

    private class LegendURLHandler
    extends ElementHandler {
        private LegendURLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            String domain = new String("LegendURL");
            WMSCapabilitiesReader.this.stack.push(domain);
            StyleDomainResource domainResource = new StyleDomainResource();
            domainResource.setWidth(atts.getValue("width"));
            domainResource.setHeight(atts.getValue("height"));
            WMSCapabilitiesReader.this.stack.push(domainResource);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            StyleDomainResource domainResource = (StyleDomainResource)WMSCapabilitiesReader.this.stack.pop();
            WMSCapabilitiesReader.this.stack.pop();
            Style style = (Style)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(style);
            style.addDomainResource(domainResource);
        }
    }

    private class StyleSheetURLHandler
    extends ElementHandler {
        private StyleSheetURLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            String domain = new String("StyleSheetURL");
            WMSCapabilitiesReader.this.stack.push(domain);
            StyleDomainResource domainResource = new StyleDomainResource();
            WMSCapabilitiesReader.this.stack.push(domainResource);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            StyleDomainResource domainResource = (StyleDomainResource)WMSCapabilitiesReader.this.stack.pop();
            WMSCapabilitiesReader.this.stack.pop();
            Style style = (Style)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(style);
            style.addDomainResource(domainResource);
        }
    }

    private class StyleURLHandler
    extends ElementHandler {
        private StyleURLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            String domain = new String("StyleURLHandler");
            WMSCapabilitiesReader.this.stack.push(domain);
            StyleDomainResource domainResource = new StyleDomainResource();
            WMSCapabilitiesReader.this.stack.push(domainResource);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            StyleDomainResource domainResource = (StyleDomainResource)WMSCapabilitiesReader.this.stack.pop();
            WMSCapabilitiesReader.this.stack.pop();
            Style style = (Style)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(style);
            style.addDomainResource(domainResource);
        }
    }

    private class LogoURLHandler
    extends ElementHandler {
        private LogoURLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String width = attributes.getValue("width");
            String height = attributes.getValue("height");
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof Attribution) {
                Attribution attribution = (Attribution)object;
                WMSCapabilitiesReader.this.checkObject(attribution);
                attribution.setLogoWidth(width);
                attribution.setLogoHeight(height);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class AttributionHandler
    extends ElementHandler {
        private AttributionHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            Attribution attribution = new Attribution();
            WMSCapabilitiesReader.this.stack.push(attribution);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Attribution attribution = (Attribution)WMSCapabilitiesReader.this.stack.pop();
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof Layer) {
                Layer layer = (Layer)object;
                WMSCapabilitiesReader.this.checkObject(layer);
                if (attribution == null) {
                    log.debug((Object)"Attribution is null, but still getting here.... explain to me");
                }
                layer.setAttribution(attribution);
            }
        }
    }

    private class ScaleHintHandler
    extends ElementHandler {
        private ScaleHintHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String min = attributes.getValue("min");
            String max = attributes.getValue("max");
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof Layer) {
                Layer layer = (Layer)object;
                WMSCapabilitiesReader.this.checkObject(layer);
                layer.setScaleHintMin(min);
                layer.setScaleHintMax(max);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class FeatureListURLHandler
    extends ElementHandler {
        private FeatureListURLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            String domain = new String("FeatureListURL");
            WMSCapabilitiesReader.this.stack.push(domain);
            LayerDomainResource domainResource = new LayerDomainResource();
            WMSCapabilitiesReader.this.stack.push(domainResource);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            LayerDomainResource domainResource = (LayerDomainResource)WMSCapabilitiesReader.this.stack.pop();
            WMSCapabilitiesReader.this.stack.pop();
            Layer layer = (Layer)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(layer);
            layer.addDomainResource(domainResource);
        }
    }

    private class DataURLHandler
    extends ElementHandler {
        private DataURLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            String domain = new String("DataURL");
            WMSCapabilitiesReader.this.stack.push(domain);
            LayerDomainResource domainResource = new LayerDomainResource();
            WMSCapabilitiesReader.this.stack.push(domainResource);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            LayerDomainResource domainResource = (LayerDomainResource)WMSCapabilitiesReader.this.stack.pop();
            WMSCapabilitiesReader.this.stack.pop();
            Layer layer = (Layer)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(layer);
            layer.addDomainResource(domainResource);
        }
    }

    private class MetadataURLHandler
    extends ElementHandler {
        private MetadataURLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            String domain = new String("MetadataURL");
            WMSCapabilitiesReader.this.stack.push(domain);
            LayerDomainResource domainResource = new LayerDomainResource();
            WMSCapabilitiesReader.this.stack.push(domainResource);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            LayerDomainResource domainResource = (LayerDomainResource)WMSCapabilitiesReader.this.stack.pop();
            WMSCapabilitiesReader.this.stack.pop();
            Layer layer = (Layer)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(layer);
            layer.addDomainResource(domainResource);
        }
    }

    private class IdentifierHandler
    extends ElementHandler {
        private IdentifierHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof Layer) {
                Layer layer = (Layer)object;
                WMSCapabilitiesReader.this.checkObject(layer);
                layer.getIdentifiers();
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class AuthorityURLHandler
    extends ElementHandler {
        private AuthorityURLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            Identifier identifier = new Identifier();
            String authority = attributes.getValue("name");
            if (authority != null) {
                identifier.setAuthorityName(authority);
            } else {
                identifier.setAuthorityName("");
            }
            WMSCapabilitiesReader.this.stack.push(identifier);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Identifier identifier = (Identifier)WMSCapabilitiesReader.this.stack.pop();
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof Layer) {
                Layer layer = (Layer)object;
                WMSCapabilitiesReader.this.checkObject(layer);
                layer.addIdentifier(identifier);
            }
        }
    }

    private class ExtentHandler
    extends ElementHandler {
        private ExtentHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof Layer) {
                Layer layer = (Layer)object;
                WMSCapabilitiesReader.this.checkObject(layer);
                layer.getDimensions();
                String name = attributes.getValue("name");
                String defaults = attributes.getValue("default");
                String nearestValue = attributes.getValue("nearestValue");
                String multipleValues = attributes.getValue("multipleValues");
                String string = attributes.getValue("current");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class DimensionHandler
    extends ElementHandler {
        private DimensionHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            Dimensions dimension = new Dimensions();
            String name = attributes.getValue("name");
            String units = attributes.getValue("units");
            String unitSymbol = attributes.getValue("unitSymbol");
            dimension.setDimensionsName(name);
            dimension.setDimensionsUnit(units);
            dimension.setDimensionsUnitSymbol(unitSymbol);
            WMSCapabilitiesReader.this.stack.push(dimension);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Dimensions dimension = (Dimensions)WMSCapabilitiesReader.this.stack.pop();
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof Layer) {
                Layer layer = (Layer)object;
                WMSCapabilitiesReader.this.checkObject(layer);
                layer.addDimension(dimension);
            }
        }
    }

    private class LatLonBoundingBoxHandler
    extends ElementHandler {
        private LatLonBoundingBoxHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof Layer) {
                Layer layer = (Layer)object;
                WMSCapabilitiesReader.this.checkObject(layer);
                SrsBoundingBox srsbb = new SrsBoundingBox();
                srsbb.setMinx(attributes.getValue("minx"));
                srsbb.setMiny(attributes.getValue("miny"));
                srsbb.setMaxx(attributes.getValue("maxx"));
                srsbb.setMaxy(attributes.getValue("maxy"));
                srsbb.setLayer(layer);
                layer.addSrsbb(srsbb);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class BoundingBoxHandler
    extends ElementHandler {
        private BoundingBoxHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            SrsBoundingBox srsbb = new SrsBoundingBox();
            srsbb.setSrs(attributes.getValue("SRS"));
            srsbb.setMinx(attributes.getValue("minx"));
            srsbb.setMiny(attributes.getValue("miny"));
            srsbb.setMaxx(attributes.getValue("maxx"));
            srsbb.setMaxy(attributes.getValue("maxy"));
            srsbb.setResx(attributes.getValue("resx"));
            srsbb.setResy(attributes.getValue("resy"));
            if (object instanceof Layer) {
                Layer layer = (Layer)object;
                srsbb.setLayer(layer);
                layer.addSrsbb(srsbb);
            } else if (object instanceof TileSet) {
                TileSet tileset = (TileSet)object;
                tileset.setBoundingBox(srsbb);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class SRSHandler
    extends ElementHandler {
        StringBuffer sb;

        private SRSHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof Layer) {
                Layer layer = (Layer)object;
                WMSCapabilitiesReader.this.checkObject(layer);
                String srssen = this.sb.toString();
                if (srssen.contains(" ")) {
                    String[] tokens = srssen.split(" ");
                    for (int t = 0; t < tokens.length; ++t) {
                        SrsBoundingBox srsbb = new SrsBoundingBox();
                        srsbb.setSrs(tokens[t]);
                        layer.addSrsbb(srsbb);
                    }
                } else if (srssen.length() > 0) {
                    SrsBoundingBox srsbb = new SrsBoundingBox();
                    srsbb.setSrs(srssen);
                    layer.addSrsbb(srsbb);
                }
            } else if (object instanceof TileSet) {
                TileSet tileset = (TileSet)object;
                WMSCapabilitiesReader.this.checkObject(tileset);
                tileset.setSrs(this.sb.toString());
            }
        }
    }

    private class FormatHandler
    extends ElementHandler {
        StringBuffer sb;

        private FormatHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            this.sb = new StringBuffer();
        }

        @Override
        public void characters(char[] chars, int start, int len) {
            this.sb.append(chars, start, len);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object object = WMSCapabilitiesReader.this.stack.peek();
            if (object instanceof LayerDomainResource) {
                LayerDomainResource domainResource = (LayerDomainResource)object;
                WMSCapabilitiesReader.this.checkObject(domainResource);
                domainResource.addFormat(this.sb.toString());
            } else if (object instanceof ServiceDomainResource) {
                ServiceDomainResource domainResource = (ServiceDomainResource)object;
                WMSCapabilitiesReader.this.checkObject(domainResource);
                domainResource.addFormat(this.sb.toString());
            } else if (object instanceof StyleDomainResource) {
                StyleDomainResource domainResource = (StyleDomainResource)object;
                WMSCapabilitiesReader.this.checkObject(domainResource);
                domainResource.addFormat(this.sb.toString());
            } else if (object instanceof Attribution) {
                Attribution attribution = (Attribution)object;
                WMSCapabilitiesReader.this.checkObject(attribution);
                attribution.setLogoFormat(this.sb.toString());
            } else if (object instanceof ServiceProvider) {
                ServiceProvider serviceProvider = (ServiceProvider)object;
                WMSCapabilitiesReader.this.checkObject(serviceProvider);
                serviceProvider.addException(this.sb.toString());
            } else if (object instanceof TileSet) {
                TileSet tileset = (TileSet)object;
                WMSCapabilitiesReader.this.checkObject(tileset);
                tileset.setFormat(this.sb.toString());
            }
        }
    }

    private class StyleHandler
    extends ElementHandler {
        private StyleHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            Style style = new Style();
            WMSCapabilitiesReader.this.stack.push(style);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Style style = (Style)WMSCapabilitiesReader.this.stack.pop();
            Layer layer = (Layer)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(layer);
            if (style.getName() == null || style.getName().equals("")) {
                style.setName("default");
            }
            if (style.getTitle() == null || style.getTitle().equals("")) {
                style.setTitle("default");
            }
            layer.addStyle(style);
        }
    }

    private class LayerHandler
    extends ElementHandler {
        private LayerHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            Layer layer = new Layer();
            String queryable = attributes.getValue("queryable");
            String cascaded = attributes.getValue("cascaded");
            String opaque = attributes.getValue("opaque");
            String noSubsets = attributes.getValue("noSubsets");
            String fixedWidth = attributes.getValue("fixedWidth");
            String fixedHeight = attributes.getValue("fixedHeight");
            layer.setQueryable(queryable);
            if (cascaded == null) {
                cascaded = "1";
            } else {
                int c = Integer.parseInt(cascaded);
                cascaded = "" + ++c;
            }
            layer.setCascaded(cascaded);
            layer.setOpaque(opaque);
            layer.setNosubsets(noSubsets);
            layer.setFixedWidth(fixedWidth);
            layer.setFixedHeight(fixedHeight);
            WMSCapabilitiesReader.this.stack.push(layer);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Layer layer = (Layer)WMSCapabilitiesReader.this.stack.pop();
            Object obj = WMSCapabilitiesReader.this.stack.peek();
            if (obj instanceof Layer) {
                Layer layerAtStack = (Layer)obj;
                WMSCapabilitiesReader.this.checkObject(layerAtStack);
                try {
                    layerAtStack.addLayer(layer);
                }
                catch (Exception ex) {
                    throw new SAXException(ex);
                }
            } else if (obj instanceof ServiceProvider) {
                ServiceProvider serviceProvider = (ServiceProvider)obj;
                WMSCapabilitiesReader.this.checkObject(serviceProvider);
                serviceProvider.setTopLayer(layer);
            }
        }
    }

    private class PostHandler
    extends ElementHandler {
        private PostHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            String post = new String("POST");
            WMSCapabilitiesReader.this.stack.push(post);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class GetHandler
    extends ElementHandler {
        private GetHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            String get = new String("GET");
            WMSCapabilitiesReader.this.stack.push(get);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class HTTPHandler
    extends ElementHandler {
        private HTTPHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class DCPTypeHandler
    extends ElementHandler {
        private DCPTypeHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class PutStylesHandler
    extends ElementHandler {
        private PutStylesHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            String domain = new String("PutStyles");
            WMSCapabilitiesReader.this.stack.push(domain);
            ServiceDomainResource domainResource = new ServiceDomainResource();
            WMSCapabilitiesReader.this.stack.push(domainResource);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ServiceDomainResource domainResource = (ServiceDomainResource)WMSCapabilitiesReader.this.stack.pop();
            WMSCapabilitiesReader.this.stack.pop();
            ServiceProvider serviceProvider = (ServiceProvider)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(serviceProvider);
            serviceProvider.addDomainResource(domainResource);
        }
    }

    private class GetStylesHandler
    extends ElementHandler {
        private GetStylesHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            String domain = new String("GetStyles");
            WMSCapabilitiesReader.this.stack.push(domain);
            ServiceDomainResource domainResource = new ServiceDomainResource();
            WMSCapabilitiesReader.this.stack.push(domainResource);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ServiceDomainResource domainResource = (ServiceDomainResource)WMSCapabilitiesReader.this.stack.pop();
            WMSCapabilitiesReader.this.stack.pop();
            ServiceProvider serviceProvider = (ServiceProvider)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(serviceProvider);
            serviceProvider.addDomainResource(domainResource);
        }
    }

    private class GetLegendGraphicHandler
    extends ElementHandler {
        private GetLegendGraphicHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            String domain = new String("GetLegendGraphic");
            WMSCapabilitiesReader.this.stack.push(domain);
            ServiceDomainResource domainResource = new ServiceDomainResource();
            WMSCapabilitiesReader.this.stack.push(domainResource);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ServiceDomainResource domainResource = (ServiceDomainResource)WMSCapabilitiesReader.this.stack.pop();
            WMSCapabilitiesReader.this.stack.pop();
            ServiceProvider serviceProvider = (ServiceProvider)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(serviceProvider);
            serviceProvider.addDomainResource(domainResource);
        }
    }

    private class DescribeLayerHandler
    extends ElementHandler {
        private DescribeLayerHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            String domain = new String("DescribeLayer");
            WMSCapabilitiesReader.this.stack.push(domain);
            ServiceDomainResource domainResource = new ServiceDomainResource();
            WMSCapabilitiesReader.this.stack.push(domainResource);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ServiceDomainResource domainResource = (ServiceDomainResource)WMSCapabilitiesReader.this.stack.pop();
            WMSCapabilitiesReader.this.stack.pop();
            ServiceProvider serviceProvider = (ServiceProvider)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(serviceProvider);
            serviceProvider.addDomainResource(domainResource);
        }
    }

    private class GetFeatureInfoHandler
    extends ElementHandler {
        private GetFeatureInfoHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            String domain = new String("GetFeatureInfo");
            WMSCapabilitiesReader.this.stack.push(domain);
            ServiceDomainResource domainResource = new ServiceDomainResource();
            WMSCapabilitiesReader.this.stack.push(domainResource);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ServiceDomainResource domainResource = (ServiceDomainResource)WMSCapabilitiesReader.this.stack.pop();
            WMSCapabilitiesReader.this.stack.pop();
            ServiceProvider serviceProvider = (ServiceProvider)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(serviceProvider);
            serviceProvider.addDomainResource(domainResource);
        }
    }

    private class GetMapHandler
    extends ElementHandler {
        private GetMapHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            String domain = new String("GetMap");
            WMSCapabilitiesReader.this.stack.push(domain);
            ServiceDomainResource domainResource = new ServiceDomainResource();
            WMSCapabilitiesReader.this.stack.push(domainResource);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ServiceDomainResource domainResource = (ServiceDomainResource)WMSCapabilitiesReader.this.stack.pop();
            WMSCapabilitiesReader.this.stack.pop();
            ServiceProvider serviceProvider = (ServiceProvider)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(serviceProvider);
            serviceProvider.addDomainResource(domainResource);
        }
    }

    private class GetCapabilitiesHandler
    extends ElementHandler {
        private GetCapabilitiesHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
            String domain = new String("GetCapabilities");
            WMSCapabilitiesReader.this.stack.push(domain);
            ServiceDomainResource domainResource = new ServiceDomainResource();
            WMSCapabilitiesReader.this.stack.push(domainResource);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            ServiceDomainResource domainResource = (ServiceDomainResource)WMSCapabilitiesReader.this.stack.pop();
            WMSCapabilitiesReader.this.stack.pop();
            ServiceProvider serviceProvider = (ServiceProvider)WMSCapabilitiesReader.this.stack.peek();
            WMSCapabilitiesReader.this.checkObject(serviceProvider);
            serviceProvider.addDomainResource(domainResource);
        }
    }

    private class ExceptionHandler
    extends ElementHandler {
        private ExceptionHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class RequestHandler
    extends ElementHandler {
        private RequestHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class CapabilityHandler
    extends ElementHandler {
        private CapabilityHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            Object obj = WMSCapabilitiesReader.this.stack.peek();
            if (obj instanceof ServiceProvider) {
                ServiceProvider sp = (ServiceProvider)obj;
                WMSCapabilitiesReader.this.checkObject(sp);
                if (sp.getTileSets() != null) {
                    Iterator<TileSet> it = sp.getTileSets().iterator();
                    Set layers = sp.getAllLayers();
                    while (it.hasNext()) {
                        TileSet ts = it.next();
                        if (ts.getLayerString() != null) {
                            String[] tsLayers = ts.getLayerString().split(",");
                            for (Layer l : layers) {
                                for (int i = 0; i < tsLayers.length; ++i) {
                                    if (l.getName() == null || !l.getName().equals(tsLayers[i])) continue;
                                    ts.addLayer(l);
                                }
                            }
                            if (ts.getLayers().size() != tsLayers.length) {
                                log.error((Object)"Fout bij inlezen TileSet. Niet alle layers in de tileset zijn aanwezig. TileSet is niet ingelezen.");
                                it.remove();
                                continue;
                            }
                        }
                        if (ts.getLayers() != null && ts.getLayers().size() != 0) continue;
                        it.remove();
                    }
                }
            }
        }
    }

    private class ServiceHandler
    extends ElementHandler {
        private ServiceHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) {
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }

    private class WMTHandler
    extends ElementHandler {
        private WMTHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            WMSCapabilitiesReader.this.checkObject(WMSCapabilitiesReader.this.serviceProvider);
            String version = attributes.getValue("version");
            WMSCapabilitiesReader.this.serviceProvider.setWmsVersion(version);
            WMSCapabilitiesReader.this.stack.push(WMSCapabilitiesReader.this.serviceProvider);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
        }
    }
}

