/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.jump.feature.BasicFeature;
import org.locationtech.jts.jump.feature.FeatureSchema;

public class FeatureFactory {
    public static BasicFeature createPointFeature(Object[] attributes, String[] columnames, int xIndex, int yIndex, FeatureSchema fs, boolean xyAsAttribute, boolean useMultiPoint) {
        if (xIndex >= attributes.length || yIndex >= attributes.length) {
            throw new ArrayIndexOutOfBoundsException("xIndex and/or yIndex is greater then the attributes length");
        }
        Double x = FeatureFactory.getDoubleFromObject(attributes[xIndex]);
        Double y = FeatureFactory.getDoubleFromObject(attributes[yIndex]);
        if (!xyAsAttribute) {
            Object[] newAttributes = new Object[attributes.length - 2];
            int addedAttributes = 0;
            for (int i = 0; i < attributes.length; ++i) {
                if (xIndex == i || yIndex == i) continue;
                newAttributes[addedAttributes] = attributes[i];
                ++addedAttributes;
            }
            attributes = newAttributes;
        }
        if (x != null && y != null) {
            return FeatureFactory.createPointFeature(attributes, columnames, x, y, fs, useMultiPoint);
        }
        return FeatureFactory.createFeature(attributes, columnames, fs);
    }

    public static BasicFeature createPointFeature(Object[] attributes, String[] columnames, double x, double y, FeatureSchema fs, boolean useMultiPoint) {
        BasicFeature f = FeatureFactory.createFeature(attributes, columnames, fs);
        if (fs.getGeometryIndex() >= 0) {
            PrecisionModel precisionModel = new PrecisionModel(PrecisionModel.FLOATING);
            int schemaSRID = fs.getCoordinateSystem().getEPSGCode();
            GeometryFactory gf = new GeometryFactory(precisionModel, schemaSRID);
            Coordinate c = new Coordinate(x, y);
            if (useMultiPoint) {
                Coordinate[] ca = new Coordinate[]{c};
                MultiPoint p = gf.createMultiPoint(ca);
                f.setGeometry((Geometry)p);
            } else {
                Point p = gf.createPoint(c);
                f.setGeometry((Geometry)p);
            }
        }
        return f;
    }

    public static BasicFeature createFeature(Object[] attributes, String[] columnames, FeatureSchema fs) {
        BasicFeature f = new BasicFeature(fs);
        if (columnames == null) {
            f.setAttributes(attributes);
        } else {
            block0: for (int i = 0; i < columnames.length; ++i) {
                for (int j = 0; j < fs.getAttributeCount(); ++j) {
                    String fsatt = fs.getAttributeName(j);
                    if (fsatt == null || !fsatt.equalsIgnoreCase(columnames[i])) continue;
                    f.setAttribute(j, attributes[i]);
                    continue block0;
                }
            }
        }
        return f;
    }

    private static Double getDoubleFromObject(Object object) {
        Double x = null;
        if (object != null) {
            if (object instanceof Double) {
                x = (Double)object;
            } else if (object instanceof String) {
                x = new Double((String)object);
            }
        }
        return x;
    }
}

