/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.utils.geotools;

import java.util.ArrayList;
import java.util.List;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class Util {
    public static SimpleFeatureType changeGeometryBinding(SimpleFeatureType ft, Class geomBinding) {
        ArrayList<AttributeDescriptor> attributeDescriptors = new ArrayList<AttributeDescriptor>(ft.getAttributeDescriptors());
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(ft);
        if (ft.getGeometryDescriptor() != null) {
            AttributeDescriptor gd = Util.changeGeometryBinding(ft.getGeometryDescriptor(), geomBinding);
            attributeDescriptors.set(ft.indexOf(ft.getGeometryDescriptor().getName()), gd);
            builder.setDefaultGeometry(ft.getGeometryDescriptor().getName().getLocalPart());
            builder.setAttributes(attributeDescriptors);
        }
        SimpleFeatureType newFt = builder.buildFeatureType();
        return newFt;
    }

    public static AttributeDescriptor changeGeometryBinding(GeometryDescriptor gd, Class geomBinding) {
        AttributeTypeBuilder builder = new AttributeTypeBuilder();
        builder.init((AttributeDescriptor)gd);
        builder.setBinding(geomBinding);
        builder.setCRS(gd.getCoordinateReferenceSystem());
        return builder.buildDescriptor(gd.getLocalName());
    }

    public static SimpleFeature rebuildFeature(SimpleFeature feature, List<String> removeAttributeNames) {
        if (removeAttributeNames == null) {
            return feature;
        }
        SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
        featureTypeBuilder.init(feature.getFeatureType());
        if (feature.getDefaultGeometryProperty() != null && featureTypeBuilder.getDefaultGeometry() == null) {
            featureTypeBuilder.setDefaultGeometry(feature.getDefaultGeometryProperty().getName().toString());
        }
        ArrayList<AttributeDescriptor> newAttributeDescriptors = new ArrayList<AttributeDescriptor>();
        ArrayList newAttributes = new ArrayList();
        List attributes = feature.getAttributes();
        ArrayList attributeDescriptors = new ArrayList(feature.getFeatureType().getAttributeDescriptors());
        for (int a = 0; a < attributeDescriptors.size(); ++a) {
            boolean skip = false;
            for (int s = 0; s < removeAttributeNames.size() && !skip; ++s) {
                if (!((AttributeDescriptor)attributeDescriptors.get(a)).getLocalName().equalsIgnoreCase(removeAttributeNames.get(s))) continue;
                skip = true;
            }
            if (skip) continue;
            AttributeDescriptor ad = (AttributeDescriptor)attributeDescriptors.get(a);
            if (ad.getLocalName().length() > 10) {
                AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
                attributeTypeBuilder.init(ad);
                String newName = ad.getLocalName();
                if (newName.indexOf(".") > 0 && newName.indexOf(".") + 1 < newName.length()) {
                    newName = newName.substring(newName.lastIndexOf(".") + 1);
                }
                ad = attributeTypeBuilder.buildDescriptor(newName);
            }
            newAttributeDescriptors.add(ad);
            newAttributes.add(attributes.get(a));
        }
        featureTypeBuilder.setAttributes(newAttributeDescriptors);
        SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(featureTypeBuilder.buildFeatureType());
        return simpleFeatureBuilder.buildFeature(feature.getID(), newAttributes.toArray(new Object[newAttributes.size()]));
    }
}

