/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.wms.capabilities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.ServiceDomainResource;
import nl.b3p.wms.capabilities.ServiceProvider;
import nl.b3p.wms.capabilities.StyleDomainResource;
import nl.b3p.wms.capabilities.XMLElement;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class Style
implements XMLElement {
    private Integer id;
    private String name = "default";
    private String title;
    private String abstracts;
    private Layer layer;
    private Set domainResource;
    private String sldPart;
    private String sldConstraints;

    public Integer getId() {
        return this.id;
    }

    private void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getAbstracts() {
        return this.abstracts;
    }

    public void setAbstracts(String abstracts) {
        this.abstracts = abstracts;
    }

    public Set getDomainResource() {
        return this.domainResource;
    }

    public void setDomainResource(Set domainResource) {
        this.domainResource = domainResource;
    }

    public void addDomainResource(StyleDomainResource dr) {
        if (null == this.domainResource) {
            this.domainResource = new HashSet();
        }
        this.domainResource.add(dr);
        dr.setStyle(this);
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public String getSldPart() {
        return this.sldPart;
    }

    public void setSldPart(String sldPart) {
        this.sldPart = sldPart;
    }

    protected void convertValues2KB(HashMap conversionValues) {
        ServiceProvider sp;
        ServiceDomainResource getLegendResource;
        if (this.sldPart != null && (this.getDomainResource() == null || this.getDomainResource().size() == 0) && (getLegendResource = (sp = this.getLayer().getServiceProvider()).getServiceDomainResourceByOperationName("GetLegendGraphic")) != null) {
            String wmsVersion = sp.getWmsVersion();
            OGCRequest url = new OGCRequest(this.getLayer().getServiceProvider().getUrl());
            url.addOrReplaceParameter("REQUEST", "GetLegendGraphic");
            if (wmsVersion != null) {
                url.addOrReplaceParameter("VERSION", wmsVersion);
            } else {
                url.addOrReplaceParameter("VERSION", "1.1.1");
            }
            url.addOrReplaceParameter("LAYER", this.getLayer().getName());
            String format = "image/png";
            if (getLegendResource.getFormats() != null) {
                format = (String)getLegendResource.getFormats().iterator().next();
            }
            url.addOrReplaceParameter("FORMAT", format);
            String sldProxyUrl = (String)conversionValues.get("url");
            sldProxyUrl = sldProxyUrl.replace("/services/", "/proxysld/");
            if (sldProxyUrl.indexOf("?") != sldProxyUrl.length() - 1 && sldProxyUrl.indexOf("&") != sldProxyUrl.length() - 1) {
                sldProxyUrl = sldProxyUrl + (sldProxyUrl.indexOf("?") > 0 ? "&" : "?");
            }
            sldProxyUrl = sldProxyUrl + "styles=";
            sldProxyUrl = sldProxyUrl + this.getId();
            sldProxyUrl = sldProxyUrl + "&";
            url.addOrReplaceParameter("SLD", sldProxyUrl);
            StyleDomainResource sdr = new StyleDomainResource();
            sdr.setDomain("LegendURL");
            sdr.setUrl(url.toString());
            HashSet<StyleDomainResource> set = new HashSet<StyleDomainResource>();
            set.add(sdr);
            this.setDomainResource(set);
        }
        if (null != this.getDomainResource() && this.getDomainResource().size() != 0) {
            for (StyleDomainResource sdr : this.getDomainResource()) {
                sdr.convertValues2KB(conversionValues);
            }
        }
    }

    public Object clone() {
        Style cloneStyle = new Style();
        if (null != this.id) {
            cloneStyle.id = new Integer(this.id);
        }
        if (null != this.name) {
            cloneStyle.name = new String(this.name);
        }
        if (null != this.title) {
            cloneStyle.title = new String(this.title);
        }
        if (null != this.abstracts) {
            cloneStyle.abstracts = new String(this.abstracts);
        }
        if (null != this.domainResource) {
            cloneStyle.domainResource = new HashSet();
            Iterator it = this.domainResource.iterator();
            while (it.hasNext()) {
                StyleDomainResource sdr = (StyleDomainResource)((StyleDomainResource)it.next()).clone();
                sdr.setStyle(cloneStyle);
                cloneStyle.domainResource.add(sdr);
            }
        }
        if (null != this.sldPart) {
            cloneStyle.sldPart = new String(this.sldPart);
        }
        return cloneStyle;
    }

    @Override
    public Element toElement(Document doc, Element rootElement) {
        Text text;
        Element styleElement = doc.createElement("Style");
        if (null != this.getName()) {
            Element nameElement = doc.createElement("Name");
            text = doc.createTextNode(this.getName());
            nameElement.appendChild(text);
            styleElement.appendChild(nameElement);
        }
        if (null != this.getTitle()) {
            Element titleElement = doc.createElement("Title");
            text = doc.createTextNode(this.getTitle());
            titleElement.appendChild(text);
            styleElement.appendChild(titleElement);
        }
        if (null != this.getDomainResource() && this.getDomainResource().size() != 0) {
            Hashtable<String, StyleDomainResource> sdrhash = new Hashtable<String, StyleDomainResource>();
            StyleDomainResource sdr2 = null;
            for (StyleDomainResource sdr2 : this.domainResource) {
                if (sdr2.getDomain() == null) continue;
                if (sdr2.getDomain().equalsIgnoreCase("LegendURL")) {
                    sdrhash.put("LegendURL", sdr2);
                    continue;
                }
                if (sdr2.getDomain().equalsIgnoreCase("StyleSheetURL")) {
                    sdrhash.put("StyleSheetURL", sdr2);
                    continue;
                }
                if (!sdr2.getDomain().equalsIgnoreCase("StyleURL")) continue;
                sdrhash.put("StyleURL", sdr2);
            }
            sdr2 = (StyleDomainResource)sdrhash.get("LegendURL");
            if (sdr2 != null) {
                styleElement = sdr2.toElement(doc, styleElement);
            }
            if ((sdr2 = (StyleDomainResource)sdrhash.get("StyleSheetURL")) != null) {
                styleElement = sdr2.toElement(doc, styleElement);
            }
            if ((sdr2 = (StyleDomainResource)sdrhash.get("StyleURL")) != null) {
                styleElement = sdr2.toElement(doc, styleElement);
            }
        }
        rootElement.appendChild(styleElement);
        return rootElement;
    }

    public String getSldConstraints() {
        return this.sldConstraints;
    }

    public void setSldConstraints(String sldConstraints) {
        this.sldConstraints = sldConstraints;
    }
}

