/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.writers;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import nl.b3p.ogc.utils.SqlMetaDataUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.jump.feature.AttributeType;
import org.locationtech.jts.jump.feature.Feature;
import org.locationtech.jts.jump.feature.FeatureCollection;
import org.locationtech.jts.jump.feature.FeatureSchema;

public class B3pOgcSqlWriter {
    private static final Log log = LogFactory.getLog(B3pOgcSqlWriter.class);
    private Connection connection;
    private int batchValue = 20;
    public static final String DEFAULT_GEOM_COLUMN = "the_geom";
    public static final String POSTGRES_GLOBALGEOMETRY = "GEOMETRY";
    public static final List SUPPORTED_DIALECTS = Arrays.asList("PostgreSQL");

    public B3pOgcSqlWriter(Connection conn) {
        this.setConnection(conn);
    }

    public B3pOgcSqlWriter(String url, String user, String password, Driver driver) throws SQLException {
        DriverManager.registerDriver(driver);
        this.setConnection(DriverManager.getConnection(url, user, password));
    }

    public int[] write(FeatureCollection fc, String tablename, String geomColumn, int dimension, boolean createTable, boolean attributeNamesToLowerCase) throws SQLException, Exception {
        return this.write(fc, tablename, geomColumn, null, dimension, createTable, attributeNamesToLowerCase, null, null);
    }

    public int[] write(FeatureCollection fc, String tablename, String geomColumn, int dimension, boolean createTable, boolean attributeNamesToLowerCase, String[] columnNamesToCheck) throws SQLException, Exception {
        return this.write(fc, tablename, geomColumn, null, dimension, createTable, attributeNamesToLowerCase, columnNamesToCheck, null);
    }

    public int[] write(FeatureCollection fc, String tablename, String geomColumn, int dimension, boolean createTable, boolean attributeNamesToLowerCase, String[] columnNamesToCheck, String ignoreValue) throws SQLException, Exception {
        return this.write(fc, tablename, geomColumn, null, dimension, createTable, attributeNamesToLowerCase, columnNamesToCheck, ignoreValue);
    }

    @Deprecated
    public int[] write(FeatureCollection fc, String tablename, String geomColumn, String srid, int dimension, boolean createTable, boolean attributeNamesToLowerCase) throws SQLException, Exception {
        return this.write(fc, tablename, geomColumn, srid, dimension, createTable, attributeNamesToLowerCase, null, null);
    }

    @Deprecated
    public int[] write(FeatureCollection fc, String tablename, String geomColumn, String srid, int dimension, boolean createTable, boolean attributeNamesToLowerCase, String[] columnNamesToCheck, String ignoreValue) throws SQLException, Exception {
        FeatureSchema fs;
        ignoreValue = "'" + ignoreValue + "'";
        int nupdates = 0;
        int ninserts = 0;
        Iterator fcit = fc.iterator();
        Geometry aGeom = null;
        boolean sameGeomType = true;
        while (fcit.hasNext() && sameGeomType) {
            Feature f = (Feature)fcit.next();
            fs = f.getSchema();
            if (fs.getGeometryIndex() < 0 || f.getGeometry() == null) continue;
            if (aGeom == null) {
                aGeom = f.getGeometry();
                continue;
            }
            if (aGeom.getGeometryType().equals(f.getGeometry().getGeometryType())) continue;
            sameGeomType = false;
        }
        DatabaseMetaData dbmd = this.connection.getMetaData();
        fs = fc.getFeatureSchema();
        if (tablename == null) {
            log.error((Object)"No table name given.");
            throw new Exception("No table name given.");
        }
        List tableNames = SqlMetaDataUtils.getTableAndViewNames(this.connection);
        if (tableNames == null) {
            log.error((Object)"Cannot get database tables.");
            throw new Exception("Cannot get database tables.");
        }
        if (tableNames.contains(tablename)) {
            this.checkcolumns(fs, geomColumn, attributeNamesToLowerCase, dbmd, tablename);
        } else if (createTable) {
            this.createTable(dbmd, tablename, fs, geomColumn, attributeNamesToLowerCase, srid, aGeom, sameGeomType, dimension);
        } else {
            log.error((Object)"Table does not exists.");
            throw new Exception("Table does not exists.");
        }
        String insertPart = this.createInsertPart(fs, tablename);
        String updatePart = this.createUpdatePart(tablename);
        Iterator it = fc.iterator();
        StringBuffer q = null;
        int inserts = 0;
        while (it.hasNext()) {
            if (q == null) {
                q = new StringBuffer();
            }
            Feature f = (Feature)it.next();
            boolean update = false;
            if (columnNamesToCheck != null) {
                update = this.checkExinstenceInDB(columnNamesToCheck, f, tablename);
            }
            if (update) {
                ++nupdates;
                q.append(updatePart.toString());
                q.append(this.addUpdateValue(fs, f, geomColumn, columnNamesToCheck, ignoreValue));
            } else {
                ++ninserts;
                q.append(insertPart.toString());
                q.append(this.addInsertValue(fs, f, geomColumn, attributeNamesToLowerCase, ignoreValue));
            }
            if (this.getBatchValue() != 0 && (inserts + 1) % this.getBatchValue() == 0) {
                this.executeStatement(q.toString());
                q = null;
            }
            ++inserts;
        }
        if (q != null && q.length() > 0) {
            this.executeStatement(q.toString());
        }
        return new int[]{nupdates, ninserts};
    }

    private boolean checkExinstenceInDB(String[] columnNamesToCheck, Feature f, String tablename) throws SQLException, ParseException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM \"");
        sql.append(tablename);
        sql.append("\" WHERE ");
        for (int i = 0; i < columnNamesToCheck.length; ++i) {
            if (i != 0) {
                sql.append(" AND ");
            }
            sql.append("\"" + columnNamesToCheck[i] + "\"");
            sql.append(" = ");
            sql.append(this.getSqlValue(f, f.getSchema(), columnNamesToCheck[i], true));
        }
        sql.append(";");
        if (log.isDebugEnabled()) {
            log.debug((Object)("checkExistenceInDB - sql: " + sql));
        }
        PreparedStatement statement = this.connection.prepareStatement(sql.toString());
        ResultSet rs = statement.executeQuery();
        boolean found = rs.next();
        statement.execute();
        statement.close();
        return found;
    }

    private void checkcolumns(FeatureSchema fs, String geomColumn, boolean attributeNamesToLowerCase, DatabaseMetaData dbmd, String tablename) throws Exception {
        for (int i = 0; i < fs.getAttributeCount(); ++i) {
            if (i != fs.getGeometryIndex() || geomColumn == null) {
                int type;
                boolean columFound = false;
                String attributeName = fs.getAttributeName(i);
                if (attributeNamesToLowerCase) {
                    attributeName = attributeName.toLowerCase();
                }
                AttributeType attributeType = fs.getAttributeType(i);
                ResultSet rs = dbmd.getColumns(null, null, tablename, attributeName);
                if (rs.next() && this.isCompatibleType(attributeType, type = rs.getInt("DATA_TYPE"))) {
                    columFound = true;
                }
                if (columFound) continue;
                log.error((Object)"Table already exists but has wrong columns.");
                throw new Exception("Table already exists but has wrong columns.");
            }
            ResultSet rs = dbmd.getColumns(null, null, tablename, geomColumn);
            if (rs.next()) continue;
            log.error((Object)"Table already exists but has wrong columns.");
            throw new Exception("Table already exists but has wrong columns.");
        }
    }

    private void executeStatement(String statementToExecute) throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("executeStatement: " + statementToExecute));
        }
        try (PreparedStatement statement = null;){
            statement = this.connection.prepareStatement(statementToExecute);
            statement.execute();
        }
    }

    private String addInsertValue(FeatureSchema fs, Feature f, String geomColumn, boolean attributeNamesToLowerCase, String ignoreValue) throws ParseException {
        StringBuffer columns = new StringBuffer();
        StringBuffer values = new StringBuffer();
        columns.append("(");
        boolean first = true;
        for (int i = 0; i < fs.getAttributeCount(); ++i) {
            String value = this.getSqlValue(f, fs, i, false);
            if (ignoreValue != null && ignoreValue.equals(value)) continue;
            if (!first) {
                columns.append(", ");
                values.append(", ");
            }
            first = false;
            values.append(value);
            if (i != fs.getGeometryIndex() || geomColumn == null) {
                if (attributeNamesToLowerCase) {
                    columns.append("\"" + fs.getAttributeName(i).toLowerCase() + "\"");
                    continue;
                }
                columns.append("\"" + fs.getAttributeName(i) + "\"");
                continue;
            }
            columns.append("\"" + geomColumn + "\"");
        }
        columns.append(") VALUES (");
        columns.append(values.toString());
        columns.append(");");
        return columns.toString();
    }

    private String getSqlValue(Feature f, FeatureSchema fs, String attributeName, boolean nullForEmptyNumber) throws ParseException {
        return this.getSqlValue(f, fs.getAttributeIndex(attributeName), nullForEmptyNumber);
    }

    private String getSqlValue(Feature f, int i, boolean nullForEmptyNumber) throws ParseException {
        return this.getSqlValue(f, f.getSchema(), i, nullForEmptyNumber);
    }

    private String getSqlValue(Feature f, FeatureSchema fs, int i, boolean nullForEmptyNumber) throws ParseException {
        Object o = f.getAttribute(fs.getAttributeName(i));
        StringBuffer values = new StringBuffer();
        if (fs.getAttributeType(i).equals(AttributeType.GEOMETRY)) {
            values.append("ST_GeomFromText('");
            values.append(f.getGeometry().toText());
            int geomSRID = f.getGeometry().getSRID();
            if (geomSRID >= 0) {
                values.append("', " + geomSRID);
            } else {
                values.append("', 28992");
            }
            values.append(")");
        } else if (fs.getAttributeType(i).equals(AttributeType.DOUBLE) || fs.getAttributeType(i).equals(AttributeType.INTEGER)) {
            if ("".equals(o) || o == null) {
                if (nullForEmptyNumber) {
                    values.append("null");
                } else {
                    values.append("''");
                }
            } else {
                try {
                    Double.parseDouble(o.toString());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("The DOUBLE/INTEGER value is not valid: " + o);
                }
                values.append(o);
            }
        } else if (fs.getAttributeType(i).equals(AttributeType.STRING)) {
            if (o == null) {
                values.append(o);
            } else {
                String s = (String)o;
                s = s.replaceAll("'", "''");
                values.append("'");
                values.append(s);
                values.append("'");
            }
        } else if (fs.getAttributeType(i).equals(AttributeType.DATE)) {
            if (o == null) {
                values.append(o);
            } else if (o instanceof Date) {
                Date d = (Date)o;
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(d);
                values.append("'");
                values.append(new SimpleDateFormat("yyyy-MM-dd").format(d));
                values.append("'");
            } else if (o instanceof String) {
                values.append("'");
                if (!"''".equals(o)) {
                    values.append(this.formatDate("dd-MM-yyyy", "HH:mm:ss", "yyyy-MM-dd", "HH:mm:ss", (String)o));
                }
                values.append("'");
            } else {
                values.append("''");
            }
        } else if (fs.getAttributeType(i).equals(AttributeType.OBJECT)) {
            if (o == null) {
                values.append(o);
            } else {
                values.append("'");
                values.append(o);
                values.append("'");
            }
        }
        return values.toString();
    }

    private String addUpdateValue(FeatureSchema fs, Feature f, String geomColumn, String[] columnNamesToCheck, String ignoreValue) throws ParseException {
        int i;
        StringBuffer sb = new StringBuffer();
        boolean first = true;
        for (i = 0; i < fs.getAttributeCount(); ++i) {
            String value = this.getSqlValue(f, fs, i, false);
            if (ignoreValue != null && ignoreValue.equals(value)) continue;
            if (!first) {
                sb.append(", ");
            }
            first = false;
            if (fs.getGeometryIndex() == i) {
                sb.append("\"" + geomColumn + "\"");
            } else {
                sb.append("\"" + fs.getAttributeName(i) + "\"");
            }
            sb.append(" = ");
            sb.append(value);
        }
        sb.append(" WHERE ");
        for (i = 0; i < columnNamesToCheck.length; ++i) {
            if (i != 0) {
                sb.append(" AND ");
            }
            sb.append("\"" + columnNamesToCheck[i] + "\"");
            sb.append(" = ");
            sb.append(this.getSqlValue(f, fs, columnNamesToCheck[i], false));
        }
        sb.append(";");
        return sb.toString();
    }

    private String formatDate(String olddate, String oldtime, String newdate, String newtime, String parse_date) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(olddate + " " + oldtime);
        Date date = null;
        try {
            date = dateFormat.parse(parse_date);
            dateFormat = new SimpleDateFormat(newdate + " " + newtime);
        }
        catch (ParseException e) {
            try {
                dateFormat.applyPattern(olddate);
                date = dateFormat.parse(parse_date);
                dateFormat = new SimpleDateFormat(newdate);
            }
            catch (ParseException e2) {
                dateFormat.applyPattern(oldtime);
                date = dateFormat.parse(parse_date);
                dateFormat = new SimpleDateFormat(newtime);
            }
        }
        return dateFormat.format(date);
    }

    private void createTable(DatabaseMetaData dbmd, String tablename, FeatureSchema fs, String geomColumn, boolean attributeNamesToLowerCase, String srid, Geometry aGeom, boolean sameGeomType, int dimension) throws SQLException, Exception {
        PreparedStatement statement;
        StringBuffer sb;
        if (SUPPORTED_DIALECTS.contains(dbmd.getDatabaseProductName())) {
            sb = new StringBuffer();
            sb.append("CREATE TABLE \"");
            sb.append(tablename);
            sb.append("\"(");
            boolean firstColumn = true;
            boolean geomColumnFound = false;
            for (int i = 0; i < fs.getAttributeCount(); ++i) {
                AttributeType at = fs.getAttributeType(i);
                if (at.equals(AttributeType.GEOMETRY)) {
                    geomColumnFound = true;
                    if (geomColumn != null) continue;
                    if (attributeNamesToLowerCase) {
                        geomColumn = fs.getAttributeName(i).toLowerCase();
                        continue;
                    }
                    geomColumn = fs.getAttributeName(i);
                    continue;
                }
                if (!firstColumn) {
                    sb.append(", ");
                }
                firstColumn = false;
                sb.append("\"");
                if (attributeNamesToLowerCase) {
                    sb.append(fs.getAttributeName(i).toLowerCase());
                } else {
                    sb.append(fs.getAttributeName(i));
                }
                sb.append("\" ");
                if (at.equals(AttributeType.DATE)) {
                    sb.append("date");
                    continue;
                }
                if (at.equals(AttributeType.DOUBLE)) {
                    sb.append("double precision");
                    continue;
                }
                if (at.equals(AttributeType.INTEGER)) {
                    sb.append("bigint");
                    continue;
                }
                sb.append("varchar(255)");
            }
            sb.append(")WITH OIDS");
            StringBuffer sbg = null;
            if (geomColumnFound && dbmd.getDatabaseProductName().equalsIgnoreCase("PostgreSQL")) {
                String s = dbmd.getURL();
                String url = dbmd.getURL();
                String db = url.split("/")[url.split("/").length - 1];
                sbg = new StringBuffer();
                sbg.append("select addGeometryColumn('");
                sbg.append("public");
                sbg.append("', '");
                sbg.append(tablename);
                sbg.append("', '");
                sbg.append(geomColumn);
                sbg.append("', ");
                if (srid != null) {
                    sbg.append(srid);
                } else if (aGeom != null) {
                    if (aGeom.getSRID() >= 0) {
                        sbg.append(aGeom.getSRID());
                    }
                } else {
                    sbg.append(-1);
                }
                sbg.append(", '");
                if (!sameGeomType || aGeom == null) {
                    sbg.append(POSTGRES_GLOBALGEOMETRY);
                } else {
                    sbg.append(aGeom.getGeometryType().toUpperCase());
                }
                sbg.append("', ");
                if (dimension > 0) {
                    sbg.append(dimension);
                } else if (aGeom.getDimension() > 1) {
                    sbg.append(aGeom.getDimension());
                } else {
                    sbg.append("2");
                }
                sbg.append(")");
            }
            statement = null;
            if (sbg.toString() != null) {
                sb.append(";");
                sb.append(sbg.toString());
            }
        } else {
            log.error((Object)("CREATE TABLE not supported for " + dbmd.getDatabaseProductName()));
            throw new Exception("CREATE TABLE not supported for " + dbmd.getDatabaseProductName());
        }
        statement = this.connection.prepareStatement(sb.toString());
        statement.execute();
        statement.close();
    }

    private String createInsertPart(FeatureSchema fs, String tablename) {
        StringBuffer insertPart = new StringBuffer();
        insertPart.append("INSERT INTO \"");
        insertPart.append(tablename);
        insertPart.append("\"");
        return insertPart.toString();
    }

    private String createUpdatePart(String tablename) {
        StringBuffer insertPart = new StringBuffer();
        insertPart.append("UPDATE \"");
        insertPart.append(tablename);
        insertPart.append("\" SET ");
        return insertPart.toString();
    }

    private boolean isCompatibleType(AttributeType attributeType, int type) {
        if (attributeType.equals(AttributeType.DATE)) {
            if (type == 91 || type == 92 || type == 93) {
                return true;
            }
        } else if (attributeType.equals(AttributeType.DOUBLE)) {
            if (type == 8 || type == 3 || type == 7 || type == 6) {
                return true;
            }
        } else {
            if (attributeType.equals(AttributeType.GEOMETRY)) {
                return true;
            }
            if (attributeType.equals(AttributeType.INTEGER)) {
                if (type == 4 || type == -5 || type == 5 || type == -6) {
                    return true;
                }
            } else {
                if (attributeType.equals(AttributeType.OBJECT)) {
                    return true;
                }
                if (attributeType.equals(AttributeType.STRING) && (type == 12 || type == 1 || type == 2004 || type == 2005 || type == -1)) {
                    return true;
                }
            }
        }
        return false;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public int getBatchValue() {
        return this.batchValue;
    }

    public void setBatchValue(int batchValue) {
        this.batchValue = batchValue;
    }

    public void close() throws SQLException {
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

