/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.wms.capabilities;

import java.util.HashSet;
import java.util.Set;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.ServiceProvider;
import nl.b3p.wms.capabilities.SrsBoundingBox;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class TileSet {
    private Integer id;
    private String srs;
    private SrsBoundingBox boundingBox;
    private String resolutions;
    private Integer width;
    private Integer height;
    private String format;
    private Set<Layer> layers;
    private String styles;
    private String layerString;
    private ServiceProvider serviceProvider;
    private String urlServiceProvideCode = null;

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getSrs() {
        return this.srs;
    }

    public void setSrs(String srs) {
        this.srs = srs;
    }

    public String getResolutions() {
        return this.resolutions;
    }

    public void setResolutions(String resolutions) {
        this.resolutions = resolutions;
    }

    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public Set<Layer> getLayers() {
        return this.layers;
    }

    public void setLayers(Set<Layer> layers) {
        this.layers = layers;
    }

    public String getUrlServiceProvideCode() {
        return this.urlServiceProvideCode;
    }

    public void setUrlServiceProvideCode(String urlServiceProvideCode) {
        this.urlServiceProvideCode = urlServiceProvideCode;
    }

    public String getStyles() {
        return this.styles;
    }

    public void setStyles(String styles) {
        this.styles = styles;
    }

    public SrsBoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(SrsBoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public String getLayerString() {
        return this.layerString;
    }

    public void setLayerString(String layerString) {
        this.layerString = layerString;
    }

    public ServiceProvider getServiceProvider() {
        return this.serviceProvider;
    }

    public void setServiceProvider(ServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    void addLayer(Layer l) {
        if (this.layers == null) {
            this.layers = new HashSet<Layer>();
        }
        this.layers.add(l);
    }

    public Element toElement(Document doc, Element rootElement) {
        Text text;
        Element element;
        if (this.getSrs() != null) {
            element = doc.createElement("SRS");
            text = doc.createTextNode(this.getSrs());
            element.appendChild(text);
            rootElement.appendChild(element);
        }
        if (this.getBoundingBox() != null) {
            rootElement = this.getBoundingBox().toElement(doc, rootElement);
        }
        if (this.getResolutions() != null) {
            element = doc.createElement("Resolutions");
            text = doc.createTextNode(this.getResolutions());
            element.appendChild(text);
            rootElement.appendChild(element);
        }
        if (this.getWidth() != null) {
            element = doc.createElement("Width");
            text = doc.createTextNode("" + this.getWidth());
            element.appendChild(text);
            rootElement.appendChild(element);
        }
        if (this.getHeight() != null) {
            element = doc.createElement("Height");
            text = doc.createTextNode("" + this.getHeight());
            element.appendChild(text);
            rootElement.appendChild(element);
        }
        if (this.getFormat() != null) {
            element = doc.createElement("Format");
            text = doc.createTextNode(this.getFormat());
            element.appendChild(text);
            rootElement.appendChild(element);
        }
        if (this.getLayers() != null) {
            String layerString = "";
            for (Layer l : this.getLayers()) {
                if (layerString.length() > 0) {
                    layerString = layerString + ",";
                }
                layerString = layerString + l.getUniqueName();
            }
            Element element2 = doc.createElement("Layers");
            Text text2 = doc.createTextNode(layerString);
            element2.appendChild(text2);
            rootElement.appendChild(element2);
        }
        if (this.getStyles() != null) {
            element = doc.createElement("Styles");
            text = doc.createTextNode(this.getStyles());
            element.appendChild(text);
            rootElement.appendChild(element);
        }
        return rootElement;
    }
}

