/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.ogc.utils;

import java.io.Serializable;
import java.util.List;
import nl.b3p.ogc.utils.OGCConstants;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.ogc.utils.OGCResponse;
import nl.b3p.ogc.utils.SpLayerSummary;
import nl.b3p.xml.wfs.v100.transaction.TransactionResult;
import nl.b3p.xml.wfs.v110.TransactionResponse;
import org.exolab.castor.xml.Unmarshaller;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WFSTransactionResponse
extends OGCResponse
implements OGCConstants {
    private TransactionResult newTransactionResponseV100;
    private TransactionResponse newTransactionResponseV110;

    @Override
    public void rebuildResponse(Document doc, OGCRequest request, String prefix) throws Exception {
        Element element = doc.getDocumentElement();
        this.httpHost = request.getUrlWithNonOGCparams();
        this.findNameSpace(doc);
        this.version = request.getFinalVersion();
        if (this.version.equalsIgnoreCase("1.0.0")) {
            Unmarshaller um = new Unmarshaller(TransactionResult.class);
            Object o = um.unmarshal((Node)element);
            TransactionResult transactionResponse = (TransactionResult)o;
            this.newTransactionResponseV100 = this.replaceTransactionResponseV100Url(transactionResponse, prefix);
        } else {
            Unmarshaller um = new Unmarshaller(TransactionResponse.class);
            Object o = um.unmarshal((Node)element);
            TransactionResponse transactionResponse = (TransactionResponse)o;
            this.newTransactionResponseV110 = this.replaceTransactionResponseV110Url(transactionResponse, prefix);
        }
        this.setUsableResponse(true);
    }

    public TransactionResult replaceTransactionResponseV100Url(TransactionResult transactionResponse, String prefix) {
        return transactionResponse;
    }

    public TransactionResponse replaceTransactionResponseV110Url(TransactionResponse transactionResponse, String prefix) {
        return transactionResponse;
    }

    @Override
    public String getResponseBody(List<SpLayerSummary> layers, OGCRequest ogcrequest, String encoding) {
        Serializable castorObject = null;
        if (!this.isUsableResponse()) {
            if (this.hasWfsV100ErrorResponse()) {
                return this.getWfsV100ErrorResponseBody(encoding);
            }
            if (this.hasOwsV100ErrorResponse()) {
                return this.getOwsV100ErrorResponseBody(encoding);
            }
            throw new UnsupportedOperationException("Failed to get suitable response! ");
        }
        if (this.hasWfsV100ErrorResponse()) {
            this.logErrorResponse(encoding);
        }
        castorObject = this.version.equals("1.0.0") ? this.newTransactionResponseV100 : this.newTransactionResponseV110;
        return this.marshalObject(castorObject, encoding);
    }
}

