/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import org.geotools.feature.AttributeTypeBuilder;
import org.opengis.feature.type.GeometryDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionFeatureType_AttributeNames_Rename
extends Action {
    private Integer[] attributeIds;
    private String[] currentAttributeNames;
    private String[] newAttributeNames;
    private List<String> removeColumns = null;
    protected String description = "Kies per invoerkolom een eigen uitvoerkolomnaam.";

    public ActionFeatureType_AttributeNames_Rename(String[] currentAttributeNames, String[] newAttributeNames) {
        this.currentAttributeNames = currentAttributeNames;
        this.newAttributeNames = newAttributeNames;
    }

    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        if (this.removeColumns == null && this.currentAttributeNames != null && this.currentAttributeNames.length > 0) {
            this.removeColumns = new ArrayList<String>();
            GeometryDescriptor gd = feature.getFeatureType().getGeometryDescriptor();
            String geomColumn = "";
            if (gd != null) {
                geomColumn = gd.getName().getLocalPart();
            }
            for (int i = 0; i < feature.getAttributeCount(); ++i) {
                String columnName = feature.getAttributeDescriptorNameByID(i);
                if (columnName.equals(geomColumn)) continue;
                this.removeColumns.add(columnName);
            }
            this.removeColumns.removeAll(Arrays.asList(this.currentAttributeNames));
        }
        if (this.currentAttributeNames != null && this.currentAttributeNames.length > 0) {
            this.attributeIds = this.getAttributeIds(feature, this.currentAttributeNames);
            for (int i = 0; i < this.currentAttributeNames.length; ++i) {
                AttributeTypeBuilder atb = new AttributeTypeBuilder();
                atb.init(feature.getFeatureType().getDescriptor(this.attributeIds[i].intValue()));
                feature.setAttributeDescriptor(this.attributeIds[i], atb.buildDescriptor(this.newAttributeNames[i]), true);
            }
            for (String columnName : this.removeColumns) {
                int attributeId = feature.getAttributeDescriptorIDbyName(columnName);
                feature.removeAttributeDescriptor(attributeId);
            }
        }
        return feature;
    }

    @Override
    public String toString() {
        return "Kies per invoerkolom een eigen uitvoerkolomnaam.";
    }

    public static List<List<String>> getConstructors(String[] invoer) {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        if (invoer != null) {
            constructors.add(Arrays.asList(invoer));
        }
        return constructors;
    }

    @Override
    public String getDescription_NL() {
        return this.description;
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
    }

    @Override
    public void processPostCollectionActions(Status status, Map properties) throws Exception {
    }
}

