/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import nl.b3p.geotools.data.linker.FeatureException;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import nl.b3p.geotools.data.linker.poi.ExcelReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionFeatureType_Replace_Class
extends Action {
    private Class newAttributeClass;
    private boolean tryCast;
    private boolean useGeometry = false;

    public ActionFeatureType_Replace_Class(String attributeName, Class newAttributeClass, boolean tryCast) {
        this.attributeName = attributeName;
        this.newAttributeClass = newAttributeClass;
        this.tryCast = tryCast;
    }

    public ActionFeatureType_Replace_Class(int attributeID, Class newAttributeClass, boolean tryCast) {
        this.attributeID = attributeID;
        this.newAttributeClass = newAttributeClass;
        this.tryCast = tryCast;
    }

    public ActionFeatureType_Replace_Class(Class newAttributeClass, boolean tryCast) {
        this.newAttributeClass = newAttributeClass;
        this.tryCast = tryCast;
        this.useGeometry = true;
    }

    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        if (this.useGeometry && feature.getFeatureType().getGeometryDescriptor() != null) {
            this.attributeName = feature.getFeatureType().getGeometryDescriptor().getLocalName();
        }
        try {
            this.fixAttributeID(feature);
        }
        catch (FeatureException fex) {
            log.debug((Object)("Attribuut " + this.attributeName + " niet gevonden voor feature."));
            return feature;
        }
        if (feature.containsAttributeDescriptor(this.attributeID)) {
            String geometryColumn;
            boolean hasGeometry = feature.getFeatureType().getGeometryDescriptor() != null;
            boolean isGeometry = false;
            if (hasGeometry && this.attributeName.equals(geometryColumn = feature.getFeatureType().getGeometryDescriptor().getName().getLocalPart())) {
                feature.setAttributeDescriptor(this.attributeID, EasyFeature.buildGeometryAttributeDescriptor(this.attributeName, this.newAttributeClass, feature.getFeature().isNillable(), feature.getFeature().getFeatureType().getCoordinateReferenceSystem()), true);
                isGeometry = true;
            }
            if (!isGeometry) {
                String value = null;
                if (feature.getAttribute(this.attributeID) != null) {
                    value = feature.getAttribute(this.attributeID).toString();
                }
                if (this.tryCast) {
                    feature.setAttributeDescriptor(this.attributeID, this.attributeName, this.newAttributeClass, false);
                    if (this.newAttributeClass.equals(Integer.class)) {
                        Integer waarde;
                        try {
                            waarde = Integer.parseInt(value);
                        }
                        catch (NumberFormatException nfe) {
                            waarde = 0;
                        }
                        feature.setAttribute(this.attributeID, (Object)waarde);
                    } else if (this.newAttributeClass.equals(String.class)) {
                        if (value == null || value.equals("")) {
                            feature.setAttribute(this.attributeID, null);
                        } else {
                            feature.setAttribute(this.attributeID, (Object)value);
                        }
                    } else if (this.newAttributeClass.equals(Double.class)) {
                        if (value == null) {
                            feature.setAttribute(this.attributeID, null);
                        } else {
                            feature.setAttribute(this.attributeID, (Object)Double.parseDouble(value));
                        }
                    } else if (this.newAttributeClass.equals(Float.class)) {
                        if (value == null) {
                            feature.setAttribute(this.attributeID, null);
                        } else {
                            feature.setAttribute(this.attributeID, (Object)Float.valueOf(Float.parseFloat(value)));
                        }
                    } else if (this.newAttributeClass.equals(Date.class)) {
                        if (value == null || value.equals("")) {
                            feature.setAttribute(this.attributeID, null);
                        } else {
                            if (value.length() == 16) {
                                String day = value.substring(7, 8);
                                String month = value.substring(5, 6);
                                String year = value.substring(0, 4);
                                value = day + "-" + month + "-" + year;
                            }
                            Locale loc = ExcelReader.LOCALE_NL;
                            String format = "dd-MM-yyyy";
                            Date date = new SimpleDateFormat(format, loc).parse(value);
                            feature.setAttribute(this.attributeID, (Object)date);
                        }
                    } else if (this.newAttributeClass.equals(Short.class)) {
                        if (value == null) {
                            feature.setAttribute(this.attributeID, null);
                        } else {
                            feature.setAttribute(this.attributeID, (Object)Short.parseShort(value));
                        }
                    } else {
                        feature.setAttribute(this.attributeID, (Object)value);
                    }
                }
            }
        }
        return feature;
    }

    @Override
    public String toString() {
        return "Verander kolomtype.";
    }

    public static List<List<String>> getConstructors() {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        constructors.add(Arrays.asList("attribute_name", "new_attribute_class", "trycast"));
        return constructors;
    }

    @Override
    public String getDescription_NL() {
        return "Met deze Action kan bij een SimpleFeatureType de class van een attribuut worden gewijzigd";
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
    }

    @Override
    public void processPostCollectionActions(Status status, Map properties) throws Exception {
    }
}

