/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import nl.b3p.commons.jpa.JpaUtilServlet;
import nl.b3p.datastorelinker.entity.Database;
import nl.b3p.geotools.data.linker.DataStoreLinker;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.Capabilities;
import org.geotools.filter.text.cql2.CQL;
import org.hibernate.Session;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Action_XY_Intersects_Add_Mapped_Attrib
extends Action {
    protected static final Log logger = LogFactory.getLog(Action_XY_Intersects_Add_Mapped_Attrib.class);
    private String vlakkenGeomColumn = null;
    private String sourceMatchColumn = null;
    private String vlakkenMatchColumn = null;
    private static DataStore ds = null;
    private static FeatureSource vlakkenFs = null;

    public Action_XY_Intersects_Add_Mapped_Attrib(Long vlakkenDatabaseId, String vlakkenGeomColumn, String vlakkenTableName, String sourceMatchColumn, String vlakkenMatchColumn, Boolean matchGeom) {
        this.vlakkenGeomColumn = vlakkenGeomColumn;
        this.sourceMatchColumn = sourceMatchColumn;
        this.vlakkenMatchColumn = vlakkenMatchColumn;
        Database db = null;
        if (vlakkenDatabaseId != null && vlakkenDatabaseId > 0L) {
            EntityManager em = JpaUtilServlet.getThreadEntityManager();
            Session session = (Session)em.getDelegate();
            db = (Database)session.get(Database.class, (Serializable)vlakkenDatabaseId);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (db != null) {
            params.put("schema", db.getSchema());
            params.put("port", db.getPort());
            params.put("passwd", db.getPassword());
            String dbType = db.getType().toString().toLowerCase();
            params.put("dbtype", dbType);
            params.put("host", db.getHost());
            params.put("validate connections", false);
            params.put("user", db.getUsername());
            params.put("database", db.getDatabaseName());
        }
        try {
            ds = DataStoreLinker.openDataStore(params);
            vlakkenFs = ds.getFeatureSource(vlakkenTableName);
        }
        catch (Exception ex) {
            logger.error((Object)"Fout tijdens openen Datastore.", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        if (vlakkenFs == null) {
            throw new Exception("No second source to combine found");
        }
        Point point = null;
        Geometry geometry = (Geometry)feature.getFeature().getDefaultGeometry();
        if (geometry != null && geometry instanceof Point) {
            point = (Point)geometry;
        } else if (geometry != null) {
            point = geometry.getCentroid();
        } else {
            throw new Exception("No default geometry found in source");
        }
        Object sourceMatchValue = null;
        SimpleFeature sourceF = feature.getFeature();
        if (this.sourceMatchColumn != null && !this.sourceMatchColumn.isEmpty()) {
            sourceMatchValue = sourceF.getAttribute(this.sourceMatchColumn);
        }
        String localVlakkenGeomColumn = null;
        localVlakkenGeomColumn = this.vlakkenGeomColumn == null || this.vlakkenGeomColumn.equals("") ? vlakkenFs.getSchema().getGeometryDescriptor().getLocalName() : this.vlakkenGeomColumn;
        Capabilities capabilities = new Capabilities();
        capabilities.addType(Intersects.class);
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        Intersects doIntersects = null;
        Filter doAttrib = null;
        And doBoth = null;
        if (localVlakkenGeomColumn != null && !localVlakkenGeomColumn.isEmpty() && !capabilities.supports((Filter)(doIntersects = ff.intersects((Expression)ff.property(localVlakkenGeomColumn), (Expression)ff.literal((Object)point))))) {
            doIntersects = null;
        }
        if (!(this.vlakkenMatchColumn == null || this.vlakkenMatchColumn.isEmpty() || sourceMatchValue == null || sourceMatchValue.toString().isEmpty() || this.vlakkenMatchColumn.equals("*") || this.sourceMatchColumn.equals("*"))) {
            doAttrib = CQL.toFilter((String)(this.vlakkenMatchColumn + " = '" + sourceMatchValue + "'"));
        }
        if (doIntersects != null && doAttrib != null) {
            doBoth = ff.and(doIntersects, doAttrib);
        }
        DefaultFeatureCollection vlakkenBronCollectie = null;
        if (doBoth != null) {
            vlakkenBronCollectie = (DefaultFeatureCollection)vlakkenFs.getFeatures((Filter)doBoth);
        } else if (doAttrib != null) {
            vlakkenBronCollectie = (DefaultFeatureCollection)vlakkenFs.getFeatures(doAttrib);
        } else if (doIntersects != null) {
            vlakkenBronCollectie = (DefaultFeatureCollection)vlakkenFs.getFeatures((Filter)doIntersects);
        } else {
            throw new Exception("No matching strategy found");
        }
        if (vlakkenBronCollectie == null || vlakkenBronCollectie.isEmpty()) {
            throw new Exception("Geometrie overlapt niet of geen match gevonden met de waarde in " + this.sourceMatchColumn);
        }
        SimpleFeatureIterator it = null;
        try {
            it = vlakkenBronCollectie.features();
            if (it.hasNext()) {
                SimpleFeature vlakkenF = (SimpleFeature)it.next();
                if (vlakkenF == null) {
                    throw new Exception("No suitable polygon found!");
                }
                String geometryName = feature.getFeature().getDefaultGeometryProperty().getDescriptor().getLocalName();
                int dId = feature.getAttributeDescriptorIDbyName(geometryName);
                GeometryDescriptor gd = vlakkenF.getDefaultGeometryProperty().getDescriptor();
                AttributeDescriptor gad = EasyFeature.buildGeometryAttributeDescriptor(geometryName, gd.getType().getBinding(), gd.isNillable(), gd.getType().getCoordinateReferenceSystem());
                feature.setAttributeDescriptor(dId, gad, false);
                feature.setAttribute(geometryName, vlakkenF.getAttribute(localVlakkenGeomColumn));
                feature.repairGeometry();
                List ads = vlakkenF.getFeatureType().getAttributeDescriptors();
                for (AttributeDescriptor ad : ads) {
                    Object vo;
                    Object o;
                    AttributeDescriptor sad;
                    String aln = ad.getLocalName();
                    if (aln.equalsIgnoreCase(localVlakkenGeomColumn) || (sad = sourceF.getFeatureType().getDescriptor(aln)) == null || (o = sourceF.getAttribute(aln)) != null && !o.toString().isEmpty() || (vo = vlakkenF.getAttribute(aln)) == null || vo.toString().isEmpty()) continue;
                    feature.setAttribute(aln, vo);
                }
            }
            Object var27_26 = null;
        }
        catch (Throwable throwable) {
            Object var27_27 = null;
            vlakkenBronCollectie.close((FeatureIterator)it);
            throw throwable;
        }
        vlakkenBronCollectie.close((FeatureIterator)it);
        return feature;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    public String getDescription_NL() {
        return "Verrijken met attributen na intersects en mapping match..";
    }

    public static List<List<String>> getConstructors() {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        constructors.add(Arrays.asList("attribute_name_outputdb_id", "attribute_name_output_geom_column", "attribute_name_poly_table", "attribute_name_match_src_column", "attribute_name_match_poly_column", "attribute_name_match_geom"));
        return constructors;
    }

    @Override
    public void close() throws Exception {
        if (ds != null) {
            ds.dispose();
        }
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
    }

    @Override
    public void processPostCollectionActions(Status status, Map properties) throws Exception {
    }
}

