/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.feature.EasyFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionFeatureType_Typename_AppendAttribute
extends Action {
    private int maxLength;

    public ActionFeatureType_Typename_AppendAttribute(String attributeName, int maxLength) {
        this.attributeName = attributeName;
        this.maxLength = maxLength;
    }

    public ActionFeatureType_Typename_AppendAttribute(int attributeID, int maxLength) {
        this.attributeID = attributeID;
        this.maxLength = maxLength;
    }

    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        this.fixAttributeID(feature);
        String attributeValue = feature.getAttribute(this.attributeID).toString();
        if (attributeValue.length() > this.maxLength) {
            attributeValue = attributeValue.substring(0, this.maxLength);
            attributeValue = attributeValue.replaceAll("([\\s])", "_");
        }
        feature.setTypeName(feature.getTypeName() + attributeValue);
        return feature;
    }

    @Override
    public String toString() {
        return "Append attribute '" + (this.attributeName.equals("") ? Integer.valueOf(this.attributeID) : this.attributeName) + "' to typename";
    }

    public static List<List<String>> getConstructors() {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        constructors.add(Arrays.asList("attribute_name", "length"));
        return constructors;
    }

    @Override
    public String getDescription_NL() {
        return "Met deze Action kan de waarde van een attribuut worden toegevoegd aan de typename";
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
    }

    @Override
    public void processPostCollectionActions(Status status, Map properties) throws Exception {
    }
}

