/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.feature.EasyFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionFeatureType_Typename_Substring
extends Action {
    private int beginIndex = -1;
    private int endIndex = -1;
    private boolean reverse = false;

    public ActionFeatureType_Typename_Substring(int beginIndex, int endIndex) {
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
    }

    public ActionFeatureType_Typename_Substring(int beginIndex) {
        this.beginIndex = beginIndex;
    }

    public ActionFeatureType_Typename_Substring(int length, boolean reverse) {
        this.endIndex = length;
        this.reverse = reverse;
    }

    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        String typename = feature.getFeatureType().getTypeName();
        if (this.reverse) {
            if (typename.length() - this.endIndex > 0) {
                typename = typename.substring(typename.length() - this.endIndex);
            }
        } else if (this.beginIndex >= 0 && this.endIndex <= typename.length()) {
            typename = this.endIndex >= 0 ? typename.substring(this.beginIndex, this.endIndex) : typename.substring(this.beginIndex);
        } else {
            String error = !this.reverse ? "Typename substring out of range; " + typename + ".subString(" + (this.endIndex >= 0 ? Integer.toString(this.beginIndex) + ", " + Integer.toString(this.endIndex) : Integer.toString(this.beginIndex)) + ")" : "Reverse typename substring failed; get last piece from " + typename + " with length " + this.endIndex;
            throw new Exception(error);
        }
        feature.setTypeName(typename);
        return feature;
    }

    @Override
    public String toString() {
        if (!this.reverse) {
            return "Typename subString(" + (this.endIndex >= 0 ? Integer.toString(this.beginIndex) + ", " + Integer.toString(this.endIndex) : Integer.toString(this.beginIndex)) + ")";
        }
        return "Reverse typename substring; get last piece from typename with length " + this.endIndex;
    }

    public static List<List<String>> getConstructors() {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        constructors.add(Arrays.asList("beginIndex", "endIndex"));
        constructors.add(Arrays.asList("beginIndex"));
        return constructors;
    }

    @Override
    public String getDescription_NL() {
        return "Met deze Action kan bij een SimpleFeatureType de typenaam worden ingekort door middel van een substring";
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
    }

    @Override
    public void processPostCollectionActions(Status status, Map properties) throws Exception {
    }
}

