/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionGeometry_Make_Point_Address
extends Action {
    private int attributeIDAddres1;
    private int attributeIDAddres2;
    private int attributeIDAddres3;
    private int attributeIDCity;
    private String attributeNameAddres1;
    private String attributeNameAddres2;
    private String attributeNameAddres3;
    private String attributeNameCity;
    private String projectie;
    private boolean useID = true;
    private String srs;

    public ActionGeometry_Make_Point_Address(int attributeIDAddres1, int attributeIDAddres2, int attributeIDAddres3, int attributeIDCity, String projectie) {
        this.attributeIDAddres1 = attributeIDAddres1;
        this.attributeIDAddres2 = attributeIDAddres2;
        this.attributeIDAddres3 = attributeIDAddres3;
        this.attributeIDCity = attributeIDCity;
        this.srs = projectie;
    }

    public ActionGeometry_Make_Point_Address(String attributeNameAddres1, String attributeNameAddres2, String attributeNameAddres3, String attributeNameCity, String projectie) {
        this.attributeNameAddres1 = attributeNameAddres1;
        this.attributeNameAddres2 = attributeNameAddres2;
        this.attributeNameAddres3 = attributeNameAddres3;
        this.attributeNameCity = attributeNameCity;
        this.srs = projectie;
        this.useID = false;
    }

    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        this.attributeIDAddres1 = -1;
        this.attributeIDAddres2 = -1;
        this.attributeIDAddres3 = -1;
        this.attributeIDCity = -1;
        if (!this.useID) {
            if (this.attributeNameAddres1 != null && !this.attributeNameAddres1.equals("")) {
                this.attributeIDAddres1 = feature.getAttributeDescriptorIDbyName(this.attributeNameAddres1);
            }
            if (this.attributeNameAddres2 != null && !this.attributeNameAddres2.equals("")) {
                this.attributeIDAddres2 = feature.getAttributeDescriptorIDbyName(this.attributeNameAddres2);
            }
            if (this.attributeNameAddres3 != null && !this.attributeNameAddres3.equals("")) {
                this.attributeIDAddres3 = feature.getAttributeDescriptorIDbyName(this.attributeNameAddres3);
            }
            if (this.attributeNameCity != null && !this.attributeNameCity.equals("")) {
                this.attributeIDCity = feature.getAttributeDescriptorIDbyName(this.attributeNameCity);
            }
        }
        EasyFeature f = this.setGeomToNewPoint(feature);
        return f;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    public String getDescription_NL() {
        return "Adres omzetten naar een Point geometrie.";
    }

    public static List<List<String>> getConstructors() {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        constructors.add(Arrays.asList("attribute_name_address1", "attribute_name_address2", "attribute_name_address3", "attribute_name_city", "srs"));
        return constructors;
    }

    private static double fixDecimals(String value) {
        if ((value = value.trim()).contains(",")) {
            if (value.contains(".")) {
                value = value.replaceAll("[.]", "");
            }
            value = value.replaceAll("[,]", ".");
        }
        return Double.parseDouble(value);
    }

    private EasyFeature setGeomToNewPoint(EasyFeature feature) throws Exception {
        String geometryDescriptorName = "the_geom";
        if (feature.getFeatureType().getGeometryDescriptor() != null) {
            geometryDescriptorName = feature.getFeatureType().getGeometryDescriptor().getName().getLocalPart();
        }
        String address1 = "";
        String address2 = "";
        String address3 = "";
        String city = "";
        if (this.attributeIDAddres1 > 0) {
            address1 = feature.getAttribute(this.attributeIDAddres1).toString();
        }
        if (this.attributeIDAddres2 > 0) {
            address2 = feature.getAttribute(this.attributeIDAddres2).toString();
        }
        if (this.attributeIDAddres3 > 0) {
            address3 = feature.getAttribute(this.attributeIDAddres3).toString();
        }
        if (this.attributeIDCity > 0) {
            city = feature.getAttribute(this.attributeIDCity).toString();
        }
        Point point = null;
        try {
            point = this.convertAddressToPoint(address1, address2, address3, city);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        if (point != null) {
            feature.setAttribute(geometryDescriptorName, (Object)point);
        }
        return feature;
    }

    private static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject readJsonFromUrl(String url) throws IOException, JSONException {
        JSONObject jSONObject;
        InputStream is = new URL(url).openStream();
        try {
            JSONObject json;
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            String jsonText = ActionGeometry_Make_Point_Address.readAll(rd);
            jSONObject = json = new JSONObject(jsonText);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            is.close();
            throw throwable;
        }
        is.close();
        return jSONObject;
    }

    private Point convertWktToRdsPoint(String wkt) throws Exception {
        Point p = null;
        try {
            Geometry targetGeometry;
            CoordinateReferenceSystem targetCRS;
            CoordinateReferenceSystem sourceCRS;
            MathTransform transform;
            Geometry sourceGeometry = ActionGeometry_Make_Point_Address.createGeomFromWKTString(wkt);
            if (sourceGeometry != null && (transform = CRS.findMathTransform((CoordinateReferenceSystem)(sourceCRS = CRS.decode((String)"EPSG:4326")), (CoordinateReferenceSystem)(targetCRS = CRS.decode((String)this.srs)), (boolean)true)) != null && (targetGeometry = JTS.transform((Geometry)sourceGeometry, (MathTransform)transform)) != null) {
                targetGeometry.setSRID(4326);
                p = targetGeometry.getCentroid();
            }
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        return p;
    }

    public static Geometry createGeomFromWKTString(String wktstring) throws Exception {
        WKTReader wktreader = new WKTReader(new GeometryFactory(new PrecisionModel(), 28992));
        try {
            return wktreader.read(wktstring);
        }
        catch (ParseException ex) {
            throw new Exception(ex);
        }
    }

    private String createGoogleUrl(String adres, String city) throws Exception {
        String url = null;
        String googleBaseUrl = "http://maps.google.nl/maps/geo?q=";
        String country = "Nederland";
        String plaats = ",+" + city + ",+" + country;
        String hl = "&hl=nl";
        String output = "&output=json";
        String encodedParams = null;
        try {
            encodedParams = URLEncoder.encode(adres + plaats, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Exception(ex);
        }
        String otherParams = hl + output;
        url = googleBaseUrl + encodedParams + otherParams;
        return url;
    }

    private String createAlternateUrl(String address) throws Exception {
        String url = null;
        String baseUrl = "http://bag42.nl/api/v0/geocode/json?maxitems=1&address=";
        String encodedParams = null;
        try {
            encodedParams = URLEncoder.encode(address, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new Exception(ex);
        }
        url = baseUrl + encodedParams;
        return url;
    }

    private String createGisGraphyurl() {
        String url = null;
        return url;
    }

    private Point convertAddressToPoint(String address1, String address2, String address3, String city) throws Exception {
        Point p1 = null;
        String adres = (address1 + " " + address2 + " " + address3).trim();
        if (adres == null || adres.equals("")) {
            throw new Exception("Adres is leeg.");
        }
        String newAdres = adres.replaceAll(" ", "");
        String encodeAdres = null;
        if (city != null && city.toUpperCase().equals("'S-HERTOGENBOSCH") || city.toUpperCase().equals("'S HERTOGENBOSCH")) {
            city = "DEN BOSCH";
        }
        if (city != null && city.toUpperCase().equals("'S-GRAVENHAGE") || city.toUpperCase().equals("'S GRAVENHAGE")) {
            city = "DEN HAAG";
        }
        if (city != null && city.toUpperCase().equals("'S-GRAVENDEEL")) {
            city = "GRAVENDEEL";
        }
        if (city != null && city.toUpperCase().equals("'S-GRAVENZANDE") || city.toUpperCase().equals("'S GRAVENZANDE")) {
            city = "GRAVENZANDE";
        }
        if (city != null && city.toUpperCase().equals("DRIEBERGEN-RIJSENBURG")) {
            city = "DRIEBERGEN";
        }
        if (city != null && city.toUpperCase().equals("HARDINXVELD-GIESSENDAM")) {
            city = "HARDINXVELD";
        }
        encodeAdres = city != null && !city.equals("") ? newAdres + "+" + city : newAdres;
        String url = this.createAlternateUrl(encodeAdres);
        try {
            JSONObject json = ActionGeometry_Make_Point_Address.readJsonFromUrl(url);
            if (json.getString("status").equals("ZERO_RESULTS")) {
                throw new Exception("Geen resultaat voor adres: " + encodeAdres);
            }
            Double x = new Double(json.getJSONArray("results").getJSONObject(0).getJSONObject("geometry").getJSONObject("location").getString("lat"));
            Double y = new Double(json.getJSONArray("results").getJSONObject(0).getJSONObject("geometry").getJSONObject("location").getString("lng"));
            try {
                Double lat = x;
                Double lon = y;
                if (x < y) {
                    lat = x;
                    lon = y;
                } else {
                    lat = y;
                    lon = x;
                }
                p1 = this.convertWktToRdsPoint("POINT(" + lat + " " + lon + ")");
            }
            catch (Exception ex) {
                throw new Exception(ex);
            }
        }
        catch (IOException ex) {
            throw new Exception(ex);
        }
        catch (JSONException ex) {
            throw new Exception(ex);
        }
        return p1;
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
    }

    @Override
    public void processPostCollectionActions(Status status, Map properties) throws Exception {
    }
}

