/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.util;

import java.util.Map;
import nl.b3p.geotools.data.linker.DataStoreLinker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.SolrParams;
import org.json.JSONException;
import org.json.JSONObject;

public class PDOKSearchClient {
    private SolrServer server = new HttpSolrServer("http://geodata.nationaalgeoregister.nl/locatieserver");
    private static final Log log = LogFactory.getLog(DataStoreLinker.class);

    public JSONObject search(String term) {
        try {
            SolrQuery query = new SolrQuery();
            query.setQuery(term);
            query.setRequestHandler("/free");
            QueryResponse rsp = this.server.query((SolrParams)query);
            SolrDocumentList list = rsp.getResults();
            for (SolrDocument solrDocument : list) {
                System.out.println(solrDocument);
                JSONObject doc = this.solrDocumentToResult(solrDocument);
                if (doc == null) continue;
                return doc;
            }
        }
        catch (SolrServerException ex) {
            log.error((Object)"Cannot search:", (Throwable)ex);
        }
        return null;
    }

    private JSONObject solrDocumentToResult(SolrDocument doc) {
        JSONObject result = null;
        try {
            Map values = doc.getFieldValueMap();
            result = new JSONObject();
            for (String key : values.keySet()) {
                result.put(key, values.get(key));
            }
        }
        catch (JSONException ex) {
            log.error((Object)ex);
        }
        return result;
    }
}

