/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import nl.b3p.geotools.data.linker.ActionList;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.feature.EasyFeature;

public abstract class ActionCondition
extends Action {
    protected ActionList actionListTrue = new ActionList();
    protected ActionList actionListFalse = new ActionList();

    @Override
    public abstract EasyFeature execute(EasyFeature var1) throws Exception;

    public ActionList getActionList(boolean type) {
        if (type) {
            return this.actionListTrue;
        }
        return this.actionListFalse;
    }

    public void clearActionList(boolean type) {
        if (type) {
            this.actionListTrue.clear();
        } else {
            this.actionListFalse.clear();
        }
    }

    public void addActionList(boolean type, ActionList actionList) {
        if (type) {
            this.actionListTrue.addAll(actionList);
        } else {
            this.actionListFalse.addAll(actionList);
        }
    }

    public void addActionToList(boolean type, Action action) {
        if (type) {
            this.actionListTrue.add(action);
        } else {
            this.actionListFalse.add(action);
        }
    }

    protected Double parseDouble(Object object) throws Exception {
        try {
            return Double.parseDouble(object.toString());
        }
        catch (NumberFormatException ex) {
            throw new Exception("Unable to compare object '" + object.toString() + "'; Object is not a number");
        }
    }

    protected EasyFeature compare(EasyFeature feature, Object left, CompareType compareType, Object right) throws Exception {
        Boolean result = null;
        switch (compareType) {
            case EQUAL: {
                result = left.equals(right);
                break;
            }
            case NOT_EQUAL: {
                result = !left.equals(right);
                break;
            }
            case GREATER: {
                result = this.parseDouble(left) > this.parseDouble(right);
                break;
            }
            case SMALLER: {
                result = this.parseDouble(left) < this.parseDouble(right);
                break;
            }
            case GREATER_EQUAL: {
                result = this.parseDouble(left) >= this.parseDouble(right);
                break;
            }
            case SMALLER_EQUAL: {
                result = this.parseDouble(left) <= this.parseDouble(right);
                break;
            }
        }
        if (result != null) {
            return this.process(result, feature);
        }
        return feature;
    }

    protected EasyFeature process(boolean actionListType, EasyFeature feature) throws Exception {
        if (actionListType) {
            return this.actionListTrue.process(feature);
        }
        return this.actionListFalse.process(feature);
    }

    @Override
    public void close() throws Exception {
        this.actionListTrue.close();
        this.actionListFalse.close();
    }

    protected String listsToString() {
        return ") {\n" + this.actionListTrue.toString() + "\n} else {\n" + this.actionListFalse.toString() + "\n}";
    }

    protected String listsGetDescription() {
        return "\n IF TRUE" + this.actionListTrue.toString() + "\n ELSE\n" + this.actionListFalse.toString() + "\n END IF";
    }

    public static enum CompareType {
        EQUAL("=="),
        NOT_EQUAL("!="),
        GREATER(">"),
        SMALLER("<"),
        GREATER_EQUAL(">="),
        SMALLER_EQUAL("<=");

        private String math;

        private CompareType(String math) {
            this.math = math;
        }

        public String toString() {
            return this.math;
        }

        public static CompareType byString(String type) {
            for (CompareType com : CompareType.values()) {
                if (!com.toString().equals(type)) continue;
                return com;
            }
            return null;
        }
    }
}

