/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.polygonize.PolygonizerWithoutInvalidLists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import nl.b3p.geotools.data.linker.ActionFactory;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.blocks.CollectionAction;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

public class CollectionAction_Polygonize
extends CollectionAction {
    protected static final Log log = LogFactory.getLog(CollectionAction_Polygonize.class);
    private final String polygonizeClassificationAttribute;
    private final Integer polygonizeClassificationBegin;
    private final Integer polygonizeClassificationEnd;
    private final String CLASS_STATUS_TODO = "waiting";
    private final String CLASS_STATUS_DONE = "done";
    private final boolean splitInClasses;
    private static final String POLYGONIZED = "_poligonized";
    private static final String DEFAULT_CLASSIFICATION = "default";
    private final boolean oneClassInMemory;

    public CollectionAction_Polygonize(Map properties) {
        Integer i;
        this.polygonizeClassificationAttribute = ActionFactory.propertyCheck(properties, "polygonize_classification_attribute") ? (String)properties.get("polygonize_classification_attribute") : null;
        if (ActionFactory.propertyCheck(properties, "polygonize_classification_begin")) {
            try {
                i = Integer.parseInt((String)properties.get("polygonize_classification_begin"));
            }
            catch (NumberFormatException nfe) {
                i = null;
            }
            this.polygonizeClassificationBegin = i;
        } else {
            this.polygonizeClassificationBegin = null;
        }
        if (ActionFactory.propertyCheck(properties, "polygonize_classification_end")) {
            try {
                i = Integer.parseInt((String)properties.get("polygonize_classification_end"));
            }
            catch (NumberFormatException nfe) {
                i = null;
            }
            this.polygonizeClassificationEnd = i;
        } else {
            this.polygonizeClassificationEnd = null;
        }
        if (ActionFactory.propertyCheck(properties, "polygonize_oneClassInMemory")) {
            Boolean b;
            try {
                b = (Boolean)properties.get("polygonize_oneClassInMemory");
            }
            catch (NumberFormatException nfe) {
                b = null;
            }
            this.oneClassInMemory = b;
        } else {
            this.oneClassInMemory = true;
        }
        this.splitInClasses = this.polygonizeClassificationAttribute != null && this.polygonizeClassificationAttribute.length() > 0;
    }

    public void execute(DefaultFeatureCollection collection, Action nextAction) {
        if (this.oneClassInMemory) {
            this.executeOneClassInMemory(collection, nextAction);
        } else {
            this.executeAllInMemory(collection, nextAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAllInMemory(DefaultFeatureCollection collection, Action nextAction) {
        log.info((Object)"execute Polygonize with all classifications at once");
        SimpleFeatureType newFt = this.createFeatureType((FeatureType)collection.getSchema());
        HashMap<Object, PolygonizerWithoutInvalidLists> polygonizers = new HashMap<Object, PolygonizerWithoutInvalidLists>();
        SimpleFeatureIterator features = null;
        try {
            features = collection.features();
            while (features.hasNext()) {
                Geometry featureGeom;
                Feature feature = features.next();
                Object classification = this.getClassification(feature);
                if (polygonizers.get(classification) == null) {
                    polygonizers.put(classification, new PolygonizerWithoutInvalidLists());
                }
                if (!(featureGeom = (Geometry)feature.getDefaultGeometryProperty().getValue()).isValid()) continue;
                ((PolygonizerWithoutInvalidLists)polygonizers.get(classification)).add(featureGeom);
            }
            for (Object classification : polygonizers.keySet()) {
                log.info((Object)("Polygonize features with classification: " + classification));
                PolygonizerWithoutInvalidLists polygonizer = (PolygonizerWithoutInvalidLists)polygonizers.get(classification);
                this.createPolygonsFeatures(polygonizer, classification, newFt, nextAction);
            }
        }
        catch (Exception e) {
            log.error((Object)("Error polygonizer for feature: " + newFt.getTypeName()), (Throwable)e);
        }
        finally {
            if (collection != null && features != null) {
                collection.close((FeatureIterator)features);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeOneClassInMemory(DefaultFeatureCollection collection, Action nextAction) {
        log.info((Object)"execute Polygonize with one classification in the memory at once");
        HashMap<Object, String> classificationStatuses = null;
        SimpleFeatureType newFt = this.createFeatureType((FeatureType)collection.getSchema());
        for (int i = 0; classificationStatuses == null || i < classificationStatuses.size(); ++i) {
            if (classificationStatuses == null) {
                classificationStatuses = new HashMap<Object, String>();
            }
            SimpleFeatureIterator features = null;
            Object currentClassification = null;
            try {
                features = collection.features();
                PolygonizerWithoutInvalidLists polygonizer = new PolygonizerWithoutInvalidLists();
                while (features.hasNext()) {
                    Geometry featureGeom;
                    Feature feature = features.next();
                    Object classification = this.getClassification(feature);
                    String classificationStatus = (String)classificationStatuses.get(classification);
                    if (classificationStatus == null) {
                        classificationStatuses.put(classification, "waiting");
                    } else if (classificationStatus.equalsIgnoreCase("done")) continue;
                    if (currentClassification == null) {
                        currentClassification = classification;
                    }
                    if (!classification.equals(currentClassification) || !(featureGeom = (Geometry)feature.getDefaultGeometryProperty().getValue()).isValid()) continue;
                    polygonizer.add(featureGeom);
                }
                log.info((Object)("Polygonize features with classification: " + currentClassification));
                this.createPolygonsFeatures(polygonizer, currentClassification, newFt, nextAction);
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Error polygonizer for feature: " + newFt.getTypeName() + " with classification: " + currentClassification), (Throwable)e);
                continue;
            }
            finally {
                if (currentClassification != null) {
                    classificationStatuses.put(currentClassification, "done");
                }
                if (collection != null && features != null) {
                    collection.close((FeatureIterator)features);
                }
            }
        }
    }

    public void close() {
    }

    private SimpleFeatureType createFeatureType(FeatureType ft) {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName(ft.getName().getLocalPart() + POLYGONIZED);
        typeBuilder.setCRS(ft.getCoordinateReferenceSystem());
        if (this.splitInClasses) {
            typeBuilder.add("classification", String.class);
        }
        typeBuilder.add(ft.getGeometryDescriptor().getLocalName(), Polygon.class);
        return typeBuilder.buildFeatureType();
    }

    private void createPolygonsFeatures(PolygonizerWithoutInvalidLists polygonizer, Object classification, SimpleFeatureType newFt, Action nextAction) throws Exception {
        int successPolygonCounter = 0;
        int totalDangles = -1;
        int invalidRingLines = -1;
        int cutEdges = -1;
        Collection c = polygonizer.getPolygons();
        if (log.isDebugEnabled()) {
            // empty if block
        }
        log.info((Object)("Polygonization for feature " + newFt.getTypeName() + " and classification " + classification + " done.\n" + c.size() + " polygons created by polygonization. \n" + totalDangles + " lines are not connected with both sides (Dangles). \n" + invalidRingLines + " invalid ring lines are formed (e.g. the component lines contain a self-intersectin). \n" + cutEdges + " lines are connected with both ends but don't form part of a polygon. (Cutted Edges)"));
        Iterator cit = c.iterator();
        while (cit.hasNext()) {
            try {
                ArrayList<Object> values = new ArrayList<Object>();
                if (this.splitInClasses) {
                    values.add(classification);
                }
                values.add((Polygon)cit.next());
                nextAction.execute(new EasyFeature(SimpleFeatureBuilder.build((SimpleFeatureType)newFt, values, (String)("" + successPolygonCounter))));
                ++successPolygonCounter;
            }
            catch (Exception e) {
                log.error((Object)"Error passing feature", (Throwable)e);
            }
        }
        log.info((Object)(c.size() + " Polygons with featureName: " + newFt.getTypeName() + "and classification: " + classification + " are processed. " + successPolygonCounter + " are successful."));
    }

    private Object getClassification(Feature feature) {
        Object classification = DEFAULT_CLASSIFICATION;
        if (this.splitInClasses) {
            if (feature.getProperty(this.polygonizeClassificationAttribute) != null && (classification = feature.getProperty(this.polygonizeClassificationAttribute).getValue()) != null && (this.polygonizeClassificationEnd != null || this.polygonizeClassificationBegin != null)) {
                String s = classification.toString();
                int begin = 0;
                int end = s.length();
                if (this.polygonizeClassificationEnd != null && this.polygonizeClassificationEnd < s.length()) {
                    end = this.polygonizeClassificationEnd;
                }
                if (this.polygonizeClassificationBegin != null) {
                    begin = this.polygonizeClassificationBegin > end ? end : this.polygonizeClassificationBegin;
                }
                classification = s.substring(begin, end);
            }
            if (classification == null) {
                classification = DEFAULT_CLASSIFICATION;
            }
        }
        return classification;
    }

    @Override
    public void execute(FeatureCollection collection, Action writer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

