/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.polygonize;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.operation.polygonize.EdgeRing;
import com.vividsolutions.jts.operation.polygonize.PolygonizeGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PolygonizerWithoutInvalidLists {
    private LineStringAdder lineStringAdder = new LineStringAdder();
    protected PolygonizeGraph graph;
    protected Collection dangles = new ArrayList();
    protected List cutEdges = new ArrayList();
    protected List invalidRingLines = new ArrayList();
    protected List holeList = null;
    protected List shellList = null;
    protected List polyList = null;

    public void add(Collection geomList) {
        for (Geometry geometry : geomList) {
            this.add(geometry);
        }
    }

    public void add(Geometry g) {
        g.apply((GeometryComponentFilter)this.lineStringAdder);
    }

    private void add(LineString line) {
        if (this.graph == null) {
            this.graph = new PolygonizeGraph(line.getFactory());
        }
        this.graph.addEdge(line);
    }

    public Collection getPolygons() {
        this.polygonize();
        return this.polyList;
    }

    public Collection getDangles() {
        this.polygonize();
        return this.dangles;
    }

    public Collection getCutEdges() {
        this.polygonize();
        return this.cutEdges;
    }

    public Collection getInvalidRingLines() {
        this.polygonize();
        return this.invalidRingLines;
    }

    private void polygonize() {
        if (this.polyList != null) {
            return;
        }
        this.polyList = new ArrayList();
        if (this.graph == null) {
            return;
        }
        this.graph.deleteDangles();
        System.gc();
        this.graph.deleteCutEdges();
        System.gc();
        ArrayList edgeRingList = this.graph.getEdgeRings();
        ArrayList validEdgeRingList = new ArrayList();
        this.invalidRingLines = new ArrayList();
        this.findValidRings(edgeRingList, validEdgeRingList, this.invalidRingLines);
        this.invalidRingLines = new ArrayList();
        edgeRingList = new ArrayList();
        System.gc();
        this.findShellsAndHoles(validEdgeRingList);
        PolygonizerWithoutInvalidLists.assignHolesToShells(this.holeList, this.shellList);
        this.polyList = new ArrayList();
        for (EdgeRing er : this.shellList) {
            this.polyList.add(er.getPolygon());
        }
    }

    private void findValidRings(List edgeRingList, List validEdgeRingList, List invalidRingList) {
        for (EdgeRing er : edgeRingList) {
            if (er.isValid()) {
                validEdgeRingList.add(er);
                continue;
            }
            invalidRingList.add(er.getLineString());
        }
    }

    private void findShellsAndHoles(List edgeRingList) {
        this.holeList = new ArrayList();
        this.shellList = new ArrayList();
        for (EdgeRing er : edgeRingList) {
            if (er.isHole()) {
                this.holeList.add(er);
                continue;
            }
            this.shellList.add(er);
        }
    }

    private static void assignHolesToShells(List holeList, List shellList) {
        for (EdgeRing holeER : holeList) {
            PolygonizerWithoutInvalidLists.assignHoleToShell(holeER, shellList);
        }
    }

    private static void assignHoleToShell(EdgeRing holeER, List shellList) {
        EdgeRing shell = EdgeRing.findEdgeRingContaining((EdgeRing)holeER, (List)shellList);
        if (shell != null) {
            shell.addHole(holeER.getRing());
        }
    }

    private class LineStringAdder
    implements GeometryComponentFilter {
        private LineStringAdder() {
        }

        public void filter(Geometry g) {
            if (g instanceof LineString) {
                PolygonizerWithoutInvalidLists.this.add((LineString)g);
            }
        }
    }
}

