/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.buffer.BufferOp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.blocks.ActionFeatureType_Replace_Class;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import org.opengis.feature.type.GeometryDescriptor;

public class ActionGeometry_Buffer
extends Action {
    private double bufferSize;

    public ActionGeometry_Buffer(double bufferSize) {
        this.bufferSize = bufferSize;
    }

    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        if (this.bufferSize < 0.0) {
            throw new Exception("Buffersize is " + this.bufferSize + "; must be zero or higher");
        }
        GeometryDescriptor gd = feature.getFeatureType().getGeometryDescriptor();
        if (gd == null) {
            return feature;
        }
        this.attributeName = gd.getName().getLocalPart();
        this.fixAttributeID(feature);
        Geometry geometry = (Geometry)feature.getAttribute(this.attributeName);
        geometry = BufferOp.bufferOp((Geometry)geometry, (double)this.bufferSize);
        ActionFeatureType_Replace_Class action = new ActionFeatureType_Replace_Class(this.attributeName, Polygon.class, false);
        ((Action)action).execute(feature);
        feature.setAttribute(this.attributeName, (Object)geometry);
        return feature;
    }

    @Override
    public String toString() {
        return "Buffer geometry to '" + this.bufferSize + "'";
    }

    public static List<List<String>> getConstructors() {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        constructors.add(Arrays.asList("buffersize"));
        return constructors;
    }

    @Override
    public String getDescription_NL() {
        return "Met deze Action kan bij een SimpleFeature de geometrie worden aangepast door bijvoorbeeld een lijn om te zetten in een dikkere lijn. De lijn zal worden omgezet in een vlak";
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
    }

    @Override
    public void processPostCollectionActions(Status status, Map properties) throws Exception {
    }
}

