/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import org.geotools.referencing.CRS;
import org.opengis.feature.type.AttributeDescriptor;

public class ActionGeometry_Make_Point
extends Action {
    private int attributeIDY;
    private String attributeNameY;
    private boolean useID = true;
    private String srs;

    public ActionGeometry_Make_Point(int attributeIDX, int attributeIDY, String srs) {
        this.attributeID = attributeIDX;
        this.attributeIDY = attributeIDY;
        this.srs = srs;
    }

    public ActionGeometry_Make_Point(String attributeNameX, String attributeNameY, String srs) {
        this.attributeName = attributeNameX;
        this.attributeNameY = attributeNameY;
        this.useID = false;
        this.srs = srs;
    }

    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        int attributeIDX = -1;
        if (this.useID) {
            attributeIDX = this.attributeID;
        } else {
            attributeIDX = feature.getAttributeDescriptorIDbyName(this.attributeName);
            this.attributeIDY = feature.getAttributeDescriptorIDbyName(this.attributeNameY);
        }
        String geometryDescriptorName = "the_geom";
        if (feature.getFeatureType().getGeometryDescriptor() != null) {
            geometryDescriptorName = feature.getFeatureType().getGeometryDescriptor().getName().getLocalPart();
        }
        AttributeDescriptor geometryAttributeType = EasyFeature.buildGeometryAttributeDescriptor(geometryDescriptorName, Point.class, feature.getFeature().isNillable(), CRS.decode((String)this.srs));
        feature.setAttributeDescriptor(geometryDescriptorName, geometryAttributeType);
        if (feature.getAttribute(attributeIDX) == null || feature.getAttribute(this.attributeIDY) == null) {
            log.warn((Object)("Unable to create point with " + this.toString()));
        } else {
            Coordinate coord = new Coordinate(ActionGeometry_Make_Point.fixDecimals(feature.getAttribute(attributeIDX).toString()), ActionGeometry_Make_Point.fixDecimals(feature.getAttribute(this.attributeIDY).toString()));
            GeometryFactory gf = new GeometryFactory();
            Point point = gf.createPoint(coord);
            feature.setAttribute(geometryDescriptorName, (Object)point);
        }
        return feature;
    }

    @Override
    public String toString() {
        return "Create geometry point(" + (this.attributeName.equals("") ? Integer.valueOf(this.attributeID) : this.attributeName) + ", " + (this.attributeNameY.equals("") ? Integer.valueOf(this.attributeIDY) : this.attributeNameY) + ")";
    }

    @Override
    public String getDescription_NL() {
        return "Maak van twee attributen een punt; bijvoorbeeld van COORD_X en COORD_Y";
    }

    public static List<List<String>> getConstructors() {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        constructors.add(Arrays.asList("attribute_name_x", "attribute_name_y", "srs"));
        return constructors;
    }

    private static double fixDecimals(String value) {
        if ((value = value.trim()).contains(",")) {
            if (value.contains(".")) {
                value = value.replaceAll("[.]", "");
            }
            value = value.replaceAll("[,]", ".");
        }
        return Double.parseDouble(value);
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
    }

    @Override
    public void processPostCollectionActions(Status status, Map properties) throws Exception {
    }
}

