/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.operation.linemerge.LineMerger;
import com.vividsolutions.jts.operation.polygonize.Polygonizer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.ActionFactory;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.blocks.CollectionAction;
import nl.b3p.geotools.data.linker.blocks.CollectionAction_PolygonizeSufLki;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.text.cql2.CQLException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;

public class CollectionAction_PolygonizeWithAttr
extends CollectionAction {
    protected static final Log log = LogFactory.getLog(CollectionAction_PolygonizeWithAttr.class);
    private static final String POLYGONIZED = "_polygonized";
    private DataStore dataStore2Write = null;
    private String cqlFilterString = null;
    private String attributeFeatureName = null;
    private String lineFeatureName = null;
    private int polygonCounter = 0;
    private int multiPolygonCounter = 0;
    protected double lineCloseTolerance = 0.0;

    public CollectionAction_PolygonizeWithAttr(DataStore dataStore2Write, Map properties) throws Exception {
        this.cqlFilterString = ActionFactory.propertyCheck(properties, "polygonizeWithAttr_cqlfilter") ? (String)properties.get("polygonizeWithAttr_cqlfilter") : null;
        this.attributeFeatureName = ActionFactory.propertyCheck(properties, "polygonizeWithAttr_attributeFeatureName") ? (String)properties.get("polygonizeWithAttr_attributeFeatureName") : null;
        this.lineFeatureName = ActionFactory.propertyCheck(properties, "polygonizeWithAttr_lineFeatureName") ? (String)properties.get("polygonizeWithAttr_lineFeatureName") : null;
        this.lineCloseTolerance = ActionFactory.propertyCheck(properties, "polygonizeWithAttr_lineCloseTolerance") ? Double.parseDouble((String)properties.get("polygonizeWithAttr_lineCloseTolerance")) : 0.001;
        if (this.attributeFeatureName == null || this.lineFeatureName == null) {
            throw new Exception("Missing one of the mandatory values in the properties map");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(DefaultFeatureCollection originalCollection, Action nextAction) {
        this.preExecute();
        if (this.cqlFilterString == null) {
            log.error((Object)"CqlFilter not set!");
            return;
        }
        SimpleFeatureIterator features = null;
        DefaultFeatureCollection collection = null;
        try {
            ArrayList<String> propertyNames = this.getPropertyNamesInCql(this.getCqlFilterString());
            Filter usableFilter = this.createFilterWithOnlyUsableFeatures(propertyNames);
            collection = (DefaultFeatureCollection)originalCollection.subCollection(usableFilter);
            features = collection.features();
            SimpleFeatureType originalFt = collection.getSchema();
            int geometryColumnIndex = -1;
            String geomColumn = originalFt.getGeometryDescriptor().getName().getLocalPart();
            List attributeDescriptors = originalFt.getAttributeDescriptors();
            for (int i = 0; i < attributeDescriptors.size(); ++i) {
                if (!((AttributeDescriptor)attributeDescriptors.get(i)).getLocalName().equalsIgnoreCase(geomColumn)) continue;
                geometryColumnIndex = i;
            }
            SimpleFeatureType polygonFt = this.createNewFeatureType(originalFt, geometryColumnIndex, Polygon.class);
            SimpleFeatureType multiPolygonFt = this.createNewFeatureType(originalFt, geometryColumnIndex, Polygon.class);
            int featureCounter = 0;
            int successcounter = 0;
            int totalFeatures = collection.size();
            while (features.hasNext()) {
                ++featureCounter;
                try {
                    int i;
                    if (featureCounter % 10000 == 0) {
                        log.info((Object)("PolygonizeWithAttr featurecount: " + featureCounter + "/" + totalFeatures));
                    }
                    SimpleFeature feature = (SimpleFeature)features.next();
                    String featureFilterString = new String(this.getCqlFilterString());
                    Filter filter = this.createLineFilter(feature, propertyNames);
                    SimpleFeatureSource fs = this.dataStore2Write.getFeatureSource(this.getLineFeatureName());
                    DefaultFeatureCollection fc = (DefaultFeatureCollection)fs.getFeatures(filter);
                    ArrayList<SimpleFeature> correctLineFeatures = null;
                    SimpleFeatureIterator lineFeatures = fc.features();
                    try {
                        correctLineFeatures = this.filterInvalidLines((FeatureIterator)lineFeatures);
                    }
                    finally {
                        fc.close((FeatureIterator)lineFeatures);
                    }
                    ArrayList<Polygon> polygons = this.createPolygonWithLines(correctLineFeatures);
                    if (polygons.size() == 0) {
                        log.debug((Object)("No polygons created with lines.\nQuery: " + filter.toString()));
                        continue;
                    }
                    ArrayList<Polygon> positivePolygons = new ArrayList<Polygon>();
                    ArrayList<Polygon> negativePolygons = new ArrayList<Polygon>();
                    for (int i2 = 0; i2 < polygons.size(); ++i2) {
                        Polygon polygon = polygons.get(i2);
                        Boolean ispositivePolygon = this.isPositivePolygon(polygon, correctLineFeatures, feature);
                        if (ispositivePolygon == null) {
                            log.error((Object)"error getting the value of the polygon (positive or negative)");
                            continue;
                        }
                        if (!ispositivePolygon.booleanValue()) {
                            negativePolygons.add(polygon);
                            continue;
                        }
                        positivePolygons.add(polygon);
                    }
                    if (positivePolygons.size() == 0) {
                        log.error((Object)("no positive geometries found.\n Query: " + filter.toString()));
                        continue;
                    }
                    Geometry geom = null;
                    geom = (Geometry)positivePolygons.get(0);
                    for (i = 1; i < positivePolygons.size(); ++i) {
                        geom = geom.union((Geometry)positivePolygons.get(i));
                    }
                    for (i = 0; i < negativePolygons.size(); ++i) {
                        geom = geom.difference((Geometry)negativePolygons.get(i));
                    }
                    SimpleFeatureType newFt = null;
                    int id = 0;
                    if (geom instanceof MultiPolygon) {
                        ++this.multiPolygonCounter;
                        id = this.multiPolygonCounter;
                        newFt = multiPolygonFt;
                    } else {
                        ++this.polygonCounter;
                        id = this.polygonCounter;
                        newFt = polygonFt;
                    }
                    List attributes = feature.getAttributes();
                    attributes.set(geometryColumnIndex, geom);
                    ++successcounter;
                    nextAction.execute(new EasyFeature(SimpleFeatureBuilder.build((SimpleFeatureType)newFt, (List)attributes, (String)("" + id))));
                }
                catch (Exception e) {
                    log.error((Object)"Error creating feature Polygon (in polygonize function): ", (Throwable)e);
                }
            }
            float xSuccess = successcounter;
            float xFeatures = featureCounter;
            float rate = xSuccess / xFeatures * 100.0f;
            log.info((Object)("Tried to make: " + featureCounter + " polygons/multipolygons. Successfully created: " + successcounter + " polygons/multipolygons. That's a rate of: " + rate + "%"));
            if (collection == null || features == null) return;
        }
        catch (Exception e) {
            try {
                log.error((Object)("Error polygonizer for feature: " + originalCollection.getSchema().getName().getLocalPart()), (Throwable)e);
                if (collection == null || features == null) return;
            }
            catch (Throwable throwable) {
                if (collection == null || features == null) throw throwable;
                collection.close(features);
                throw throwable;
            }
            collection.close((FeatureIterator)features);
            return;
        }
        collection.close((FeatureIterator)features);
        return;
    }

    public void preExecute() {
    }

    private Filter createFilterWithOnlyUsableFeatures(ArrayList<String> propertyNames) throws CQLException {
        String cqlFilter = this.getCqlFilterString();
        IncludeFilter filter = Filter.INCLUDE;
        if (propertyNames.size() > 0) {
            String newCqlFilter = "";
            for (int i = 0; i < propertyNames.size(); ++i) {
                if (newCqlFilter.length() > 0) {
                    newCqlFilter = newCqlFilter + " and ";
                }
                newCqlFilter = newCqlFilter + propertyNames.get(i) + " is not null";
            }
            filter = CQL.toFilter((String)newCqlFilter);
        }
        return filter;
    }

    private ArrayList<String> getPropertyNamesInCql(String cqlFilter) {
        int beginIndex = cqlFilter.indexOf("[");
        int endIndex = cqlFilter.indexOf("]");
        ArrayList<String> propertyNames = new ArrayList<String>();
        while (beginIndex >= 0) {
            String propName;
            if (endIndex > beginIndex && !propertyNames.contains(propName = cqlFilter.substring(beginIndex + 1, endIndex))) {
                propertyNames.add(propName);
            }
            beginIndex = cqlFilter.indexOf("[", endIndex + 1);
            endIndex = cqlFilter.indexOf("]", endIndex + 1);
        }
        return propertyNames;
    }

    public Filter createLineFilter(SimpleFeature feature, ArrayList<String> propertyNames) throws CQLException {
        String featureFilterString = new String(this.getCqlFilterString());
        for (int i = 0; i < propertyNames.size() && featureFilterString.indexOf("[") >= 0; ++i) {
            if (featureFilterString.indexOf("[" + propertyNames.get(i) + "]") < 0 || feature.getProperty(propertyNames.get(i)) == null) continue;
            String regExp = "\\[" + propertyNames.get(i) + "\\]";
            String value = null;
            if (feature.getProperty(propertyNames.get(i)).getValue() != null) {
                value = feature.getProperty(propertyNames.get(i)).getValue().toString();
            }
            if (value == null) continue;
            value = "'" + value + "'";
            featureFilterString = featureFilterString.replaceAll(regExp, value);
        }
        if (featureFilterString.indexOf("[") >= 0) {
            log.error((Object)("The CQL string is not correct: " + featureFilterString));
            return null;
        }
        return CQL.toFilter((String)featureFilterString);
    }

    public ArrayList<SimpleFeature> filterInvalidLines(FeatureIterator lineFeatures) {
        ArrayList<Object> correctLineFeatures = new ArrayList<SimpleFeature>();
        while (lineFeatures.hasNext()) {
            int i;
            SimpleFeature line = (SimpleFeature)lineFeatures.next();
            boolean addLine = false;
            ArrayList<Integer> removeIndex = new ArrayList<Integer>();
            if (line != null && line.getDefaultGeometryProperty() != null && line.getDefaultGeometryProperty().getValue() != null) {
                addLine = true;
                Geometry featureGeom = (Geometry)line.getDefaultGeometryProperty().getValue();
                for (i = 0; i < correctLineFeatures.size() && addLine; ++i) {
                    Geometry lineGeom = (Geometry)((SimpleFeature)correctLineFeatures.get(i)).getDefaultGeometryProperty().getValue();
                    if (lineGeom.equals(featureGeom)) {
                        addLine = false;
                        continue;
                    }
                    if (featureGeom.crosses(lineGeom)) {
                        addLine = false;
                        continue;
                    }
                    if (lineGeom.buffer(5.0E-4).contains(featureGeom)) {
                        addLine = false;
                        continue;
                    }
                    if (!featureGeom.buffer(5.0E-4).contains(lineGeom)) continue;
                    removeIndex.add(new Integer(i));
                }
            } else {
                log.error((Object)"Feature has no (line)geometry!");
            }
            if (!addLine) continue;
            if (removeIndex.size() > 0) {
                ArrayList<Object> newCorrectLines = new ArrayList<Object>();
                for (i = 0; i < correctLineFeatures.size(); ++i) {
                    boolean doAdd = true;
                    for (int r = 0; r < removeIndex.size() && doAdd; ++r) {
                        if (i != (Integer)removeIndex.get(r)) continue;
                        doAdd = false;
                    }
                    if (!doAdd) continue;
                    newCorrectLines.add(correctLineFeatures.get(i));
                }
                correctLineFeatures = newCorrectLines;
            }
            correctLineFeatures.add(line);
        }
        return correctLineFeatures;
    }

    public ArrayList<Polygon> createPolygonWithLines(ArrayList<SimpleFeature> lines) {
        LineMerger merger = new LineMerger();
        for (int i = 0; i < lines.size(); ++i) {
            Geometry lineGeom = (Geometry)lines.get(i).getDefaultGeometryProperty().getValue();
            merger.add(lineGeom);
        }
        Collection coll = merger.getMergedLineStrings();
        Iterator geomIt = coll.iterator();
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        while (geomIt.hasNext()) {
            Geometry linestring = (Geometry)geomIt.next();
            if (this.getLineCloseTolerance() != 0.0 && linestring instanceof LineString) {
                linestring = this.closeLineString((LineString)linestring);
            }
            Polygonizer p = new Polygonizer();
            p.add(linestring);
            if (p.getPolygons().size() <= 0) {
                if (!log.isDebugEnabled()) continue;
                String logMessage = "No polygon created with: " + linestring.toText() + " cause:";
                if (p.getCutEdges().size() > 0) {
                    logMessage = logMessage + "\nGeometry has Cut Edges";
                }
                if (p.getDangles().size() > 0) {
                    logMessage = logMessage + "\nGeometry has Dangles";
                }
                if (p.getInvalidRingLines().size() > 0) {
                    logMessage = logMessage + "\nGeometry has Invalid Ring Lines";
                }
                log.debug((Object)logMessage);
                continue;
            }
            polygons.addAll(p.getPolygons());
        }
        return polygons;
    }

    public Geometry closeLineString(LineString ls) {
        if (ls.isClosed()) {
            return ls;
        }
        Coordinate[] oriCoords = ls.getCoordinates();
        if (this.getLineCloseTolerance() < 0.0 || oriCoords[0].distance(oriCoords[oriCoords.length - 1]) < this.getLineCloseTolerance()) {
            log.debug((Object)("Line not closed. Close the line with a tolerance of: " + this.getLineCloseTolerance()));
            Coordinate[] newCoords = new Coordinate[oriCoords.length + 1];
            for (int i = 0; i < oriCoords.length; ++i) {
                newCoords[i] = oriCoords[i];
            }
            newCoords[newCoords.length - 1] = oriCoords[0];
            GeometryFactory gf = new GeometryFactory(new PrecisionModel(), ls.getSRID());
            ls = gf.createLineString(newCoords);
        }
        return ls;
    }

    public SimpleFeatureType createNewFeatureType(SimpleFeatureType featureType, int attributeId, Class binding) {
        AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
        attributeTypeBuilder.setBinding(binding);
        attributeTypeBuilder.setCRS(featureType.getGeometryDescriptor().getCoordinateReferenceSystem());
        attributeTypeBuilder.setName(featureType.getGeometryDescriptor().getName().getLocalPart());
        attributeTypeBuilder.setNillable(featureType.getGeometryDescriptor().isNillable());
        attributeTypeBuilder.setLength(256);
        AttributeDescriptor attributeDescriptor = attributeTypeBuilder.buildDescriptor(featureType.getGeometryDescriptor().getName().getLocalPart());
        ArrayList<AttributeDescriptor> attributeDescriptors = new ArrayList<AttributeDescriptor>(featureType.getAttributeDescriptors());
        attributeDescriptors.set(attributeId, attributeDescriptor);
        SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
        featureTypeBuilder.init(featureType);
        featureTypeBuilder.setAttributes(attributeDescriptors);
        if (binding == Polygon.class) {
            featureTypeBuilder.setName(featureType.getName().getLocalPart() + "_v");
        } else if (binding == MultiPolygon.class) {
            featureTypeBuilder.setName(featureType.getName().getLocalPart() + "_mv");
        } else {
            featureTypeBuilder.setName(featureType.getName().getLocalPart() + POLYGONIZED);
        }
        return featureTypeBuilder.buildFeatureType();
    }

    public String getCqlFilterString() {
        return this.cqlFilterString;
    }

    public void setCqlFilterString(String cqlFilterString) {
        this.cqlFilterString = cqlFilterString;
    }

    public void setAttributeFeatureName(String attributeFeatureName) {
        this.attributeFeatureName = attributeFeatureName;
    }

    public String getAttributeFeatureName() {
        return this.attributeFeatureName;
    }

    public String getLineFeatureName() {
        return this.lineFeatureName;
    }

    public void setLineFeatureName(String lineFeatureName) {
        this.lineFeatureName = lineFeatureName;
    }

    public void setDataStore2Write(DataStore dataStore2Write) {
        this.dataStore2Write = dataStore2Write;
    }

    public DataStore getDataStore2Write() {
        return this.dataStore2Write;
    }

    public Boolean isPositivePolygon(Polygon polygon, ArrayList<SimpleFeature> correctLineFeatures, SimpleFeature feature) {
        return true;
    }

    public void setLineCloseTolerance(int lineCloseTolerance) {
        this.lineCloseTolerance = lineCloseTolerance;
    }

    public double getLineCloseTolerance() {
        return this.lineCloseTolerance;
    }

    public static void main(String[] args) throws Exception {
        CollectionAction_PolygonizeWithAttr.testMerge2();
    }

    public static void testMerge2() throws IOException, CQLException, Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("host", "localhost");
        params.put("schema", "public");
        params.put("database", "uploadDL");
        params.put("dbtype", "postgis");
        params.put("user", "xxxx");
        params.put("port", "5432");
        params.put("passwd", "xxxx");
        params.put("polygonizeWithAttr_lineFeatureName", "bla");
        params.put("polygonizeWithAttr_attributeFeatureName", "bla");
        String cqlFilter = "(gemeentecode_perceel_links = 'AHM01' AND sectie_perceel_links = 'N' AND perceelnummer_perceel_links = '7508' AND indexnummer_perceel_links ='0000') OR (gemeentecode_perceel_rechts = 'AHM01' AND sectie_perceel_rechts = 'N' AND perceelnummer_perceel_rechts ='7508' AND indexnummer_perceel_rechts ='0000')";
        String featureType = "arnhem_new_l";
        DataStore ds = DataStoreFinder.getDataStore(params);
        CollectionAction_PolygonizeSufLki polygonizer = new CollectionAction_PolygonizeSufLki(ds, params);
        SimpleFeatureSource fs = ds.getFeatureSource(featureType);
        FeatureCollection fc = fs.getFeatures(CQL.toFilter((String)cqlFilter));
        ArrayList<SimpleFeature> correctLineFeatures = polygonizer.filterInvalidLines(fc.features());
        ArrayList<Polygon> polygons = polygonizer.createPolygonWithLines(correctLineFeatures);
        System.out.println("polygons found: " + polygons.size());
    }

    @Override
    public void execute(FeatureCollection collection, Action writer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

