/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker;

import java.util.ArrayList;
import java.util.Map;
import nl.b3p.geotools.data.linker.DataStoreLinker;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.blocks.ActionCombo;
import nl.b3p.geotools.data.linker.blocks.ActionCondition;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ActionList
extends ArrayList<Action> {
    protected static final Log log = LogFactory.getLog(DataStoreLinker.class);

    public EasyFeature process(EasyFeature feature) throws Exception {
        for (Action action : this) {
            feature = action.execute(feature);
            if (feature != null) continue;
            return null;
        }
        return feature;
    }

    public void flush(Status status, Map properties) throws Exception {
        for (Action action : this) {
            action.flush(status, properties);
        }
    }

    public void close() throws Exception {
        for (Action action : this) {
            action.close();
        }
    }

    public void print() {
        log.info((Object)("\n" + this.toString()));
    }

    @Override
    public String toString() {
        String result = "";
        for (Action action : this) {
            result = result + action.toString() + "\n";
        }
        return result;
    }

    @Override
    public boolean add(Action action) {
        if (action != null) {
            return super.add(action);
        }
        return false;
    }

    @Override
    public void add(int index, Action action) {
        if (action != null) {
            super.add(index, action);
        }
    }

    public String getDescription() {
        String result = "\n";
        for (Action action : this) {
            result = result + action.getName() + ":\n";
            if (action instanceof ActionCondition) {
                ActionCondition condition = (ActionCondition)action;
                result = result + action.getDescription_NL() + "\n";
                result = result + "IF TRUE\n";
                result = result + condition.getActionList(true).getDescription();
                result = result + "ELSE\n";
                result = result + condition.getActionList(false).getDescription();
                result = result + "END IF\n";
                continue;
            }
            if (action instanceof ActionCombo) {
                ActionCombo combo = (ActionCombo)action;
                result = result + combo.getActionList().getDescription();
                continue;
            }
            result = result + action.getDescription_NL() + "\n - " + action.toString() + "\n\n";
        }
        return result;
    }

    public void processPostCollectionActions(Status status, Map properties) throws Exception {
        for (Action action : this) {
            action.processPostCollectionActions(status, properties);
        }
    }
}

