/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.DataStoreLinker;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.blocks.ActionCombo;
import nl.b3p.geotools.data.linker.blocks.ActionCondition;
import nl.b3p.geotools.data.linker.blocks.ActionCondition_FeatureType_Typename_Length;
import nl.b3p.geotools.data.linker.blocks.ActionFeatureType_AttributeName_Case;
import nl.b3p.geotools.data.linker.blocks.ActionFeatureType_Typename_Case;
import nl.b3p.geotools.data.linker.blocks.ActionFeatureType_Typename_Substring;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.jdbc.JDBCDataStore;

public class ActionCombo_Fix_To_Oracle
extends ActionCombo {
    protected static final int ORACLE_MAX_TABLE_NAME_LENGTH_VANILLA = 30;
    protected static final int ORACLE_SPATIAL_MAX_LENGTH_SUFFIX = "_MV_THE_GEOM_IDX".length();
    protected static final int ORACLE_MAX_TABLE_NAME_LENGTH = 30 - ORACLE_SPATIAL_MAX_LENGTH_SUFFIX;
    private Integer minx = null;
    private Integer miny = null;
    private Integer maxx = null;
    private Integer maxy = null;
    private String precision = null;

    public ActionCombo_Fix_To_Oracle(Integer minx, Integer miny, Integer maxx, Integer maxy, String precision) {
        this.minx = minx;
        this.miny = miny;
        this.maxx = maxx;
        this.maxy = maxy;
        this.precision = precision;
        ActionFeatureType_Typename_Case actionTypenameCase = new ActionFeatureType_Typename_Case(true);
        this.actionList.add(actionTypenameCase);
        ActionCondition_FeatureType_Typename_Length actionTypenameLength = new ActionCondition_FeatureType_Typename_Length(ActionCondition.CompareType.GREATER, ORACLE_MAX_TABLE_NAME_LENGTH);
        this.actionList.add(actionTypenameLength);
        ActionFeatureType_Typename_Substring actionTypenameSubstring = new ActionFeatureType_Typename_Substring(ORACLE_MAX_TABLE_NAME_LENGTH, true);
        actionTypenameLength.addActionToList(true, actionTypenameSubstring);
    }

    public static List<List<String>> getConstructors() {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        constructors.add(Arrays.asList("metadata_bbox_minx", "metadata_bbox_miny", "metadata_bbox_maxx", "metadata_bbox_maxy", "metadata_precision"));
        return constructors;
    }

    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        for (int i = 0; i < feature.getAttributeCount(); ++i) {
            ActionFeatureType_AttributeName_Case action = new ActionFeatureType_AttributeName_Case(i, true);
            ((Action)action).execute(feature);
        }
        return feature;
    }

    @Override
    public String getDescription_NL() {
        return "In deze ActionCombo wordt de typename zo aangepast dat deze gebruikt kan worden als Oracle tabelnaam. Dit betekend dat de typenaam omgezet wordt naar hoofdlettes en dat de lengte word aangepast aan de maximale lengte " + ORACLE_MAX_TABLE_NAME_LENGTH + " (neem laatste deel van de typenaam)";
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPostCollectionActions(Status status, Map properties) throws Exception {
        Map params = (Map)properties.get("params");
        DataStore ds = DataStoreLinker.openDataStore(params, false);
        if (ds instanceof JDBCDataStore) {
            JDBCDataStore jdbcDS = (JDBCDataStore)ds;
            DefaultTransaction t = new DefaultTransaction();
            try {
                String tableName = (String)properties.get("newFeatureTypeName");
                String geomColumnName = jdbcDS.getFeatureSource(tableName).getSchema().getGeometryDescriptor().getLocalName();
                String sql = "update USER_SDO_GEOM_METADATA set diminfo = MDSYS.SDO_DIM_ARRAY(\n";
                sql = sql + "   MDSYS.SDO_DIM_ELEMENT('X', " + this.minx + ", " + this.maxx + ", " + this.precision + "),";
                sql = sql + "   MDSYS.SDO_DIM_ELEMENT('Y', " + this.miny + ", " + this.maxy + ", " + this.precision + "))";
                sql = sql + "   where column_name = '" + geomColumnName + "' and table_name = '" + tableName + "'";
                Connection connection = jdbcDS.getConnection((Transaction)t);
                PreparedStatement statement = connection.prepareStatement(sql);
                statement.executeUpdate();
                t.commit();
            }
            catch (Exception ex) {
                log.error((Object)"Error while creating index: ", (Throwable)ex);
                t.rollback();
            }
            finally {
                try {
                    t.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing connection-transaction", (Throwable)e);
                }
            }
        }
    }
}

