/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import org.geotools.feature.AttributeTypeBuilder;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;

public class ActionFeatureType_AttributeNames_Map_To_Output
extends Action {
    private String[] outputAttributeNames;
    private String[] inputAttributeNames;
    private List<String> allOutputColumns;
    protected String description = "Kies per uitvoerkolom een invoerkolom.";

    public ActionFeatureType_AttributeNames_Map_To_Output(String[] outputAttributeNames, String[] inputAttributeNames, List<String> outputColumns) {
        this.outputAttributeNames = outputAttributeNames;
        this.inputAttributeNames = inputAttributeNames;
        if (outputColumns != null && outputColumns.size() > 0) {
            this.allOutputColumns = outputColumns;
        }
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
    }

    @Override
    public void processPostCollectionActions(Status status, Map properties) throws Exception {
    }

    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        if (this.allOutputColumns == null || this.allOutputColumns.size() == 0) {
            return feature;
        }
        HashMap<String, AttributeSummary> inputAttributes = new HashMap<String, AttributeSummary>();
        for (int i = 0; i < this.inputAttributeNames.length; ++i) {
            int inputColumnId = this.getAttributeId(feature, this.inputAttributeNames[i]);
            if (inputColumnId == -1) {
                throw new Exception("Ongeldige kolomnaam in mapping!");
            }
            AttributeDescriptor inputAd = feature.getFeatureType().getDescriptor(inputColumnId);
            AttributeType at = inputAd.getType();
            inputAttributes.put(this.inputAttributeNames[i], new AttributeSummary(this.inputAttributeNames[i], feature.getAttribute(inputColumnId), at.getBinding()));
        }
        feature.removeAllAttributeDescriptors(true);
        String geometryName = null;
        GeometryAttribute ga = feature.getFeature().getDefaultGeometryProperty();
        if (ga != null) {
            geometryName = ga.getDescriptor().getLocalName();
        }
        for (String outputColumnName : this.allOutputColumns) {
            String inputColumnName = null;
            for (int i = 0; i < this.outputAttributeNames.length; ++i) {
                if (!this.outputAttributeNames[i].equals(outputColumnName)) continue;
                inputColumnName = this.inputAttributeNames[i];
                break;
            }
            Class binding = String.class;
            Object value = null;
            String name = outputColumnName;
            if (inputColumnName != null) {
                AttributeSummary as = (AttributeSummary)inputAttributes.get(inputColumnName);
                binding = as.binding;
                value = as.value;
            }
            if (inputColumnName != null && inputColumnName.equalsIgnoreCase(geometryName)) {
                int geometryID = -1;
                List attributeDescriptors = feature.getFeatureType().getAttributeDescriptors();
                for (int i = 0; i < attributeDescriptors.size(); ++i) {
                    if (!((AttributeDescriptor)attributeDescriptors.get(i)).getLocalName().equalsIgnoreCase(geometryName)) continue;
                    geometryID = i;
                    break;
                }
                AttributeTypeBuilder atb = new AttributeTypeBuilder();
                atb.init(feature.getFeatureType().getDescriptor(geometryID));
                feature.setAttributeDescriptor(geometryID, atb.buildDescriptor(name), true);
                continue;
            }
            feature.addAttributeDescriptor(name, binding);
            Integer newColumnId = this.getAttributeId(feature, name);
            feature.setAttribute(newColumnId, value);
        }
        return feature;
    }

    @Override
    public String toString() {
        return "Kies per uitvoerkolom een invoerkolom.";
    }

    public static List<List<String>> getConstructors(String[] invoer) {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        if (invoer != null) {
            constructors.add(Arrays.asList(invoer));
        }
        return constructors;
    }

    @Override
    public String getDescription_NL() {
        return this.description;
    }

    protected class AttributeSummary {
        Class binding;
        Object value;
        String name;

        AttributeSummary(String name, Object value, Class binding) {
            this.binding = binding;
            this.value = value;
            this.name = name;
        }
    }
}

