/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.FeatureException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class EasyFeature {
    private static final Log log = LogFactory.getLog(EasyFeature.class);
    private SimpleFeature feature;
    private boolean skipped = false;

    public EasyFeature(SimpleFeature feature) {
        this.feature = feature;
    }

    public SimpleFeature getFeature() {
        return this.feature;
    }

    public AttributeType getAttributeType(int attributeID) {
        return this.feature.getFeatureType().getType(attributeID);
    }

    public AttributeType getAttributeType(String name) {
        return this.feature.getFeatureType().getType(name);
    }

    public void insertAttributeDescriptor(int attributeID, String name, Class binding) {
        AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
        attributeTypeBuilder.setName(name);
        attributeTypeBuilder.setBinding(binding);
        this.insertAttributeDescriptor(attributeID, attributeTypeBuilder.buildDescriptor(name));
    }

    public void insertAttributeDescriptor(int attributeID, AttributeDescriptor attributeDescriptor) {
        Map ud = this.feature.getUserData();
        ArrayList<AttributeDescriptor> attributeDescriptors = new ArrayList<AttributeDescriptor>(this.feature.getFeatureType().getAttributeDescriptors());
        attributeDescriptors.add(attributeID, attributeDescriptor);
        SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
        featureTypeBuilder.init(this.feature.getFeatureType());
        featureTypeBuilder.setAttributes(attributeDescriptors);
        SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(featureTypeBuilder.buildFeatureType());
        List attributes = this.feature.getAttributes();
        attributes.add(attributeID, null);
        this.feature = simpleFeatureBuilder.buildFeature(this.getID(), attributes.toArray(new Object[attributes.size()]));
        this.feature.getUserData().putAll(ud);
    }

    public void addAttributeDescriptor(AttributeDescriptor attributeDescriptor) {
        this.insertAttributeDescriptor(this.feature.getAttributeCount(), attributeDescriptor);
    }

    public void addAttributeDescriptor(String name, Class binding) {
        this.insertAttributeDescriptor(this.feature.getAttributeCount(), name, binding);
    }

    public void removeAllAttributeDescriptors(boolean keepGeom) throws Exception {
        Map ud = this.feature.getUserData();
        String geometryName = null;
        Integer geometryID = null;
        GeometryAttribute ga = null;
        AttributeDescriptor gad = null;
        if (keepGeom && (ga = this.feature.getDefaultGeometryProperty()) != null) {
            geometryName = ga.getDescriptor().getLocalName();
            geometryID = this.getAttributeDescriptorIDbyName(geometryName);
        }
        SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
        featureTypeBuilder.init(this.feature.getFeatureType());
        ArrayList<AttributeDescriptor> attributeDescriptors = new ArrayList<AttributeDescriptor>(this.feature.getFeatureType().getAttributeDescriptors());
        if (geometryID != null) {
            gad = (AttributeDescriptor)attributeDescriptors.get(geometryID);
        }
        attributeDescriptors = new ArrayList();
        if (keepGeom && gad != null) {
            attributeDescriptors.add(gad);
        }
        featureTypeBuilder.setAttributes(attributeDescriptors);
        SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(featureTypeBuilder.buildFeatureType());
        List attributes = this.feature.getAttributes();
        Object[] values = null;
        if (keepGeom && gad != null) {
            Object value = null;
            if (geometryID != null) {
                value = attributes.get(geometryID);
            }
            values = new Object[]{value};
        }
        this.feature = values == null ? simpleFeatureBuilder.buildFeature(this.getID()) : simpleFeatureBuilder.buildFeature(this.getID(), values);
        this.feature.getUserData().putAll(ud);
    }

    public void removeAttributeDescriptor(int attributeID) throws Exception {
        Map ud = this.feature.getUserData();
        SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
        featureTypeBuilder.init(this.feature.getFeatureType());
        ArrayList attributeDescriptors = new ArrayList(this.feature.getFeatureType().getAttributeDescriptors());
        attributeDescriptors.remove(attributeID);
        featureTypeBuilder.setAttributes(attributeDescriptors);
        SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(featureTypeBuilder.buildFeatureType());
        List attributes = this.feature.getAttributes();
        attributes.remove(attributeID);
        this.feature = simpleFeatureBuilder.buildFeature(this.getID(), attributes.toArray(new Object[attributes.size()]));
        this.feature.getUserData().putAll(ud);
    }

    public void removeAttributeDescriptor(String name) throws Exception {
        this.removeAttributeDescriptor(this.getAttributeDescriptorIDbyName(name));
    }

    public void setAttributeDescriptor(int attributeID, String name, Class binding, boolean keepValue) {
        AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
        attributeTypeBuilder.setName(name);
        attributeTypeBuilder.setBinding(binding);
        this.setAttributeDescriptor(attributeID, attributeTypeBuilder.buildDescriptor(name), keepValue);
    }

    public void setAttributeDescriptor(int attributeID, AttributeDescriptor attributeDescriptor, boolean keepValue) {
        Map ud = this.feature.getUserData();
        ArrayList<AttributeDescriptor> attributeDescriptors = new ArrayList<AttributeDescriptor>(this.feature.getFeatureType().getAttributeDescriptors());
        attributeDescriptors.set(attributeID, attributeDescriptor);
        SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
        featureTypeBuilder.init(this.feature.getFeatureType());
        featureTypeBuilder.setAttributes(attributeDescriptors);
        SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(featureTypeBuilder.buildFeatureType());
        List attributes = this.feature.getAttributes();
        if (!keepValue) {
            attributes.set(attributeID, null);
        }
        this.feature = simpleFeatureBuilder.buildFeature(this.getID(), attributes.toArray(new Object[attributes.size()]));
        this.feature.getUserData().putAll(ud);
    }

    public void setAttributeDescriptor(String attributeName, AttributeDescriptor attributeDescriptor) throws Exception {
        if (this.containsAttributeDescriptor(attributeName)) {
            int attributeID = this.getAttributeDescriptorIDbyName(attributeName);
            this.setAttributeDescriptor(attributeID, attributeDescriptor, true);
        } else {
            this.addAttributeDescriptor(attributeDescriptor);
        }
    }

    public int getAttributeDescriptorIDbyName(String name) throws FeatureException {
        List attributeDescriptors = this.feature.getFeatureType().getAttributeDescriptors();
        for (int i = 0; i < attributeDescriptors.size(); ++i) {
            if (!((AttributeDescriptor)attributeDescriptors.get(i)).getLocalName().equalsIgnoreCase(name)) continue;
            return i;
        }
        return -1;
    }

    public String getAttributeDescriptorNameByID(int attributeID) throws Exception {
        if (attributeID < 0 || attributeID >= this.getAttributeCount()) {
            throw new Exception("AttributeType attributeID " + attributeID + " not allowed");
        }
        return ((AttributeDescriptor)this.feature.getFeatureType().getAttributeDescriptors().get(attributeID)).getLocalName();
    }

    public int getAttributeCount() {
        return this.feature.getAttributeCount();
    }

    public void setAttribute(int attributeID, Object attribute) {
        this.feature.setAttribute(attributeID, attribute);
    }

    public void setAttribute(String name, Object attribute) {
        this.feature.setAttribute(name, attribute);
    }

    public Object getAttribute(int attributeID) {
        return this.feature.getAttribute(attributeID);
    }

    public Object getAttribute(String name) {
        return this.feature.getAttribute(name);
    }

    public List<Object> getAttributes() {
        return this.feature.getAttributes();
    }

    public String toString() {
        String attributes = "";
        for (AttributeType attribute : this.feature.getFeatureType().getTypes()) {
            attributes = attributes + ", " + attribute.getName().toString();
        }
        attributes = attributes.length() > 2 ? attributes.substring(2) : "[empty]";
        return "Feature(" + attributes + ")";
    }

    public String getTypeName() {
        return this.feature.getFeatureType().getTypeName();
    }

    public void setTypeName(String name) {
        Map ud = this.feature.getUserData();
        SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
        featureTypeBuilder.addAll(this.feature.getFeatureType().getAttributeDescriptors());
        featureTypeBuilder.setName(name);
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureTypeBuilder.buildFeatureType());
        this.feature = featureBuilder.buildFeature(this.feature.getID(), this.feature.getAttributes().toArray(new Object[this.feature.getAttributeCount()]));
        this.feature.getUserData().putAll(ud);
    }

    public EasyFeature copy() {
        return this.copy(null, null);
    }

    public EasyFeature copy(String ID) {
        return this.copy(null, ID);
    }

    public EasyFeature copy(String name, String ID) {
        SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
        if (name == null) {
            name = this.feature.getFeatureType().getTypeName();
        }
        if (ID == null) {
            ID = this.feature.getID();
        }
        featureTypeBuilder.setName(name);
        ArrayList attributeDescriptors = new ArrayList(this.feature.getFeatureType().getAttributeDescriptors());
        featureTypeBuilder.setAttributes(attributeDescriptors);
        SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(featureTypeBuilder.buildFeatureType());
        List attributes = this.feature.getAttributes();
        SimpleFeature f = simpleFeatureBuilder.buildFeature(ID, attributes.toArray(new Object[attributes.size()]));
        f.getUserData().putAll(this.feature.getUserData());
        return new EasyFeature(f);
    }

    public String getID() {
        return this.feature.getID();
    }

    public SimpleFeatureType getFeatureType() {
        return this.feature.getFeatureType();
    }

    public boolean containsAttributeDescriptor(int attributeID) {
        return attributeID >= 0 && attributeID < this.getAttributeCount();
    }

    public boolean containsAttributeDescriptor(String attributeName) {
        for (AttributeDescriptor descriptor : this.feature.getFeatureType().getAttributeDescriptors()) {
            if (!descriptor.getName().getLocalPart().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    public static AttributeDescriptor buildGeometryAttributeDescriptor(String attributeName, Class binding, boolean isNillable, CoordinateReferenceSystem crs) {
        AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
        attributeTypeBuilder.setBinding(binding);
        attributeTypeBuilder.setCRS(crs);
        attributeTypeBuilder.setName(attributeName);
        attributeTypeBuilder.setNillable(isNillable);
        attributeTypeBuilder.setLength(256);
        return attributeTypeBuilder.buildDescriptor(attributeName);
    }

    public void setCRS(CoordinateReferenceSystem crs) throws Exception {
        GeometryAttribute ga = this.feature.getDefaultGeometryProperty();
        if (ga == null) {
            return;
        }
        String geometryName = ga.getDescriptor().getLocalName();
        boolean isNillable = this.feature.getFeatureType().getGeometryDescriptor().isNillable();
        Class binding = this.feature.getFeatureType().getGeometryDescriptor().getType().getBinding();
        int attributeID = this.getAttributeDescriptorIDbyName(geometryName);
        this.setAttributeDescriptor(attributeID, EasyFeature.buildGeometryAttributeDescriptor(geometryName, binding, isNillable, crs), true);
    }

    public void repairGeometry() throws FeatureException {
        SimpleFeatureType ft;
        Class typeBinding;
        Class<?> binding = this.feature.getDefaultGeometry().getClass();
        if (!binding.equals(typeBinding = (ft = this.feature.getFeatureType()).getGeometryDescriptor().getType().getBinding())) {
            log.debug((Object)("feature binding: " + binding.toString() + " for feature: " + this.feature.getID()));
            log.debug((Object)("feature type binding: " + typeBinding.toString() + " for feature type: " + ft.getName().getLocalPart()));
            GeometryAttribute ga = this.feature.getDefaultGeometryProperty();
            CoordinateReferenceSystem crs = ga.getDescriptor().getCoordinateReferenceSystem();
            String geometryName = ga.getDescriptor().getLocalName();
            boolean isNillable = this.feature.getFeatureType().getGeometryDescriptor().isNillable();
            int attributeID = this.getAttributeDescriptorIDbyName(geometryName);
            this.setAttributeDescriptor(attributeID, EasyFeature.buildGeometryAttributeDescriptor(geometryName, binding, isNillable, crs), true);
        }
    }

    public void convertGeomTo2D() {
        if (this.feature != null && this.feature.getDefaultGeometry() != null) {
            Geometry g = (Geometry)this.feature.getDefaultGeometry();
            Coordinate[] cs = g.getCoordinates();
            boolean hasZCoord = false;
            for (int t = 0; t < cs.length; ++t) {
                if (Double.isNaN(cs[t].z)) continue;
                hasZCoord = true;
            }
            if (hasZCoord) {
                WKBWriter writer = new WKBWriter(2);
                WKBReader reader = new WKBReader();
                Geometry geom2D = null;
                byte[] binary = writer.write(g);
                try {
                    geom2D = reader.read(binary);
                }
                catch (ParseException parsEx) {
                    log.error((Object)"Error reading wkb", (Throwable)parsEx);
                }
                this.feature.setDefaultGeometry((Object)geom2D);
            }
        }
    }

    public boolean isSkipped() {
        return this.skipped;
    }

    public void setSkipped(boolean skipped) {
        this.skipped = skipped;
    }
}

