/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker;

import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import nl.b3p.datastorelinker.entity.Process;
import nl.b3p.geotools.data.linker.DataStoreLinker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataStoreLinkerMail {
    private static final Log log = LogFactory.getLog(DataStoreLinkerMail.class);

    public static void mail(Properties batch, String message) throws Exception {
        String smtpServer = DataStoreLinker.getSaveProp(batch, "log.mail.smtp.host", "");
        String from = DataStoreLinker.getSaveProp(batch, "log.mail.from", "ETL DataStoreLinker Logger <noreply@b3partners.nl>");
        String to = DataStoreLinker.getSaveProp(batch, "log.mail.to", "");
        String subject = DataStoreLinker.getSaveProp(batch, "log.mail.subject", "Fout tijdens ETL proces");
        DataStoreLinkerMail.mail(smtpServer, to, from, subject, message);
    }

    public static void mail(Properties batch, String subject, String message) throws Exception {
        String smtpServer = DataStoreLinker.getSaveProp(batch, "log.mail.smtp.host", "");
        String from = DataStoreLinker.getSaveProp(batch, "log.mail.from", "ETL DataStoreLinker Logger <noreply@b3partners.nl>");
        String to = DataStoreLinker.getSaveProp(batch, "log.mail.to", "");
        DataStoreLinkerMail.mail(smtpServer, to, from, subject, message);
    }

    public static void mail(Process process, String message) throws Exception {
        DataStoreLinkerMail.mail(process, message, process.getMail().getSubject() + ": \"" + process.getName() + "\"");
    }

    public static void mail(Process process, String message, String subject) throws Exception {
        String smtpServer = process.getMail().getSmtpHost();
        String from = process.getMail().getFromEmailAddress();
        String to = process.getMail().getToEmailAddress();
        DataStoreLinkerMail.mail(smtpServer, to, from, subject, message);
    }

    private static void mail(String smtpServer, String to, String from, String subject, String body) throws Exception {
        log.debug((Object)"Sending process complete mail.");
        if ((from == null || from.isEmpty()) && DataStoreLinker.DEFAULT_FROM != null && !DataStoreLinker.DEFAULT_FROM.isEmpty()) {
            from = DataStoreLinker.DEFAULT_FROM;
        }
        if ((smtpServer == null || smtpServer.isEmpty()) && DataStoreLinker.DEFAULT_SMTPHOST != null && !DataStoreLinker.DEFAULT_SMTPHOST.isEmpty()) {
            smtpServer = DataStoreLinker.DEFAULT_SMTPHOST;
        }
        if (smtpServer == null || smtpServer.isEmpty()) {
            throw new Exception("no smtp server!");
        }
        if (body == null || body.isEmpty()) {
            throw new Exception("nothing to send!");
        }
        Properties props = System.getProperties();
        props.put("mail.smtp.host", smtpServer);
        Session session = Session.getDefaultInstance((Properties)props, null);
        session.setDebug(log.isDebugEnabled());
        MimeMessage msg = new MimeMessage(session);
        msg.setFrom((Address)new InternetAddress(from));
        msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to, (boolean)false));
        msg.setSubject(subject);
        msg.setText(body);
        msg.setHeader("X-Mailer", "B3Partners");
        msg.setSentDate(new Date());
        Transport.send((Message)msg);
    }
}

