/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import nl.b3p.datastorelinker.entity.Process;
import nl.b3p.geotools.data.linker.ActionFactory;
import nl.b3p.geotools.data.linker.util.LocalizationUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Status {
    public static final String FEATURES_START = "read.features.start";
    public static final String FEATURES_END = "read.features.end";
    private static final ResourceBundle resources = LocalizationUtil.getResources();
    private String errorReport = "";
    private int nonFatalErrorCount = 0;
    private int writeErrorCount = 0;
    private int visitedFeatures = 0;
    private int processedFeatures = 0;
    private int featureStart = 0;
    private int featureEnd = -1;
    private int totalFeatureSize = 0;
    private boolean interrupted = false;
    private Map<String, List<String>> nonFatalErrorMap = null;
    private Map<String, List<String>> writeErrorMap = null;
    private static final Log log = LogFactory.getLog(Status.class);
    private static final String DEFAULT_NEW_LINE = "\n";
    private static final int DEFAULT_MAX_FEATURE_NUMBER_PER_EXCEPTION = 3;
    private static final int DEFAULT_MAX_EXCEPTIONS = 30;
    private static final String MESSAGE_KEY_MULTIPLE_ERRORS = "Meer fouten gevonden, maar niet getoond.";
    protected Properties batch;
    protected Process process;
    private String processName = null;

    public Status(Properties batch) {
        if (batch.containsKey(FEATURES_START)) {
            this.featureStart = ActionFactory.toInteger(batch.getProperty(FEATURES_START));
        }
        if (batch.containsKey(FEATURES_END)) {
            this.featureEnd = ActionFactory.toInteger(batch.getProperty(FEATURES_END));
        }
        this.init();
    }

    public Status(Process process) {
        if (process.getFeaturesStart() != null) {
            this.featureStart = process.getFeaturesStart();
        }
        if (process.getFeaturesEnd() != null) {
            this.featureEnd = process.getFeaturesEnd();
        }
        this.init();
        this.processName = process.getName();
    }

    private void init() {
        this.nonFatalErrorMap = new HashMap<String, List<String>>();
        this.writeErrorMap = new HashMap<String, List<String>>();
    }

    public synchronized void addNonFatalError(String errorString, String featureKey) {
        this.incrementNonFatalErrorCount();
        if (this.nonFatalErrorMap.size() <= 30) {
            if (!this.nonFatalErrorMap.containsKey(errorString)) {
                this.nonFatalErrorMap.put(errorString, new ArrayList());
            }
            this.nonFatalErrorMap.get(errorString).add(featureKey);
        }
    }

    public synchronized Map<String, List<String>> getNonFatalErrors() {
        return this.nonFatalErrorMap;
    }

    public synchronized void addWriteError(String errorString, String featureKey) {
        this.incrementWriteErrorCount();
        if (this.writeErrorMap.size() <= 30) {
            if (!this.writeErrorMap.containsKey(errorString)) {
                this.writeErrorMap.put(errorString, new ArrayList());
            }
            this.writeErrorMap.get(errorString).add(featureKey);
        }
    }

    public synchronized Map<String, List<String>> getWriteErrorMap() {
        return this.writeErrorMap;
    }

    public synchronized String getNonFatalErrorReport(String newLineString, int maxFeatureNumbersPerException) {
        int i;
        if (newLineString == null) {
            newLineString = DEFAULT_NEW_LINE;
        }
        if (maxFeatureNumbersPerException < 1) {
            maxFeatureNumbersPerException = 3;
        }
        StringBuilder sb = new StringBuilder();
        if (this.processName != null) {
            sb.append(MessageFormat.format(resources.getString("report.processFinished"), this.processName));
            sb.append(newLineString);
            sb.append(newLineString);
        }
        sb.append(this.getFinishedMessage());
        sb.append(newLineString);
        for (Map.Entry<String, List<String>> entry : this.nonFatalErrorMap.entrySet()) {
            sb.append(entry.getKey());
            sb.append(newLineString);
            sb.append(resources.getString("report.errorAppliesTo"));
            i = 0;
            for (String featureKey : entry.getValue()) {
                if (maxFeatureNumbersPerException > 0 && i >= maxFeatureNumbersPerException) {
                    sb.delete(sb.length() - 1, sb.length());
                    sb.append(" ");
                    sb.append(resources.getString("report.and"));
                    sb.append(" ");
                    sb.append(entry.getValue().size() - i);
                    sb.append(" ");
                    sb.append(resources.getString("report.others"));
                    sb.append(".");
                    break;
                }
                sb.append(" ");
                sb.append(featureKey);
                sb.append(",");
                ++i;
            }
            if (entry.getValue().size() > 0 && i <= maxFeatureNumbersPerException - 1) {
                sb.delete(sb.length() - 1, sb.length());
            }
            sb.append(newLineString);
        }
        sb.append(newLineString);
        for (Map.Entry<String, List<String>> entry : this.writeErrorMap.entrySet()) {
            sb.append(entry.getKey());
            sb.append(newLineString);
            sb.append(resources.getString("report.errorAppliesTo"));
            i = 0;
            for (String featureKey : entry.getValue()) {
                if (maxFeatureNumbersPerException > 0 && i >= maxFeatureNumbersPerException) {
                    sb.delete(sb.length() - 1, sb.length());
                    sb.append(" ");
                    sb.append(resources.getString("report.and"));
                    sb.append(" ");
                    sb.append(entry.getValue().size() - i);
                    sb.append(" ");
                    sb.append(resources.getString("report.others"));
                    sb.append(".");
                    break;
                }
                sb.append(" ");
                sb.append(featureKey);
                sb.append(",");
                ++i;
            }
            if (entry.getValue().size() > 0 && i <= maxFeatureNumbersPerException - 1) {
                sb.delete(sb.length() - 1, sb.length());
            }
            sb.append(newLineString);
        }
        return sb.toString();
    }

    @Deprecated
    public synchronized String getTruncatedErrorReport() {
        return this.errorReport.length() > 500 ? this.errorReport.substring(0, 500) + "... (see log)" : this.errorReport;
    }

    public synchronized String getErrorReport() {
        return this.errorReport;
    }

    public synchronized void setErrorReport(String errorReport) {
        this.errorReport = errorReport;
    }

    public synchronized int getNonFatalErrorCount() {
        return this.nonFatalErrorCount;
    }

    public synchronized void setNonFatalErrorCount(int nonFatalErrorCount) {
        this.nonFatalErrorCount = nonFatalErrorCount;
    }

    public synchronized void incrementNonFatalErrorCount() {
        ++this.nonFatalErrorCount;
    }

    public synchronized int getWriteErrorCount() {
        return this.writeErrorCount;
    }

    public synchronized void setWriteErrorCount(int writeErrorCount) {
        this.writeErrorCount = writeErrorCount;
    }

    public synchronized void incrementWriteErrorCount() {
        ++this.writeErrorCount;
    }

    public synchronized int getErrorCount() {
        return this.writeErrorCount + this.nonFatalErrorCount;
    }

    private String getFinishedMessage() {
        if (this.getProcessedFeatures() == 0 && this.getErrorCount() == 0) {
            return resources.getString("report.nothingProcessed");
        }
        if (this.getProcessedFeatures() == this.getVisitedFeatures() && this.getErrorCount() == 0) {
            return MessageFormat.format(resources.getString("report.allProcessed"), this.getProcessedFeatures());
        }
        return MessageFormat.format(resources.getString("report.processedWithErrors"), this.getProcessedFeatures(), this.getVisitedFeatures());
    }

    public synchronized int getVisitedFeatures() {
        return this.visitedFeatures;
    }

    public synchronized void setVisitedFeatures(int visitedFeatures) {
        this.visitedFeatures = visitedFeatures;
    }

    public synchronized void incrementVisitedFeatures() {
        ++this.visitedFeatures;
    }

    public synchronized int getProcessedFeatures() {
        return this.processedFeatures;
    }

    public synchronized void setProcessedFeatures(int processedFeatures) {
        this.processedFeatures = processedFeatures;
    }

    public synchronized void incrementProcessedFeatures() {
        ++this.processedFeatures;
    }

    public synchronized int getFeatureStart() {
        return this.featureStart;
    }

    public synchronized void setFeatureStart(int featureStart) {
        this.featureStart = featureStart;
    }

    public synchronized int getFeatureEnd() {
        return this.featureEnd;
    }

    public synchronized void setFeatureEnd(int featureEnd) {
        this.featureEnd = featureEnd;
    }

    public synchronized int getTotalFeatureSize() {
        return this.totalFeatureSize;
    }

    public synchronized void setTotalFeatureSize(int totalFeatureSize) {
        this.totalFeatureSize = totalFeatureSize;
    }

    public synchronized void incrementTotalFeatureSize() {
        ++this.totalFeatureSize;
    }

    public synchronized boolean isInterrupted() {
        return this.interrupted;
    }

    public synchronized void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }
}

