/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import nl.b3p.geotools.data.linker.ActionFactory;
import nl.b3p.geotools.data.linker.DataStoreLinker;
import nl.b3p.geotools.data.linker.FeatureException;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.blocks.CollectionAction;
import nl.b3p.geotools.data.linker.blocks.CollectionAction_Intersects_XY_Add_Attrib;
import nl.b3p.geotools.data.linker.blocks.CollectionAction_Point_Within_Polygon;
import nl.b3p.geotools.data.linker.blocks.CollectionAction_Polygonize;
import nl.b3p.geotools.data.linker.blocks.CollectionAction_PolygonizeSufLki;
import nl.b3p.geotools.data.linker.blocks.CollectionAction_PolygonizeWithAttr;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.postgis.PostGISDialect;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.wfs.WFSDataStore;
import org.geotools.factory.Hints;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;

public class ActionDataStore_Writer
extends Action {
    private boolean initDone = false;
    private DataStore dataStore2Write = null;
    private Map params;
    private final boolean append;
    private final boolean dropFirst;
    private final boolean modify;
    private final boolean modifyGeom;
    private final String modifyFilter;
    private boolean postCollectionActionsInitDone = false;
    private boolean polygonize = false;
    private boolean polygonizeWithAttr = false;
    private boolean polygonizeSufLki = false;
    private boolean postPointWithinPolygon = false;
    private Exception constructorEx;
    private List<String> datastoreTypeNames = new ArrayList<String>();
    private Map<String, FeatureStore> featureStores = new HashMap<String, FeatureStore>();
    private Map<String, PrimaryKey> featurePKs = new HashMap<String, PrimaryKey>();
    private List<String> featureTypeNames = new ArrayList<String>();
    private Map<String, DefaultFeatureCollection> featureCollectionCache = new HashMap<String, DefaultFeatureCollection>();
    private Map<String, Integer> featureBatchSizes = new HashMap<String, Integer>();
    private Map<String, Integer> featuresWritten = new HashMap<String, Integer>();
    private Map<String, List<List<String>>> featureErrors = new HashMap<String, List<List<String>>>();
    private Map<String, List<List<String>>> featureNonFatals = new HashMap<String, List<List<String>>>();
    private static final int MAX_CONNECTIONS_NR = 50;
    private static final String MAX_CONNECTIONS = "max connections";
    private static final int BATCHSIZE = 50;
    private static final int MAX_BATCHSIZE = 5000;
    private static final int INCREASEFACTOR = 2;
    private static final int DECREASEFACTOR = 10;
    private ArrayList<CollectionAction> collectionActions = new ArrayList();
    private Random generator = new Random(new Date().getTime());

    public ActionDataStore_Writer(Map params, Map properties) {
        this.params = params;
        log.debug((Object)params);
        this.append = ActionFactory.propertyCheck(properties, "append") ? (Boolean)properties.get("append") : true;
        this.dropFirst = ActionFactory.propertyCheck(properties, "drop") ? (Boolean)properties.get("drop") : false;
        this.modify = ActionFactory.propertyCheck(properties, "modify") ? (Boolean)properties.get("modify") : false;
        this.modifyGeom = ActionFactory.propertyCheck(properties, "modifyGeom") ? (Boolean)properties.get("modifyGeom") : false;
        this.modifyFilter = ActionFactory.propertyCheck(properties, "modifyFilter") ? (String)properties.get("modifyFilter") : null;
        if (!params.containsKey(MAX_CONNECTIONS)) {
            params.put(MAX_CONNECTIONS, 50);
        }
        try {
            this.dataStore2Write = DataStoreLinker.openDataStore(params);
            if (this.dataStore2Write != null) {
                this.datastoreTypeNames = Arrays.asList(this.dataStore2Write.getTypeNames());
                this.initDone = true;
            }
        }
        catch (Exception ex) {
            this.constructorEx = ex;
        }
        this.initPostCollectionActions(properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        if (!this.initDone) {
            throw new Exception("\nOpening dataStore failed; datastore could not be found, missing library or no access to file: " + this.toString() + "\n\n" + this.constructorEx.getLocalizedMessage());
        }
        long start = new Date().getTime();
        feature = this.fixFeatureTypeName(feature);
        String typename = feature.getFeatureType().getTypeName();
        PrimaryKey pks = null;
        DefaultFeatureCollection fc = null;
        FeatureStore store = null;
        List<List<String>> errors = null;
        List<List<String>> nonFatals = null;
        int batchsize = 50;
        int numWritten = 0;
        if (this.featureTypeNames.contains(typename)) {
            pks = this.featurePKs.get(typename);
            fc = this.featureCollectionCache.get(typename);
            store = this.featureStores.get(typename);
            batchsize = this.featureBatchSizes.get(typename);
            numWritten = this.featuresWritten.get(typename);
            errors = this.featureErrors.get(typename);
            nonFatals = this.featureNonFatals.get(typename);
        } else {
            boolean delayRemoveUntilFirstCommit = false;
            if (batchsize == -1) {
                delayRemoveUntilFirstCommit = true;
            }
            String oldTypeName = typename;
            boolean typeExists = this.datastoreTypeNames.contains(oldTypeName);
            typename = this.checkSchema(feature.getFeatureType(), delayRemoveUntilFirstCommit, typeExists);
            if (!typename.equals(oldTypeName)) {
                feature.setTypeName(typename);
            }
            fc = new DefaultFeatureCollection(typename, feature.getFeatureType());
            this.featureCollectionCache.put(typename, fc);
            if (this.dataStore2Write != null) {
                if (this.dataStore2Write instanceof JDBCDataStore) {
                    ContentFeatureSource fs = ((JDBCDataStore)this.dataStore2Write).getFeatureSource(typename, Transaction.AUTO_COMMIT);
                    if (!(fs instanceof JDBCFeatureStore)) throw new IllegalStateException("Table cannot be written: no primary key? FeatureSource was not of type JDBCFeatureStore");
                    store = (JDBCFeatureStore)fs;
                    pks = ((JDBCFeatureStore)fs).getPrimaryKey();
                } else {
                    store = (FeatureStore)this.dataStore2Write.getFeatureSource(typename);
                }
            }
            this.featureStores.put(typename, store);
            this.featurePKs.put(typename, pks);
            this.featureBatchSizes.put(typename, batchsize);
            this.featuresWritten.put(typename, numWritten);
            this.featureErrors.put(typename, new ArrayList());
            this.featureNonFatals.put(typename, new ArrayList());
            this.featureTypeNames.add(typename);
        }
        feature.convertGeomTo2D();
        this.prepareWrite(fc, pks, feature);
        Integer collectionSize = fc.size();
        if (collectionSize >= batchsize && batchsize != -1) {
            try {
                batchsize = this.writeCollection(fc, store, batchsize);
                this.featureBatchSizes.put(typename, batchsize);
            }
            catch (Exception ex) {
                throw new FeatureException("Error writing feature collection. Features not written.", ex);
            }
            finally {
                fc.retainAll(new ArrayList());
            }
        }
        long end = new Date().getTime() - start;
        log.debug((Object)("WRITER BLOCK: " + end));
        return feature;
    }

    private void prepareWrite(DefaultFeatureCollection fc, PrimaryKey pk, EasyFeature feature) throws IOException {
        PrimaryKey usePk = pk;
        SimpleFeature newFeature = feature.getFeature();
        StringBuilder oldfid = new StringBuilder();
        if (usePk != null) {
            List pkcs = usePk.getColumns();
            for (PrimaryKeyColumn pkc : pkcs) {
                String cn = pkc.getName();
                Object o = feature.getAttribute(cn);
                if (o == null) {
                    oldfid = null;
                    break;
                }
                oldfid.append(o).append(".");
            }
            if (oldfid != null) {
                oldfid.setLength(oldfid.length() - 1);
            }
        }
        if (oldfid != null && oldfid.length() > 0) {
            newFeature = feature.copy(oldfid.toString()).getFeature();
            newFeature.getUserData().put(Hints.USE_PROVIDED_FID, true);
        }
        SimpleFeatureType type = fc.getSchema();
        if (feature.isSkipped()) {
            ArrayList<String> message = new ArrayList<String>(Arrays.asList("Feature uitgefilterd", feature.getID()));
            this.featureNonFatals.get(type.getTypeName()).add(message);
        } else {
            fc.add(newFeature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeCollection(DefaultFeatureCollection fc, FeatureStore store, int batchsize) throws FeatureException, IOException {
        SimpleFeatureIterator fi;
        SimpleFeatureType type = fc.getSchema();
        int orgbatchsize = batchsize;
        int stamp = this.generator.nextInt(10000);
        int orgfcsize = fc.size();
        log.info((Object)("Starting write out for typename: " + type.getTypeName() + " with batch size: " + orgbatchsize + " and stamp: " + stamp + " and size: " + orgfcsize));
        DefaultFeatureCollection currentFc = null;
        if (batchsize == -1) {
            currentFc = fc;
        } else {
            currentFc = new DefaultFeatureCollection(type.getTypeName(), type);
            ArrayList<SimpleFeature> removeList = new ArrayList<SimpleFeature>();
            fi = fc.features();
            for (int count = 0; fi.hasNext() && count < batchsize; ++count) {
                SimpleFeature newFeature = (SimpleFeature)fi.next();
                currentFc.add(newFeature);
                removeList.add(newFeature);
            }
            fc.removeAll(removeList);
            if (!fc.isEmpty()) {
                batchsize = this.writeCollection(fc, store, batchsize);
                this.featureBatchSizes.put(type.getTypeName(), batchsize);
            }
        }
        store.setTransaction((Transaction)t);
        try (DefaultTransaction t = new DefaultTransaction("add");){
            if (this.modify) {
                fi = currentFc.features();
                while (fi.hasNext()) {
                    SimpleFeature newFeature = (SimpleFeature)fi.next();
                    List properties = newFeature.getFeatureType().getTypes();
                    Object filterValue = newFeature.getAttribute(this.modifyFilter);
                    Filter filter = ECQL.toFilter((String)(this.modifyFilter + "='" + filterValue + "'"));
                    boolean hasGeom = newFeature.getDefaultGeometryProperty() != null;
                    for (AttributeType property : properties) {
                        if (hasGeom && newFeature.getDefaultGeometryProperty().getName().equals((Object)property.getName()) && !this.modifyGeom || newFeature.getAttribute(property.getName().toString()) == null) continue;
                        store.modifyFeatures(property.getName(), newFeature.getAttribute(property.getName()), filter);
                    }
                }
            } else {
                if (batchsize == -1) {
                    log.info((Object)("Removing all features from: " + type.getTypeName() + " within insert transaction."));
                    store.removeFeatures((Filter)Filter.INCLUDE);
                }
                store.addFeatures((FeatureCollection)currentFc);
            }
            t.commit();
            int numWritten = this.featuresWritten.get(type.getTypeName());
            int numProcessed = currentFc.size();
            this.featuresWritten.put(type.getTypeName(), numWritten + numProcessed);
            if ((batchsize *= 2) > 5000) {
                batchsize = 5000;
            }
            currentFc.retainAll(new ArrayList());
        }
        log.info((Object)("finishing write out for typename: " + type.getTypeName() + " with batch size: " + orgbatchsize + " and stamp: " + stamp + " and size: " + orgfcsize));
        return batchsize;
    }

    @Override
    public void close() throws Exception {
        log.info((Object)"Closing ActionDataStore Writer");
        if (this.dataStore2Write != null) {
            this.dataStore2Write.dispose();
        }
    }

    private void initPostCollectionActions(Map properties) {
        if (this.postCollectionActionsInitDone) {
            return;
        }
        if (ActionFactory.propertyCheck(properties, "polygonize")) {
            this.polygonize = new Boolean(properties.get("polygonize").toString());
            this.postCollectionActionsInitDone = true;
        } else {
            this.polygonize = false;
        }
        if (ActionFactory.propertyCheck(properties, "polygonizeWithAttr")) {
            this.polygonizeWithAttr = new Boolean(properties.get("polygonizeWithAttr").toString());
            this.postCollectionActionsInitDone = true;
        } else {
            this.polygonizeWithAttr = false;
        }
        if (ActionFactory.propertyCheck(properties, "polygonizeSufLki")) {
            this.polygonizeSufLki = new Boolean(properties.get("polygonizeSufLki").toString());
            this.postCollectionActionsInitDone = true;
        } else {
            this.polygonizeSufLki = false;
        }
        if (ActionFactory.propertyCheck(properties, "postPointWithinPolygon")) {
            this.postPointWithinPolygon = new Boolean(properties.get("postPointWithinPolygon").toString());
            this.postCollectionActionsInitDone = true;
        } else {
            this.postPointWithinPolygon = false;
        }
        if (this.polygonize) {
            log.info((Object)"Polygonize is configured as post action");
            this.collectionActions.add(new CollectionAction_Polygonize(new HashMap(properties)));
        }
        if (this.postPointWithinPolygon) {
            log.info((Object)"Point_Within_Polygon with attribute is configured as post action");
            try {
                this.collectionActions.add(new CollectionAction_Point_Within_Polygon(this.dataStore2Write, new HashMap(properties)));
            }
            catch (Exception e) {
                log.error((Object)"Cannot create Point_Within_Polygon post action", (Throwable)e);
            }
        }
        if (this.polygonizeWithAttr) {
            log.info((Object)"Polygonize with attribute is configured as post action");
            try {
                this.collectionActions.add(new CollectionAction_PolygonizeWithAttr(this.dataStore2Write, new HashMap(properties)));
            }
            catch (Exception e) {
                log.error((Object)"Can not create PolygonizeWithAttr post action", (Throwable)e);
            }
        } else if (this.polygonizeSufLki) {
            log.info((Object)"Polygonize with attribute is configured as post action");
            try {
                this.collectionActions.add(new CollectionAction_PolygonizeSufLki(this.dataStore2Write, new HashMap(properties)));
            }
            catch (Exception e) {
                log.error((Object)"Can not create PolygonizeWithAttr post action", (Throwable)e);
            }
        }
        if (this.postPointWithinPolygon) {
            log.info((Object)"Find polygon with point is configured as post action");
            try {
                this.collectionActions.add(new CollectionAction_Intersects_XY_Add_Attrib(this.dataStore2Write, new HashMap(properties)));
            }
            catch (Exception e) {
                log.error((Object)"Can not create Find polygon with point post action", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPostCollectionActions(Status status, Map properties) {
        this.initPostCollectionActions(properties);
        log.info((Object)"Collect errors from ActionDataStore_Writer");
        if (this.dataStore2Write != null) {
            try {
                int i;
                String[] typeNames = this.dataStore2Write.getTypeNames();
                List<List<String>> nonFatals = null;
                for (int i2 = 0; i2 < typeNames.length; ++i2) {
                    nonFatals = this.featureNonFatals.get(typeNames[i2]);
                    if (nonFatals == null || nonFatals.isEmpty()) continue;
                    for (int j = 0; j < nonFatals.size(); ++j) {
                        List<String> message = nonFatals.get(j);
                        status.addNonFatalError(message.get(0), message.get(1));
                    }
                }
                List<List<String>> errors = null;
                for (i = 0; i < typeNames.length; ++i) {
                    errors = this.featureErrors.get(typeNames[i]);
                    if (errors == null || errors.isEmpty()) continue;
                    for (int j = 0; j < errors.size(); ++j) {
                        List<String> message = errors.get(j);
                        status.addWriteError(message.get(0), message.get(1));
                    }
                }
                for (i = 0; i < typeNames.length; ++i) {
                    Integer numWritten = this.featuresWritten.get(typeNames[i]);
                    if (numWritten == null) continue;
                    int numProcessed = status.getProcessedFeatures();
                    status.setProcessedFeatures(numProcessed + numWritten);
                }
            }
            catch (IOException e) {
                status.addWriteError("Error collecting errors/messages from ActionDataStore_Writer", null);
                log.error((Object)"Error collecting errors/messages from ActionDataStore_Writer.", (Throwable)e);
            }
        }
        for (int i = 0; i < this.collectionActions.size(); ++i) {
            DefaultFeatureCollection fc;
            SimpleFeatureSource fs;
            log.info((Object)"Process Post actions ActionDataStore_Writer");
            CollectionAction ca = this.collectionActions.get(i);
            if (ca instanceof CollectionAction_Polygonize) {
                for (int s = 0; s < this.featureTypeNames.size(); ++s) {
                    try {
                        Class geometryTypeBinding;
                        GeometryDescriptor gd = this.dataStore2Write.getSchema(this.featureTypeNames.get(s)).getGeometryDescriptor();
                        if (gd == null || LineString.class != (geometryTypeBinding = this.dataStore2Write.getSchema(this.featureTypeNames.get(s)).getGeometryDescriptor().getType().getBinding()) && MultiLineString.class != geometryTypeBinding) continue;
                        SimpleFeatureSource fs2 = this.dataStore2Write.getFeatureSource(this.featureTypeNames.get(s));
                        FeatureCollection fc2 = fs2.getFeatures();
                        ca.execute(fc2, this);
                        continue;
                    }
                    catch (Exception e) {
                        status.addWriteError("Error while polygonizing the lines", "");
                        log.error((Object)"Error while Polygonizing the lines.", (Throwable)e);
                    }
                }
            }
            if (ca instanceof CollectionAction_Point_Within_Polygon) {
                DataStore ds = null;
                try {
                    CollectionAction_Point_Within_Polygon cap = (CollectionAction_Point_Within_Polygon)ca;
                    fs = this.dataStore2Write.getFeatureSource(cap.getPointsTable());
                    fc = (DefaultFeatureCollection)fs.getFeatures();
                    SimpleFeatureSource fs2 = this.dataStore2Write.getFeatureSource(cap.getPolygonTable());
                    DefaultFeatureCollection fc2 = (DefaultFeatureCollection)fs2.getFeatures();
                    ds = DataStoreLinker.openDataStore(this.params);
                    cap.setDataStore2Write(ds);
                    cap.execute(fc, fc2, this);
                }
                catch (Exception e) {
                    status.addWriteError("Error while points within polygon with attributes", "");
                    log.error((Object)"Error while Points within Polygon with attributes.", (Throwable)e);
                }
                finally {
                    if (ds != null) {
                        ds.dispose();
                    }
                }
            }
            if (!(ca instanceof CollectionAction_PolygonizeWithAttr)) continue;
            DataStore ds = null;
            try {
                CollectionAction_PolygonizeWithAttr cap = (CollectionAction_PolygonizeWithAttr)ca;
                fs = this.dataStore2Write.getFeatureSource(cap.getAttributeFeatureName());
                fc = fs.getFeatures();
                ds = DataStoreLinker.openDataStore(this.params);
                cap.setDataStore2Write(ds);
                cap.execute((FeatureCollection)fc, (Action)this);
                continue;
            }
            catch (Exception e) {
                status.addWriteError("Error while polygonizing the lines with attributes", "");
                log.error((Object)"Error while polygonizing the lines with attributes.", (Throwable)e);
                continue;
            }
            finally {
                if (ds != null) {
                    ds.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String checkSchema(SimpleFeatureType featureType, boolean delayRemoveUntilFirstCommit, boolean typeExists) throws Exception {
        String typename2Write = featureType.getTypeName();
        if (this.dropFirst && typeExists) {
            if (this.dataStore2Write instanceof JDBCDataStore) {
                log.info((Object)("Verwijderen van tabel: " + featureType.getTypeName()));
                try {
                    this.dataStore2Write.removeSchema(featureType.getTypeName());
                }
                catch (IOException io) {
                    log.warn((Object)("Verwijderen van " + featureType.getTypeName() + " is niet gelukt, melding: " + io.getLocalizedMessage()));
                }
            }
            typeExists = false;
        }
        if (!typeExists) {
            log.info((Object)("Creating new table with name: " + featureType.getTypeName()));
            this.dataStore2Write.createSchema((FeatureType)featureType);
        } else if (!(this.append || this.modify || delayRemoveUntilFirstCommit)) {
            log.info((Object)("Removing all features from: " + typename2Write));
            boolean deleteSuccess = false;
            if (this.dataStore2Write instanceof JDBCDataStore) {
                JDBCDataStore database = (JDBCDataStore)this.dataStore2Write;
                try (Connection con = null;){
                    con = database.getConnection(Transaction.AUTO_COMMIT);
                    this.removeAllFeaturesWithTruncate(database, con, typename2Write);
                    deleteSuccess = true;
                }
            }
            if (!deleteSuccess) {
                this.removeAllFeatures(this.dataStore2Write, typename2Write);
                log.info((Object)"Removing using geotools");
            }
        }
        this.datastoreTypeNames = Arrays.asList(this.dataStore2Write.getTypeNames());
        return typename2Write;
    }

    private EasyFeature fixFeatureTypeName(EasyFeature feature) throws Exception {
        String oldTypeName = feature.getTypeName();
        boolean isWFS = false;
        if (this.dataStore2Write instanceof WFSDataStore) {
            isWFS = true;
        }
        String typename = ActionDataStore_Writer.fixTypename(oldTypeName.replaceAll(" ", "_"), isWFS);
        for (String tnn : this.datastoreTypeNames) {
            if (!tnn.equalsIgnoreCase(typename)) continue;
            typename = tnn;
            break;
        }
        if (!typename.equals(oldTypeName)) {
            feature.setTypeName(typename);
        }
        return feature;
    }

    public Map getParams() {
        return this.params;
    }

    @Override
    public String toString() {
        if (this.params == null) {
            return "No datastore params";
        }
        HashMap cleanedParams = new HashMap();
        for (Object param : this.params.keySet()) {
            if (param.toString().toLowerCase().contains("passw")) continue;
            cleanedParams.put(param, this.params.get(param));
        }
        return "Datastore params: " + ((Object)cleanedParams).toString();
    }

    public static List<List<String>> getConstructors() {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        constructors.add(Arrays.asList("params", "append", "drop"));
        constructors.add(Arrays.asList("params"));
        return constructors;
    }

    @Override
    public String getDescription_NL() {
        return "Schrijf de SimpleFeature weg naar een datastore. Als de datastore een database is, kan de SimpleFeature worden toegevoegd of kan de tabel worden geleegd voor het toevoegen";
    }

    private void removeAllFeaturesWithTruncate(JDBCDataStore database, Connection con, String typeName) throws SQLException {
        PreparedStatement ps = null;
        ps = database.getSQLDialect() instanceof PostGISDialect ? con.prepareStatement("TRUNCATE TABLE \"" + typeName + "\" CASCADE") : con.prepareStatement("TRUNCATE TABLE \"" + typeName + "\"");
        ps.execute();
        log.info((Object)"Removing using truncate");
    }

    private void removeAllFeaturesWithDelete(JDBCDataStore database, Connection con, String typeName) throws SQLException {
        PreparedStatement ps = con.prepareStatement("DELETE FROM \"" + typeName + "\"");
        ps.execute();
        log.info((Object)"Removing using delete from table");
    }

    private void removeAllFeatures(DataStore datastore, String typeName) throws IOException, Exception {
        FeatureStore store = (FeatureStore)datastore.getFeatureSource(typeName);
        try (DefaultTransaction transaction = new DefaultTransaction("removeTransaction");){
            store.removeFeatures((Filter)Filter.INCLUDE);
            transaction.commit();
        }
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
        for (Map.Entry<String, DefaultFeatureCollection> pairs : this.featureCollectionCache.entrySet()) {
            String key = pairs.getKey();
            FeatureStore store = this.featureStores.get(key);
            int batchsize = this.featureBatchSizes.get(key);
            DefaultFeatureCollection fc = pairs.getValue();
            int fcsize = fc.size();
            if (fc != null && fcsize > 0) {
                batchsize = this.writeCollection(fc, store, batchsize);
            }
            log.info((Object)("finished flushing cache for typename: " + key + " with batch size: " + batchsize + " and size: " + fcsize));
        }
    }
}

