/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import org.geotools.feature.type.AttributeDescriptorImpl;
import org.geotools.feature.type.AttributeTypeImpl;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.LengthFunction;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Expression;

public class ActionFeatureType_AttributeType_Restriction
extends Action {
    private int length = 256;

    public ActionFeatureType_AttributeType_Restriction(int attributeID, int length) {
        this.attributeID = attributeID;
        this.length = length;
    }

    public ActionFeatureType_AttributeType_Restriction(String attributeName, int length) {
        this.attributeName = attributeName;
        this.length = length;
    }

    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        this.fixAttributeID(feature);
        if (this.attributeID != -1) {
            if (feature.getAttribute(this.attributeID) instanceof String) {
                String value = (String)feature.getAttribute(this.attributeID);
                value = value.length() >= this.length ? value.substring(0, this.length) : value.substring(0, value.length());
                feature.setAttribute(this.attributeID, (Object)value);
            }
            AttributeDescriptor oldDescriptor = (AttributeDescriptor)feature.getFeatureType().getAttributeDescriptors().get(this.attributeID);
            AttributeType oldType = feature.getAttributeType(this.attributeID);
            FilterFactoryImpl filterFactory = new FilterFactoryImpl();
            filterFactory.literal(this.length);
            ArrayList<PropertyIsLessThanOrEqualTo> restrictions = new ArrayList<PropertyIsLessThanOrEqualTo>();
            restrictions.add(filterFactory.lessOrEqual((Expression)new LengthFunction(), (Expression)filterFactory.literal(this.length)));
            AttributeTypeImpl newType = new AttributeTypeImpl(oldType.getName(), oldType.getBinding(), oldType.isIdentified(), oldType.isAbstract(), restrictions, oldType.getSuper(), oldType.getDescription());
            AttributeDescriptorImpl newAttributeDescriptor = new AttributeDescriptorImpl((AttributeType)newType, oldDescriptor.getName(), oldDescriptor.getMinOccurs(), oldDescriptor.getMaxOccurs(), oldDescriptor.isNillable(), oldDescriptor.getDefaultValue());
            feature.removeAttributeDescriptor(this.attributeID);
            feature.insertAttributeDescriptor(this.attributeID, (AttributeDescriptor)newAttributeDescriptor);
        }
        return feature;
    }

    @Override
    public String toString() {
        return "Remove attribute '" + (this.attributeName.equals("") ? Integer.valueOf(this.attributeID) : this.attributeName) + "'";
    }

    public static List<List<String>> getConstructors() {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        constructors.add(Arrays.asList("attribute_name", "length"));
        return constructors;
    }

    @Override
    public String getDescription_NL() {
        return "Met deze Action kan bij een SimpleFeatureType een attribuut worden verwijderd.";
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
    }

    @Override
    public void processPostCollectionActions(Status status, Map properties) throws Exception {
    }
}

