/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import org.geotools.data.DataSourceException;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ActionFeatureType_Set_CRS
extends Action {
    private HashMap metadata;
    private String srs;
    private boolean useSRS = true;

    public ActionFeatureType_Set_CRS(String srs) {
        this.srs = srs;
    }

    public ActionFeatureType_Set_CRS(HashMap params) {
        this.metadata = params;
        this.useSRS = false;
    }

    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        CoordinateReferenceSystem crs = this.useSRS ? ActionFeatureType_Set_CRS.loadSRS(this.srs) : this.loadMetaData();
        feature.setCRS(crs);
        return feature;
    }

    public static CoordinateReferenceSystem loadSRS(String srs) throws DataSourceException {
        if (srs != null) {
            try {
                return CRS.decode((String)srs);
            }
            catch (Exception e) {
                throw new DataSourceException("Error parsing CoordinateSystem srs: \"" + srs + "\"");
            }
        }
        throw new DataSourceException("CoordinateSystem srs can not be null");
    }

    public CoordinateReferenceSystem loadMetaData() throws DataSourceException {
        String[] csMetadata = this.metadata.values().toArray(new String[this.metadata.size()]);
        if (csMetadata != null) {
            String wkt = csMetadata[0];
            try {
                CRSFactory crsFactory = ReferencingFactoryFinder.getCRSFactory(null);
                return crsFactory.createFromWKT(wkt);
            }
            catch (Exception e) {
                throw new DataSourceException("Error parsing CoordinateSystem WKT: \"" + wkt + "\": " + e.getLocalizedMessage());
            }
        }
        throw new DataSourceException("Coordinatesystem csMetadata is empty");
    }

    @Override
    public String toString() {
        if (this.useSRS) {
            return "Set SRS to " + this.srs;
        }
        return "Set CRS using " + this.metadata.toString();
    }

    @Override
    public String getDescription_NL() {
        return "Stel een ander SRS in (standaard EPSG:28992)";
    }

    public static List<List<String>> getConstructors() {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        constructors.add(Arrays.asList("srs"));
        return constructors;
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
    }

    @Override
    public void processPostCollectionActions(Status status, Map properties) throws Exception {
    }
}

