/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import nl.b3p.geotools.data.linker.poi.ExcelReader;

public class ActionFeature_Add_External_Attributes
extends Action {
    private int attributeIDDXFHandle;
    private int attributeIDOtherFileHandle;
    private int attributeIDOtherFileName;
    private String attributeNameDXFHandle;
    private String attributeNameOtherFileHandle;
    private String attributeNameOtherFileName;
    private boolean useID = true;

    public ActionFeature_Add_External_Attributes(int attributeIDDXFHandle, int attributeIDOtherFileHandle, int attributeIDOtherFileName) {
        this.attributeIDDXFHandle = attributeIDDXFHandle;
        this.attributeIDOtherFileHandle = attributeIDOtherFileHandle;
        this.attributeIDOtherFileName = attributeIDOtherFileName;
    }

    public ActionFeature_Add_External_Attributes(String attributeNameDXFHandle, String attributeNameOtherFileHandle, String attributeNameOtherFileName) {
        this.attributeNameDXFHandle = attributeNameDXFHandle;
        this.attributeNameOtherFileHandle = attributeNameOtherFileHandle;
        this.attributeNameOtherFileName = attributeNameOtherFileName;
        this.useID = false;
    }

    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        this.attributeIDDXFHandle = -1;
        this.attributeIDOtherFileHandle = -1;
        this.attributeIDOtherFileName = -1;
        String dxfHandle = null;
        Object f = null;
        if (!this.useID) {
            if (this.attributeNameDXFHandle != null && !this.attributeNameDXFHandle.equals("")) {
                this.attributeIDDXFHandle = feature.getAttributeDescriptorIDbyName(this.attributeNameDXFHandle);
            }
            if (this.attributeIDDXFHandle > 0 && feature.getAttribute(this.attributeIDDXFHandle) != null) {
                dxfHandle = feature.getAttribute(this.attributeIDDXFHandle).toString();
            }
        }
        if (this.attributeNameOtherFileName != null && dxfHandle != null && !dxfHandle.equals("")) {
            return this.addExternalData(feature, dxfHandle);
        }
        return feature;
    }

    private EasyFeature addExternalData(EasyFeature feature, String dxfHandle) {
        ExcelReader reader = new ExcelReader();
        try {
            int i;
            List<String> record = null;
            List<String> columns = reader.getColumns(this.attributeNameOtherFileName);
            Integer index = columns.indexOf(this.attributeNameOtherFileHandle.toLowerCase());
            if (index != null && index > -1) {
                record = reader.getRecord(this.attributeNameOtherFileName, index, dxfHandle);
            }
            if (record != null && columns != null) {
                for (i = 0; i < columns.size(); ++i) {
                    if (i == index) continue;
                    feature.addAttributeDescriptor(record.get(i), String.class);
                }
            }
            if (record != null && columns != null && record.size() > columns.size()) {
                for (i = 0; i < columns.size(); ++i) {
                    if (i == index) continue;
                    feature.setAttribute(record.get(i), (Object)record.get(i + columns.size()));
                }
            }
        }
        catch (FileNotFoundException fex) {
            log.debug((Object)"Bestand niet gevonden!", (Throwable)fex);
        }
        catch (IOException iex) {
            log.debug((Object)"Fout tijdens lezen!", (Throwable)iex);
        }
        catch (Exception ex) {
            log.debug((Object)"Fout!", (Throwable)ex);
        }
        return feature;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    public String getDescription_NL() {
        return "Verrijken met attributen uit extern bestand.";
    }

    public static List<List<String>> getConstructors() {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        constructors.add(Arrays.asList("attribute_name_other_file_name", "attribute_name_dxf_handle", "attribute_name_other_file_handle"));
        return constructors;
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
    }

    @Override
    public void processPostCollectionActions(Status status, Map properties) throws Exception {
    }
}

