/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.filter.text.cql2.CQL;
import org.opengis.filter.Filter;

public class ActionFeature_Filter_Column_Value
extends Action {
    protected static final Log logger = LogFactory.getLog(ActionFeature_Filter_Column_Value.class);
    private String columnName = null;
    private String operator = null;
    private String filterValue = null;

    public ActionFeature_Filter_Column_Value(String columnName, String operator, String filterValue) {
        this.columnName = columnName;
        this.operator = operator;
        this.filterValue = filterValue;
    }

    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        Filter filter;
        boolean result;
        long start = new Date().getTime();
        int id = feature.getAttributeDescriptorIDbyName(this.columnName);
        if (id < 0) {
            String err = "Kolom " + this.columnName + " in filter blok bestaat niet.";
            throw new Exception(err);
        }
        String filterString = this.columnName + " " + this.operator;
        if (this.filterValue != null && !this.filterValue.trim().isEmpty()) {
            filterString = filterString + " '";
            filterString = filterString + this.filterValue;
            filterString = filterString + "'";
        }
        if (!(result = (filter = CQL.toFilter((String)filterString)).evaluate((Object)feature.getFeature()))) {
            feature.setSkipped(true);
        }
        long end = new Date().getTime() - start;
        log.debug((Object)("FILTER BLOCK: " + end));
        return feature;
    }

    @Override
    public String toString() {
        return "";
    }

    @Override
    public String getDescription_NL() {
        return "Filter feature op basis van kolomwaarde.";
    }

    public static List<List<String>> getConstructors() {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        constructors.add(Arrays.asList("attribute_name_filter_column", "attribute_name_filter_operator", "attribute_name_filter_value"));
        return constructors;
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
    }

    @Override
    public void processPostCollectionActions(Status status, Map properties) throws Exception {
    }
}

