/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.feature.EasyFeature;

public class ActionFeature_Value_Substring
extends Action {
    private int beginIndex = -1;
    private int endIndex = -1;

    public ActionFeature_Value_Substring(String attributeName, int beginIndex, int endIndex) {
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.attributeName = attributeName;
    }

    public ActionFeature_Value_Substring(int attributeID, int beginIndex, int endIndex) {
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
        this.attributeID = attributeID;
    }

    public ActionFeature_Value_Substring(String attributeName, int beginIndex) {
        this.beginIndex = beginIndex;
        this.attributeName = attributeName;
    }

    public ActionFeature_Value_Substring(int attributeID, int beginIndex) {
        this.beginIndex = beginIndex;
        this.attributeID = attributeID;
    }

    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        this.fixAttributeID(feature);
        if (this.attributeID != -1) {
            if (feature.getAttribute(this.attributeID) instanceof String) {
                String value = (String)feature.getAttribute(this.attributeID);
                if (value.length() > this.beginIndex) {
                    if (this.endIndex == -1) {
                        value = value.substring(this.beginIndex);
                    } else if (value.length() > this.endIndex) {
                        value = value.substring(this.beginIndex, this.endIndex);
                    }
                }
                feature.setAttribute(this.attributeID, (Object)value);
            }
        } else {
            throw new Exception("Attribute " + this.attributeID + " not found");
        }
        return feature;
    }

    @Override
    public String toString() {
        return "Make substring of value = substring(" + this.beginIndex + (this.endIndex == -1 ? "" : ", " + this.endIndex) + ")";
    }

    public static List<List<String>> getConstructors() {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        constructors.add(Arrays.asList("attribute_name", "beginIndex", "endIndex"));
        constructors.add(Arrays.asList("attribute_name", "beginIndex"));
        return constructors;
    }

    @Override
    public String getDescription_NL() {
        return "Met deze Action kan bij een SimpleFeature een attribuutWaarde worden gewijzigd in een subString van deze waarde";
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
    }

    @Override
    public void processPostCollectionActions(Status status, Map properties) throws Exception {
    }
}

