/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.ActionFactory;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.blocks.CollectionAction;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.And;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Intersects;
import org.opengis.geometry.BoundingBox;

public class CollectionAction_Point_Within_Polygon
extends CollectionAction {
    protected static final Log log = LogFactory.getLog(CollectionAction_Point_Within_Polygon.class);
    private DataStore dataStore2Write = null;
    private String pointsTable = null;
    private String polygonTable = null;
    private static final String MATCHED = "_matched";
    private static final int BUFFER_POINT = 1;

    public CollectionAction_Point_Within_Polygon(DataStore dataStore2Write, Map properties) throws Exception {
        properties.put("pointWithinPolygonPointsTable", "gouda_sonderingen_p");
        properties.put("pointWithinPolygonPolygonTable", "gouda_sonderingen_v");
        this.pointsTable = ActionFactory.propertyCheck(properties, "pointWithinPolygonPointsTable") ? (String)properties.get("pointWithinPolygonPointsTable") : null;
        this.polygonTable = ActionFactory.propertyCheck(properties, "pointWithinPolygonPolygonTable") ? (String)properties.get("pointWithinPolygonPolygonTable") : null;
        if (this.pointsTable == null || this.polygonTable == null) {
            throw new Exception("Missing one of the mandatory values in the properties map");
        }
    }

    @Override
    public void execute(FeatureCollection collection, Action writer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DefaultFeatureCollection pointCollection, DefaultFeatureCollection polygonCollection, Action nextAction) {
        SimpleFeature feature = null;
        SimpleFeatureIterator it = pointCollection.features();
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        DefaultFeatureCollection newFc = null;
        HashMap<SimpleFeature, SimpleFeature> resultMap = new HashMap<SimpleFeature, SimpleFeature>();
        try {
            while (it.hasNext()) {
                feature = (SimpleFeature)it.next();
                BoundingBox bounds = feature.getBounds();
                BBOX boundsCheck = ff.bbox((Expression)ff.property("the_geom"), bounds);
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                geom = geom.buffer(1.0);
                Intersects polyCheck = ff.intersects((Expression)ff.property("the_geom"), (Expression)ff.literal((Object)geom));
                And andFil = ff.and((Filter)boundsCheck, (Filter)polyCheck);
                newFc = (DefaultFeatureCollection)polygonCollection.subCollection((Filter)andFil);
                if (newFc == null || newFc.size() <= 0) continue;
                SimpleFeature sf = (SimpleFeature)newFc.features().next();
                resultMap.put(feature, sf);
            }
        }
        catch (RuntimeException ex) {
            log.error((Object)("Problem filtering feature id " + feature.getID() + ":"), (Throwable)ex);
        }
        finally {
            if (newFc != null && it != null) {
                newFc.close((FeatureIterator)it);
            }
        }
        log.info((Object)("Number of matches found: " + resultMap.size()));
        if (resultMap == null || resultMap.size() < 1) {
            return;
        }
        SimpleFeatureType pointFt = pointCollection.getSchema();
        SimpleFeatureType polygonFt = polygonCollection.getSchema();
        int geometryColumnIndex = -1;
        String geomColumn = polygonFt.getGeometryDescriptor().getName().getLocalPart();
        List attributeDescriptors = polygonFt.getAttributeDescriptors();
        for (int i = 0; i < attributeDescriptors.size(); ++i) {
            if (!((AttributeDescriptor)attributeDescriptors.get(i)).getLocalName().equalsIgnoreCase(geomColumn)) continue;
            geometryColumnIndex = i;
        }
        ArrayList pointAttrDescr = new ArrayList(pointFt.getAttributeDescriptors());
        ArrayList polyAttrDescr = new ArrayList(polygonFt.getAttributeDescriptors());
        AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
        String pointGeomColumn = pointFt.getGeometryDescriptor().getName().getLocalPart();
        ArrayList<AttributeDescriptor> newAttrDescr = new ArrayList<AttributeDescriptor>();
        for (AttributeDescriptor pDescr : pointAttrDescr) {
            if (pDescr.getName().getLocalPart().equals(pointGeomColumn) || polyAttrDescr.contains(pDescr)) continue;
            newAttrDescr.add(pDescr);
        }
        SimpleFeatureType newFt = this.createNewFeatureType(polygonFt, geometryColumnIndex, Polygon.class, newAttrDescr);
        SimpleFeatureIterator it2 = polygonCollection.features();
        try {
            while (it2.hasNext()) {
                feature = (SimpleFeature)it2.next();
                Geometry geom = (Geometry)feature.getDefaultGeometry();
                List pointAttribs = null;
                for (Map.Entry pairs : resultMap.entrySet()) {
                    SimpleFeature polyF = (SimpleFeature)pairs.getValue();
                    if (!polyF.getID().equals(feature.getID())) continue;
                    SimpleFeature pointF = (SimpleFeature)pairs.getKey();
                    pointAttribs = pointF.getAttributes();
                }
                List attributes = feature.getAttributes();
                attributes.set(geometryColumnIndex, geom);
                if (pointAttribs != null && pointAttribs.size() > 0) {
                    List<Object> newAttribs = this.fillExtraAttributes(attributes, pointAttribs, feature);
                    attributes.addAll(newAttribs);
                }
                nextAction.execute(new EasyFeature(SimpleFeatureBuilder.build((SimpleFeatureType)newFt, (List)attributes, (String)("" + feature.getID()))));
            }
        }
        catch (Exception ex) {
            log.error((Object)("Problem adding feature id " + feature.getID() + ":"), (Throwable)ex);
        }
        finally {
            if (polygonCollection != null && it2 != null) {
                polygonCollection.close((FeatureIterator)it2);
            }
        }
    }

    private List<Object> fillExtraAttributes(List<Object> currentAttribs, List<Object> pointAttribs, SimpleFeature feature) {
        int currentSize;
        ArrayList<Object> newAttribs = new ArrayList<Object>();
        int pointSize = pointAttribs.size();
        int diff = pointSize - (currentSize = currentAttribs.size());
        if (diff > 0) {
            for (int i = diff; i > 0; --i) {
                Object object = pointAttribs.get(pointSize - i);
                newAttribs.add(object);
            }
        }
        return newAttribs;
    }

    public SimpleFeatureType createNewFeatureType(SimpleFeatureType featureType, int attributeId, Class binding, List<AttributeDescriptor> extraAttr) {
        AttributeTypeBuilder attributeTypeBuilder = new AttributeTypeBuilder();
        attributeTypeBuilder.setName(featureType.getGeometryDescriptor().getName().getLocalPart());
        attributeTypeBuilder.setLength(256);
        attributeTypeBuilder.setBinding(binding);
        attributeTypeBuilder.setCRS(featureType.getGeometryDescriptor().getCoordinateReferenceSystem());
        AttributeDescriptor geomDescr = attributeTypeBuilder.buildDescriptor(featureType.getGeometryDescriptor().getName().getLocalPart());
        ArrayList<AttributeDescriptor> attributeDescriptors = new ArrayList<AttributeDescriptor>(featureType.getAttributeDescriptors());
        attributeDescriptors.set(attributeId, geomDescr);
        if (extraAttr != null && extraAttr.size() > 0) {
            attributeDescriptors.addAll(extraAttr);
        }
        SimpleFeatureTypeBuilder featureTypeBuilder = new SimpleFeatureTypeBuilder();
        featureTypeBuilder.init(featureType);
        featureTypeBuilder.setAttributes(attributeDescriptors);
        featureTypeBuilder.setName(featureType.getName().getLocalPart() + MATCHED);
        return featureTypeBuilder.buildFeatureType();
    }

    public DataStore getDataStore2Write() {
        return this.dataStore2Write;
    }

    public void setDataStore2Write(DataStore dataStore2Write) {
        this.dataStore2Write = dataStore2Write;
    }

    public String getPointsTable() {
        return this.pointsTable;
    }

    public void setPointsTable(String pointsTable) {
        this.pointsTable = pointsTable;
    }

    public String getPolygonTable() {
        return this.polygonTable;
    }

    public void setPolygonTable(String polygonTable) {
        this.polygonTable = polygonTable;
    }
}

