/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.activation.UnsupportedDataTypeException;
import javax.xml.validation.Schema;
import nl.b3p.datastorelinker.entity.Process;
import nl.b3p.datastorelinker.util.MarshalUtils;
import nl.b3p.geotools.data.linker.DataStoreLinker;
import nl.b3p.geotools.data.linker.DataStoreLinkerMail;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.PropertyConfigurator;
import org.geotools.util.logging.Logging;

public class Client {
    private static final String version = "1.1";
    private static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final Log log = LogFactory.getLog(DataStoreLinker.class);
    static final Logging logging = Logging.ALL;
    private static HashMap<String, Boolean> projectProperties = new HashMap();
    private static final String TO_XML = "toXml";
    private static final String PRINT_STATS = "printStats";
    private static final String NO_MAIL = "noMail";

    public static void main(String[] args) throws Exception {
        Class<Client> c = Client.class;
        URL log4j_url = c.getResource("log4j.properties");
        if (log4j_url == null) {
            throw new IOException("Unable to locate log4j.properties in package " + Client.class.getPackage().toString());
        }
        try {
            logging.setLoggerFactory("org.geotools.util.logging.Log4JLoggerFactory");
        }
        catch (ClassNotFoundException log4jException) {
            log.error((Object)"error: ", (Throwable)log4jException);
        }
        Properties p = new Properties();
        p.load(log4j_url.openStream());
        PropertyConfigurator.configure((Properties)p);
        log.info((Object)"logging configured!");
        Client.parseProjectProperties(args);
        Properties batch = new Properties();
        Process process = null;
        String tempFile = "";
        if (Client.getProjectProperty(PRINT_STATS)) {
            System.out.println();
        }
        try {
            if (args.length == 0) {
                System.out.println("No arguments specified; enter .properties and / or .xml file(s)");
            }
            for (int i = 0; i < args.length; ++i) {
                tempFile = args[i];
                String reportMessage = "";
                if (!args[i].toLowerCase().endsWith(".xml") && !args[i].toLowerCase().endsWith(".properties")) continue;
                File file = new File(args[i]);
                if (file.exists() && file.isFile()) {
                    FileInputStream input;
                    String info = "Reading \"" + file.getAbsolutePath().substring(file.getAbsolutePath().lastIndexOf("\\") + 1) + "\"\n";
                    Date startTime = Calendar.getInstance().getTime();
                    info = info + "Started at " + sdf.format(startTime) + "\n";
                    reportMessage = reportMessage + info;
                    log.info((Object)info);
                    if (Client.getProjectProperty(PRINT_STATS)) {
                        System.out.println(info);
                    }
                    if (Client.getProjectProperty(TO_XML)) {
                        Client.saveAsXML(file);
                    }
                    if ((input = new FileInputStream(args[i])) != null) {
                        batch = new Properties();
                        process = null;
                        if (args[i].toLowerCase().endsWith(".xml")) {
                            process = MarshalUtils.unmarshalProcess((InputStream)input, (Schema)MarshalUtils.getDslSchema());
                        } else if (args[i].toLowerCase().endsWith(".properties")) {
                            batch.load(input);
                        } else {
                            throw new UnsupportedDataTypeException("File \"" + args[i] + "\" not supported; Use .properties or .xml");
                        }
                        DataStoreLinker dsl = null;
                        dsl = process != null ? new DataStoreLinker(process) : new DataStoreLinker(batch);
                        dsl.process();
                        info = dsl.getStatus().getNonFatalErrorReport("\n", 3);
                        Date endTime = Calendar.getInstance().getTime();
                        info = info + Client.giveTimeInfo(startTime, endTime);
                        log.info((Object)info);
                        reportMessage = reportMessage + "\n" + info + "\n";
                        if (Client.getProjectProperty(PRINT_STATS)) {
                            System.out.println(" " + info + "\n");
                        }
                        if (Client.getProjectProperty(NO_MAIL)) continue;
                        if (process != null) {
                            DataStoreLinkerMail.mail(process, reportMessage, "Batchreport for '" + file.getAbsoluteFile().getName() + "' - finished at " + sdf.format(endTime));
                            continue;
                        }
                        DataStoreLinkerMail.mail(batch, "Batchreport for '" + file.getAbsoluteFile().getName() + "' - finished at " + sdf.format(endTime), reportMessage);
                        continue;
                    }
                    throw new Exception("Filestream \"" + args[i] + "\" could not be opened");
                }
                throw new Exception("File \"" + file.toURI().toString() + " could not be found");
            }
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            String exception = ex.getMessage() == null ? " > Geen info. Foutmelding ontstaan buiten DataStoreLinker." : ex.getMessage() + "\n" + (ex.getCause() != null ? "\n" + ex.getCause().toString() : "") + "\n";
            log.error((Object)exception);
            if (!Client.getProjectProperty(NO_MAIL)) {
                String message = "Er is een fout opgetreden bij de verwerking van batchBestand " + tempFile + "\n\nVoor meer informatie over de ontstane fout verwijzen wij u naar het logbestand:\n" + p.getProperty("logFilePath") + p.getProperty("logFile") + "\n\n\nFoutmelding:\n" + exception;
                if (process != null) {
                    DataStoreLinkerMail.mail(process, message);
                } else {
                    DataStoreLinkerMail.mail(batch, message);
                }
            }
            throw ex;
        }
    }

    private static String giveTimeInfo(Date startTime, Date endTime) {
        Date total = new Date(endTime.getTime() - startTime.getTime());
        double seconds = (double)(Integer.parseInt(Long.toString(endTime.getTime() - startTime.getTime())) / 10) / 100.0;
        String milliseconds = "0";
        if (Double.toString(seconds).contains(".")) {
            String value = Double.toString(seconds);
            milliseconds = value.substring(value.indexOf("."));
        }
        int minutes = total.getMinutes();
        int hours = total.getHours() - 1;
        return "\n\nBatch succesful (total time:" + (hours == 0 ? "" : " " + hours + " hour" + (hours == 1 ? "" : "s") + " ,") + (minutes == 0 ? "" : " " + minutes + " minute" + (minutes == 1 ? "" : "s") + " ,") + " " + total.getSeconds() + milliseconds + " seconds)";
    }

    public static void saveAsXML(File propertiesFile) throws FileNotFoundException, IOException {
        FileInputStream input = new FileInputStream(propertiesFile);
        String fileToString = propertiesFile.getAbsolutePath();
        if (!fileToString.toLowerCase().endsWith(".properties")) {
            throw new IOException("File \"" + propertiesFile.toURI().toString() + "\" is not a propertiesFile");
        }
        String outString = fileToString.substring(0, fileToString.length() - ".properties".length()) + ".xml";
        File outputFile = new File(outString);
        FileOutputStream output = new FileOutputStream(outputFile);
        Properties properties = new Properties();
        properties.load(input);
        properties.storeToXML(output, "XML Generated with DataStoreLinker v1.1");
    }

    private static void parseProjectProperties(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-") || args[i].length() <= 1) continue;
            String arg = args[i].substring(1);
            projectProperties.put(arg, true);
        }
    }

    private static boolean getProjectProperty(String property) {
        if (projectProperties.containsKey(property)) {
            return projectProperties.get(property);
        }
        return false;
    }

    static {
        projectProperties.put(PRINT_STATS, false);
        projectProperties.put(TO_XML, false);
        projectProperties.put(NO_MAIL, false);
    }
}

