/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import nl.b3p.commons.jpa.JpaUtilServlet;
import nl.b3p.datastorelinker.entity.Database;
import nl.b3p.datastorelinker.entity.Process;
import nl.b3p.datastorelinker.util.Namespaces;
import nl.b3p.datastorelinker.util.Util;
import nl.b3p.geotools.data.linker.ActionFactory;
import nl.b3p.geotools.data.linker.ActionList;
import nl.b3p.geotools.data.linker.ConfigurationException;
import nl.b3p.geotools.data.linker.DataStoreLinkerMail;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.blocks.WritableAction;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import nl.b3p.geotools.data.linker.util.LocalizationUtil;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.Query;
import org.geotools.data.oracle.OracleNGDataStoreFactory;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.wfs.WFSDataStoreFactory;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.PrimaryKey;
import org.jdom2.input.DOMBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.w3c.dom.Element;

public class DataStoreLinker
implements Runnable {
    private static final Log log = LogFactory.getLog(DataStoreLinker.class);
    private static final ResourceBundle resources = LocalizationUtil.getResources();
    public static final String ACTIONLIST_PREFIX = "actionlist";
    public static final String ACTION_PREFIX = "action";
    public static final String TYPE_PREFIX = "type";
    public static final String SETTINGS_PREFIX = "settings";
    public static final String DATASTORE2READ_PREFIX = "read.datastore.";
    public static final String READ_TYPENAME = "read.typename";
    protected static final String DEFAULT_WRITER = "ActionCombo_GeometrySingle_Writer";
    public static String DEFAULT_SMTPHOST = "kmail.b3partners.nl";
    public static String DEFAULT_FROM = "noreply@b3partners.nl";
    protected Status status;
    protected DataStore dataStore2Read;
    protected ActionList actionList;
    protected Properties batch;
    protected Process process;
    protected boolean disposed;
    private int exceptionLogCount = 0;
    private static final int MAX_EXCEPTION_LOG_COUNT = 10;
    public static final String TYPE_ORACLE = "oracle";
    public static final String TYPE_POSTGIS = "postgis";
    public static final String TYPE_WFS = "wfs";

    public synchronized Status getStatus() {
        return this.status;
    }

    public DataStoreLinker(Process process) throws Exception {
        this.init(process);
        this.dataStore2Read = this.openDataStore();
        this.actionList = this.createActionList();
        this.postInit();
    }

    public DataStoreLinker(Properties batch) throws Exception {
        this.init(batch);
        this.dataStore2Read = this.createDataStore2Read(batch);
        this.actionList = this.createActionList(batch);
        this.postInit();
    }

    public DataStoreLinker(Map<String, Object> input, Map<String, Object> actions, Properties batch) throws Exception {
        this.init(batch);
        this.dataStore2Read = DataStoreLinker.openDataStore(input);
        this.actionList = DataStoreLinker.createActionList(actions);
        this.postInit();
    }

    private void init(Process process) throws ConfigurationException, IOException {
        this.process = process;
        this.disposed = false;
        this.status = new Status(process);
    }

    private void init(Properties batch) throws ConfigurationException, IOException {
        this.batch = batch;
        this.disposed = false;
        this.status = new Status(batch);
    }

    private void calculateSizes() throws IOException {
        int totalFeatureSize = 0;
        if (this.dataStore2Read != null) {
            for (String typeName2Read : this.getTypeNames()) {
                SimpleFeatureCollection fc = this.dataStore2Read.getFeatureSource(typeName2Read).getFeatures();
                totalFeatureSize += fc.size();
            }
        }
        this.status.setTotalFeatureSize(totalFeatureSize);
    }

    private void postInit() throws IOException {
        this.calculateSizes();
        log.info((Object)"dsl init complete.");
    }

    @Override
    public void run() {
        try {
            this.process();
        }
        catch (Exception ex) {
            log.error((Object)ex);
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public synchronized void dispose() throws Exception {
        if (!this.disposed) {
            try {
                this.dataStore2Read.dispose();
                this.actionList.close();
            }
            finally {
                this.disposed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() throws Exception {
        if (this.disposed) {
            throw new Exception("Dsl already used. Please create a new instance of this class");
        }
        try {
            for (String typeName2Read : this.getTypeNames()) {
                this.processTypeName(typeName2Read);
            }
        }
        finally {
            try {
                if (this.batch != null) {
                    DataStoreLinkerMail.mail(this.batch, this.status.getNonFatalErrorReport("\n", 3));
                } else if (this.process != null) {
                    DataStoreLinkerMail.mail(this.process, this.status.getNonFatalErrorReport("\n", 3));
                }
            }
            catch (Exception mex) {
                this.status.addNonFatalError(mex.getLocalizedMessage(), "");
            }
            log.info((Object)("Error report: " + this.status.getNonFatalErrorReport("\n", 3)));
            this.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTypeName(String typeName2Read) throws Exception, IOException {
        ContentFeatureSource fs;
        SimpleFeature feature = null;
        String filterName = this.process.getFilter();
        Query query = new Query();
        if (filterName != null) {
            Filter filter = ECQL.toFilter((String)filterName);
            query.setFilter(filter);
        }
        SimpleFeatureCollection fc = this.dataStore2Read.getFeatureSource(typeName2Read).getFeatures(query);
        FeatureIterator iterator = fc.features();
        PrimaryKey pk = null;
        if (this.dataStore2Read != null && this.dataStore2Read instanceof JDBCDataStore && (fs = ((JDBCDataStore)this.dataStore2Read).getFeatureSource(typeName2Read)) instanceof JDBCFeatureStore) {
            pk = ((JDBCFeatureStore)fs).getPrimaryKey();
        }
        Map<Object, Object> properties = null;
        if (this.batch != null) {
            properties = new HashMap<Object, Object>(this.batch);
        } else if (this.process != null) {
            properties = this.process.toOutputMap();
        }
        try {
            while (iterator.hasNext()) {
                try {
                    feature = (SimpleFeature)iterator.next();
                }
                catch (Exception ex) {
                    log.error((Object)"Fout bij inlezen feature ", (Throwable)ex);
                    String id = null;
                    if (feature != null) {
                        id = feature.getID();
                    }
                    this.status.addNonFatalError(ExceptionUtils.getRootCauseMessage((Throwable)ex), id);
                    this.status.incrementVisitedFeatures();
                    continue;
                }
                Map userData = feature.getUserData();
                if (pk != null && userData != null) {
                    userData.put("sourcePks", pk);
                }
                this.processFeature(feature);
                if (this.status.getVisitedFeatures() % 10000 == 0) {
                    log.info((Object)("" + this.status.getVisitedFeatures() + "/" + this.status.getTotalFeatureSize() + " features processed (" + typeName2Read + ")"));
                }
                if (!this.status.isInterrupted()) continue;
                this.actionList.flush(this.status, properties);
                this.actionList.processPostCollectionActions(this.status, properties);
                throw new InterruptedException("User canceled the process.");
            }
            this.actionList.flush(this.status, properties);
            log.info((Object)"Try to do the Post actions");
            this.actionList.processPostCollectionActions(this.status, properties);
            log.info((Object)("Total of: " + this.status.getVisitedFeatures() + " features processed (" + typeName2Read + ")"));
        }
        finally {
            iterator.close();
            JpaUtilServlet.closeThreadEntityManager();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processFeature(SimpleFeature feature) throws Exception {
        if (!this.mustProcessFeature()) {
            return;
        }
        try {
            EasyFeature ef = new EasyFeature(feature);
            if (ef.getFeature().getDefaultGeometry() != null) {
                ef.repairGeometry();
            }
            if (this.actionList.process(ef) == null) {
                // empty if block
            }
        }
        catch (IllegalStateException ex) {
            this.status.addWriteError(ex.getLocalizedMessage(), feature.getID());
            log.error((Object)"Cannot write to datastore: ", (Throwable)ex);
            throw ex;
        }
        catch (Exception e) {
            if (this.exceptionLogCount++ < 10) {
                log.error((Object)("Exception tijdens processen van feature (exception nr. " + this.exceptionLogCount + " van max " + 10 + " die worden gelogd)"), (Throwable)e);
            }
            this.status.addNonFatalError(ExceptionUtils.getRootCauseMessage((Throwable)e), feature.getID());
        }
        this.status.incrementVisitedFeatures();
    }

    private boolean mustProcessFeature() {
        return this.status.getVisitedFeatures() >= this.status.getFeatureStart() && (this.status.getVisitedFeatures() <= this.status.getFeatureEnd() && this.status.getFeatureEnd() >= 0 || this.status.getFeatureEnd() < 0);
    }

    private DataStore createDataStore2Read(Properties batch) throws Exception {
        return DataStoreLinker.openDataStore(DataStoreLinker.propertiesToMaps(batch, DATASTORE2READ_PREFIX));
    }

    private ActionList createActionList() throws Exception {
        ActionList newActionList = new ActionList();
        String outputWriter = null;
        Element actions = this.process.getActions();
        if (actions != null) {
            org.jdom2.Element actionsElement = new DOMBuilder().build(actions);
            for (Object actionObject : actionsElement.getChildren(ACTION_PREFIX, Namespaces.DSL_NAMESPACE)) {
                org.jdom2.Element actionElement = (org.jdom2.Element)actionObject;
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                org.jdom2.Element parametersElement = actionElement.getChild("parameters", Namespaces.DSL_NAMESPACE);
                if (parametersElement != null) {
                    for (Object parameterObject : parametersElement.getChildren("parameter", Namespaces.DSL_NAMESPACE)) {
                        org.jdom2.Element parameterElement = (org.jdom2.Element)parameterObject;
                        String key = parameterElement.getChildTextTrim("paramId", Namespaces.DSL_NAMESPACE);
                        String value = parameterElement.getChildTextTrim("value", Namespaces.DSL_NAMESPACE);
                        parameters.put(key, value);
                    }
                }
                String actionType = actionElement.getChildTextTrim(TYPE_PREFIX, Namespaces.DSL_NAMESPACE);
                if (WritableAction.class.isAssignableFrom(Class.forName("nl.b3p.geotools.data.linker.blocks." + actionType))) {
                    outputWriter = actionType;
                    continue;
                }
                newActionList.add(ActionFactory.createAction(actionType, parameters));
            }
        }
        if (outputWriter == null) {
            newActionList.add(ActionFactory.createAction(DEFAULT_WRITER, this.process.toOutputMap()));
        } else {
            newActionList.add(ActionFactory.createAction(outputWriter, this.process.toOutputMap()));
        }
        log.debug((Object)"Actions to be executed (in this order):");
        for (Action action : newActionList) {
            log.debug((Object)action.getName());
        }
        return newActionList;
    }

    private Boolean parseBoolean(String bool) throws Exception {
        if (bool.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (bool.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        throw new Exception(MessageFormat.format(resources.getString("parseBooleanFailed"), bool));
    }

    private ActionList createActionList(Properties batch) throws Exception {
        Map<String, Object> actionlistParams = DataStoreLinker.propertiesToMaps(batch, "actionlist.action");
        return DataStoreLinker.createActionList(actionlistParams);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ActionList createActionList(Map<String, Object> actionlistParams) throws Exception {
        ActionList actionList = new ActionList();
        int count = 1;
        while (actionlistParams.containsKey(Integer.toString(count))) {
            Map params = (Map)actionlistParams.get(Integer.toString(count));
            if (!params.containsKey(TYPE_PREFIX)) throw new Exception("No type found for action" + Integer.toString(count));
            if (params.containsKey(SETTINGS_PREFIX)) {
                if (!(params.get(TYPE_PREFIX) instanceof String) || !(params.get(SETTINGS_PREFIX) instanceof Map)) throw new Exception("Expected action" + Integer.toString(count) + "." + TYPE_PREFIX + " to be String and " + ACTION_PREFIX + Integer.toString(count) + "." + SETTINGS_PREFIX + " to be a Map");
                actionList.add(ActionFactory.createAction((String)params.get(TYPE_PREFIX), (Map)params.get(SETTINGS_PREFIX)));
            } else {
                if (!(params.get(TYPE_PREFIX) instanceof String)) throw new Exception("Expected action" + Integer.toString(count) + "." + TYPE_PREFIX + " to be String");
                actionList.add(ActionFactory.createAction((String)params.get(TYPE_PREFIX), new HashMap<String, Object>()));
            }
            ++count;
        }
        return actionList;
    }

    private DataStore openDataStore() throws ConfigurationException, Exception {
        Database database = this.process.getInput().getDatabase();
        String file = this.process.getInput().getFile();
        if (database != null) {
            return DataStoreLinker.openDataStore(database);
        }
        if (file != null) {
            return DataStoreLinker.openDataStore(file);
        }
        throw new ConfigurationException("Xml configuration exception: No input database or file specified.");
    }

    public static DataStore openDataStore(Database database) throws ConfigurationException, Exception {
        return DataStoreLinker.openDataStore(database.toGeotoolsDataStoreParametersMap());
    }

    public static DataStore openDataStore(String file) throws ConfigurationException, Exception {
        return DataStoreLinker.openDataStore(Util.fileToMap((File)new File(file)));
    }

    public static DataStore openDataStore(Map params) throws Exception {
        return DataStoreLinker.openDataStore(params, false);
    }

    public static DataStore openDataStore(Map params, boolean createNew) throws Exception {
        log.debug((Object)("openDataStore with: " + params));
        DataStore dataStore = null;
        String dbType = (String)params.get("dbtype");
        if (dbType != null && dbType.equals(TYPE_ORACLE)) {
            params.put(OracleNGDataStoreFactory.EXPOSE_PK.key, Boolean.TRUE);
            params.put("min connections", 0);
            params.put("max connections", 50);
            params.put("connection timeout", 60);
            params.put("validate connections", Boolean.FALSE);
            log.debug((Object)("Created OracleNGDataStoreFactory with: " + params));
            return new OracleNGDataStoreFactory().createDataStore(params);
        }
        if (dbType != null && dbType.equals(TYPE_POSTGIS)) {
            params.put(PostgisNGDataStoreFactory.EXPOSE_PK.key, Boolean.TRUE);
            params.put("min connections", 0);
            params.put("max connections", 50);
            params.put("connection timeout", 60);
            params.put("validate connections", Boolean.FALSE);
            log.debug((Object)("Created PostgisNGDataStoreFactory with: " + params));
            return new PostgisNGDataStoreFactory().createDataStore(params);
        }
        if (dbType != null && dbType.equals(TYPE_WFS)) {
            log.debug((Object)("Created WFSDataStoreFactory with: " + params));
            return new WFSDataStoreFactory().createDataStore(params);
        }
        String errormsg = "DataStore could not be found using parameters";
        try {
            dataStore = DataStoreFinder.getDataStore((Map)params);
            if (dataStore == null && createNew && params.containsKey("url")) {
                String url = (String)params.get("url");
                if (url.lastIndexOf(".shp") == url.length() - ".shp".length()) {
                    ShapefileDataStoreFactory factory = new ShapefileDataStoreFactory();
                    params.put("url", new File(url).toURI());
                    dataStore = factory.createNewDataStore(params);
                } else {
                    log.warn((Object)"Can not create a new datastore, filetype unknown.");
                }
            }
        }
        catch (NullPointerException nullEx) {
            if (!DataStoreLinker.urlExists(params)) {
                throw new Exception("URL in parameters seems to point to a non-existing file \n\n" + params.toString());
            }
            throw new Exception(errormsg + " " + params.toString());
        }
        if (dataStore == null) {
            if (!DataStoreLinker.urlExists(params)) {
                throw new Exception("URL in parameters may point to a non-existing file \n\n" + params.toString());
            }
            throw new Exception("DataStoreFinder returned null for \n\n" + params.toString());
        }
        log.debug((Object)("DataStore class: " + dataStore.getClass()));
        return dataStore;
    }

    private static boolean urlExists(Map params) {
        try {
            if (params.containsKey("url")) {
                if (params.get("url") instanceof URL) {
                    URL url = (URL)params.get("url");
                    log.debug((Object)("Checking url exists: " + url));
                    File file = new File(url.toURI());
                    log.debug((Object)("Checking file url exists: " + file.getAbsolutePath()));
                    return file.exists();
                }
                if (params.get("url") instanceof String) {
                    String url = params.get("url").toString();
                    log.debug((Object)("Checking url exists: " + url));
                    File file = new File(url);
                    log.debug((Object)("Checking file url exists: " + file.getAbsolutePath()));
                    return file.exists();
                }
            }
        }
        catch (URISyntaxException uriEx) {
            return false;
        }
        return true;
    }

    public static String getSaveProp(Properties batch, String key, String defaultValue) {
        if (batch.containsKey(key)) {
            return batch.getProperty(key);
        }
        return defaultValue;
    }

    public static Map<String, Object> propertiesToMaps(Properties batch, String filter) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String string : batch.keySet()) {
            if (!string.startsWith(filter)) continue;
            String value = batch.getProperty(string);
            String keypart = string.substring(filter.length());
            Map<String, Object> stepIn = map;
            while (keypart.contains(".")) {
                String step = keypart.substring(0, keypart.indexOf("."));
                keypart = keypart.substring(keypart.indexOf(".") + 1);
                if (stepIn.containsKey(step)) {
                    if (stepIn.get(step) instanceof Map) {
                        stepIn = (Map)stepIn.get(step);
                        continue;
                    }
                    throw new IOException("Tried to save settingsMap for property '" + string + "', but property has already a value?\nValue = '" + stepIn.get(step).toString() + "'");
                }
                HashMap newStep = new HashMap();
                stepIn.put(step, newStep);
                stepIn = newStep;
            }
            if (value.toLowerCase().equals("false")) {
                stepIn.put(keypart, false);
                continue;
            }
            if (value.toLowerCase().equals("true")) {
                stepIn.put(keypart, true);
                continue;
            }
            if (keypart.toLowerCase().equals("url")) {
                File file = new File(value);
                if (file.exists()) {
                    stepIn.put(keypart, file.toURI());
                    continue;
                }
                stepIn.put(keypart, value);
                continue;
            }
            stepIn.put(keypart, value);
        }
        return map;
    }

    private String[] getTypeNames() throws IOException {
        String[] typenames = null;
        if (this.batch != null && this.batch.containsKey(READ_TYPENAME)) {
            typenames = new String[]{this.batch.getProperty(READ_TYPENAME)};
        } else if (this.process != null && this.process.getInput().getTableName() != null) {
            typenames = new String[]{this.process.getInput().getTableName()};
        }
        if (typenames == null) {
            typenames = this.dataStore2Read.getTypeNames();
        }
        return typenames;
    }
}

