/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class ActionGeometry_RemoveDuplicateVertices
extends Action {
    public static List<List<String>> getConstructors() {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        constructors.add(Collections.EMPTY_LIST);
        return constructors;
    }

    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        MultiLineString ml;
        Object geometry = feature.getFeature().getDefaultGeometry();
        if (geometry instanceof Polygon) {
            Polygon p = ActionGeometry_RemoveDuplicateVertices.removeDuplicateVertices((Polygon)geometry);
            if (p != null) {
                feature.getFeature().setDefaultGeometry((Object)p);
            }
        } else if (geometry instanceof MultiPolygon) {
            MultiPolygon mp = (MultiPolygon)ActionGeometry_RemoveDuplicateVertices.removeDuplicateVerticesMultiGeometry((GeometryCollection)((MultiPolygon)geometry));
            if (mp != null) {
                feature.getFeature().setDefaultGeometry((Object)mp);
            }
        } else if (geometry instanceof LineString) {
            LineString l = ActionGeometry_RemoveDuplicateVertices.removeDuplicateVertices((LineString)geometry);
            if (l != null) {
                feature.getFeature().setDefaultGeometry((Object)l);
            }
        } else if (geometry instanceof MultiLineString && (ml = (MultiLineString)ActionGeometry_RemoveDuplicateVertices.removeDuplicateVerticesMultiGeometry((GeometryCollection)((MultiLineString)geometry))) != null) {
            feature.getFeature().setDefaultGeometry((Object)ml);
        }
        return feature;
    }

    private static GeometryCollection removeDuplicateVerticesMultiGeometry(GeometryCollection gc) {
        boolean isChanged = false;
        Geometry[] geometries = new Geometry[gc.getNumGeometries()];
        for (int i = 0; i < geometries.length; ++i) {
            Object g;
            geometries[i] = g = gc.getGeometryN(i);
            if ((g = g instanceof Polygon ? ActionGeometry_RemoveDuplicateVertices.removeDuplicateVertices((Polygon)g) : ActionGeometry_RemoveDuplicateVertices.removeDuplicateVertices((LineString)g)) == null) continue;
            isChanged = true;
            geometries[i] = g;
        }
        if (isChanged) {
            if (gc instanceof MultiPolygon) {
                Polygon[] polys = new Polygon[geometries.length];
                System.arraycopy(geometries, 0, polys, 0, geometries.length);
                return gc.getFactory().createMultiPolygon(polys);
            }
            LineString[] lines = new LineString[geometries.length];
            System.arraycopy(geometries, 0, lines, 0, geometries.length);
            return gc.getFactory().createMultiLineString(lines);
        }
        return null;
    }

    private static Polygon removeDuplicateVertices(Polygon p) {
        int i;
        LinearRing exterior = ActionGeometry_RemoveDuplicateVertices.removeDuplicateVertices(p.getExteriorRing());
        LinearRing[] interiorRings = new LinearRing[p.getNumInteriorRing()];
        boolean interiorRingChanged = false;
        for (i = 0; i < interiorRings.length; ++i) {
            interiorRings[i] = ActionGeometry_RemoveDuplicateVertices.removeDuplicateVertices(p.getInteriorRingN(i));
            interiorRingChanged |= interiorRings[i] != null;
        }
        if (interiorRingChanged || exterior != null) {
            if (exterior == null) {
                exterior = p.getExteriorRing();
            }
            for (i = 0; i < interiorRings.length; ++i) {
                if (interiorRings[i] != null) continue;
                interiorRings[i] = p.getInteriorRingN(i);
            }
            return p.getFactory().createPolygon(exterior, interiorRings);
        }
        return null;
    }

    private static LineString removeDuplicateVertices(LineString line) {
        Coordinate[] coords = ActionGeometry_RemoveDuplicateVertices.removeDuplicateVertices(line.getCoordinates());
        if (coords == null) {
            return null;
        }
        return line.getFactory().createLineString(coords);
    }

    private static LinearRing removeDuplicateVertices(LinearRing ring) {
        Coordinate[] coords = ActionGeometry_RemoveDuplicateVertices.removeDuplicateVertices(ring.getCoordinates());
        if (coords == null) {
            return null;
        }
        return ring.getFactory().createLinearRing(coords);
    }

    private static Coordinate[] removeDuplicateVertices(Coordinate[] vertices) {
        int i;
        if (vertices.length < 3) {
            return null;
        }
        for (i = 1; i < vertices.length && !vertices[i].equals((Object)vertices[i - 1]); ++i) {
        }
        if (i == vertices.length) {
            return null;
        }
        Coordinate c = vertices[i];
        int j = i++;
        while (true) {
            if (i < vertices.length && vertices[i].equals((Object)c)) {
                ++i;
                continue;
            }
            if (i == vertices.length) break;
            c = vertices[i++];
            vertices[j++] = c;
            if (i >= vertices.length) break;
        }
        Coordinate[] fixed = new Coordinate[j];
        System.arraycopy(vertices, 0, fixed, 0, j);
        return fixed;
    }

    @Override
    public String toString() {
        return "remove duplicate vertices";
    }

    @Override
    public String getDescription_NL() {
        return "Verwijder uit lijnen en vlakken dubbele opeenvolgende vertices";
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
    }

    @Override
    public void processPostCollectionActions(Status status, Map properties) throws Exception {
    }
}

