/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import nl.b3p.geotools.data.linker.Status;
import nl.b3p.geotools.data.linker.blocks.Action;
import nl.b3p.geotools.data.linker.feature.EasyFeature;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class ActionGeometry_VertexPrecisionThreshold
extends Action {
    private static final Log log = LogFactory.getLog(ActionGeometry_VertexPrecisionThreshold.class);
    private static final RoundingMode rm = RoundingMode.FLOOR;
    private int scale = 2;
    private boolean floatPrecision = false;

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setFloatPrecision(boolean floatPrecision) {
        this.floatPrecision = floatPrecision;
    }

    public static List<List<String>> getConstructors() {
        ArrayList<List<String>> constructors = new ArrayList<List<String>>();
        constructors.add(Arrays.asList("scale", "float_precision"));
        return constructors;
    }

    @Override
    public EasyFeature execute(EasyFeature feature) throws Exception {
        Geometry geometry = (Geometry)feature.getFeature().getDefaultGeometry();
        if (geometry == null) {
            return feature;
        }
        if (geometry instanceof Point || geometry instanceof MultiPoint) {
            return feature;
        }
        if (!(geometry instanceof GeometryCollection)) {
            if (ActionGeometry_VertexPrecisionThreshold.verticesBelowPrecisionThreshold(geometry.getCoordinates(), this.scale, this.floatPrecision)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("feature below precision threshold, removing: " + geometry.toString()));
                }
                return null;
            }
            return feature;
        }
        GeometryCollection gc = (GeometryCollection)geometry;
        if (gc.isEmpty()) {
            return feature;
        }
        ArrayList<Geometry> features = new ArrayList<Geometry>();
        boolean haveFeaturesToRemove = false;
        for (int i = 0; i < gc.getNumGeometries(); ++i) {
            Geometry g = gc.getGeometryN(i);
            if (!ActionGeometry_VertexPrecisionThreshold.verticesBelowPrecisionThreshold(g.getCoordinates(), this.scale, this.floatPrecision)) {
                features.add(g);
                continue;
            }
            haveFeaturesToRemove = true;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("geometry #" + (i + 1) + " from geometrycollection is below precision threshold: " + g.toString()));
        }
        if (!haveFeaturesToRemove) {
            return feature;
        }
        if (features.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("all features from geometrycollection below precision threshold, removing entire feature: " + geometry.toString()));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("rebuilding geometrycollection without features below precision threshold; " + features.size() + " of " + gc.getNumGeometries() + " remain"));
            log.debug((Object)("original geometrycollection: " + geometry.toString()));
        }
        if (gc instanceof MultiPolygon) {
            geometry = geometry.getFactory().createMultiPolygon(features.toArray(new Polygon[0]));
        } else if (gc instanceof MultiLineString) {
            geometry = geometry.getFactory().createMultiLineString(features.toArray(new LineString[0]));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("rebuilt geometrycollection: " + geometry.toString()));
        }
        String geometryName = feature.getFeature().getDefaultGeometryProperty().getDescriptor().getLocalName();
        feature.setAttribute(geometryName, (Object)geometry);
        return feature;
    }

    public static boolean verticesBelowPrecisionThreshold(Coordinate[] vertices, int scale, boolean floatPrecision) {
        BigDecimal x = null;
        BigDecimal y = null;
        for (int i = 0; i < vertices.length; ++i) {
            BigDecimal cy;
            BigDecimal cx;
            Coordinate c = vertices[i];
            if (floatPrecision) {
                cx = new BigDecimal((float)c.x).setScale(scale, rm);
                cy = new BigDecimal((float)c.y).setScale(scale, rm);
            } else {
                cx = new BigDecimal(c.x).setScale(scale, rm);
                cy = new BigDecimal(c.y).setScale(scale, rm);
            }
            if (x == null) {
                x = cx;
                y = cy;
                continue;
            }
            if (cx.equals(x) && cy.equals(y)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "vertex precision threshold";
    }

    @Override
    public String getDescription_NL() {
        return "Verwijder geometrie waarvan de coordinaten van alle vertices bij een bepaalde precisie niet verschillen";
    }

    @Override
    public void flush(Status status, Map properties) throws Exception {
    }

    @Override
    public void processPostCollectionActions(Status status, Map properties) throws Exception {
    }
}

