/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.blocks;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Map;
import nl.b3p.geotools.data.linker.blocks.CollectionAction_PolygonizeWithAttr;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.jdbc.JDBCDataStore;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;

public class CollectionAction_PolygonizeSufLki
extends CollectionAction_PolygonizeWithAttr {
    protected static final Log log = LogFactory.getLog(CollectionAction_PolygonizeSufLki.class);

    public CollectionAction_PolygonizeSufLki(DataStore dataStore2Write, Map properties) throws Exception {
        super(dataStore2Write, properties);
        if (this.getCqlFilterString() == null) {
            StringBuffer cqlFilter = new StringBuffer();
            cqlFilter.append("(");
            cqlFilter.append("gemeentecode_perceel_links");
            cqlFilter.append(" = [gemeentecode] AND ");
            cqlFilter.append("sectie_perceel_links");
            cqlFilter.append(" = [sectie] AND ");
            cqlFilter.append("perceelnummer_perceel_links");
            cqlFilter.append(" = [perceelnummer] AND ");
            cqlFilter.append("indexnummer_perceel_links");
            cqlFilter.append(" =[indexnummer]) OR (");
            cqlFilter.append("gemeentecode_perceel_rechts");
            cqlFilter.append(" = [gemeentecode] AND ");
            cqlFilter.append("sectie_perceel_rechts");
            cqlFilter.append(" = [sectie] AND ");
            cqlFilter.append("perceelnummer_perceel_rechts");
            cqlFilter.append(" =[perceelnummer] AND ");
            cqlFilter.append("indexnummer_perceel_rechts");
            cqlFilter.append(" =[indexnummer])");
            this.setCqlFilterString(cqlFilter.toString());
        }
    }

    @Override
    public Boolean isPositivePolygon(Polygon polygon, ArrayList<SimpleFeature> correctLineFeatures, SimpleFeature feature) {
        String perceelNummer = feature.getAttribute("perceelnummer").toString();
        Coordinate[] polyCoords = polygon.getCoordinates();
        for (int l = 0; l < correctLineFeatures.size(); ++l) {
            SimpleFeature lineFeature = correctLineFeatures.get(l);
            Geometry lineGeom = (Geometry)lineFeature.getDefaultGeometryProperty().getValue();
            if (!lineGeom.touches((Geometry)polygon)) continue;
            Coordinate[] lineCoords = lineGeom.getCoordinates();
            for (int pc = 0; pc < polyCoords.length; ++pc) {
                int afterIndex;
                if (!polyCoords[pc].equals((Object)lineCoords[0])) continue;
                int beforeIndex = pc - 1;
                if (beforeIndex < 0) {
                    beforeIndex = polyCoords.length - 1;
                }
                if ((afterIndex = pc + 1) >= polyCoords.length) {
                    afterIndex = 0;
                }
                if (lineCoords[1].equals((Object)polyCoords[afterIndex])) {
                    if (lineFeature.getAttribute("perceelnummer_perceel_links") != null && lineFeature.getAttribute("perceelnummer_perceel_links").toString().equals(perceelNummer)) {
                        return false;
                    }
                    if (lineFeature.getAttribute("perceelnummer_perceel_rechts") == null || !lineFeature.getAttribute("perceelnummer_perceel_rechts").toString().equals(perceelNummer)) continue;
                    return true;
                }
                if (!lineCoords[1].equals((Object)polyCoords[beforeIndex])) continue;
                if (lineFeature.getAttribute("perceelnummer_perceel_links") != null && lineFeature.getAttribute("perceelnummer_perceel_links").toString().equals(perceelNummer)) {
                    return true;
                }
                if (lineFeature.getAttribute("perceelnummer_perceel_rechts") == null || !lineFeature.getAttribute("perceelnummer_perceel_rechts").toString().equals(perceelNummer)) continue;
                return false;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preExecute() {
        if (this.getDataStore2Write() instanceof JDBCDataStore) {
            JDBCDataStore jdbcDS = (JDBCDataStore)this.getDataStore2Write();
            DefaultTransaction t = new DefaultTransaction();
            try {
                Connection connection = jdbcDS.getConnection((Transaction)t);
                String query = "CREATE INDEX ";
                query = query + this.getLineFeatureName() + "_" + "perceelnummer_perceel_links";
                query = query + " ON " + this.getLineFeatureName();
                query = query + "(perceelnummer_perceel_links)";
                PreparedStatement statement = connection.prepareStatement(query);
                statement.executeUpdate();
                query = "CREATE INDEX ";
                query = query + this.getLineFeatureName() + "_" + "perceelnummer_perceel_rechts";
                query = query + " ON " + this.getLineFeatureName();
                query = query + "(perceelnummer_perceel_rechts)";
                statement = connection.prepareStatement(query);
                statement.executeUpdate();
                t.commit();
            }
            catch (Exception ex) {
                log.error((Object)"Error while creating index: ", (Throwable)ex);
            }
            finally {
                try {
                    t.close();
                }
                catch (IOException e) {
                    log.error((Object)"Error closing connection-transaction", (Throwable)e);
                }
            }
        }
    }
}

