/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.geotools.data.linker.poi;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;

public class ExcelReader {
    private final DecimalFormatSymbols symbols = new DecimalFormatSymbols();
    public static final Locale LOCALE_NL = new Locale("nl", "NL");
    public static final String DATE_FORMAT = "dd-MM-yyyy";

    private HSSFWorkbook readFile(String fileName) throws FileNotFoundException, IOException {
        return new HSSFWorkbook((InputStream)new FileInputStream(fileName));
    }

    public List<String> getRecord(String fileName, Integer index, String searchValue) throws FileNotFoundException, IOException {
        ArrayList<String> record = new ArrayList<String>();
        HSSFWorkbook wb = this.readFile(fileName);
        for (int k = 0; k < wb.getNumberOfSheets(); ++k) {
            HSSFSheet sheet = wb.getSheetAt(k);
            int rows = sheet.getPhysicalNumberOfRows();
            block13: for (int r = 0; r < rows; ++r) {
                HSSFRow row = sheet.getRow(r);
                if (row == null) continue;
                int cells = row.getPhysicalNumberOfCells();
                for (int c = 0; c < cells; ++c) {
                    HSSFCell cell = row.getCell(c);
                    String value = null;
                    if (cell == null) continue;
                    switch (cell.getCellType()) {
                        case FORMULA: {
                            value = cell.getCellFormula();
                            break;
                        }
                        case NUMERIC: {
                            value = String.valueOf((int)cell.getNumericCellValue());
                            break;
                        }
                        case STRING: {
                            value = cell.getStringCellValue();
                            break;
                        }
                    }
                    if (r == 0 && index > -1) {
                        record.add(value);
                    }
                    if (value == null || c != index || !value.equalsIgnoreCase(searchValue)) continue;
                    for (int d = 0; d < cells; ++d) {
                        HSSFCell tempCell = row.getCell(d);
                        if (tempCell == null) {
                            record.add(null);
                            continue;
                        }
                        switch (tempCell.getCellType()) {
                            case FORMULA: {
                                try {
                                    String temp;
                                    value = temp = tempCell.getStringCellValue();
                                }
                                catch (IllegalStateException ise) {
                                    double num = tempCell.getNumericCellValue();
                                    value = Double.toString(num);
                                }
                                break;
                            }
                            case NUMERIC: {
                                HSSFCellStyle style = tempCell.getCellStyle();
                                if (HSSFDateUtil.isCellDateFormatted((Cell)tempCell)) {
                                    value = this.getDateValue(tempCell);
                                    break;
                                }
                                value = this.getNumericValue(tempCell).toString();
                                break;
                            }
                            case STRING: {
                                value = tempCell.getStringCellValue();
                                break;
                            }
                            default: {
                                value = null;
                            }
                        }
                        record.add(value);
                    }
                    continue block13;
                }
            }
        }
        return record;
    }

    public List<String> getColumns(String fileName) throws FileNotFoundException, IOException {
        ArrayList<String> columns = new ArrayList<String>();
        HSSFWorkbook wb = this.readFile(fileName);
        for (int k = 0; k < wb.getNumberOfSheets(); ++k) {
            HSSFSheet sheet = wb.getSheetAt(k);
            int rows = sheet.getPhysicalNumberOfRows();
            for (int r = 0; r < 1; ++r) {
                HSSFRow row = sheet.getRow(r);
                if (row == null) continue;
                int cells = row.getPhysicalNumberOfCells();
                for (int c = 0; c < cells; ++c) {
                    HSSFCell cell = row.getCell(c);
                    String value = null;
                    if (cell == null) continue;
                    switch (cell.getCellType()) {
                        case FORMULA: {
                            value = cell.getCellFormula();
                            break;
                        }
                        case NUMERIC: {
                            value = String.valueOf((int)cell.getNumericCellValue());
                            break;
                        }
                        case STRING: {
                            value = cell.getStringCellValue();
                            break;
                        }
                    }
                    if (value == null) continue;
                    columns.add(value.toLowerCase());
                }
            }
        }
        return columns;
    }

    protected Object getDateValueFromJavaNumber(HSSFCell cell) {
        double numericValue = cell.getNumericCellValue();
        BigDecimal numericValueBd = new BigDecimal(String.valueOf(numericValue));
        numericValueBd = this.stripTrailingZeros(numericValueBd);
        return numericValueBd.longValue();
    }

    protected String getDateValue(HSSFCell cell) {
        double numericValue = cell.getNumericCellValue();
        Date date = HSSFDateUtil.getJavaDate((double)numericValue);
        long tzOffset = TimeZone.getDefault().getOffset(date.getTime());
        date = new Date(date.getTime() + tzOffset);
        return new SimpleDateFormat(DATE_FORMAT, LOCALE_NL).format(date);
    }

    private BigDecimal stripTrailingZeros(BigDecimal value) {
        if (value.scale() <= 0) {
            return value;
        }
        String valueAsString = String.valueOf(value);
        int idx = valueAsString.indexOf(".");
        if (idx == -1) {
            return value;
        }
        for (int i = valueAsString.length() - 1; i > idx; --i) {
            if (valueAsString.charAt(i) != '0') {
                if (valueAsString.charAt(i) != '.') break;
                valueAsString = valueAsString.substring(0, i);
                break;
            }
            valueAsString = valueAsString.substring(0, i);
        }
        BigDecimal result = new BigDecimal(valueAsString);
        return result;
    }

    protected BigDecimal getNumericValue(HSSFCell cell) {
        BigDecimal result;
        String formatString = cell.getCellStyle().getDataFormatString();
        String resultString = null;
        double cellValue = cell.getNumericCellValue();
        if (formatString != null && !formatString.equals("General") && !formatString.equals("@")) {
            DecimalFormat nf = new DecimalFormat(formatString, this.symbols);
            resultString = nf.format(cellValue);
        }
        if (resultString != null) {
            try {
                result = new BigDecimal(resultString);
            }
            catch (NumberFormatException e) {
                result = this.toBigDecimal(cellValue);
            }
        } else {
            result = this.toBigDecimal(cellValue);
        }
        return result;
    }

    private BigDecimal toBigDecimal(double cellValue) {
        String resultString = String.valueOf(cellValue);
        if (resultString.endsWith(".0")) {
            resultString = resultString.substring(0, resultString.length() - 2);
        }
        BigDecimal result = new BigDecimal(resultString);
        return result;
    }
}

