/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import com.vividsolutions.jts.geom.Geometry;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.b3p.combineimages.CombineImagesServlet;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.gis.geotools.DataStoreUtil;
import nl.b3p.gis.geotools.FilterBuilder;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.viewer.AdminDataRowBean;
import nl.b3p.gis.viewer.BaseGisAction;
import nl.b3p.gis.viewer.ImageAction;
import nl.b3p.gis.viewer.admindata.CollectAdmindata;
import nl.b3p.gis.viewer.db.CMSPagina;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.ThemaData;
import nl.b3p.gis.viewer.db.Themas;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.services.SpatialUtil;
import nl.b3p.imagetool.CombineImageSettings;
import nl.b3p.zoeker.configuratie.Bron;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.hibernate.classic.Session;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetViewerDataAction
extends BaseGisAction {
    private static final Log logger = LogFactory.getLog(GetViewerDataAction.class);
    protected static final String ADMINDATA = "admindata";
    protected static final String AANVULLENDEINFO = "aanvullendeinfo";
    protected static final String METADATA = "metadata";
    protected static final String OBJECTDATA = "objectdata";
    protected static final String ADMINDATAFW = "admindata";
    protected static final String PK_FIELDNAME_PARAM = "pkFieldName";

    protected Map getActionMethodPropertiesMap() {
        HashMap<String, ExtendedMethodProperties> map = new HashMap<String, ExtendedMethodProperties>();
        ExtendedMethodProperties hibProp = null;
        hibProp = new ExtendedMethodProperties(OBJECTDATA);
        hibProp.setDefaultForwardName("success");
        hibProp.setAlternateForwardName("failure");
        hibProp.setAlternateMessageKey("error.objectdata.failed");
        map.put(OBJECTDATA, hibProp);
        hibProp = new ExtendedMethodProperties("admindata");
        hibProp.setDefaultForwardName("success");
        hibProp.setAlternateForwardName("failure");
        hibProp.setAlternateMessageKey("error.admindata.failed");
        map.put("admindata", hibProp);
        hibProp = new ExtendedMethodProperties(AANVULLENDEINFO);
        hibProp.setDefaultForwardName("success");
        hibProp.setAlternateForwardName("failure");
        hibProp.setAlternateMessageKey("error.aanvullende.failed");
        map.put(AANVULLENDEINFO, hibProp);
        hibProp = new ExtendedMethodProperties(METADATA);
        hibProp.setDefaultForwardName("success");
        hibProp.setAlternateForwardName("failure");
        hibProp.setAlternateMessageKey("error.metadata.failed");
        map.put(METADATA, hibProp);
        return map;
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("success");
    }

    public ActionForward admindata(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        logger.debug((Object)"Entering admindata");
        ArrayList themas = this.getThemas(mapping, dynaForm, request);
        List ggbBeans = new ArrayList();
        if (themas != null) {
            ggbBeans = CollectAdmindata.collectGegevensbronRecordChilds(request, themas, false);
        }
        request.setAttribute("beans", ggbBeans);
        boolean onlyFeaturesInGeom = true;
        if (FormUtils.nullIfEmpty((String)request.getParameter("onlyFeaturesInGeom")) != null) {
            try {
                onlyFeaturesInGeom = Boolean.parseBoolean(request.getParameter("onlyFeaturesInGeom"));
            }
            catch (Exception e) {
                logger.error((Object)"Param 'onlyFeaturesInGeom' is not a boolean", (Throwable)e);
            }
        }
        String bookmarkAppcode = null;
        if (FormUtils.nullIfEmpty((String)request.getParameter("bookmarkAppcode")) != null) {
            bookmarkAppcode = request.getParameter("bookmarkAppcode");
        }
        request.setAttribute("onlyFeaturesInGeom", (Object)onlyFeaturesInGeom);
        request.setAttribute("bookmarkAppcode", (Object)bookmarkAppcode);
        this.setCMSTheme(request);
        return mapping.findForward("admindata");
    }

    public ActionForward aanvullendeinfo(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Gegevensbron gb = this.getGegevensbron(mapping, dynaForm, request);
        if (gb == null) {
            return mapping.findForward(AANVULLENDEINFO);
        }
        boolean addKaart = false;
        if (FormUtils.nullIfEmpty((String)request.getParameter("addKaart")) != null) {
            addKaart = true;
        }
        if (addKaart) {
            CombineImageSettings settings = ImageAction.getCombineImageSettings(request);
            String imageId = CombineImagesServlet.uniqueName((String)"");
            request.getSession().setAttribute(imageId, (Object)settings);
            request.setAttribute("imageId", (Object)imageId);
        }
        String appCode = request.getParameter("appCode");
        String gegevensbronId = request.getParameter("gegevensbronid");
        if (gegevensbronId != null) {
            gb = SpatialUtil.getGegevensbron(gegevensbronId);
            String fkId = request.getParameter("id");
            request.setAttribute("fkId", (Object)fkId);
        }
        List<ThemaData> thema_items = SpatialUtil.getThemaData(gb, false);
        request.setAttribute("thema_items", thema_items);
        Bron b = gb.getBron(request);
        if (b != null) {
            request.setAttribute("regels", (Object)this.getThemaObjectsWithId(gb, thema_items, request, appCode));
        }
        this.setCMSTheme(request);
        return mapping.findForward(AANVULLENDEINFO);
    }

    public ActionForward metadata(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Themas t = this.getThema(mapping, dynaForm, request);
        request.setAttribute("themas", (Object)t);
        return mapping.findForward(METADATA);
    }

    public ActionForward objectdata(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String appCode = request.getParameter("bookmarkAppcode");
        request.setAttribute("appCode", (Object)appCode);
        ArrayList<Themas> locatieThemas = new ArrayList<Themas>();
        ArrayList themas = this.getThemas(mapping, dynaForm, request);
        if (themas != null) {
            for (Themas t : themas) {
                if (!t.isLocatie_thema()) continue;
                locatieThemas.add(t);
            }
        }
        List ggbBeans = new ArrayList();
        if (locatieThemas.size() > 0) {
            ggbBeans = CollectAdmindata.collectGegevensbronRecordChilds(request, locatieThemas, false);
        }
        request.setAttribute("ggbBeans", ggbBeans);
        this.setCMSTheme(request);
        return mapping.findForward(OBJECTDATA);
    }

    private void setCMSTheme(HttpServletRequest request) {
        String param = request.getParameter("cmsPageId");
        Integer cmsPageId = null;
        if (param != null && !param.isEmpty()) {
            cmsPageId = new Integer(param);
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        CMSPagina cmsPage = null;
        if (cmsPageId != null && cmsPageId > 0) {
            cmsPage = (CMSPagina)sess.get(CMSPagina.class, (Serializable)cmsPageId);
        }
        if (cmsPage != null && cmsPage.getThema() != null && !cmsPage.getThema().equals("")) {
            request.setAttribute("theme", (Object)cmsPage.getThema());
        }
    }

    private void collectThemaRegels(ActionMapping mapping, HttpServletRequest request, List themas, List regels, List ti, boolean locatie, String appCode) {
        for (int i = 0; i < themas.size(); ++i) {
            GisPrincipal user;
            Themas t = (Themas)themas.get(i);
            if (locatie && !t.isLocatie_thema() || !t.hasValidAdmindataSource(user = GisPrincipal.getGisPrincipal(request))) continue;
            try {
                Gegevensbron gb = t.getGegevensbron();
                List<ThemaData> thema_items = SpatialUtil.getThemaData(gb, true);
                int themadatanummer = 0;
                themadatanummer = ti.size();
                for (int a = 0; a < ti.size(); ++a) {
                    if (!this.compareThemaDataLists((List)ti.get(a), thema_items)) continue;
                    themadatanummer = a;
                    break;
                }
                Bron b = gb.getBron(request);
                List<AdminDataRowBean> l = null;
                if (b != null) {
                    if (themadatanummer == regels.size()) {
                        regels.add(new ArrayList());
                    }
                    l = this.getThemaObjectsWithGeom(t, thema_items, request, appCode);
                }
                if (l == null || l.size() <= 0) continue;
                ((ArrayList)regels.get(themadatanummer)).addAll(l);
                if (themadatanummer != ti.size()) continue;
                ti.add(thema_items);
                continue;
            }
            catch (Exception e) {
                String mapserver4Hack = "msQueryByRect(): Search returned no results. No matching record(s) found.";
                if (mapserver4Hack.equalsIgnoreCase(e.getMessage())) continue;
                String msg = e.getMessage();
                if (msg != null) {
                    if (msg.contains("PropertyDescriptor is null - did you request a property that does not exist?")) {
                        msg = "U vraagt een attribuut op dat niet bestaat, waarschijnlijk is de configuratie niet in orde, raadpleeg de beheerder!";
                    }
                } else {
                    msg = "Kon objectinfo niet ophalen.";
                }
                logger.error((Object)("Fout bij laden admindata voor thema: " + t.getNaam() + ":"), (Throwable)e);
                this.addAlternateMessage(mapping, request, "", "thema: " + t.getNaam() + ", " + msg);
            }
        }
    }

    private List<AdminDataRowBean> getThemaObjectsWithGeom(Themas t, List<ThemaData> thema_items, HttpServletRequest request, String appCode) throws Exception {
        if (t == null) {
            return null;
        }
        if (thema_items == null || thema_items.isEmpty()) {
            return null;
        }
        Geometry geom = CollectAdmindata.getGeometry(request);
        Filter extraFilter = CollectAdmindata.getExtraFilter(t, request);
        Gegevensbron gb = t.getGegevensbron();
        Bron b = gb.getBron(request);
        List<String> propnames = DataStoreUtil.basisRegelThemaData2PropertyNames(thema_items);
        Integer maximum = ConfigKeeper.getMaxNumberOfFeatures(appCode);
        ArrayList<Feature> features = DataStoreUtil.getFeatures(b, gb, geom, extraFilter, propnames, maximum, true);
        ArrayList<AdminDataRowBean> regels = new ArrayList<AdminDataRowBean>();
        for (int i = 0; i < features.size(); ++i) {
            Feature f = (Feature)features.get(i);
            regels.add(this.getRegel(f, gb, thema_items));
        }
        return regels;
    }

    protected List getThemaObjectsWithId(Gegevensbron gb, List thema_items, HttpServletRequest request, String appCode) throws Exception {
        if (gb == null) {
            return null;
        }
        if (thema_items == null || thema_items.isEmpty()) {
            return null;
        }
        String adminPk = DataStoreUtil.convertColumnNameToQName(gb.getAdmin_pk()).getLocalPart();
        String id = null;
        Filter filter = null;
        if (adminPk != null) {
            id = request.getParameter(adminPk);
            String fkField = gb.getAdmin_fk();
            String fkId = null;
            if (fkField != null && (fkId = (String)request.getAttribute("fkId")) != null) {
                filter = FilterBuilder.createEqualsFilter(fkField, fkId);
            }
            if (id != null && fkId == null) {
                filter = FilterBuilder.createEqualsFilter(adminPk, id);
            } else {
                String primaryKeys = request.getParameter("primaryKeys");
                if (primaryKeys != null) {
                    String[] primaryKeysArray = primaryKeys.split(",");
                    filter = FilterBuilder.createOrEqualsFilter(adminPk, primaryKeysArray);
                }
            }
        }
        ArrayList<AdminDataRowBean> regels = new ArrayList<AdminDataRowBean>();
        boolean addKaart = false;
        if (FormUtils.nullIfEmpty((String)request.getParameter("addKaart")) != null) {
            addKaart = true;
        }
        ArrayList<ReferencedEnvelope> kaartEnvelopes = new ArrayList<ReferencedEnvelope>();
        Bron b = gb.getBron(request);
        List<String> propnames = DataStoreUtil.themaData2PropertyNames(thema_items);
        Integer maximum = ConfigKeeper.getMaxNumberOfFeatures(appCode);
        ArrayList<Feature> features = DataStoreUtil.getFeatures(b, gb, null, filter, propnames, maximum, true);
        for (int i = 0; i < features.size(); ++i) {
            ReferencedEnvelope env;
            Feature f = (Feature)features.get(i);
            if (addKaart && (env = DataStoreUtil.convertFeature2Envelop(f)) != null) {
                kaartEnvelopes.add(env);
            }
            regels.add(this.getRegel(f, gb, thema_items));
        }
        if (addKaart) {
            request.setAttribute("envelops", kaartEnvelopes);
        }
        return regels;
    }

    protected AdminDataRowBean getRegel(Feature f, Gegevensbron gb, List<ThemaData> thema_items) throws SQLException, UnsupportedEncodingException, Exception {
        AdminDataRowBean regel = new AdminDataRowBean();
        String adminPk = DataStoreUtil.convertColumnNameToQName(gb.getAdmin_pk()).getLocalPart();
        if (adminPk != null) {
            regel.setPrimaryKey(f.getProperty(adminPk).getValue());
        }
        for (ThemaData td : thema_items) {
            StringBuffer url;
            String kolomnaam = td.getKolomnaam();
            if (kolomnaam != null && kolomnaam.length() > 0) {
                kolomnaam = DataStoreUtil.convertColumnNameToQName(td.getKolomnaam()).getLocalPart();
            }
            if ((td.getDataType().getId() == 1 || td.getDataType().getId() == 6) && kolomnaam != null) {
                if (f.getProperty(kolomnaam).getValue() == null) {
                    regel.addValue(null);
                    continue;
                }
                regel.addValue(f.getProperty(kolomnaam).getValue().toString());
                continue;
            }
            if (td.getDataType().getId() == 2) {
                url = td.getCommando() != null ? new StringBuffer(td.getCommando()) : new StringBuffer();
                url.append("themaid");
                url.append("=");
                url.append(gb.getId());
                Object value = null;
                if (adminPk != null && (value = f.getProperty(adminPk).getValue()) != null) {
                    url.append("&");
                    url.append(adminPk);
                    url.append("=");
                    url.append(URLEncoder.encode(value.toString().trim(), "utf-8"));
                }
                if (kolomnaam != null && kolomnaam.length() > 0 && !kolomnaam.equalsIgnoreCase(adminPk) && (value = f.getProperty(kolomnaam).getValue()) != null) {
                    url.append("&");
                    url.append(kolomnaam);
                    url.append("=");
                    url.append(URLEncoder.encode(value.toString().trim(), "utf-8"));
                }
                regel.addValue(url.toString());
                continue;
            }
            if (td.getDataType().getId() == 3) {
                if (td.getCommando() != null) {
                    url = new StringBuffer(td.getCommando());
                    String commando = url.toString();
                    Object valueToSplit = null;
                    if (kolomnaam != null && f.getProperty(kolomnaam) != null) {
                        valueToSplit = f.getProperty(kolomnaam).getValue();
                    }
                    HashMap fhm = this.toHashMap(f);
                    List values = this.splitObject(valueToSplit, ",");
                    ArrayList<String> regelValues = new ArrayList<String>();
                    for (int i = 0; i < values.size(); ++i) {
                        Object value = values.get(i);
                        if (commando.contains("[") || commando.contains("]")) {
                            if (kolomnaam != null) {
                                fhm.put(kolomnaam, value);
                            }
                            String newCommando = this.replaceValuesInString(commando, fhm);
                            regelValues.add(newCommando);
                            continue;
                        }
                        if (value != null) {
                            url.append(value.toString().trim());
                            regelValues.add(url.toString());
                            continue;
                        }
                        regelValues.add("");
                    }
                    regel.addValue(regelValues);
                    continue;
                }
                if (f.getProperty(kolomnaam).getValue() == null) {
                    regel.addValue(null);
                    continue;
                }
                regel.addValue(f.getProperty(kolomnaam).getValue().toString());
                continue;
            }
            if (td.getDataType().getId() == 4) {
                Object keyValue = null;
                if (adminPk != null) {
                    keyValue = f.getProperty(adminPk).getValue();
                }
                if (keyValue != null) {
                    String attributeName = kolomnaam;
                    Object attributeValue = null;
                    if (attributeName != null) {
                        attributeValue = f.getProperty(attributeName).getValue();
                    } else {
                        attributeName = adminPk;
                        attributeValue = keyValue;
                    }
                    StringBuilder function = new StringBuilder("");
                    function.append(attributeValue);
                    function.append("###").append(td.getCommando());
                    function.append("(this, ");
                    function.append("'").append(td.getGegevensbron().getId()).append("'");
                    function.append(",");
                    function.append("'").append(adminPk).append("'");
                    function.append(",");
                    function.append("'").append(keyValue).append("'");
                    function.append(",");
                    function.append("'").append(attributeName).append("'");
                    function.append(",");
                    function.append("'").append(attributeValue).append("'");
                    function.append(",");
                    function.append("'").append(td.getEenheid()).append("'");
                    function.append(")");
                    regel.addValue(function.toString());
                    continue;
                }
                regel.addValue("");
                continue;
            }
            regel.addValue("");
        }
        return regel;
    }

    protected String getStringFromParam(Map params, String key) {
        Object ob = params.get(key);
        String string = null;
        if (ob instanceof String) {
            string = (String)ob;
        }
        if (ob instanceof String[]) {
            string = ((String[])ob)[0];
        }
        return string;
    }

    protected boolean compareThemaDataLists(List list1, List list2) {
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        int basisRegelTeller1 = 0;
        int basisRegelTeller2 = 0;
        for (int i1 = 0; i1 < list1.size(); ++i1) {
            ThemaData td1 = (ThemaData)list1.get(i1);
            if (td1.isBasisregel()) {
                ++basisRegelTeller1;
            }
            if (!td1.isBasisregel() || td1.getLabel() == null) continue;
            boolean bevatGelijke = false;
            for (int i2 = 0; i2 < list2.size(); ++i2) {
                ThemaData td2 = (ThemaData)list2.get(i2);
                if (td2.isBasisregel()) {
                    ++basisRegelTeller2;
                }
                if (!td2.isBasisregel() || !td1.getLabel().equalsIgnoreCase(td2.getLabel())) continue;
                bevatGelijke = true;
                break;
            }
            if (bevatGelijke) continue;
            return false;
        }
        return basisRegelTeller1 == basisRegelTeller2;
    }

    private HashMap toHashMap(Feature f) throws Exception {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FeatureType ft = f.getType();
        for (PropertyDescriptor pd : ft.getDescriptors()) {
            String key = pd.getName().getLocalPart();
            Object value = f.getProperty(pd.getName()).getValue();
            result.put(key, value);
        }
        return result;
    }

    private String replaceValuesInString(String string, HashMap values) throws Exception {
        if (!string.contains("[") && !string.contains("]")) {
            return string;
        }
        StringBuffer url = string != null ? new StringBuffer(string) : new StringBuffer();
        int begin = -1;
        int eind = -1;
        for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            if (c == '[') {
                if (begin == -1) {
                    begin = i;
                    continue;
                }
                logger.error((Object)("Commando \"" + string + "\" is niet correct. Er ontbreekt een ] ."));
                throw new Exception("Commando \"" + string + "\" is niet correct. Er ontbreekt een ] .");
            }
            if (c == ']') {
                eind = i;
                if (begin != -1 && eind != -1) {
                    String kolomnaam = url.substring(begin + 1, eind);
                    if (kolomnaam == null || kolomnaam.length() == 0) {
                        logger.error((Object)("Commando \"" + string + "\" is niet correct. Geen kolomnaam aanwezig tussen [ en ]."));
                        throw new Exception("Commando \"" + string + "\" is niet correct. Geen kolomnaam aanwezig tussen [ en ].");
                    }
                    Object value = values.get(kolomnaam);
                    if (value == null) {
                        value = "";
                    }
                    url.replace(begin, eind + 1, value.toString().trim());
                    begin = -1;
                    eind = -1;
                    i = 0;
                    continue;
                }
                logger.error((Object)("Commando \"" + string + "\" is niet correct. Er ontbreekt een [ ."));
                throw new Exception("Commando \"" + string + "\" is niet correct. Er ontbreekt een [ .");
            }
            if (i != url.length() - 1 || begin == -1) continue;
            logger.error((Object)("Commando \"" + string + "\" is niet correct. Er ontbreekt een ] ."));
            throw new Exception("Commando \"" + string + "\" is niet correct. Er ontbreekt een ] .");
        }
        return url.toString();
    }

    private List splitObject(Object value, String seperator) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (value == null) {
            values.add(value);
        } else if (value instanceof String) {
            String[] tokens = ((String)value).split(seperator);
            values.addAll(Arrays.asList(tokens));
        } else {
            values.add(value);
        }
        return values;
    }
}

