/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.gis.geotools.DataStoreUtil;
import nl.b3p.gis.geotools.FilterBuilder;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.ThemaData;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.services.ObjectdataPdfInfo;
import nl.b3p.gis.viewer.services.SpatialUtil;
import nl.b3p.imagetool.CombineImageSettings;
import nl.b3p.imagetool.CombineImagesHandler;
import nl.b3p.zoeker.configuratie.Bron;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.geotools.feature.simple.SimpleFeatureImpl;
import org.hibernate.Transaction;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.filter.Filter;
import org.xml.sax.SAXException;
import sun.misc.BASE64Encoder;

public class Data2PDF
extends HttpServlet {
    private static final Log log = LogFactory.getLog(Data2PDF.class);
    private static String HTMLTITLE = "Exporteer naar PDF";
    private static String xsl_data2pdf = null;
    private static Integer MAX_PDF_RECORDS = 25;
    public static String fopConfig = null;
    public static String fontPath = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String appCode = request.getParameter("appCode");
        String gegevensbronId = request.getParameter("gbId");
        String objectIds = request.getParameter("objectIds");
        String orientation = request.getParameter("orientation");
        if (gegevensbronId == null || gegevensbronId.equals("") || objectIds == null || objectIds.equals("")) {
            this.writeErrorMessage(response, "Ongeldige request parameters.");
            log.error((Object)"Ongeldige request parameters.");
            return;
        }
        if (xsl_data2pdf == null || xsl_data2pdf.equals("")) {
            this.writeErrorMessage(response, "Xsl template niet geconfigureerd.");
            log.error((Object)"Xsl template niet geconfigureerd.");
            return;
        }
        Transaction tx = HibernateUtil.getSessionFactory().getCurrentSession().beginTransaction();
        try {
            Gegevensbron gb = SpatialUtil.getGegevensbron(gegevensbronId);
            String decoded = URLDecoder.decode(objectIds, "UTF-8");
            String[] ids = decoded.split(",");
            if (ids != null && ids.length > MAX_PDF_RECORDS) {
                String msg = "Er mogen maximaal " + MAX_PDF_RECORDS + " records in een" + " pdf geexporteerd worden. Momenteel zijn er " + ids.length + " records" + " geselecteerd.";
                this.writeErrorMessage(response, msg);
                log.debug((Object)msg);
                return;
            }
            GisPrincipal user = GisPrincipal.getGisPrincipal(request);
            if (user == null) {
                this.writeErrorMessage(response, "Kan de data niet ophalen omdat u niet bent ingelogd.");
                return;
            }
            Bron b = gb.getBron(request);
            if (b == null) {
                throw new ServletException("Gegevensbron (id " + gb.getId() + ") Bron null.");
            }
            List data = null;
            String[] propertyNames = this.getThemaPropertyNames(gb);
            Map columnLabels = this.getThemaLabelNames(gb);
            try {
                data = this.getData(b, gb, ids, propertyNames, appCode);
            }
            catch (Exception ex) {
                this.writeErrorMessage(response, ex.getMessage());
                log.error((Object)"Fout bij laden pdf data.", (Throwable)ex);
                HibernateUtil.getSessionFactory().getCurrentSession().close();
                return;
            }
            Date now = new Date();
            SimpleDateFormat df = new SimpleDateFormat("d MMMMM yyyy", new Locale("NL"));
            ObjectdataPdfInfo pdfInfo = new ObjectdataPdfInfo();
            pdfInfo.setTitel("Export van " + gb.getNaam());
            pdfInfo.setDatum(df.format(now));
            HashMap<Integer, ObjectdataPdfInfo.Record> records = new HashMap<Integer, ObjectdataPdfInfo.Record>();
            BASE64Encoder enc = new BASE64Encoder();
            String jsonSettingsParam = FormUtils.nullIfEmpty((String)request.getParameter("jsonSettings"));
            String legendUrls = FormUtils.nullIfEmpty((String)request.getParameter("legendUrls"));
            JSONObject jsonSettings = new JSONObject(jsonSettingsParam);
            String mimeType = FormUtils.nullIfEmpty((String)request.getParameter("FORMAT"));
            if (mimeType == null || !mimeType.equals("")) {
                // empty if block
            }
            int i = 0;
            for (Object obj : data) {
                CombineImageSettings settings = null;
                try {
                    settings = this.getCombineImageSettings(jsonSettings, legendUrls);
                }
                catch (Exception ex) {
                    log.error((Object)"Fout tijdens ophalen combine settings: ", (Throwable)ex);
                }
                settings.setWidth(Integer.valueOf(500));
                settings.setHeight(Integer.valueOf(375));
                settings.setMimeType(mimeType);
                String[] items = (String[])obj;
                ObjectdataPdfInfo.Record record = new ObjectdataPdfInfo.Record();
                record.setId(i);
                String wkt = items[items.length - 1];
                Geometry geom = null;
                try {
                    geom = DataStoreUtil.createGeomFromWKTString(wkt);
                }
                catch (Exception ex) {
                    log.error((Object)"Fout tijdens knutselen geometrie: ", (Throwable)ex);
                }
                Envelope bbox = geom.getEnvelopeInternal();
                double[] dbbox = new double[4];
                double bufferSize = 50.0;
                dbbox[0] = bbox.getMinX() - bufferSize;
                dbbox[1] = bbox.getMinY() - bufferSize;
                dbbox[2] = bbox.getMaxX() + bufferSize;
                dbbox[3] = bbox.getMaxY() + bufferSize;
                settings.setBbox(dbbox);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                String imageUrl = "";
                try {
                    CombineImagesHandler.combineImage((OutputStream)baos, (CombineImageSettings)settings);
                    byte[] imageBytes = baos.toByteArray();
                    imageUrl = enc.encode(imageBytes);
                }
                catch (Exception imageBytes) {
                    // empty catch block
                }
                record.setImageUrl(imageUrl);
                for (int j = 0; j < items.length - 1; ++j) {
                    String string = items[j];
                    String propertyName = propertyNames[j];
                    String label = (String)columnLabels.get(propertyName);
                    record.addItem(label, string);
                }
                records.put(i, record);
                ++i;
            }
            pdfInfo.setRecords(records);
            try {
                Data2PDF.createPdfOutput(pdfInfo, xsl_data2pdf, response);
            }
            catch (MalformedURLException ex) {
                this.writeErrorMessage(response, ex.getMessage());
                log.error((Object)"Fout tijdens maken pdf: ", (Throwable)ex);
            }
            catch (SAXException ex) {
                this.writeErrorMessage(response, ex.getMessage());
                log.error((Object)"Fout tijdens maken pdf: ", (Throwable)ex);
            }
        }
        catch (JSONException ex) {
            log.error((Object)"Error creating CombineImageSettings: ", (Throwable)ex);
        }
        finally {
            HibernateUtil.getSessionFactory().getCurrentSession().close();
        }
    }

    public static void createXmlOutput(ObjectdataPdfInfo object, String xmlFile) {
        try {
            File file = new File(xmlFile);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectdataPdfInfo.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.marshal((Object)object, file);
        }
        catch (JAXBException e) {
            log.error((Object)"Fout tijdens maken objectdata export naar xml: ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createPdfOutput(ObjectdataPdfInfo pdfInfo, String template, HttpServletResponse response) throws MalformedURLException, IOException, SAXException {
        File xslFile = new File(template);
        String path = new File(xslFile.getParent()).toURI().toString();
        FopFactory fopFactory = FopFactory.newInstance();
        fopFactory.setBaseURL(path);
        fopFactory.getFontManager().setFontBaseURL(fontPath);
        fopFactory.setUserConfig(new File(fopConfig));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            foUserAgent.setCreator("Gisviewer webapplicatie");
            foUserAgent.setProducer("B3Partners");
            Date now = new Date();
            foUserAgent.setCreationDate(now);
            foUserAgent.setTitle("Objectdata PDF Export");
            Fop fop = fopFactory.newFop("application/pdf", foUserAgent, (OutputStream)out);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ObjectdataPdfInfo.class});
            JAXBSource src = new JAXBSource(jc, (Object)pdfInfo);
            StreamSource xsltSrc = new StreamSource(xslFile);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(xsltSrc);
            if (transformer == null) {
                log.error((Object)"Fout tijdens inlezen xsl bestand.");
                return;
            }
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            if (transformer != null) {
                transformer.transform((Source)src, res);
            }
            response.setContentType("application/pdf");
            response.setContentLength(out.size());
            SimpleDateFormat df = new SimpleDateFormat("dd-MM-yyyy", new Locale("NL"));
            String date = df.format(now);
            String fileName = "Objectdata_Export_" + date + ".pdf";
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            response.getOutputStream().write(out.toByteArray());
            response.getOutputStream().flush();
        }
        catch (Exception ex) {
            log.error((Object)"Fout tijdens objectdata pdf export: ", (Throwable)ex);
        }
        finally {
            out.close();
        }
    }

    public String[] getThemaPropertyNames(Gegevensbron gb) {
        Set themadata = gb.getThemaData();
        Iterator it = themadata.iterator();
        ArrayList<String> columns = new ArrayList<String>();
        while (it.hasNext()) {
            ThemaData td = (ThemaData)it.next();
            if (td.getKolomnaam() == null || columns.contains(td.getKolomnaam()) || td.getKolomnaam().equalsIgnoreCase("the_geom") || td.getKolomnaam().equalsIgnoreCase("geometry")) continue;
            columns.add(td.getKolomnaam());
        }
        String[] s = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            s[i] = (String)columns.get(i);
        }
        return s;
    }

    public Map getThemaLabelNames(Gegevensbron gb) {
        Set themadata = gb.getThemaData();
        Iterator it = themadata.iterator();
        ArrayList<String> columns = new ArrayList<String>();
        HashMap<String, String> labels = new HashMap<String, String>();
        while (it.hasNext()) {
            ThemaData td = (ThemaData)it.next();
            if (td.getKolomnaam() == null || columns.contains(td.getKolomnaam()) || td.getKolomnaam().equalsIgnoreCase("the_geom") || td.getKolomnaam().equalsIgnoreCase("geometry")) continue;
            columns.add(td.getKolomnaam());
            if (td.getLabel() != null) {
                labels.put(td.getKolomnaam(), td.getLabel());
                continue;
            }
            labels.put(td.getKolomnaam(), td.getKolomnaam());
        }
        return labels;
    }

    public List getData(Bron b, Gegevensbron gb, String[] pks, String[] propertyNames, String appCode) throws IOException, Exception {
        Filter filter = FilterBuilder.createOrEqualsFilter(DataStoreUtil.convertColumnNameToQName(gb.getAdmin_pk()).getLocalPart(), pks);
        List<ThemaData> items = SpatialUtil.getThemaData(gb, false);
        List<String> propnames = DataStoreUtil.themaData2PropertyNames(items);
        Integer maximum = ConfigKeeper.getMaxNumberOfFeatures(appCode);
        ArrayList<Feature> features = DataStoreUtil.getFeatures(b, gb, null, filter, propnames, maximum, true);
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (int i = 0; i < features.size(); ++i) {
            Feature f = features.get(i);
            String[] row = new String[propertyNames.length + 1];
            for (int p = 0; p < propertyNames.length; ++p) {
                Property property = f.getProperty(propertyNames[p]);
                row[p] = property != null && property.getValue() != null && property.getValue().toString() != null ? property.getValue().toString().trim() : "";
            }
            SimpleFeatureImpl feature = (SimpleFeatureImpl)f;
            Geometry geom = (Geometry)feature.getDefaultGeometry();
            String wkt = null;
            wkt = geom != null && !geom.isEmpty() ? geom.toText() : "POINT (0 0)";
            row[row.length - 1] = wkt;
            result.add(row);
        }
        return result;
    }

    private void writeErrorMessage(HttpServletResponse response, String message) throws IOException {
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter pw = response.getWriter();
        pw.println("<html>");
        pw.println("<head>");
        pw.println("<title>" + HTMLTITLE + "</title>");
        pw.println("<script type=\"text/javascript\"> if(window.parent && (typeof window.parent.showCsvError == 'function')) { window.parent.showCsvError(); } </script>");
        pw.println("</head>");
        pw.println("<body>");
        pw.println("<h1>Fout</h1>");
        pw.println("<h3>" + message + "</h3>");
        pw.println("</body>");
        pw.println("</html>");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            if (config.getInitParameter("xsl_data2pdf") != null) {
                xsl_data2pdf = this.getServletContext().getRealPath(config.getInitParameter("xsl_data2pdf"));
            }
            fopConfig = this.getServletContext().getRealPath("/WEB-INF/xsl/fop.xml");
            fontPath = this.getServletContext().getRealPath("/WEB-INF/xsl/fonts");
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private CombineImageSettings getCombineImageSettings(JSONObject jsonSettings, String legendUrls) throws Exception {
        CombineImageSettings settings = CombineImageSettings.fromJson((JSONObject)jsonSettings);
        HashMap<String, String> legendMap = new HashMap<String, String>();
        if (legendUrls != null) {
            log.debug((Object)("legendUrls: " + legendUrls));
            String[] arr = legendUrls.split(";");
            for (int i = 0; i < arr.length; ++i) {
                String[] legendUrlsArr = arr[i].split("#");
                legendMap.put(legendUrlsArr[0], legendUrlsArr[1]);
            }
            settings.setLegendMap(legendMap);
        }
        return settings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

