/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer.services;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.gis.geotools.DataStoreUtil;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.viewer.db.Configuratie;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.Themas;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.services.SpatialUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Transaction;
import org.hibernate.classic.Session;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SldServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(SldServlet.class);
    public static final String OGCNS = "http://www.opengis.net/ogc";
    public static final String SLDNS = "http://www.opengis.net/sld";
    public static final String SENS = "http://www.opengis.net/se";
    public static final String SLDTYPE_NAMEDSTYLE = "NamedStyle";
    public static final String SLDTYPE_USERSTYLE = "UserStyle";
    public static final String DEFAULT_STYLE = "default";
    private String defaultSldPath;
    public static final String CFG_TEKEN_FILTER_SLD = "tekenFilterSld";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ServletOutputStream out = response.getOutputStream();
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Transaction tx = sess.beginTransaction();
        try {
            int i;
            String url = request.getRequestURL().toString();
            log.debug((Object)("SLD Url: " + url));
            String[] visibleValue = null;
            String themaId = null;
            if (FormUtils.nullIfEmpty((String)request.getParameter("propvalue")) != null) {
                visibleValue = new String[]{request.getParameter("propvalue")};
            }
            if (request.getParameter("visibleValue") != null) {
                visibleValue = request.getParameter("visibleValue").split(",");
            }
            if (visibleValue == null) {
                throw new Exception("visibleValue is verplicht");
            }
            String clusterId = null;
            if (FormUtils.nullIfEmpty((String)request.getParameter("id")) != null) {
                themaId = request.getParameter("id");
            }
            if (FormUtils.nullIfEmpty((String)request.getParameter("themaId")) != null) {
                themaId = request.getParameter("themaId");
            }
            if (FormUtils.nullIfEmpty((String)request.getParameter("clusterId")) != null) {
                clusterId = request.getParameter("clusterId");
            }
            if (themaId == null && clusterId == null) {
                throw new Exception("id of clusterId is verplicht");
            }
            String sldType = SLDTYPE_USERSTYLE;
            if (FormUtils.nullIfEmpty((String)request.getParameter("sldType")) != null) {
                sldType = request.getParameter("sldType");
            }
            Document doc = this.getDefaultSld();
            Element root = doc.getDocumentElement();
            ArrayList<Themas> themaList = new ArrayList<Themas>();
            if (themaId != null) {
                String[] themaIds = themaId.split(",");
                for (i = 0; i < themaIds.length; ++i) {
                    Themas th = SpatialUtil.getThema(themaIds[i]);
                    if (th == null) {
                        log.error((Object)("Can't find thema with id: " + themaId));
                        continue;
                    }
                    themaList.add(th);
                }
            }
            if (clusterId != null) {
                String[] clusterIds = clusterId.split(",");
                for (i = 0; i < clusterIds.length; ++i) {
                    try {
                        Integer cid = Integer.parseInt(clusterIds[i]);
                        List<Themas> clusterThemaList = this.getClusterThemas(cid);
                        if (clusterThemaList == null || clusterThemaList.isEmpty()) {
                            log.warn((Object)("No cluster or no themas in cluster: " + clusterIds[i]));
                            continue;
                        }
                        themaList.addAll(clusterThemaList);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        log.error((Object)("clusterId is NAN: " + clusterIds[i]));
                    }
                }
            }
            String sldPart = null;
            String appCode = request.getParameter("appcode");
            if (appCode != null && !appCode.isEmpty()) {
                sldPart = this.getTekenKaartlaagSLDPart((org.hibernate.Session)sess, appCode);
            }
            for (int i2 = 0; i2 < themaList.size(); ++i2) {
                Themas th = (Themas)themaList.get(i2);
                Gegevensbron gb = th.getGegevensbron();
                String sldattribuut = th.getSldattribuut();
                if (sldattribuut == null || sldattribuut.length() == 0) {
                    sldattribuut = DataStoreUtil.convertColumnNameToQName(gb.getAdmin_pk()).getLocalPart();
                }
                if (sldattribuut == null || sldattribuut.length() == 0) {
                    log.debug((Object)"thema heeft geen sld attribuut");
                    continue;
                }
                String featureType = th.getWms_layers_real();
                if (featureType == null || featureType.length() == 0) {
                    log.debug((Object)"thema heeft geen featuretype");
                    continue;
                }
                featureType = featureType.substring(featureType.indexOf("_") + 1);
                String geometryType = null;
                try {
                    geometryType = this.getGeomtryType(th, request);
                }
                catch (Exception e) {
                    log.debug((Object)"Error getting geometry type. Creating the style with a polygonsimbolizer.");
                }
                if (FormUtils.nullIfEmpty((String)request.getParameter("propname")) != null) {
                    sldattribuut = request.getParameter("propname");
                }
                Node child = this.createNamedLayer(doc, featureType, sldattribuut, visibleValue, geometryType, sldType, sldPart);
                root.appendChild(child);
            }
            DOMSource domSource = new DOMSource(doc);
            Transformer t = TransformerFactory.newInstance().newTransformer();
            response.setContentType("text/xml");
            t.transform(domSource, new StreamResult((OutputStream)out));
            tx.commit();
        }
        catch (Exception e) {
            if (tx.isActive()) {
                tx.rollback();
            }
            log.error((Object)"Fout bij maken sld: ", (Throwable)e);
            response.setContentType("text/html;charset=UTF-8");
            PrintWriter pw = new PrintWriter((OutputStream)out);
            pw.write(e.getMessage());
        }
        finally {
            out.close();
        }
    }

    private List<Themas> getClusterThemas(Integer id) throws Exception {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        return sess.createQuery("from Themas where cluster=:p").setInteger("p", id.intValue()).list();
    }

    private String getTekenKaartlaagSLDPart(org.hibernate.Session sess, String appCode) {
        String sld = null;
        ConfigKeeper keeper = new ConfigKeeper();
        Configuratie cfg = keeper.getConfiguratie(CFG_TEKEN_FILTER_SLD, appCode);
        if (cfg != null) {
            sld = cfg.getPropval();
        }
        return sld;
    }

    private String getGeomtryType(Themas t, HttpServletRequest request) throws Exception {
        GisPrincipal user = GisPrincipal.getGisPrincipal(request);
        String geometryType = DataStoreUtil.getThemaGeomType(t, user);
        return geometryType;
    }

    public Document getDefaultSld() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        FileInputStream fi = new FileInputStream(this.defaultSldPath);
        Document doc = db.parse(fi);
        return doc;
    }

    public Node createNamedLayer(Document doc, String featureName, String attribute, String[] value, String geometryType, String sldType) {
        return this.createNamedLayer(doc, featureName, attribute, value, geometryType, sldType, false, null);
    }

    public Node createNamedLayer(Document doc, String featureName, String attribute, String[] value, String geometryType, String sldType, String sldPart) {
        return this.createNamedLayer(doc, featureName, attribute, value, geometryType, sldType, false, sldPart);
    }

    public Node createNamedLayer(Document doc, String featureName, String attribute, String[] value, String geometryType, String sldType, boolean not, String sldPart) {
        Element name = doc.createElementNS(SLDNS, "Name");
        name.appendChild(doc.createTextNode(featureName));
        Element namedLayer = doc.createElementNS(SLDNS, "NamedLayer");
        namedLayer.appendChild(name);
        if (sldType.equalsIgnoreCase(SLDTYPE_USERSTYLE)) {
            Node featureTypeStyle = this.createFeatureTypeStyle(doc, attribute, value, geometryType, sldPart);
            Element userStyle = doc.createElementNS(SLDNS, SLDTYPE_USERSTYLE);
            userStyle.appendChild(featureTypeStyle);
            namedLayer.appendChild(userStyle);
        } else if (sldType.equalsIgnoreCase(SLDTYPE_NAMEDSTYLE)) {
            Element layerFeatureConstraints = doc.createElementNS(SLDNS, "LayerFeatureConstraints");
            Node featureTypeConstraints = this.createFeatureTypeConstraint(doc, attribute, value, not);
            layerFeatureConstraints.appendChild(featureTypeConstraints);
            namedLayer.appendChild(layerFeatureConstraints);
            Element namedStyle = doc.createElementNS(SLDNS, SLDTYPE_NAMEDSTYLE);
            Element styleName = doc.createElementNS(SLDNS, "Name");
            styleName.appendChild(doc.createTextNode(DEFAULT_STYLE));
            namedStyle.appendChild(styleName);
            namedLayer.appendChild(namedStyle);
        }
        return namedLayer;
    }

    public Node createFeatureTypeStyle(Document doc, String attribute, String[] value, String geometryType) {
        return this.createFeatureTypeStyle(doc, attribute, value, geometryType, null);
    }

    private Node createSldNode(String xml, Document doc) throws Exception {
        Document doc2 = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes()));
        Node node = doc.importNode(doc2.getDocumentElement(), true);
        return node;
    }

    public Node createFeatureTypeStyle(Document doc, String attribute, String[] value, String geometryType, String sldPart) {
        Element featureTypeStyle = doc.createElementNS(SLDNS, "FeatureTypeStyle");
        Element rule = doc.createElement("Rule");
        Node filter = this.createFilter(doc, attribute, value, false);
        rule.appendChild(filter);
        Node sldNode = null;
        if (sldPart != null && !sldPart.isEmpty()) {
            try {
                sldNode = this.createSldNode(sldPart, doc);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (sldNode != null) {
            rule.appendChild(sldNode);
        } else if (geometryType == null || geometryType.toLowerCase().indexOf("polygon") >= 0) {
            rule.appendChild(SldServlet.createDashedLinePolygon(doc));
        } else if (geometryType == null || geometryType.toLowerCase().indexOf("line") >= 0) {
            rule.appendChild(SldServlet.createStyleLine(doc, attribute));
        } else if (geometryType == null || geometryType.toLowerCase().indexOf("point") >= 0) {
            rule.appendChild(SldServlet.createStylePoint(doc, attribute));
        }
        featureTypeStyle.appendChild(rule);
        return featureTypeStyle;
    }

    private static Node createStylePoint(Document doc, String geoProperty) {
        Element pointSymbolizer = doc.createElement("PointSymbolizer");
        Element geo = doc.createElement("Geometry");
        Element propName = doc.createElementNS(OGCNS, "PropertyName");
        propName.appendChild(doc.createTextNode(geoProperty));
        geo.appendChild(propName);
        Element graphic = doc.createElement("Graphic");
        Element mark = doc.createElement("Mark");
        Element wkn = doc.createElement("WellKnownName");
        wkn.appendChild(doc.createTextNode("circle"));
        Element fill = doc.createElement("Fill");
        Element cssParam = doc.createElement("CssParameter");
        cssParam.setAttribute("name", "fill");
        cssParam.appendChild(doc.createTextNode("#ff0000"));
        Element size = doc.createElement("Size");
        size.appendChild(doc.createTextNode("10.0"));
        fill.appendChild(cssParam);
        mark.appendChild(wkn);
        mark.appendChild(fill);
        graphic.appendChild(mark);
        graphic.appendChild(size);
        pointSymbolizer.appendChild(geo);
        pointSymbolizer.appendChild(graphic);
        return pointSymbolizer;
    }

    private Node createStylePolygon(Document doc, String geoProperty) {
        Element polygonSymbolizer = doc.createElement("PolygonSymbolizer");
        Element geo = doc.createElement("Geometry");
        Element propName = doc.createElementNS(OGCNS, "PropertyName");
        propName.appendChild(doc.createTextNode(geoProperty));
        geo.appendChild(propName);
        Element fill = doc.createElement("Fill");
        Element cssParam2 = doc.createElement("CssParameter");
        cssParam2.setAttribute("name", "fill");
        cssParam2.appendChild(doc.createTextNode("#ff0000"));
        fill.appendChild(cssParam2);
        Element stroke = doc.createElement("Stroke");
        Element cssParam = doc.createElement("CssParameter");
        cssParam.setAttribute("name", "stroke");
        cssParam.appendChild(doc.createTextNode("#ff00ff"));
        stroke.appendChild(cssParam);
        polygonSymbolizer.appendChild(geo);
        polygonSymbolizer.appendChild(stroke);
        polygonSymbolizer.appendChild(fill);
        return polygonSymbolizer;
    }

    private static Node createDashedLinePolygon(Document doc) {
        Element polygonSymbolizer = doc.createElement("PolygonSymbolizer");
        Element stroke = doc.createElement("Stroke");
        Element cssParam1 = doc.createElement("CssParameter");
        cssParam1.setAttribute("name", "stroke");
        cssParam1.appendChild(doc.createTextNode("#ff0000"));
        stroke.appendChild(cssParam1);
        Element cssParam2 = doc.createElement("CssParameter");
        cssParam2.setAttribute("name", "stroke-width");
        cssParam2.appendChild(doc.createTextNode("3"));
        stroke.appendChild(cssParam2);
        Element cssParam3 = doc.createElement("CssParameter");
        cssParam3.setAttribute("name", "stroke-dasharray");
        cssParam3.appendChild(doc.createTextNode("10 8"));
        stroke.appendChild(cssParam3);
        Element fill = doc.createElement("Fill");
        Element cssParam4 = doc.createElement("CssParameter");
        cssParam4.setAttribute("name", "fill-opacity");
        cssParam4.appendChild(doc.createTextNode("0"));
        fill.appendChild(cssParam4);
        polygonSymbolizer.appendChild(stroke);
        polygonSymbolizer.appendChild(fill);
        return polygonSymbolizer;
    }

    public static String getDefaultPolygonStyle() throws ParserConfigurationException {
        Document doc = SldServlet.getEmptyDocument();
        Node childNode = SldServlet.createDashedLinePolygon(doc);
        doc.appendChild(childNode);
        return SldServlet.docToString(doc);
    }

    public static String getDefaultLineStyle() throws ParserConfigurationException {
        Document doc = SldServlet.getEmptyDocument();
        Node childNode = SldServlet.createStyleLine(doc, "");
        doc.appendChild(childNode);
        return SldServlet.docToString(doc);
    }

    public static String getDefaultPointStyle() throws ParserConfigurationException {
        Document doc = SldServlet.getEmptyDocument();
        Node childNode = SldServlet.createStylePoint(doc, "");
        doc.appendChild(childNode);
        return SldServlet.docToString(doc);
    }

    private static String docToString(Document doc) {
        try {
            StringWriter sw = new StringWriter();
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.transform(new DOMSource(doc), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception ex) {
            log.debug((Object)"Fout omzetten Document naar xml");
            return null;
        }
    }

    private static Document getEmptyDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        return db.newDocument();
    }

    private static Node createStyleLine(Document doc, String geoProperty) {
        Element lineSymbolizer = doc.createElement("LineSymbolizer");
        Element geo = doc.createElement("Geometry");
        Element propName = doc.createElementNS(OGCNS, "PropertyName");
        propName.appendChild(doc.createTextNode(geoProperty));
        geo.appendChild(propName);
        Element stroke = doc.createElement("Stroke");
        Element cssStroke = doc.createElement("CssParameter");
        cssStroke.setAttribute("name", "stroke");
        cssStroke.appendChild(doc.createTextNode("#ff00ff"));
        stroke.appendChild(cssStroke);
        Element cssDash = doc.createElement("CssParameter");
        cssDash.setAttribute("name", "stroke-dasharray");
        cssDash.appendChild(doc.createTextNode("10.0 5 5 10"));
        stroke.appendChild(cssDash);
        lineSymbolizer.appendChild(geo);
        lineSymbolizer.appendChild(stroke);
        return lineSymbolizer;
    }

    private Node createFilter(Document doc, String attribute, String[] value, boolean not) {
        Element filter;
        Element nodeToUse = filter = doc.createElementNS(OGCNS, "Filter");
        if (not) {
            Element notFilter = doc.createElementNS(OGCNS, "Not");
            filter.appendChild(notFilter);
            nodeToUse = notFilter;
        }
        if (value.length > 1) {
            Element orFilter = doc.createElementNS(OGCNS, "Or");
            nodeToUse.appendChild(orFilter);
            nodeToUse = orFilter;
        }
        for (int i = 0; i < value.length; ++i) {
            Element propertyName = doc.createElementNS(OGCNS, "PropertyName");
            propertyName.appendChild(doc.createTextNode(attribute));
            Element literal = doc.createElementNS(OGCNS, "Literal");
            literal.appendChild(doc.createTextNode(value[i]));
            Element propertyIsEqualTo = doc.createElementNS(OGCNS, "PropertyIsEqualTo");
            propertyIsEqualTo.appendChild(propertyName);
            propertyIsEqualTo.appendChild(literal);
            nodeToUse.appendChild(propertyIsEqualTo);
        }
        return filter;
    }

    private Node createFeatureTypeConstraint(Document doc, String attribute, String[] value, boolean not) {
        Element featureTypeConstraint = doc.createElementNS(SLDNS, "FeatureTypeConstraint");
        Node filter = this.createFilter(doc, attribute, value, not);
        featureTypeConstraint.appendChild(filter);
        return featureTypeConstraint;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            if (config.getInitParameter("defaultSld") != null) {
                this.defaultSldPath = this.getServletContext().getRealPath(config.getInitParameter("defaultSld"));
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "Short description";
    }
}

