/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.SendFailedException;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.b3p.commons.services.StreamCopy;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.gis.utils.KaartSelectieUtil;
import nl.b3p.gis.viewer.BaseGisAction;
import nl.b3p.gis.viewer.db.Applicatie;
import nl.b3p.gis.viewer.db.Clusters;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.Themas;
import nl.b3p.gis.viewer.db.UserKaartgroep;
import nl.b3p.gis.viewer.db.UserKaartlaag;
import nl.b3p.gis.viewer.db.UserLayer;
import nl.b3p.gis.viewer.db.UserLayerStyle;
import nl.b3p.gis.viewer.db.UserService;
import nl.b3p.gis.viewer.services.DownloadServlet;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.services.SpatialUtil;
import nl.b3p.ogc.sld.SldUserStyle;
import nl.b3p.ogc.sld.SldWriter;
import nl.b3p.ogc.utils.KBConfiguration;
import nl.b3p.ogc.utils.OGCRequest;
import nl.b3p.wms.capabilities.Style;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.StyleImpl;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.WMSUtils;
import org.geotools.data.wms.WebMapServer;
import org.geotools.ows.ServiceException;
import org.hibernate.classic.Session;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KaartSelectieAction
extends BaseGisAction {
    private static final Log log = LogFactory.getLog(KaartSelectieAction.class);
    protected static final String SAVE = "save";
    protected static final String SAVE_WMS_SERVICE = "saveWMSService";
    protected static final String DELETE_WMS_SERVICES = "deleteWMSServices";
    protected static final String ERROR_DUPLICATE_WMS = "error.duplicate.wms";
    protected static final String PARAM_APPCODE = "appCode";
    protected static final String ERROR_SAVE_WMS = "error.save.wms";
    protected static final String ERROR_SAVE_WMS_IO = "error.save.wms.io";
    protected static final String ERROR_SAVE_WMS_SERVICE = "error.save.wms.service";
    protected static final String ERROR_SAVE_WMS_SAX = "error.save.wms.sax";
    private static final int BUFFER_SIZE = 8192;
    private static final String ISO_CHARSET = "ISO-8859-1";
    private static final String UTF8_CHARSET = "UTF-8";

    protected Map getActionMethodPropertiesMap() {
        HashMap<String, ExtendedMethodProperties> map = new HashMap<String, ExtendedMethodProperties>();
        ExtendedMethodProperties hibProp = null;
        hibProp = new ExtendedMethodProperties(SAVE);
        hibProp.setDefaultForwardName("success");
        hibProp.setDefaultMessageKey("message.layerselection.success");
        hibProp.setAlternateForwardName("failure");
        hibProp.setAlternateMessageKey("message.layerselection.failed");
        map.put(SAVE, hibProp);
        hibProp = new ExtendedMethodProperties(SAVE_WMS_SERVICE);
        hibProp.setDefaultForwardName("success");
        hibProp.setDefaultMessageKey("message.userwms.success");
        hibProp.setAlternateForwardName("failure");
        hibProp.setAlternateMessageKey("message.userwms.failed");
        map.put(SAVE_WMS_SERVICE, hibProp);
        hibProp = new ExtendedMethodProperties(DELETE_WMS_SERVICES);
        hibProp.setDefaultForwardName("success");
        hibProp.setDefaultMessageKey("message.userwms.delete.success");
        hibProp.setAlternateForwardName("failure");
        hibProp.setAlternateMessageKey("message.userwms.delete.failed");
        map.put(DELETE_WMS_SERVICES, hibProp);
        return map;
    }

    private void reloadFormData(HttpServletRequest request) throws JSONException, Exception {
        this.setTree(request);
        this.setUserviceTrees(request);
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws JSONException, Exception {
        HttpSession session = request.getSession(true);
        String appCode = (String)session.getAttribute(PARAM_APPCODE);
        Boolean useUserWmsDropdown = (Boolean)session.getAttribute("useUserWmsDropdown");
        KaartSelectieUtil.populateKaartSelectieForm(appCode, request);
        Applicatie app = KaartSelectieUtil.getApplicatie(appCode);
        if (app != null) {
            Boolean readOnly = app.getRead_only();
            if (readOnly.booleanValue()) {
                dynaForm.set("currentAppReadOnly", (Object)"1");
                request.setAttribute("currentAppReadOnly", (Object)"1");
            } else {
                dynaForm.set("currentAppReadOnly", (Object)"0");
                request.setAttribute("currentAppReadOnly", (Object)"0");
            }
            dynaForm.set("kaartNaam", (Object)app.getNaam());
            request.setAttribute("kaartNaam", (Object)app.getNaam());
            String email = "";
            if (app.getVersie() != null && app.getVersie() < 2) {
                String emailSuffix = DownloadServlet.getEmailSuffix();
                if (emailSuffix != null && !emailSuffix.equals("")) {
                    email = emailSuffix;
                }
            } else if (app.getVersie() != null && app.getVersie() > 1 && app.getEmail() != null && !app.getEmail().equals("")) {
                email = app.getEmail();
            }
            dynaForm.set("gebruikerEmail", (Object)email);
            request.setAttribute("gebruikerEmail", (Object)email);
            if (app.getVersie() != null) {
                request.setAttribute("appVersion", (Object)app.getVersie());
            }
        }
        if (useUserWmsDropdown != null) {
            if (useUserWmsDropdown.booleanValue()) {
                dynaForm.set("useUserWmsDropdown", (Object)"1");
                request.setAttribute("useUserWmsDropdown", (Object)"1");
                Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
                List services = sess.createQuery("from UserService where use_in_list = :uselist order by name").setParameter("uselist", (Object)true).list();
                if (services != null && services.size() > 0) {
                    request.setAttribute("userWmsList", (Object)services);
                }
            } else {
                dynaForm.set("useUserWmsDropdown", (Object)"0");
                request.setAttribute("useUserWmsDropdown", (Object)"0");
            }
        }
        return mapping.findForward("success");
    }

    public ActionForward save(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean defaultOn;
        String[] kaartgroepenAan = (String[])dynaForm.get("kaartgroepenAan");
        String[] kaartlagenAan = (String[])dynaForm.get("kaartlagenAan");
        String[] kaartgroepenDefaultAan = (String[])dynaForm.get("kaartgroepenDefaultAan");
        String[] kaartlagenDefaultAan = (String[])dynaForm.get("kaartlagenDefaultAan");
        String[] layersAan = (String[])dynaForm.get("layersAan");
        String[] layersDefaultAan = (String[])dynaForm.get("layersDefaultAan");
        String[] useLayerStyles = (String[])dynaForm.get("useLayerStyles");
        String[] userLayerIds = (String[])dynaForm.get("userLayerIds");
        String[] useLayerSldParts = (String[])dynaForm.get("useLayerSldParts");
        kaartgroepenAan = this.addDefaultOnValues(kaartgroepenDefaultAan, kaartgroepenAan);
        kaartlagenAan = this.addDefaultOnValues(kaartlagenDefaultAan, kaartlagenAan);
        layersAan = this.addDefaultOnValues(layersDefaultAan, layersAan);
        HttpSession session = request.getSession(true);
        String code = (String)session.getAttribute(PARAM_APPCODE);
        String currentAppReadOnly = dynaForm.getString("currentAppReadOnly");
        String useUserWmsDropdown = dynaForm.getString("useUserWmsDropdown");
        Boolean makeAppReadOnly = (Boolean)dynaForm.get("makeAppReadOnly");
        Boolean isReadOnly = false;
        if (currentAppReadOnly != null && currentAppReadOnly.equals("1")) {
            isReadOnly = true;
        }
        Boolean makeReadOnly = false;
        if (makeAppReadOnly != null && makeAppReadOnly.booleanValue()) {
            makeReadOnly = true;
        }
        String kaartNaam = dynaForm.getString("kaartNaam");
        String gebruikerEmail = dynaForm.getString("gebruikerEmail");
        String newkaartoption = dynaForm.getString("newkaartoption");
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        Applicatie currentApp = KaartSelectieUtil.getApplicatie(code);
        if (newkaartoption != null && newkaartoption.equals("new")) {
            isReadOnly = true;
        }
        if (isReadOnly.booleanValue()) {
            if (currentApp != null) {
                Applicatie app = KaartSelectieUtil.copyApplicatie(currentApp, makeReadOnly, true);
                if (kaartNaam != null && !kaartNaam.equals("") && gebruikerEmail != null && !gebruikerEmail.equals("")) {
                    app.setNaam(kaartNaam);
                    app.setEmail(gebruikerEmail);
                } else {
                    app.setNaam(currentApp.getNaam());
                    app.setEmail(currentApp.getEmail());
                }
                sess.save((Object)app);
                sess.flush();
                code = app.getCode();
            }
        } else if (!isReadOnly.booleanValue() && makeReadOnly.booleanValue()) {
            currentApp.setRead_only(makeReadOnly);
            sess.save((Object)currentApp);
            sess.flush();
        }
        this.removeExistingUserKaartgroepAndUserKaartlagen(code);
        this.resetExistingUserLayers(code);
        for (int i = 0; i < kaartgroepenAan.length; ++i) {
            Integer clusterId = new Integer(kaartgroepenAan[i]);
            defaultOn = this.isKaartGroepDefaultOn(kaartgroepenDefaultAan, clusterId);
            UserKaartgroep groep = this.getUserKaartGroep(code, clusterId);
            if (groep != null) {
                groep.setDefault_on(defaultOn);
                sess.merge((Object)groep);
                continue;
            }
            UserKaartgroep newGroep = new UserKaartgroep(code, clusterId, defaultOn);
            sess.save((Object)newGroep);
        }
        for (int j = 0; j < kaartlagenAan.length; ++j) {
            Integer themaId = new Integer(kaartlagenAan[j]);
            defaultOn = this.isKaartlaagDefaultOn(kaartlagenDefaultAan, themaId);
            UserKaartlaag laag = this.getUserKaartlaag(code, themaId);
            if (laag != null) {
                laag.setDefault_on(defaultOn);
                sess.merge((Object)laag);
                continue;
            }
            UserKaartlaag newLaag = new UserKaartlaag(code, themaId, defaultOn);
            sess.save((Object)newLaag);
        }
        for (int k = 0; k < layersAan.length; ++k) {
            Integer id = new Integer(layersAan[k]);
            defaultOn = this.isKaartlaagDefaultOn(layersDefaultAan, id);
            UserLayer userLayer = (UserLayer)sess.get(UserLayer.class, (Serializable)id);
            if (userLayer == null) continue;
            userLayer.setDefault_on(defaultOn);
            userLayer.setShow(true);
            sess.merge((Object)userLayer);
        }
        for (int m = 0; m < useLayerStyles.length; ++m) {
            String[] useStyle = useLayerStyles[m].split("@");
            Integer layerId = new Integer(useStyle[0]);
            String styleName = useStyle[1];
            if (layerId == null || layerId <= 0 || styleName == null) continue;
            UserLayer ul = (UserLayer)sess.get(UserLayer.class, (Serializable)layerId);
            if (styleName.equals("default")) {
                ul.setUse_style(null);
            } else {
                ul.setUse_style(styleName);
            }
            sess.merge((Object)ul);
        }
        for (int n = 0; n < useLayerSldParts.length; ++n) {
            String sldPart = useLayerSldParts[n];
            Integer layerId = new Integer(userLayerIds[n]);
            if (sldPart == null || layerId == null || layerId <= 0) continue;
            UserLayer ul = (UserLayer)sess.get(UserLayer.class, (Serializable)layerId);
            if (sldPart == null || sldPart.equals("")) {
                ul.setSld_part(null);
            } else {
                ul.setSld_part(sldPart);
            }
            sess.merge((Object)ul);
        }
        session.setAttribute(PARAM_APPCODE, (Object)code);
        request.setAttribute("appCodeSaved", (Object)code);
        if (useUserWmsDropdown != null && !useUserWmsDropdown.equals("")) {
            if (useUserWmsDropdown.equals("1")) {
                List services = sess.createQuery("from UserService where use_in_list = :uselist order by name").setParameter("uselist", (Object)true).list();
                if (services != null && services.size() > 0) {
                    request.setAttribute("userWmsList", (Object)services);
                }
                session.setAttribute("useUserWmsDropdown", (Object)true);
                request.setAttribute("useUserWmsDropdown", (Object)"1");
            } else {
                session.setAttribute("useUserWmsDropdown", (Object)false);
                request.setAttribute("useUserWmsDropdown", (Object)"0");
            }
        }
        if (kaartNaam != null && !kaartNaam.equals("") && gebruikerEmail != null && !gebruikerEmail.equals("")) {
            String servletpath = request.getRequestURL().toString();
            servletpath = servletpath.substring(0, servletpath.lastIndexOf("/"));
            String url = servletpath + "/viewer.do?appCode=" + code + "&forceViewer=true";
            this.sendEmail(kaartNaam, gebruikerEmail, url);
        }
        KaartSelectieUtil.populateKaartSelectieForm(code, request);
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    private void sendEmail(String kaartNaam, String gebruikerEmail, String link) {
        try {
            Properties properties = System.getProperties();
            String smtpHost = DownloadServlet.getSmtpHost();
            properties.put("mail.smtp.host", smtpHost);
            javax.mail.Session mailSession = javax.mail.Session.getInstance((Properties)properties, null);
            mailSession.setDebug(false);
            MimeMessage msg = new MimeMessage(mailSession);
            String contactEmail = DownloadServlet.getContactEmail();
            if (contactEmail == null) {
                throw new Exception("Instelling contact e-mail is verplicht.");
            }
            InternetAddress frmAddress = new InternetAddress(contactEmail);
            msg.setFrom((Address)frmAddress);
            InternetAddress[] toAddresses = InternetAddress.parse((String)gebruikerEmail);
            msg.setRecipients(Message.RecipientType.TO, (Address[])toAddresses);
            String onderwerp = "Gisviewer link naar " + kaartNaam + " kaart";
            msg.setSubject(onderwerp);
            String file = DownloadServlet.getMailKaartselectie();
            Object[] params = null;
            params = new Object[]{kaartNaam, link, contactEmail};
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedInputStream in = null;
            in = new BufferedInputStream(new FileInputStream(file), 8192);
            StreamCopy.copy((InputStream)in, (OutputStream)out);
            MessageFormat textMessage = new MessageFormat(out.toString(ISO_CHARSET), Locale.ENGLISH);
            String tekst = textMessage.format(params);
            msg.setContent((Object)tekst, "text/plain");
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
        }
        catch (AddressException ae) {
            log.error((Object)"Fout bij het opgegeven emailadres. ", (Throwable)ae);
        }
        catch (SendFailedException sfe) {
            log.error((Object)"Fout bij het verzenden van het bericht.", (Throwable)sfe);
        }
        catch (MessagingException me) {
            log.error((Object)"Fout bij het verzenden van het bericht. ", (Throwable)me);
        }
        catch (Exception e) {
            log.error((Object)"Error", (Throwable)e);
        }
    }

    public ActionForward saveWMSService(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserService service;
        String groupName = (String)dynaForm.get("groupName");
        String serviceUrl = (String)dynaForm.get("serviceUrl");
        String sldUrl = (String)dynaForm.get("sldUrl");
        Boolean useWmsDropdown = false;
        String selectedUserWMSId = (String)dynaForm.get("selectedUserWMSId");
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        if (selectedUserWMSId != null && !selectedUserWMSId.equals("") && (service = (UserService)sess.get(UserService.class, (Serializable)new Integer(selectedUserWMSId))) != null) {
            useWmsDropdown = true;
            groupName = service.getGroupname();
            serviceUrl = service.getUrl();
            sldUrl = service.getSld_url();
        }
        HttpSession session = request.getSession(true);
        String code = (String)session.getAttribute(PARAM_APPCODE);
        String currentAppReadOnly = dynaForm.getString("currentAppReadOnly");
        Boolean makeAppReadOnly = (Boolean)dynaForm.get("makeAppReadOnly");
        Boolean isReadOnly = false;
        if (currentAppReadOnly != null && currentAppReadOnly.equals("1")) {
            isReadOnly = true;
        }
        Boolean makeReadOnly = false;
        if (makeAppReadOnly != null && makeAppReadOnly.booleanValue()) {
            makeReadOnly = true;
        }
        Applicatie currentApp = KaartSelectieUtil.getApplicatie(code);
        Applicatie app = null;
        if (isReadOnly.booleanValue()) {
            if (currentApp != null) {
                app = KaartSelectieUtil.copyApplicatie(currentApp, makeReadOnly, true);
                app.setNaam(currentApp.getNaam());
                sess.save((Object)app);
                sess.flush();
                code = app.getCode();
            }
        } else if (!isReadOnly.booleanValue() && makeReadOnly.booleanValue()) {
            currentApp.setRead_only(makeReadOnly);
            sess.save((Object)currentApp);
            sess.flush();
        }
        OGCRequest wmsUrl = this.checkWmsUrl(serviceUrl.trim());
        URL url = null;
        try {
            url = new URL(wmsUrl.getUrl());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        WebMapServer wms = null;
        Layer[] layers = null;
        try {
            wms = new WebMapServer(url);
            layers = WMSUtils.getNamedLayers((WMSCapabilities)wms.getCapabilities());
        }
        catch (IOException ioex) {
            log.error((Object)"Kan geen verbinding maken naar de WMS Service.", (Throwable)ioex);
            this.reloadFormData(request);
            this.addMessage(request, ERROR_SAVE_WMS_IO, url.toString());
            return this.getAlternateForward(mapping, request);
        }
        catch (ServiceException se) {
            log.error((Object)"De WMS Service geeft een fout status terug.", (Throwable)se);
            this.reloadFormData(request);
            this.addMessage(request, ERROR_SAVE_WMS_SERVICE, url.toString());
            return this.getAlternateForward(mapping, request);
        }
        catch (SAXException saxe) {
            log.error((Object)"De WMS Service geeft een ongeldig document terug.", (Throwable)saxe);
            this.reloadFormData(request);
            this.addMessage(request, ERROR_SAVE_WMS_SAX, url.toString());
            return this.getAlternateForward(mapping, request);
        }
        catch (Exception ex) {
            log.error((Object)"Fout tijdens opslaan WMS Service: ", (Throwable)ex);
            this.reloadFormData(request);
            this.addMessage(request, ERROR_SAVE_WMS, url.toString());
            return this.getAlternateForward(mapping, request);
        }
        UserService us = new UserService(code, serviceUrl, groupName);
        List<Layer> parents = this.getParentLayers(layers);
        for (Layer layer : parents) {
            UserLayer ul = this.createUserLayers(us, layer, null);
            us.addLayer(ul);
        }
        if (parents.size() < 1) {
            for (int i = 0; i < layers.length; ++i) {
                UserLayer ul = this.createUserLayers(us, layers[i], null);
                us.addLayer(ul);
            }
        }
        if (sldUrl != null && !sldUrl.equals("")) {
            us.setSld_url(sldUrl);
        }
        sess.save((Object)us);
        SldWriter sldwriter = new SldWriter();
        if (sldUrl != null && !sldUrl.equals("")) {
            sldwriter.parseByUrl(sldUrl);
        }
        Set layerSet = us.getUser_layers();
        for (UserLayer userLayer : layerSet) {
            List userStyles = sldwriter.getUserStyles(userLayer.getName());
            for (SldUserStyle userStyle : userStyles) {
                userLayer.setSld_part(userStyle.getSldPart());
                UserLayerStyle uls = new UserLayerStyle();
                uls.setLayerid(userLayer);
                if (userLayer.getName() == null && userLayer.getName().equals("")) {
                    uls.setName(userStyle.getName() + "_SLD");
                } else {
                    uls.setName(userLayer.getName());
                }
                userLayer.addStyle(uls);
            }
            sess.save((Object)userLayer);
        }
        session.setAttribute(PARAM_APPCODE, (Object)code);
        request.setAttribute("appCodeSaved", (Object)code);
        KaartSelectieUtil.populateKaartSelectieForm(code, request);
        if (useWmsDropdown.booleanValue()) {
            List services = sess.createQuery("from UserService where use_in_list = :uselist order by name").setParameter("uselist", (Object)true).list();
            if (services != null && services.size() > 0) {
                request.setAttribute("userWmsList", (Object)services);
            }
            session.setAttribute("useUserWmsDropdown", (Object)true);
            request.setAttribute("useUserWmsDropdown", (Object)"1");
        } else {
            session.setAttribute("useUserWmsDropdown", (Object)false);
            request.setAttribute("useUserWmsDropdown", (Object)"0");
        }
        if (app != null) {
            Boolean readOnly = app.getRead_only();
            if (readOnly.booleanValue()) {
                dynaForm.set("currentAppReadOnly", (Object)"1");
                request.setAttribute("currentAppReadOnly", (Object)"1");
            } else {
                dynaForm.set("currentAppReadOnly", (Object)"0");
                request.setAttribute("currentAppReadOnly", (Object)"0");
            }
            dynaForm.set("kaartNaam", (Object)app.getNaam());
            dynaForm.set("gebruikerEmail", (Object)app.getEmail());
            request.setAttribute("kaartNaam", (Object)app.getNaam());
        }
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward deleteWMSServices(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession(true);
        Boolean useUserWmsDropdown = (Boolean)session.getAttribute("useUserWmsDropdown");
        String[] servicesAan = (String[])dynaForm.get("servicesAan");
        String code = (String)session.getAttribute(PARAM_APPCODE);
        Applicatie app = KaartSelectieUtil.getApplicatie(code);
        for (int i = 0; i < servicesAan.length; ++i) {
            Integer serviceId = new Integer(servicesAan[i]);
            KaartSelectieUtil.removeService(serviceId);
        }
        KaartSelectieUtil.populateKaartSelectieForm(code, request);
        if (useUserWmsDropdown.booleanValue()) {
            Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
            List services = sess.createQuery("from UserService where use_in_list = :uselist order by name").setParameter("uselist", (Object)true).list();
            if (services != null && services.size() > 0) {
                request.setAttribute("userWmsList", (Object)services);
            }
            session.setAttribute("useUserWmsDropdown", (Object)true);
            request.setAttribute("useUserWmsDropdown", (Object)"1");
        } else {
            session.setAttribute("useUserWmsDropdown", (Object)false);
            request.setAttribute("useUserWmsDropdown", (Object)"0");
        }
        if (app != null) {
            Boolean readOnly = app.getRead_only();
            if (readOnly.booleanValue()) {
                dynaForm.set("currentAppReadOnly", (Object)"1");
                request.setAttribute("currentAppReadOnly", (Object)"1");
            } else {
                dynaForm.set("currentAppReadOnly", (Object)"0");
                request.setAttribute("currentAppReadOnly", (Object)"0");
            }
            dynaForm.set("kaartNaam", (Object)app.getNaam());
            dynaForm.set("gebruikerEmail", (Object)app.getEmail());
            request.setAttribute("kaartNaam", (Object)app.getNaam());
        }
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    private List<Layer> getParentLayers(Layer[] layers) {
        ArrayList<Layer> parents = new ArrayList<Layer>();
        for (int i = 0; i < layers.length; ++i) {
            if (layers[i].getChildren().length <= 0 && layers[i].getParent() != null) continue;
            parents.add(layers[i]);
        }
        return parents;
    }

    private UserLayer createUserLayers(UserService us, Layer layer, UserLayer parent) {
        String layerTitle = layer.getTitle();
        String layerName = layer.getName();
        boolean queryable = layer.isQueryable();
        double scaleMin = layer.getScaleDenominatorMin();
        double scaleMax = layer.getScaleDenominatorMax();
        UserLayer ul = new UserLayer();
        ul.setServiceid(us);
        if (layerName != null && !layerName.equals("")) {
            ul.setName(layerName);
        }
        if (layerTitle != null && !layerTitle.equals("")) {
            ul.setTitle(layerTitle);
        }
        ul.setQueryable(queryable);
        if (scaleMin > 0.0) {
            ul.setScalehint_min(Double.toString(scaleMin));
        }
        if (scaleMax > 0.0) {
            ul.setScalehint_max(Double.toString(scaleMax));
        }
        List styles = layer.getStyles();
        for (StyleImpl style : styles) {
            String styleName = style.getName();
            if (styleName == null || styleName.equals("")) continue;
            UserLayerStyle uls = new UserLayerStyle(ul, styleName);
            ul.addStyle(uls);
        }
        if (parent != null) {
            ul.setParent(parent);
        }
        Layer[] childs = layer.getChildren();
        for (int i = 0; i < childs.length; ++i) {
            UserLayer child = this.createUserLayers(us, childs[i], ul);
            us.addLayer(child);
        }
        return ul;
    }

    private void setTree(HttpServletRequest request) throws JSONException, Exception {
        List ctl = SpatialUtil.getValidClusters();
        HibernateUtil.setUseKaartenbalieCluster(false);
        List themalist = this.getValidThemas(false, ctl, request);
        Map rootClusterMap = this.getClusterMap(themalist, ctl, null);
        GisPrincipal user = GisPrincipal.getGisPrincipal(request);
        JSONObject treeObject = this.createJasonObject(rootClusterMap, user);
        request.setAttribute("tree", (Object)treeObject);
    }

    private Map getClusterMap(List themalist, List clusterlist, Clusters rootCluster) throws JSONException, Exception {
        if (themalist == null || clusterlist == null) {
            return null;
        }
        List childrenList = this.getThemaList(themalist, rootCluster);
        ArrayList<Map> subclusters = null;
        for (Clusters cluster : clusterlist) {
            Map clusterMap;
            if (rootCluster != cluster.getParent() || (clusterMap = this.getClusterMap(themalist, clusterlist, cluster)) == null || clusterMap.isEmpty()) continue;
            if (subclusters == null) {
                subclusters = new ArrayList<Map>();
            }
            subclusters.add(clusterMap);
        }
        if ((childrenList == null || childrenList.isEmpty()) && (subclusters == null || subclusters.isEmpty())) {
            return null;
        }
        HashMap<String, Object> clusterNode = new HashMap<String, Object>();
        clusterNode.put("subclusters", subclusters);
        clusterNode.put("children", childrenList);
        clusterNode.put("cluster", rootCluster);
        return clusterNode;
    }

    private List getThemaList(List themalist, Clusters rootCluster) throws JSONException, Exception {
        if (themalist == null) {
            return null;
        }
        ArrayList<Themas> children = null;
        for (Themas thema : themalist) {
            if (thema.getCluster() != rootCluster) continue;
            if (children == null) {
                children = new ArrayList<Themas>();
            }
            children.add(thema);
        }
        return children;
    }

    protected JSONObject createJasonObject(Map rootClusterMap, GisPrincipal user) throws JSONException {
        JSONObject root = new JSONObject().put("id", (Object)"root").put("type", (Object)"root").put("title", (Object)"root");
        if (rootClusterMap == null || rootClusterMap.isEmpty()) {
            return root;
        }
        List clusterMaps = (List)rootClusterMap.get("subclusters");
        if (clusterMaps == null || clusterMaps.isEmpty()) {
            return root;
        }
        List<UserKaartgroep> groepen = SpatialUtil.getUserKaartGroepen(user.getCode());
        List<UserKaartlaag> lagen = SpatialUtil.getUserKaartLagen(user.getCode());
        root.put("children", (Object)this.getSubClusters(clusterMaps, null, user, 0, groepen, lagen));
        return root;
    }

    private JSONArray getSubClusters(List subclusterMaps, JSONArray clusterArray, GisPrincipal user, int order, List<UserKaartgroep> groepen, List<UserKaartlaag> lagen) throws JSONException {
        if (subclusterMaps == null) {
            return clusterArray;
        }
        for (Map clMap : subclusterMaps) {
            Clusters cluster = (Clusters)clMap.get("cluster");
            JSONObject jsonCluster = new JSONObject();
            if (cluster.getId() != null) {
                jsonCluster.put("id", cluster.getId().intValue());
            }
            jsonCluster.put("type", (Object)"child");
            String titel = cluster.getNaam();
            if (titel == null || titel.equals("")) {
                titel = "(geen naam opgegeven)";
            }
            jsonCluster.put("title", (Object)titel);
            jsonCluster.put("cluster", true);
            if (cluster.isExclusive_childs()) {
                jsonCluster.put("exclusive_childs", true);
            } else {
                jsonCluster.put("exclusive_childs", false);
            }
            this.setExtraClusterProperties(jsonCluster, cluster);
            jsonCluster.put("visible", true);
            if (cluster.getMetadatalink() != null) {
                Object metadatalink = cluster.getMetadatalink();
                metadatalink = ((String)metadatalink).replaceAll("%id%", "" + cluster.getId());
                jsonCluster.put("metadatalink", metadatalink);
            } else {
                jsonCluster.put("metadatalink", (Object)"#");
            }
            jsonCluster.put("groepSelected", false);
            jsonCluster.put("groupDefaultOn", false);
            for (UserKaartgroep kaartGroep : groepen) {
                if (cluster.getId().intValue() != kaartGroep.getClusterid().intValue()) continue;
                jsonCluster.put("groepSelected", true);
                if (!kaartGroep.getDefault_on().booleanValue()) continue;
                jsonCluster.put("groupDefaultOn", true);
            }
            List childrenList = (List)clMap.get("children");
            JSONArray childrenArray = new JSONArray();
            order = this.getChildren(childrenArray, childrenList, user, order, lagen);
            List subsubclusterMaps = (List)clMap.get("subclusters");
            childrenArray = this.getSubClusters(subsubclusterMaps, childrenArray, user, order, groepen, lagen);
            jsonCluster.put("children", (Object)childrenArray);
            if (clusterArray == null) {
                clusterArray = new JSONArray();
            }
            clusterArray.put((Object)jsonCluster);
        }
        return clusterArray;
    }

    private void setExtraClusterProperties(JSONObject jsonCluster, Clusters cluster) throws JSONException {
        if (cluster.isDefault_cluster()) {
            jsonCluster.put("default_cluster", true);
        } else {
            jsonCluster.put("default_cluster", false);
        }
        if (cluster.isHide_legend()) {
            jsonCluster.put("hide_legend", true);
        } else {
            jsonCluster.put("hide_legend", false);
        }
        if (cluster.isHide_tree()) {
            jsonCluster.put("hide_tree", true);
        } else {
            jsonCluster.put("hide_tree", false);
        }
        if (cluster.isBackground_cluster()) {
            jsonCluster.put("background", true);
        } else {
            jsonCluster.put("background", false);
        }
        if (cluster.isExtra_level()) {
            jsonCluster.put("extra_level", true);
        } else {
            jsonCluster.put("extra_level", false);
        }
        if (cluster.isCallable()) {
            jsonCluster.put("callable", true);
        } else {
            jsonCluster.put("callable", false);
        }
    }

    private int getChildren(JSONArray childrenArray, List children, GisPrincipal user, int order, List<UserKaartlaag> lagen) throws JSONException {
        if (children == null || childrenArray == null) {
            return order;
        }
        for (Themas th : children) {
            boolean validAdmindataSource = false;
            Gegevensbron themaGb = th.getGegevensbron();
            if (themaGb != null && themaGb.getAdmin_pk() != null) {
                validAdmindataSource = true;
            }
            if (th.isAnalyse_thema() && !validAdmindataSource) {
                log.debug((Object)(th.getNaam() + "' is analyse kaartlaag maar hier is nog geen gegevensbron voor geconfigureerd."));
            }
            Integer themaId = th.getId();
            String ttitel = th.getNaam();
            if (ttitel == null || ttitel.equals("")) {
                ttitel = "(geen naam opgegeven)";
            }
            JSONObject jsonCluster = new JSONObject().put("id", (Object)themaId).put("type", (Object)"child").put("title", (Object)ttitel).put("cluster", false);
            jsonCluster.put("order", ++order);
            if (th.getOrganizationcodekey() != null && th.getOrganizationcodekey().length() > 0) {
                jsonCluster.put("organizationcodekey", (Object)th.getOrganizationcodekey().toUpperCase());
            } else {
                jsonCluster.put("organizationcodekey", (Object)"");
            }
            if (th.getMaptipstring() != null) {
                jsonCluster.put("maptipfield", (Object)th.getMaptipstring());
            }
            jsonCluster.put("visible", (Object)"on");
            jsonCluster.put("analyse", (Object)"off");
            if (th.isAnalyse_thema()) {
                jsonCluster.put("highlight", (Object)"on");
            } else {
                jsonCluster.put("highlight", (Object)"off");
            }
            jsonCluster.put("kaartSelected", false);
            jsonCluster.put("kaartDefaultOn", false);
            for (UserKaartlaag kaartlaag : lagen) {
                if (th.getId().intValue() != kaartlaag.getThemaid().intValue()) continue;
                jsonCluster.put("kaartSelected", true);
                if (!kaartlaag.getDefault_on().booleanValue()) continue;
                jsonCluster.put("kaartDefaultOn", true);
            }
            Clusters cluster = th.getCluster();
            if (cluster.getId() != null) {
                jsonCluster.put("clusterid", (Object)("c" + cluster.getId()));
            }
            this.setExtraClusterProperties(jsonCluster, cluster);
            nl.b3p.wms.capabilities.Layer layer = null;
            if (th.getWms_layers_real() != null) {
                jsonCluster.put("wmslayers", (Object)th.getWms_layers_real());
                if (th.getWms_querylayers_real() != null && !validAdmindataSource) {
                    jsonCluster.put("wmsquerylayers", (Object)th.getWms_querylayers_real());
                }
                if (th.getWms_legendlayer_real() != null) {
                    jsonCluster.put("legendurl", (Object)user.getLegendGraphicUrl(user.getLayer(th.getWms_legendlayer_real()), th.getStyle()));
                }
                layer = user.getLayer(th.getWms_layers_real());
            } else {
                jsonCluster.put("wmslayers", (Object)th.getWms_layers());
                if (th.getWms_querylayers() != null && !validAdmindataSource) {
                    jsonCluster.put("wmsquerylayers", (Object)th.getWms_querylayers());
                }
                if (th.getWms_legendlayer() != null) {
                    jsonCluster.put("legendurl", (Object)user.getLegendGraphicUrl(user.getLayer(th.getWms_legendlayer()), th.getStyle()));
                }
                layer = user.getLayer(th.getWms_layers());
            }
            if (layer != null) {
                DecimalFormat formatter = new DecimalFormat("#.#####");
                double shmax = -1.0;
                try {
                    shmax = Double.parseDouble(layer.getScaleHintMax());
                }
                catch (NumberFormatException nfe) {
                    log.debug((Object)("max scale hint not valid: " + layer.getScaleHintMax()));
                }
                if (shmax > 0.0) {
                    jsonCluster.put("scalehintmax", (Object)formatter.format(shmax));
                }
                double shmin = -1.0;
                try {
                    shmin = Double.parseDouble(layer.getScaleHintMin());
                }
                catch (NumberFormatException nfe) {
                    log.debug((Object)("min scale hint not valid: " + layer.getScaleHintMin()));
                }
                if (shmin > 0.0) {
                    jsonCluster.put("scalehintmin", (Object)formatter.format(shmin));
                }
            }
            if (th.getMetadata_link() != null) {
                String metadatalink = th.getMetadata_link();
                metadatalink = metadatalink.replaceAll("%id%", "" + themaId);
                jsonCluster.put("metadatalink", (Object)metadatalink);
            } else {
                jsonCluster.put("metadatalink", (Object)"#");
            }
            childrenArray.put((Object)jsonCluster);
        }
        return order;
    }

    private UserKaartgroep getUserKaartGroep(String code, Integer clusterId) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List groepen = sess.createQuery("from UserKaartgroep where code = :code and clusterid = :clusterid").setParameter("code", (Object)code).setParameter("clusterid", (Object)clusterId).setMaxResults(1).list();
        if (groepen != null && groepen.size() == 1) {
            return (UserKaartgroep)groepen.get(0);
        }
        return null;
    }

    private UserKaartlaag getUserKaartlaag(String code, Integer themaId) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List groepen = sess.createQuery("from UserKaartlaag where code = :code and themaid = :themaid").setParameter("code", (Object)code).setParameter("themaid", (Object)themaId).setMaxResults(1).list();
        if (groepen != null && groepen.size() == 1) {
            return (UserKaartlaag)groepen.get(0);
        }
        return null;
    }

    private UserLayer getUserLayerById(Integer layerId) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List layers = sess.createQuery("from UserLayer where id = :id").setParameter("id", (Object)layerId).setMaxResults(1).list();
        if (layers != null && layers.size() == 1) {
            return (UserLayer)layers.get(0);
        }
        return null;
    }

    private boolean isKaartGroepDefaultOn(String[] kaartgroepenDefaultAan, Integer clusterId) {
        boolean defaultOn = false;
        for (int i = 0; i < kaartgroepenDefaultAan.length; ++i) {
            Integer defaultOnId = new Integer(kaartgroepenDefaultAan[i]);
            if (defaultOnId.intValue() != clusterId.intValue()) continue;
            defaultOn = true;
            break;
        }
        return defaultOn;
    }

    private boolean isKaartlaagDefaultOn(String[] kaartlagenDefaultAan, Integer themaId) {
        boolean defaultOn = false;
        for (int i = 0; i < kaartlagenDefaultAan.length; ++i) {
            Integer defaultOnId = new Integer(kaartlagenDefaultAan[i]);
            if (defaultOnId.intValue() != themaId.intValue()) continue;
            defaultOn = true;
            break;
        }
        return defaultOn;
    }

    private void removeExistingUserKaartgroepAndUserKaartlagen(String code) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List groepen = sess.createQuery("from UserKaartgroep where code = :code").setParameter("code", (Object)code).list();
        List lagen = sess.createQuery("from UserKaartlaag where code = :code").setParameter("code", (Object)code).list();
        for (UserKaartgroep groep : groepen) {
            sess.delete((Object)groep);
        }
        for (UserKaartlaag laag : lagen) {
            sess.delete((Object)laag);
        }
    }

    private void resetExistingUserLayers(String code) {
        List<UserService> services = SpatialUtil.getUserServices(code);
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        for (UserService service : services) {
            Set userLayers = service.getUser_layers();
            for (UserLayer layer : userLayers) {
                layer.setDefault_on(null);
                layer.setShow(null);
                sess.merge((Object)layer);
            }
        }
    }

    private String[] addDefaultOnValues(String[] defaults, String[] current) {
        ArrayList<String> col2 = new ArrayList<String>();
        col2.addAll(Arrays.asList(current));
        for (int j = 0; j < defaults.length; ++j) {
            if (col2.contains(defaults[j])) continue;
            col2.add(defaults[j]);
        }
        return col2.toArray(new String[0]);
    }

    private void setUserviceTrees(HttpServletRequest request) throws JSONException, Exception {
        ArrayList<JSONObject> servicesTrees = new ArrayList<JSONObject>();
        GisPrincipal user = GisPrincipal.getGisPrincipal(request);
        String code = user.getCode();
        List<UserService> services = SpatialUtil.getUserServices(code);
        for (UserService service : services) {
            JSONObject tree = this.createUserServiceTree(service);
            servicesTrees.add(tree);
        }
        request.setAttribute("servicesTrees", servicesTrees);
    }

    protected JSONObject createUserServiceTree(UserService service) throws JSONException, Exception {
        JSONObject root = new JSONObject();
        root.put("id", (Object)"0");
        root.put("title", (Object)service.getGroupname());
        root.put("name", (Object)service.getGroupname());
        root.put("serviceid", (Object)service.getId());
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List ctl = sess.createQuery("from UserLayer where serviceid = :service order by name, title, id").setParameter("service", (Object)service).list();
        Map rootLayerMap = this.getUserLayersMap(ctl, null);
        List lMaps = (List)rootLayerMap.get("sublayers");
        root.put("children", (Object)this.getSubLayers(lMaps, null));
        return root;
    }

    private Map getUserLayersMap(List layerList, UserLayer root) throws JSONException, Exception {
        if (layerList == null) {
            return null;
        }
        ArrayList<Map> subLayers = null;
        for (UserLayer la : layerList) {
            Map lMap;
            if (root != la.getParent() || (lMap = this.getUserLayersMap(layerList, la)) == null || lMap.isEmpty()) continue;
            if (subLayers == null) {
                subLayers = new ArrayList<Map>();
            }
            subLayers.add(lMap);
        }
        HashMap<String, Object> lNode = new HashMap<String, Object>();
        lNode.put("sublayers", subLayers);
        lNode.put("userlayer", root);
        return lNode;
    }

    private JSONArray getSubLayers(List subLayers, JSONArray layersArray) throws JSONException {
        if (subLayers == null) {
            return layersArray;
        }
        for (Map lMap : subLayers) {
            List subsubMaps;
            UserLayer layer = (UserLayer)lMap.get("userlayer");
            JSONObject jsonLayer = new JSONObject();
            jsonLayer.put("id", layer.getId().intValue());
            jsonLayer.put("serviceid", layer.getServiceid().getId().intValue());
            jsonLayer.put("title", (Object)layer.getTitle());
            jsonLayer.put("name", (Object)layer.getName());
            jsonLayer.put("queryable", (Object)layer.getQueryable());
            jsonLayer.put("scalehintmin", (Object)layer.getScalehint_min());
            jsonLayer.put("scalehintmax", (Object)layer.getScalehint_max());
            jsonLayer.put("use_style", (Object)layer.getUse_style());
            jsonLayer.put("sld_part", (Object)layer.getSld_part());
            jsonLayer.put("show", (Object)layer.getShow());
            jsonLayer.put("default_on", (Object)layer.getDefault_on());
            JSONArray styles = this.getLayerStyles(layer);
            if (styles != null && styles.length() > 0) {
                jsonLayer.put("styles", (Object)styles);
            }
            if ((subsubMaps = (List)lMap.get("sublayers")) != null && !subsubMaps.isEmpty()) {
                JSONArray childrenArray = new JSONArray();
                childrenArray = this.getSubLayers(subsubMaps, childrenArray);
                jsonLayer.put("children", (Object)childrenArray);
            }
            if (layersArray == null) {
                layersArray = new JSONArray();
            }
            layersArray.put((Object)jsonLayer);
        }
        return layersArray;
    }

    private JSONArray getLayerStyles(UserLayer layer) throws JSONException {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List styles = sess.createQuery("from UserLayerStyle where layerid = :layer").setParameter("layer", (Object)layer).list();
        JSONArray arr = new JSONArray();
        for (UserLayerStyle uls : styles) {
            arr.put((Object)uls.getName());
        }
        return arr;
    }

    private boolean userAlreadyHasThisService(String code, String url) {
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        List services = sess.createQuery("from UserService where code = :code and url = :url").setParameter("code", (Object)code).setParameter("url", (Object)url).setMaxResults(1).list();
        return services != null && services.size() == 1;
    }

    private String getUniqueStyleName(Set<Style> styles, String name) throws Exception {
        return this.getUniqueStyleName(styles, name, null);
    }

    private String getUniqueStyleName(Set<Style> styles, String name, Integer tries) throws Exception {
        if (tries != null && tries == 10) {
            throw new Exception("Can't create unique name for style");
        }
        String newName = name;
        if (tries != null) {
            newName = newName + tries;
        }
        Iterator<Style> it = styles.iterator();
        boolean unique = true;
        while (it.hasNext() && unique) {
            Style s = it.next();
            if (!s.getName().equals(newName)) continue;
            unique = false;
        }
        if (!unique) {
            if (tries == null) {
                tries = new Integer("0");
            }
            Integer n = tries;
            Integer n2 = tries = Integer.valueOf(tries + 1);
            return this.getUniqueStyleName(styles, name, tries);
        }
        return newName;
    }

    protected OGCRequest checkWmsUrl(String url) throws Exception {
        OGCRequest ogcrequest = new OGCRequest(url);
        if (ogcrequest.containsParameter("REQUEST") && !"GetCapabilities".equalsIgnoreCase(ogcrequest.getParameter("REQUEST"))) {
            log.error((Object)KBConfiguration.UNSUPPORTED_REQUEST);
            throw new Exception(KBConfiguration.UNSUPPORTED_REQUEST);
        }
        ogcrequest.addOrReplaceParameter("REQUEST", "GetCapabilities");
        if (ogcrequest.containsParameter("SERVICE") && !"WMS".equalsIgnoreCase(ogcrequest.getParameter("SERVICE"))) {
            log.error((Object)KBConfiguration.UNSUPPORTED_SERVICE);
            throw new Exception(KBConfiguration.UNSUPPORTED_SERVICE);
        }
        ogcrequest.addOrReplaceParameter("SERVICE", "WMS");
        if (ogcrequest.containsParameter("VERSION") && !"1.1.1".equalsIgnoreCase(ogcrequest.getParameter("VERSION"))) {
            log.error((Object)KBConfiguration.UNSUPPORTED_VERSION);
            throw new Exception(KBConfiguration.UNSUPPORTED_VERSION);
        }
        ogcrequest.addOrReplaceParameter("VERSION", "1.1.1");
        return ogcrequest;
    }
}

