/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gis.viewer;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKTReader;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import nl.b3p.commons.services.FormUtils;
import nl.b3p.commons.struts.ExtendedMethodProperties;
import nl.b3p.gis.utils.ConfigKeeper;
import nl.b3p.gis.utils.KaartSelectieUtil;
import nl.b3p.gis.viewer.BaseGisAction;
import nl.b3p.gis.viewer.db.Applicatie;
import nl.b3p.gis.viewer.db.CMSPagina;
import nl.b3p.gis.viewer.db.Clusters;
import nl.b3p.gis.viewer.db.Gegevensbron;
import nl.b3p.gis.viewer.db.Tekstblok;
import nl.b3p.gis.viewer.db.Themas;
import nl.b3p.gis.viewer.db.UserKaartgroep;
import nl.b3p.gis.viewer.db.UserKaartlaag;
import nl.b3p.gis.viewer.db.UserLayer;
import nl.b3p.gis.viewer.db.UserService;
import nl.b3p.gis.viewer.services.GisPrincipal;
import nl.b3p.gis.viewer.services.HibernateUtil;
import nl.b3p.gis.viewer.services.SpatialUtil;
import nl.b3p.wms.capabilities.Layer;
import nl.b3p.wms.capabilities.ServiceProvider;
import nl.b3p.wms.capabilities.SrsBoundingBox;
import nl.b3p.wms.capabilities.TileSet;
import nl.b3p.zoeker.configuratie.ZoekAttribuut;
import nl.b3p.zoeker.configuratie.ZoekConfiguratie;
import nl.b3p.zoeker.services.A11YResult;
import nl.b3p.zoeker.services.Zoeker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;
import org.hibernate.classic.Session;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.securityfilter.filter.SecurityFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewerAction
extends BaseGisAction {
    private static final Log log = LogFactory.getLog(ViewerAction.class);
    protected static final String LIST = "list";
    protected static final String LOGIN = "login";
    protected static final String SIMPLE_VIEWER_FW = "simpleviewer";
    private static final String PAGE_GISVIEWER_TAB = "gisviewer_tab";
    public static final String ID = "id";
    public static final String CLUSTERID = "clusterId";
    public static final String EXTENT = "extent";
    public static final String RESOLUTION = "resolution";
    public static final String SEARCHCONFIGID = "searchConfigId";
    public static final String SEARCHCONFIGNAME = "searchConfigName";
    public static final String SEARCH = "search";
    public static final String SEARCHACTION = "searchAction";
    public static final String SEARCHSLDTHEMAID = "searchSldThemaId";
    public static final String SEARCHID = "searchId";
    public static final String SEARCHSLDCLUSTERID = "searchSldClusterId";
    public static final String SEARCHCLUSTERID = "searchClusterId";
    public static final String SEARCHSLDVISIBLEVALUE = "searchSldVisibleValue";
    public static final String ACTIVETAB = "activeTab";
    public static final String ENABLEDTAB = "enabledTabs";
    public static final String EXPANDNODES = "expandNodes";
    public static final String ZOEKCONFIGURATIES = "zoekconfiguraties";
    public static final double squareRootOf2 = Math.sqrt(2.0);
    public static final String APPCODE = "appCode";
    public static final String A11Y_VIEWER_FW = "a11yViewer";
    public static final String A11Y = "accessibility";
    public static final String FORCEVIEWER = "forceViewer";

    protected Map getActionMethodPropertiesMap() {
        HashMap<String, ExtendedMethodProperties> map = new HashMap<String, ExtendedMethodProperties>();
        ExtendedMethodProperties hibProp = null;
        hibProp = new ExtendedMethodProperties(LIST);
        hibProp.setDefaultForwardName(LIST);
        hibProp.setAlternateForwardName("failure");
        map.put(LIST, hibProp);
        return map;
    }

    public ActionForward list(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        List themalist = this.getValidUserThemas(false, null, request);
        request.setAttribute("themalist", (Object)themalist);
        this.addDefaultMessage(mapping, request, "acknowledgeMessages");
        return this.getDefaultForward(mapping, request);
    }

    public ActionForward unspecified(ActionMapping mapping, DynaValidatorForm dynaForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewerTemplate;
        Integer nr;
        GisPrincipal user = GisPrincipal.getGisPrincipal(request);
        if (user == null) {
            SecurityFilter.saveRequestInformation((HttpServletRequest)request);
            log.debug((Object)"Ongeldige gebruiker. Terug naar login form.");
            return mapping.findForward(LOGIN);
        }
        String a11yStr = request.getParameter(A11Y);
        if (a11yStr != null && !a11yStr.equals("") && (nr = new Integer(a11yStr)) != null && nr == 1) {
            return mapping.findForward(A11Y_VIEWER_FW);
        }
        this.createLists(dynaForm, request);
        Map configMap = (Map)request.getAttribute("configMap");
        if (configMap != null && (viewerTemplate = (String)configMap.get("viewerTemplate")) != null && viewerTemplate.equals("embedded")) {
            return mapping.findForward(SIMPLE_VIEWER_FW);
        }
        String forceViewer = request.getParameter(FORCEVIEWER);
        if (forceViewer != null && !forceViewer.equals("")) {
            boolean viewer = new Boolean(forceViewer);
            if (!viewer) {
                return mapping.findForward(A11Y_VIEWER_FW);
            }
        } else {
            return mapping.findForward(A11Y_VIEWER_FW);
        }
        return mapping.findForward("success");
    }

    @Override
    protected void createLists(DynaValidatorForm dynaForm, HttpServletRequest request) throws Exception {
        Layer layer;
        String cfgExtent;
        String treeOrder;
        ConfigKeeper configKeeper;
        Map<String, Object> map;
        Boolean useUserWmsDropdown;
        super.createLists(dynaForm, request);
        List ctl = SpatialUtil.getValidClusters();
        List themalist = this.getValidUserThemas(false, ctl, request);
        GisPrincipal user = GisPrincipal.getGisPrincipal(request);
        String userCode = user.getCode();
        request.setAttribute("userRoles", (Object)new JSONArray((Collection)user.getRoles()));
        Applicatie app = null;
        String appCode = request.getParameter(APPCODE);
        if (appCode != null && appCode.length() > 0) {
            app = KaartSelectieUtil.getApplicatie(appCode);
        }
        if (app == null) {
            app = KaartSelectieUtil.getDefaultApplicatie();
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        if (app == null) {
            app = KaartSelectieUtil.getNewApplicatie();
            app.setDefault_app(true);
            app.setNaam("standaard");
            sess.save((Object)app);
            sess.flush();
            ConfigKeeper.createStandardApplicationConfiguration(app.getCode());
        }
        if (app != null && !app.getNaam().equals("")) {
            request.setAttribute("appName", (Object)app.getNaam());
        }
        if (app != null) {
            HttpSession session = request.getSession(true);
            session.setAttribute(APPCODE, (Object)app.getCode());
            request.setAttribute("bookmarkAppcode", (Object)app.getCode());
            appCode = app.getCode();
            app.setDatum_gebruikt(new Date());
            sess.save((Object)app);
            sess.flush();
        }
        Map rootClusterMap = this.getClusterMap(themalist, ctl, null, userCode);
        ArrayList<Integer> actieveThemas = null;
        if (FormUtils.nullIfEmpty((String)request.getParameter(ID)) != null) {
            actieveThemas = new ArrayList<Integer>();
            String[] ids = request.getParameter(ID).split(",");
            for (int i = 0; i < ids.length; ++i) {
                try {
                    int id = Integer.parseInt(ids[i]);
                    actieveThemas.add(id);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    log.error((Object)"Id geen integer. ", (Throwable)nfe);
                }
            }
            if (actieveThemas.isEmpty()) {
                actieveThemas = null;
            }
        }
        String lastActiefThemaId = null;
        if (actieveThemas != null) {
            lastActiefThemaId = "" + actieveThemas.get(actieveThemas.size() - 1);
        }
        Themas actiefThema = SpatialUtil.getThema(lastActiefThemaId);
        ArrayList<Integer> actieveClusters = null;
        if (FormUtils.nullIfEmpty((String)request.getParameter(CLUSTERID)) != null) {
            actieveClusters = new ArrayList<Integer>();
            String[] ids = request.getParameter(CLUSTERID).split(",");
            for (int i = 0; i < ids.length; ++i) {
                try {
                    int id = Integer.parseInt(ids[i]);
                    actieveClusters.add(id);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    log.error((Object)"ClusterId geen integer. ", (Throwable)nfe);
                }
            }
            if (actieveClusters.isEmpty()) {
                actieveClusters = null;
            }
        }
        if ((useUserWmsDropdown = (Boolean)(map = (configKeeper = new ConfigKeeper()).getConfigMap(appCode, true)).get("useUserWmsDropdown")) != null) {
            HttpSession session = request.getSession(true);
            session.setAttribute("useUserWmsDropdown", (Object)useUserWmsDropdown);
        }
        request.setAttribute("configMap", map);
        JSONObject treeObject = this.createJasonObject(rootClusterMap, actieveThemas, actieveClusters, user, appCode);
        request.setAttribute("tree", (Object)treeObject);
        if (map != null && (treeOrder = (String)map.get("treeOrder")) != null && treeOrder.equals("alphabet")) {
            this.convertTreeOrderPlim(treeObject);
        }
        this.setUserviceTrees(appCode, request);
        GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 28992);
        Polygon extentBbox = null;
        Polygon fullExtentBbox = null;
        Set bboxen = null;
        if (user.getSp().getTopLayer() != null) {
            bboxen = user.getSp().getTopLayer().getSrsbb();
            for (SrsBoundingBox bbox : bboxen) {
                if (FormUtils.nullIfEmpty((String)bbox.getMaxx()) == null || FormUtils.nullIfEmpty((String)bbox.getMaxy()) == null || FormUtils.nullIfEmpty((String)bbox.getMinx()) == null || FormUtils.nullIfEmpty((String)bbox.getMiny()) == null || bbox.getSrs() == null || !bbox.getSrs().equalsIgnoreCase("epsg:28992")) continue;
                request.setAttribute("fullExtent", (Object)(bbox.getMinx() + "," + bbox.getMiny() + "," + bbox.getMaxx() + "," + bbox.getMaxy()));
                try {
                    Coordinate[] ca = this.getCoordinateArray(Double.parseDouble(bbox.getMinx()), Double.parseDouble(bbox.getMiny()), Double.parseDouble(bbox.getMaxx()), Double.parseDouble(bbox.getMaxy()));
                    LinearRing lr = geometryFactory.createLinearRing(ca);
                    fullExtentBbox = geometryFactory.createPolygon(lr, null);
                }
                catch (NumberFormatException nfe) {
                    log.error((Object)("BBOX fullextent wrong format: " + request.getAttribute("fullExtent")));
                }
                break;
            }
        }
        String extent = null;
        if (request.getParameter(EXTENT) != null && request.getParameter(EXTENT).split(",").length == 4) {
            try {
                String requestExtent = request.getParameter(EXTENT);
                int test = Integer.parseInt(requestExtent.split(",")[0]);
                test = Integer.parseInt(requestExtent.split(",")[1]);
                test = Integer.parseInt(requestExtent.split(",")[2]);
                test = Integer.parseInt(requestExtent.split(",")[3]);
                extent = requestExtent;
            }
            catch (NumberFormatException nfe) {
                log.error((Object)"1 of meer van de opgegeven extent coordinaten is geen getal.");
                extent = null;
            }
        }
        if (map != null && extent == null && (cfgExtent = (String)map.get(EXTENT)) != null && cfgExtent.split(",").length == 4) {
            extent = cfgExtent;
        }
        if (FormUtils.nullIfEmpty((String)request.getParameter(RESOLUTION)) != null) {
            request.setAttribute(RESOLUTION, (Object)request.getParameter(RESOLUTION));
        }
        if (extent == null && actiefThema != null && (layer = user.getLayer(actiefThema.getWms_layers_real())) != null && (bboxen = layer.getSrsbb()) != null) {
            for (SrsBoundingBox bbox : bboxen) {
                if (FormUtils.nullIfEmpty((String)bbox.getMaxx()) == null || FormUtils.nullIfEmpty((String)bbox.getMaxy()) == null || FormUtils.nullIfEmpty((String)bbox.getMinx()) == null || FormUtils.nullIfEmpty((String)bbox.getMiny()) == null || bbox.getSrs() == null || !bbox.getSrs().equalsIgnoreCase("epsg:28992")) continue;
                extent = "" + bbox.getMinx() + "," + bbox.getMiny() + "," + bbox.getMaxx() + "," + bbox.getMaxy();
                try {
                    Coordinate[] ca = this.getCoordinateArray(Double.parseDouble(bbox.getMinx()), Double.parseDouble(bbox.getMiny()), Double.parseDouble(bbox.getMaxx()), Double.parseDouble(bbox.getMaxy()));
                    LinearRing lr = geometryFactory.createLinearRing(ca);
                    extentBbox = geometryFactory.createPolygon(lr, null);
                }
                catch (NumberFormatException nfe) {
                    log.error((Object)("BBOX extent wrong format: " + extent));
                }
                break;
            }
        }
        if (extent != null) {
            Envelope env;
            Polygon ip;
            if (fullExtentBbox != null && extentBbox != null && !(ip = (Polygon)fullExtentBbox.intersection(extentBbox)).isEmpty() && (env = ip.getEnvelopeInternal()) != null) {
                extent = "" + env.getMinX() + "," + env.getMinY() + "," + env.getMaxX() + "," + env.getMaxY();
            }
            request.setAttribute(EXTENT, extent);
        }
        if (FormUtils.nullIfEmpty((String)request.getParameter(SEARCHCONFIGID)) != null && FormUtils.nullIfEmpty((String)request.getParameter(SEARCH)) != null) {
            try {
                request.setAttribute(SEARCHCONFIGID, (Object)new Integer(request.getParameter(SEARCHCONFIGID)));
                request.setAttribute(SEARCH, (Object)request.getParameter(SEARCH));
                if (FormUtils.nullIfEmpty((String)request.getParameter(SEARCHACTION)) != null) {
                    request.setAttribute(SEARCHACTION, (Object)request.getParameter(SEARCHACTION));
                }
                if (FormUtils.nullIfEmpty((String)request.getParameter(SEARCHID)) != null) {
                    request.setAttribute(SEARCHID, (Object)request.getParameter(SEARCHID));
                } else if (FormUtils.nullIfEmpty((String)request.getParameter(SEARCHSLDTHEMAID)) != null) {
                    request.setAttribute(SEARCHID, (Object)request.getParameter(SEARCHSLDTHEMAID));
                } else if (FormUtils.nullIfEmpty((String)request.getParameter(ID)) != null) {
                    request.setAttribute(SEARCHID, (Object)request.getParameter(ID));
                }
                if (FormUtils.nullIfEmpty((String)request.getParameter(SEARCHCLUSTERID)) != null) {
                    request.setAttribute(SEARCHCLUSTERID, (Object)request.getParameter(SEARCHCLUSTERID));
                } else if (FormUtils.nullIfEmpty((String)request.getParameter(SEARCHSLDCLUSTERID)) != null) {
                    request.setAttribute(SEARCHCLUSTERID, (Object)request.getParameter(SEARCHSLDCLUSTERID));
                } else if (FormUtils.nullIfEmpty((String)request.getParameter(CLUSTERID)) != null) {
                    request.setAttribute(SEARCHCLUSTERID, (Object)request.getParameter(CLUSTERID));
                }
                if (FormUtils.nullIfEmpty((String)request.getParameter(SEARCHSLDVISIBLEVALUE)) != null) {
                    request.setAttribute(SEARCHSLDVISIBLEVALUE, (Object)request.getParameter(SEARCHSLDVISIBLEVALUE));
                }
            }
            catch (NumberFormatException nfe) {
                log.error((Object)("searchConfigId = NAN: " + request.getParameter(SEARCHCONFIGID)));
            }
        }
        String temp = request.getParameter(SEARCHCONFIGID);
        String zoekIngangNaam = request.getParameter(SEARCHCONFIGNAME);
        Integer zoekConfigId = null;
        Set velden = null;
        if (temp != null && !temp.equals("")) {
            zoekConfigId = new Integer(temp);
        }
        List zoekconfiguraties = Zoeker.getZoekConfiguraties();
        ArrayList<JSONObject> zoekconfiguratiesJson = new ArrayList<JSONObject>();
        if (zoekconfiguraties != null) {
            for (int i = 0; i < zoekconfiguraties.size(); ++i) {
                ZoekConfiguratie zc = (ZoekConfiguratie)zoekconfiguraties.get(i);
                if ((zc.getForUsageIn() == null || !zc.getForUsageIn().equals("viewer_webr")) && !zc.getForUsageIn().equals("viewer")) continue;
                zoekconfiguratiesJson.add(zc.toJSON());
                Integer zcId = zc.getId();
                if (zoekIngangNaam == null && zoekConfigId != null && zcId.intValue() == zoekConfigId.intValue()) {
                    velden = zc.getZoekVelden();
                    continue;
                }
                if (zoekIngangNaam == null || zc.getNaam() == null || !zc.getNaam().equals(zoekIngangNaam)) continue;
                velden = zc.getZoekVelden();
                zoekConfigId = zc.getId();
            }
        }
        if (zoekconfiguraties != null) {
            request.setAttribute(ZOEKCONFIGURATIES, zoekconfiguratiesJson);
        }
        if ((zoekConfigId != null || zoekIngangNaam != null) && velden != null) {
            String params = "";
            int i = 0;
            for (ZoekAttribuut za : velden) {
                String veldNaam = null;
                String waarde = null;
                if (za.getLabel() != null) {
                    veldNaam = za.getLabel();
                    waarde = request.getParameter(veldNaam);
                }
                if (waarde == null && za.getAttribuutLocalnaam() != null) {
                    veldNaam = za.getAttribuutLocalnaam();
                    waarde = request.getParameter(veldNaam);
                }
                if (waarde == null && za.getAttribuutnaam() != null) {
                    veldNaam = za.getAttribuutnaam();
                    waarde = request.getParameter(veldNaam);
                }
                if (waarde == null) {
                    String upper = veldNaam.toUpperCase();
                    waarde = request.getParameter(upper);
                }
                if (waarde == null) {
                    String lower = veldNaam.toLowerCase();
                    waarde = request.getParameter(lower);
                }
                if (waarde == null) {
                    waarde = "";
                }
                if (za.getType() == 0) {
                    // empty if block
                }
                params = i < 1 ? params + waarde : params + "," + waarde;
                ++i;
            }
            request.setAttribute(SEARCHCONFIGID, (Object)zoekConfigId);
            request.setAttribute(SEARCH, (Object)params);
        }
        JSONArray enabledTabs = null;
        String[] enabledTokens = null;
        String enabledTab = FormUtils.nullIfEmpty((String)request.getParameter(ENABLEDTAB));
        String activeTab = FormUtils.nullIfEmpty((String)request.getParameter(ACTIVETAB));
        if (enabledTab != null) {
            enabledTabs = new JSONArray();
            enabledTokens = enabledTab.split(",");
            boolean containsActiveTab = false;
            for (int i = 0; i < enabledTokens.length; ++i) {
                enabledTabs.put((Object)enabledTokens[i]);
                if (!enabledTokens[i].equalsIgnoreCase(activeTab)) continue;
                containsActiveTab = true;
            }
            if (!containsActiveTab && activeTab != null) {
                enabledTabs.put((Object)activeTab);
            }
        }
        if (activeTab != null) {
            request.setAttribute(ACTIVETAB, (Object)activeTab);
        }
        if (enabledTabs != null) {
            request.setAttribute(ENABLEDTAB, (Object)enabledTabs);
        }
        if (FormUtils.nullIfEmpty((String)request.getParameter(EXPANDNODES)) != null) {
            String collapsedNodes = request.getParameter(EXPANDNODES);
            JSONArray nodes = new JSONArray();
            String[] nodeIds = collapsedNodes.split(",");
            for (int i = 0; i < nodeIds.length; ++i) {
                nodes.put((Object)nodeIds[i]);
            }
            request.setAttribute(EXPANDNODES, (Object)nodes);
        }
        String param = request.getParameter("cmsPageId");
        Integer cmsPageId = null;
        if (param != null && !param.equals("")) {
            cmsPageId = new Integer(param);
        }
        List tekstBlokken = this.getTekstBlokken(cmsPageId);
        JSONArray jsonBlokken = this.getTekstBlokkenJson(tekstBlokken);
        request.setAttribute("tekstBlokken", (Object)jsonBlokken);
        HttpSession session = request.getSession(true);
        A11YResult a11yResult = (A11YResult)session.getAttribute("a11yResult");
        if (a11yResult != null && a11yResult.getStartWkt() != null) {
            request.setAttribute("a11yStartWkt", (Object)a11yResult.getStartWkt());
            Geometry startGeom = this.createGeomFromWkt(a11yResult.getStartWkt());
            if (startGeom != null && startGeom.getCentroid() != null) {
                Integer defaultSearchRadius;
                Double startLocationX = startGeom.getCentroid().getX();
                Double startLocationY = startGeom.getCentroid().getY();
                request.setAttribute("startLocationX", (Object)startLocationX);
                request.setAttribute("startLocationY", (Object)startLocationY);
                if (map != null && (defaultSearchRadius = (Integer)map.get("defaultSearchRadius")) != null && defaultSearchRadius > 0) {
                    request.setAttribute("defaultSearchRadius", (Object)defaultSearchRadius);
                    session.setAttribute("defaultSearchRadius", (Object)defaultSearchRadius);
                }
            }
        }
        String transSliderTab = null;
        if (map != null && (transSliderTab = (String)map.get("transSliderTab")) != null && !transSliderTab.equals("")) {
            request.setAttribute("transSliderTab", (Object)transSliderTab);
        }
        if (transSliderTab == null || transSliderTab.equals("")) {
            request.setAttribute("transSliderTab", (Object)"legenda");
        }
        CMSPagina cmsPage = null;
        if (cmsPageId != null && cmsPageId > 0) {
            cmsPage = (CMSPagina)sess.get(CMSPagina.class, (Serializable)cmsPageId);
        }
        if (cmsPageId != null && cmsPageId > 0) {
            request.setAttribute("cmsPageId", (Object)cmsPageId);
        }
        if (cmsPage != null && cmsPage.getThema() != null && !cmsPage.getThema().equals("")) {
            request.setAttribute("theme", (Object)cmsPage.getThema());
        }
    }

    private Coordinate[] getCoordinateArray(double minx, double miny, double maxx, double maxy) {
        Coordinate[] ca = new Coordinate[]{new Coordinate(minx, miny), new Coordinate(minx, maxy), new Coordinate(maxx, maxy), new Coordinate(maxx, miny), new Coordinate(minx, miny)};
        return ca;
    }

    private Map getClusterMap(List themalist, List clusterlist, Clusters rootCluster, String userCode) throws JSONException, Exception {
        if (themalist == null || clusterlist == null) {
            return null;
        }
        List childrenList = this.getThemaList(themalist, rootCluster);
        ArrayList<Map> subclusters = null;
        for (Clusters cluster : clusterlist) {
            Map clusterMap;
            if (rootCluster != cluster.getParent() || (clusterMap = this.getClusterMap(themalist, clusterlist, cluster, userCode)) == null || clusterMap.isEmpty()) continue;
            if (subclusters == null) {
                subclusters = new ArrayList<Map>();
            }
            subclusters.add(clusterMap);
        }
        if ((childrenList == null || childrenList.isEmpty()) && (subclusters == null || subclusters.isEmpty())) {
            return null;
        }
        HashMap<String, Object> clusterNode = new HashMap<String, Object>();
        clusterNode.put("subclusters", subclusters);
        clusterNode.put("children", childrenList);
        clusterNode.put("cluster", rootCluster);
        return clusterNode;
    }

    private List getThemaList(List themalist, Clusters rootCluster) throws JSONException, Exception {
        if (themalist == null) {
            return null;
        }
        ArrayList<Themas> children = null;
        for (Themas thema : themalist) {
            if (thema.getCluster() != rootCluster) continue;
            if (children == null) {
                children = new ArrayList<Themas>();
            }
            children.add(thema);
        }
        return children;
    }

    private void convertTreeOrderPlim(JSONObject treeObject) throws JSONException {
        if (!treeObject.isNull("children")) {
            JSONArray childArray = treeObject.getJSONArray("children");
            TreeMap<String, JSONObject> tm = new TreeMap<String, JSONObject>();
            for (int i = 0; i < childArray.length(); ++i) {
                JSONObject childObject = childArray.getJSONObject(i);
                this.convertTreeOrderPlim(childObject);
                String title = childObject.getString("title");
                tm.put(title, childObject);
            }
            Collection c = tm.values();
            treeObject.put("children", c);
        }
    }

    protected JSONObject createJasonObject(Map rootClusterMap, List actieveThemas, List actieveClusters, GisPrincipal user, String appCode) throws JSONException {
        JSONObject root = new JSONObject().put(ID, (Object)"root").put("type", (Object)"root").put("title", (Object)"root");
        if (rootClusterMap == null || rootClusterMap.isEmpty()) {
            return root;
        }
        List clusterMaps = (List)rootClusterMap.get("subclusters");
        if (clusterMaps == null || clusterMaps.isEmpty()) {
            return root;
        }
        List<UserKaartgroep> groepen = SpatialUtil.getUserKaartGroepen(appCode);
        List<UserKaartlaag> userlagen = SpatialUtil.getUserKaartLagen(appCode);
        JSONArray children = this.getSubClusters(clusterMaps, null, actieveThemas, actieveClusters, user, 0, appCode, groepen, userlagen);
        root.put("children", (Object)children);
        return root;
    }

    private JSONArray getSubClusters(List subclusterMaps, JSONArray clusterArray, List actieveThemas, List actieveClusters, GisPrincipal user, int order, String appCode, List<UserKaartgroep> groepen, List<UserKaartlaag> userlagen) throws JSONException {
        if (subclusterMaps == null) {
            return clusterArray;
        }
        Session sess = HibernateUtil.getSessionFactory().getCurrentSession();
        for (Map clMap : subclusterMaps) {
            Clusters cluster = (Clusters)clMap.get("cluster");
            boolean showCluster = false;
            for (UserKaartlaag userKaartlaag : userlagen) {
                Integer themaId = userKaartlaag.getThemaid();
                Themas thema = (Themas)sess.get(Themas.class, (Serializable)themaId);
                if (!this.isInCluster(thema, cluster)) continue;
                showCluster = true;
                break;
            }
            boolean defaultOn = false;
            if (groepen != null && groepen.size() > 0) {
                for (UserKaartgroep groep : groepen) {
                    if (!groep.getClusterid().equals(cluster.getId()) || !groep.getDefault_on().booleanValue()) continue;
                    defaultOn = true;
                }
            }
            JSONObject jSONObject = new JSONObject();
            if (cluster.getId() != null) {
                jSONObject.put(ID, (Object)("c" + cluster.getId()));
            }
            jSONObject.put("type", (Object)"child");
            String titel = cluster.getNaam();
            if (titel == null || titel.equals("")) {
                titel = "(geen naam opgegeven)";
            }
            jSONObject.put("title", (Object)titel);
            jSONObject.put("cluster", true);
            jSONObject.put("tree_order", cluster.getBelangnr());
            if (cluster.isExclusive_childs()) {
                jSONObject.put("exclusive_childs", true);
            } else {
                jSONObject.put("exclusive_childs", false);
            }
            this.setExtraClusterProperties(jSONObject, cluster);
            if (actieveClusters != null && actieveClusters.contains(cluster.getId())) {
                jSONObject.put("active", true);
                jSONObject.put("visible", true);
            } else if ((actieveClusters == null || actieveClusters.isEmpty()) && cluster.isDefault_visible()) {
                jSONObject.put("visible", true);
            } else {
                jSONObject.put("visible", false);
            }
            if (cluster.getMetadatalink() != null) {
                String metadatalink = cluster.getMetadatalink();
                metadatalink = metadatalink.replaceAll("%id%", "" + cluster.getId());
                jSONObject.put("metadatalink", (Object)metadatalink);
            } else {
                jSONObject.put("metadatalink", (Object)"#");
            }
            if (defaultOn) {
                jSONObject.put("visible", true);
            }
            if (userlagen != null && userlagen.size() > 0 && !showCluster && !defaultOn) {
                jSONObject.put("hide_tree", true);
                jSONObject.put("callable", false);
                jSONObject.put("background", false);
                jSONObject.put("hide_legend", true);
                jSONObject.put("visible", false);
                jSONObject.put("active", false);
            }
            List childrenList = (List)clMap.get("children");
            JSONArray childrenArray = new JSONArray();
            order = this.getChildren(childrenArray, childrenList, actieveThemas, user, order, appCode, userlagen);
            List subsubclusterMaps = (List)clMap.get("subclusters");
            childrenArray = this.getSubClusters(subsubclusterMaps, childrenArray, actieveThemas, actieveClusters, user, order, appCode, groepen, userlagen);
            if (childrenArray.length() <= 0) continue;
            jSONObject.put("children", (Object)childrenArray);
            if (clusterArray == null) {
                clusterArray = new JSONArray();
            }
            clusterArray.put((Object)jSONObject);
        }
        return clusterArray;
    }

    private int getChildren(JSONArray childrenArray, List children, List actieveThemas, GisPrincipal user, int order, String appCode, List<UserKaartlaag> lagen) throws JSONException {
        if (children == null || childrenArray == null) {
            return order;
        }
        for (Themas th : children) {
            boolean defaultOn = false;
            if (lagen != null && lagen.size() > 0) {
                boolean isInList = false;
                for (UserKaartlaag laag : lagen) {
                    if (!laag.getThemaid().equals(th.getId())) continue;
                    isInList = true;
                    if (!laag.getDefault_on().booleanValue()) break;
                    defaultOn = true;
                    break;
                }
                if (!isInList) continue;
            }
            boolean validAdmindataSource = false;
            Gegevensbron themaGb = th.getGegevensbron();
            if (themaGb != null && themaGb.getAdmin_pk() != null) {
                validAdmindataSource = true;
            }
            if (th.isAnalyse_thema() && !validAdmindataSource) {
                log.debug((Object)(th.getNaam() + "' is analyse kaartlaag maar hier is nog geen gegevensbron voor geconfigureerd."));
            }
            Integer themaId = th.getId();
            String ttitel = th.getNaam();
            if (ttitel == null || ttitel.equals("")) {
                ttitel = "(geen naam opgegeven)";
            }
            JSONObject jsonCluster = new JSONObject().put(ID, (Object)themaId).put("type", (Object)"child").put("title", (Object)ttitel).put("cluster", false);
            jsonCluster.put("order", ++order);
            jsonCluster.put("tree_order", th.getBelangnr());
            if (th.getOrganizationcodekey() != null && th.getOrganizationcodekey().length() > 0) {
                jsonCluster.put("organizationcodekey", (Object)th.getOrganizationcodekey().toUpperCase());
            } else {
                jsonCluster.put("organizationcodekey", (Object)"");
            }
            if (th.getMaptipstring() != null) {
                jsonCluster.put("maptipfield", (Object)th.getMaptipstring());
            }
            if (actieveThemas != null && themaId != null && actieveThemas.contains(themaId)) {
                jsonCluster.put("visible", (Object)"on");
                if (th.isAnalyse_thema() && validAdmindataSource) {
                    jsonCluster.put("analyse", (Object)"active");
                } else {
                    jsonCluster.put("analyse", (Object)"off");
                }
            } else if (actieveThemas == null || actieveThemas.isEmpty()) {
                if (th.isVisible()) {
                    jsonCluster.put("visible", (Object)"on");
                } else {
                    jsonCluster.put("visible", (Object)"off");
                }
                if (th.isAnalyse_thema() && validAdmindataSource) {
                    jsonCluster.put("analyse", (Object)"on");
                } else {
                    jsonCluster.put("analyse", (Object)"off");
                }
            }
            if (defaultOn && lagen.size() > 0) {
                jsonCluster.put("visible", (Object)"on");
            } else if (!defaultOn && lagen.size() > 0) {
                jsonCluster.put("visible", (Object)"off");
                if (actieveThemas != null && actieveThemas.contains(themaId)) {
                    jsonCluster.put("visible", (Object)"on");
                }
            }
            if (th.isAnalyse_thema()) {
                jsonCluster.put("highlight", (Object)"on");
            } else {
                jsonCluster.put("highlight", (Object)"off");
            }
            if (validAdmindataSource) {
                jsonCluster.put("gegevensbronid", (Object)themaGb.getId());
            } else {
                jsonCluster.put("gegevensbronid", -1);
            }
            Clusters cluster = th.getCluster();
            if (cluster.getId() != null) {
                jsonCluster.put("clusterid", (Object)("c" + cluster.getId()));
            }
            this.setExtraClusterProperties(jsonCluster, cluster);
            Layer layer = null;
            if (th.getWms_layers_real() != null) {
                jsonCluster.put("wmslayers", (Object)th.getWms_layers_real());
                if (th.getWms_querylayers_real() != null && !validAdmindataSource) {
                    jsonCluster.put("wmsquerylayers", (Object)th.getWms_querylayers_real());
                }
                if (th.getWms_legendlayer_real() != null) {
                    jsonCluster.put("legendurl", (Object)user.getLegendGraphicUrl(user.getLayer(th.getWms_legendlayer_real()), th.getStyle()));
                }
                if (th.isLocatie_thema()) {
                    jsonCluster.put("legendscaling", true);
                }
                layer = user.getLayer(th.getWms_layers_real());
            } else {
                jsonCluster.put("wmslayers", (Object)th.getWms_layers());
                if (th.getWms_querylayers() != null && !validAdmindataSource) {
                    jsonCluster.put("wmsquerylayers", (Object)th.getWms_querylayers());
                }
                if (th.getWms_legendlayer() != null) {
                    jsonCluster.put("legendurl", (Object)user.getLegendGraphicUrl(user.getLayer(th.getWms_legendlayer()), th.getStyle()));
                }
                if (th.isLocatie_thema()) {
                    jsonCluster.put("legendscaling", true);
                }
                layer = user.getLayer(th.getWms_layers());
            }
            if (layer != null) {
                TileSet ts;
                ServiceProvider sp;
                DecimalFormat formatter = new DecimalFormat("#.#####");
                double shmax = -1.0;
                try {
                    shmax = Double.parseDouble(layer.getScaleHintMax());
                    shmax /= squareRootOf2;
                }
                catch (NumberFormatException nfe) {
                    log.debug((Object)("max scale hint not valid: " + layer.getScaleHintMax()));
                }
                if (shmax > 0.0) {
                    jsonCluster.put("scalehintmax", (Object)formatter.format(shmax));
                }
                double shmin = -1.0;
                try {
                    shmin = Double.parseDouble(layer.getScaleHintMin());
                    shmin /= squareRootOf2;
                }
                catch (NumberFormatException nfe) {
                    log.debug((Object)("min scale hint not valid: " + layer.getScaleHintMin()));
                }
                if (shmin > 0.0) {
                    jsonCluster.put("scalehintmin", (Object)formatter.format(shmin));
                }
                if ((sp = user.getSp()) != null && (ts = sp.getTileSet(layer)) != null) {
                    jsonCluster.put("tiled", true);
                    jsonCluster.put("resolutions", (Object)ts.getResolutions());
                    jsonCluster.put("tileWidth", (Object)ts.getWidth());
                    jsonCluster.put("tileHeight", (Object)ts.getHeight());
                    jsonCluster.put("tileFormat", (Object)ts.getFormat());
                    jsonCluster.put("tileLayers", (Object)ts.getLayerString());
                    if (ts.getBoundingBox() != null) {
                        jsonCluster.put("tileSrs", (Object)ts.getBoundingBox().getSrs());
                    } else {
                        jsonCluster.put("tileSrs", (Object)"EPSG:28992");
                    }
                    jsonCluster.put("tileVersion", (Object)sp.getWmsVersion());
                    jsonCluster.put("tileStyles", (Object)ts.getStyles());
                    if (ts.getBoundingBox() != null) {
                        String bbox = "";
                        bbox = bbox + ts.getBoundingBox().getMinx() + ",";
                        bbox = bbox + ts.getBoundingBox().getMiny() + ",";
                        bbox = bbox + ts.getBoundingBox().getMaxx() + ",";
                        bbox = bbox + ts.getBoundingBox().getMaxy();
                        jsonCluster.put("tileBoundingBox", (Object)bbox);
                    } else {
                        jsonCluster.put("tileBoundingBox", (Object)"-285401.92,22598.08,595401.9199999999,903401.9199999999");
                    }
                }
            }
            if (th.getMetadata_link() != null) {
                String metadatalink = th.getMetadata_link();
                metadatalink = metadatalink.replaceAll("%id%", "" + themaId);
                jsonCluster.put("metadatalink", (Object)metadatalink);
            } else {
                jsonCluster.put("metadatalink", (Object)"#");
            }
            if (th.getStyle() != null) {
                jsonCluster.put("use_style", (Object)th.getStyle());
            } else {
                jsonCluster.put("use_style", (Object)"default");
            }
            String kaartlaagInfo = th.getInfo_tekst();
            if (kaartlaagInfo != null && !kaartlaagInfo.isEmpty()) {
                jsonCluster.put("info_tekst", true);
            } else {
                jsonCluster.put("info_tekst", false);
            }
            childrenArray.put((Object)jsonCluster);
        }
        return order;
    }

    private void setExtraClusterProperties(JSONObject jsonCluster, Clusters cluster) throws JSONException {
        if (cluster.isDefault_cluster()) {
            jsonCluster.put("default_cluster", true);
        } else {
            jsonCluster.put("default_cluster", false);
        }
        if (cluster.isHide_legend()) {
            jsonCluster.put("hide_legend", true);
        } else {
            jsonCluster.put("hide_legend", false);
        }
        if (cluster.isHide_tree()) {
            jsonCluster.put("hide_tree", true);
        } else {
            jsonCluster.put("hide_tree", false);
        }
        if (cluster.isBackground_cluster()) {
            jsonCluster.put("background", true);
        } else {
            jsonCluster.put("background", false);
        }
        if (cluster.isExtra_level()) {
            jsonCluster.put("extra_level", true);
        } else {
            jsonCluster.put("extra_level", false);
        }
        if (cluster.isCallable()) {
            jsonCluster.put("callable", true);
        } else {
            jsonCluster.put("callable", false);
        }
    }

    private void setUserviceTrees(String appCode, HttpServletRequest request) throws JSONException, Exception {
        ArrayList<JSONObject> servicesTrees = new ArrayList<JSONObject>();
        List<UserService> services = SpatialUtil.getValidUserServices(appCode);
        for (UserService service : services) {
            JSONObject tree = this.createUserServiceTree(service);
            servicesTrees.add(tree);
        }
        request.setAttribute("servicesTrees", servicesTrees);
    }

    protected JSONObject createUserServiceTree(UserService service) throws JSONException, Exception {
        JSONObject root = new JSONObject();
        root.put(ID, (Object)"0");
        root.put("title", (Object)service.getGroupname());
        root.put("name", (Object)service.getGroupname());
        List<UserLayer> ctl = SpatialUtil.getValidUserLayers(service);
        Map rootLayerMap = this.getUserLayersMap(ctl, null);
        List lMaps = (List)rootLayerMap.get("sublayers");
        root.put("children", (Object)this.getSubLayers(lMaps, null, service));
        return root;
    }

    private Map getUserLayersMap(List layerList, UserLayer root) throws JSONException, Exception {
        if (layerList == null) {
            return null;
        }
        ArrayList<Map> subLayers = null;
        for (UserLayer la : layerList) {
            Map lMap;
            if (root != la.getParent() || (lMap = this.getUserLayersMap(layerList, la)) == null || lMap.isEmpty()) continue;
            if (subLayers == null) {
                subLayers = new ArrayList<Map>();
            }
            subLayers.add(lMap);
        }
        HashMap<String, Object> lNode = new HashMap<String, Object>();
        lNode.put("sublayers", subLayers);
        lNode.put("userlayer", root);
        return lNode;
    }

    private JSONArray getSubLayers(List subLayers, JSONArray layersArray, UserService service) throws JSONException {
        if (subLayers == null) {
            return layersArray;
        }
        String serviceUrl = service.getUrl();
        String serviceSld = service.getSld_url();
        for (Map lMap : subLayers) {
            UserLayer layer = (UserLayer)lMap.get("userlayer");
            JSONObject jsonLayer = new JSONObject();
            jsonLayer.put(ID, layer.getId().intValue());
            jsonLayer.put("serviceid", layer.getServiceid().getId().intValue());
            jsonLayer.put("title", (Object)layer.getTitle());
            jsonLayer.put("name", (Object)layer.getName());
            jsonLayer.put("queryable", (Object)layer.getQueryable());
            jsonLayer.put("scalehintmin", (Object)layer.getScalehint_min());
            jsonLayer.put("scalehintmax", (Object)layer.getScalehint_max());
            jsonLayer.put("use_style", (Object)layer.getUse_style());
            jsonLayer.put("sld_part", (Object)layer.getSld_part());
            jsonLayer.put("show", (Object)layer.getShow());
            jsonLayer.put("default_on", (Object)layer.getDefault_on());
            jsonLayer.put("service_url", (Object)serviceUrl);
            jsonLayer.put("service_sld", (Object)serviceSld);
            List subsubMaps = (List)lMap.get("sublayers");
            if (subsubMaps != null && !subsubMaps.isEmpty()) {
                JSONArray childrenArray = new JSONArray();
                childrenArray = this.getSubLayers(subsubMaps, childrenArray, service);
                jsonLayer.put("children", (Object)childrenArray);
            }
            if (layersArray == null) {
                layersArray = new JSONArray();
            }
            layersArray.put((Object)jsonLayer);
        }
        return layersArray;
    }

    private boolean isInCluster(Themas thema, Clusters inCluster) {
        if (thema == null || thema.getCluster() == null) {
            return false;
        }
        return this.isInCluster(thema.getCluster(), inCluster);
    }

    private boolean isInCluster(Clusters cluster, Clusters inCluster) {
        if (cluster.getId().equals(inCluster.getId())) {
            return true;
        }
        if (cluster.getParent() == null) {
            return false;
        }
        return this.isInCluster(cluster.getParent(), inCluster);
    }

    private Geometry createGeomFromWkt(String wkt) {
        WKTReader wktreader = new WKTReader(new GeometryFactory(new PrecisionModel(), 28992));
        Geometry geom = null;
        try {
            geom = wktreader.read(wkt);
        }
        catch (Exception e) {
            log.error((Object)"Fout bij parsen wkt geometry", (Throwable)e);
        }
        return geom;
    }

    private JSONArray getTekstBlokkenJson(List tekstBlokken) {
        Iterator it = tekstBlokken.iterator();
        JSONArray jsonBlokken = new JSONArray();
        while (it.hasNext()) {
            Tekstblok tb = (Tekstblok)it.next();
            try {
                jsonBlokken.put((Object)tb.toJson());
            }
            catch (JSONException e) {
                log.error((Object)"Fout bij converteren van tekstblok naar Json", (Throwable)e);
            }
        }
        return jsonBlokken;
    }
}

